/* $Id: mbuf.c,v 1.4 2003/05/30 00:42:40 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "libc.h"
#include "mbuf.h"
#include "misc.h"


/*
 * Mbuf routines.  Semantics are described in the header
 */

void mbuf_init(mbuf_t *mbuf, int length)
{
	if (!length) {
		mbuf->size = 0;
		mbuf->front_ptr = mbuf->buf + 1024;
		mbuf->end_ptr = mbuf->buf + 1024;
	} else { 
		if (length > MBUF_BUFSIZE) {
			lib_die("Out of memory");
		}
		mbuf->size = length;
		mbuf->front_ptr = mbuf->buf;
		mbuf->end_ptr = mbuf->buf + length;
	}
}

int mbuf_prepend_space(mbuf_t *mbuf, unsigned int bytes)
{
	if ((mbuf->front_ptr - mbuf->buf) < bytes) {
		return MBUF_OUT_OF_ROOM;
	}
	mbuf->front_ptr -= bytes;
	mbuf->size += bytes;
	return MBUF_SUCCESS;	
}

int mbuf_prepend(mbuf_t *mbuf, void *ptr, unsigned int bytes)
{
	int retval;
	retval = mbuf_prepend_space(mbuf, bytes);
	if (retval == MBUF_SUCCESS) {
		lib_memcpy(mbuf->front_ptr, ptr, bytes);
	}
	return retval;
}


int mbuf_append_space(mbuf_t *mbuf, unsigned int bytes)
{
	if (MBUF_BUFSIZE - (mbuf->end_ptr - mbuf->buf) < bytes) {
		return MBUF_OUT_OF_ROOM;
	}
	mbuf->end_ptr += bytes;
	mbuf->size += bytes;
	return MBUF_SUCCESS;
}

int mbuf_append(mbuf_t *mbuf, void *ptr, unsigned int bytes)
{
	int retval;
	retval = mbuf_append_space(mbuf, bytes);
	if (retval == MBUF_SUCCESS) {
		lib_memcpy(mbuf->end_ptr-bytes, ptr, bytes);
	}
	return retval;
}

void mbuf_trim_head(mbuf_t *mbuf, unsigned int bytes)
{
	if (mbuf->size < bytes) {
		bytes = mbuf->size;
	} 
	mbuf->size -= bytes;
	mbuf->front_ptr += bytes;
}

void mbuf_trim_tail(mbuf_t *mbuf, unsigned int bytes)
{
	if (mbuf->size < bytes) {
		bytes = mbuf->size;
	}
	mbuf->size -= bytes;
	mbuf->end_ptr -= bytes;
}

int mbuf_range_ok(mbuf_t *mbuf, void *void_ptr, unsigned int bytes)
{
	uint8_t *ptr = (uint8_t *)void_ptr;
	int retval = 0;
	
	if ((ptr < mbuf->end_ptr) 
	    && (ptr >= mbuf->front_ptr)
	    && (ptr + bytes <= mbuf->end_ptr)) {
		retval = 1;
	}
	return retval;
}
