/***************************************************************************
                          interface_widget_orderlist.cpp  -  description
                             -------------------
    begin                : Sat Mar 24 2001
    copyright            : (C) 2001 by Juan Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_widget_orderlist.h"

int OrderlistWidget::Orderlist_Colors[] = {
    10, 20, 30,
    100, 200, 100,
    230, 250, 230,
    30, 30, 30,
    30, 40, 50
};
gint OrderlistWidget::button_press_event_impl(GdkEventButton* p0) {

	grab_focus(); // is this the best way to do it? I cant figure it out!
        im_focused=true;
	draw_single_mode();
	return 0;
}

gint  OrderlistWidget::focus_out_event_impl(GdkEventFocus* p0) {

        im_focused=false;
	draw_single_mode();

	return 0;
}
void OrderlistWidget::allocate_colormap () {

	Gdk_Color tmpcolor;
	int i;

	for (i=0;i<Colormap_max_Colors*3;i+=3) {

                //tmpcolor=colors[i/3];
		//tmpcolor=colors[i/3];

		colors[i/3].red = Orderlist_Colors[i] * 0xFFFF / 0xFF;
		colors[i/3].green = Orderlist_Colors[i+1] * 0xFFFF / 0xFF;
		colors[i/3].blue = Orderlist_Colors[i+2] * 0xFFFF / 0xFF;
	        get_colormap().alloc(colors[i/3]);
	}

}


void OrderlistWidget::realize_impl() {

	Gdk_WindowAttr attributes;
        int attributes_mask;

	set_flags(GTK_REALIZED|GTK_CAN_FOCUS|GTK_HAS_GRAB);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	

	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&OrderlistWidget::do_expose_event));

	allocate_colormap();

        bgcol.create(get_window());
	fgcol.create(get_window());
	cursorcol.create(get_window());
	sepcol.create(get_window());
	playcol.create(get_window());

	bgcol.set_foreground(colors[Col_BackGround]);
	fgcol.set_foreground(colors[Col_ForeGround]);
	cursorcol.set_foreground(colors[Col_Cursor]);
	sepcol.set_foreground(colors[Col_Separator]);
	playcol.set_foreground(colors[Col_BeingPlayed]);

	bgcol.set_exposures(1);
	window.set_user_data(gtkobj());
	window.set_background(colors[Col_BackGround]);
#ifdef WIN32_ENABLED

	font.load("fixedsys");
#else
 	font.load("-adobe-courier-bold-r-normal--*-120-*-*-*-*-*-*");
#endif
	font_draw.set_font(&font);
	font_draw.set_window(&window);

}

int OrderlistWidget::get_font_width() {

	return font_draw.get_width();

}

int OrderlistWidget::get_font_height() {

	return (font.ascent()+font.descent());
}


void OrderlistWidget::draw_single_cursor() {

	int initx,inity;

	initx=get_font_width()*4+editor->orderlist_get_cursor_x()*get_font_width();
	inity=get_font_height()*(editor->orderlist_get_cursor_y()-row_offset);

	window.draw_rectangle(cursorcol,FALSE,10+initx-1,inity-1,get_font_width()+2,get_font_height()+2);
}

void OrderlistWidget::draw_single_mode() {

	int i;
       	

	int rows_to_draw;

	rows_to_draw=height()/get_font_height();

	if (editor->orderlist_get_cursor_y()<row_offset) row_offset=editor->orderlist_get_cursor_y();
	if (editor->orderlist_get_cursor_y()>=(row_offset+rows_to_draw)) row_offset=(editor->orderlist_get_cursor_y()-rows_to_draw)+1;

	for (i=0;i<rows_to_draw;i++) {

		window.draw_rectangle(bgcol,TRUE,0,get_font_height()*i,width(),get_font_height());

		if ((i+row_offset)<editor->song->get_max_order()) {

			char tmpnumb[4]={'0','0','0',0};
		    	tmpnumb[0]='0'+(i+row_offset)/100;
		     	tmpnumb[1]='0'+((i+row_offset)/10) % 10;
		     	tmpnumb[2]='0'+(i+row_offset) % 10;
                        tmpnumb[3]=0;

			font_draw.do_string(&cursorcol,10,get_font_height()*i+get_font_height(),tmpnumb);
			font_draw.do_string(&fgcol,10+get_font_width()*4,get_font_height()*i+get_font_height(),editor->orderlist_get_cursor_string(i+row_offset));
		}

	}

	window.draw_rectangle(sepcol,TRUE,13+get_font_width()*3,0,3,height());
	if (im_focused) {

		window.draw_rectangle(cursorcol,FALSE,0,0,width()-1,height()-1);
		draw_single_cursor();
	}
}



gint OrderlistWidget::do_expose_event(GdkEventExpose* p0) {

      	if (editor==NULL) return 0;

	draw_single_mode();

	return 0;

}



OrderlistWidget::OrderlistWidget(){

	row_offset=0;
	editor=NULL;
}

OrderlistWidget::~OrderlistWidget(){
}
