-- MySQL dump 8.22
--
-- Host: localhost    Database: scoop
-- -------------------------------------------------------
-- Server version	3.23.52-log

--
-- Table structure for table 'ad_info'
--

CREATE TABLE ad_info (
  ad_id int(11) NOT NULL auto_increment,
  ad_tmpl varchar(30) default NULL,
  ad_file varchar(255) default NULL,
  ad_url varchar(255) default NULL,
  ad_text1 text,
  ad_text2 text,
  views_left int(11) default '0',
  first_day date default NULL,
  perpetual int(1) default '0',
  last_seen datetime default NULL,
  sponsor int(11) default NULL,
  active int(1) default '0',
  example int(1) default '0',
  ad_title varchar(255) default NULL,
  submitted_on datetime default NULL,
  view_count int(11) default '0',
  click_throughs int(11) default '0',
  judged int(1) default '0',
  reason text,
  paid int(1) default '0',
  purchase_size int(11) default '0',
  purchase_price decimal(7,2) default '0.00',
  judger int(11) default NULL,
  approved int(1) default NULL,
  impression_cache int(11) default '0',
  pos int(5) NOT NULL default '1',
  ad_sid varchar(20) default NULL,
  PRIMARY KEY  (ad_id),
  KEY seen_active (active,last_seen,ad_tmpl),
  KEY pos (pos)
);

--
-- Dumping data for table 'ad_info'
--


INSERT INTO ad_info VALUES (1,'text_ad_template','7981192.png','http://scoop.kuro5hin.org','The swiss army chainsaw of Content Management',NULL,NULL,NULL,NULL,NULL,1,NULL,1,'Scoop','2001-12-21 09:39:12',0,1,0,NULL,0,0,0.00,NULL,NULL,NULL,1,NULL);

--
-- Table structure for table 'ad_log'
--

CREATE TABLE ad_log (
  req_num bigint(20) NOT NULL auto_increment,
  req_time int(11) NOT NULL default '0',
  requestor int(11) NOT NULL default '0',
  request_ip varchar(16) NOT NULL default '',
  ad_id int(11) NOT NULL default '0',
  req_type varchar(20) NOT NULL default '',
  PRIMARY KEY  (req_num)
);

--
-- Dumping data for table 'ad_log'
--



--
-- Table structure for table 'ad_payments'
--

CREATE TABLE ad_payments (
  ad_id int(11) NOT NULL default '0',
  order_id varchar(50) NOT NULL default '',
  cost decimal(7,2) NOT NULL default '0.00',
  pay_type varchar(10) NOT NULL default '',
  auth_date date NOT NULL default '0000-00-00',
  final_date date default NULL,
  paid int(1) default NULL,
  PRIMARY KEY  (ad_id,order_id)
);

--
-- Dumping data for table 'ad_payments'
--



--
-- Table structure for table 'ad_types'
--

CREATE TABLE ad_types (
  type_template varchar(30) NOT NULL default '',
  type_name varchar(50) NOT NULL default '',
  short_desc varchar(255) NOT NULL default '',
  submit_instructions text,
  max_file_size int(11) default NULL,
  max_text1_chars int(5) default NULL,
  max_text2_chars int(5) default NULL,
  max_title_chars int(5) default NULL,
  cpm decimal(7,2) default NULL,
  active int(1) NOT NULL default '0',
  min_purchase_size int(7) default NULL,
  max_purchase_size int(7) default '1000000',
  pos int(5) NOT NULL default '1',
  allow_discussion int(1) default '0',
  PRIMARY KEY  (type_template)
);

--
-- Dumping data for table 'ad_types'
--


INSERT INTO ad_types VALUES ('text_ad_template','Simple Text Ad','This is a simple text advertisement that allows a title, some text, and a link to your site.','Put in your title, text, and where you want to link to below.',NULL,50,NULL,20,2.50,1,1000,1000000,1,0);

--
-- Table structure for table 'admin_tools'
--

CREATE TABLE admin_tools (
  tool varchar(20) NOT NULL default '',
  pos int(2) NOT NULL default '0',
  dispname varchar(60) NOT NULL default '',
  menuname varchar(60) NOT NULL default '',
  perm varchar(50) NOT NULL default '',
  func varchar(50) NOT NULL default '',
  is_box int(1) default '0',
  PRIMARY KEY  (tool)
);

--
-- Dumping data for table 'admin_tools'
--


INSERT INTO admin_tools VALUES ('story',1,'Stories','New Story','story_admin','edit_story',0);
INSERT INTO admin_tools VALUES ('storylist',2,'Stories','Story List','story_list','list_stories',0);
INSERT INTO admin_tools VALUES ('editpoll',3,'Polls','New Poll','edit_polls','edit_polls',0);
INSERT INTO admin_tools VALUES ('listpolls',4,'Polls','Poll List','list_polls','admin_polls',0);
INSERT INTO admin_tools VALUES ('vars',5,'Vars','Site Controls','edit_vars','edit_vars',0);
INSERT INTO admin_tools VALUES ('blocks',6,'Blocks','Blocks','edit_blocks','edit_blocks',0);
INSERT INTO admin_tools VALUES ('topics',7,'Topics','Topics','edit_topics','edit_topics',0);
INSERT INTO admin_tools VALUES ('sections',8,'Sections','Sections','edit_sections','edit_sections',0);
INSERT INTO admin_tools VALUES ('special',9,'Special Pages','Special Pages','edit_special','edit_special',0);
INSERT INTO admin_tools VALUES ('boxes',10,'Boxes','Boxes','edit_boxes','edit_boxes',0);
INSERT INTO admin_tools VALUES ('groups',11,'Groups','Groups','edit_groups','edit_groups',0);
INSERT INTO admin_tools VALUES ('rdf',12,'RDF Feeds','RDF Feeds','rdf_admin','edit_rdfs',0);
INSERT INTO admin_tools VALUES ('cron',13,'Cron','Cron','cron_admin','edit_cron',0);
INSERT INTO admin_tools VALUES ('ads',14,'Advertising','Advertising','ad_admin','ad_admin_choice',0);
INSERT INTO admin_tools VALUES ('ops',15,'Ops','Ops','edit_ops','edit_ops',0);
INSERT INTO admin_tools VALUES ('hooks',17,'Hooks','Hooks','edit_hooks','edit_hooks',0);

--
-- Table structure for table 'advertisers'
--

CREATE TABLE advertisers (
  advertisor_id int(11) NOT NULL default '0',
  contact_name varchar(255) NOT NULL default '',
  contact_phone varchar(20) default NULL,
  company_name varchar(255) NOT NULL default '',
  snail_mail varchar(255) default NULL,
  PRIMARY KEY  (advertisor_id)
);

--
-- Dumping data for table 'advertisers'
--



--
-- Table structure for table 'blocks'
--

CREATE TABLE blocks (
  bid varchar(30) NOT NULL default '',
  block text,
  aid varchar(20) default NULL,
  description text,
  category varchar(128) NOT NULL default 'general',
  theme varchar(32) NOT NULL default 'default',
  language varchar(10) NOT NULL default 'en',
  PRIMARY KEY  (bid,category,theme,language)
);

--
-- Dumping data for table 'blocks'
--


INSERT INTO blocks VALUES ('footer','<CENTER>\r\n<TABLE WIDTH=\"80%\" CELLPADDING=0 CELLSPACING=0 BORDER=0>\r\n<TR>\r\n<TD>%%norm_font%%\r\n<FORM NAME=\"Search\" ACTION=\"%%rootdir%%\" METHOD=\"POST\">\r\n<INPUT TYPE=\"hidden\" NAME=\"op\" VALUE=\"search\">\r\n<INPUT TYPE=\"text\" SIZE=20 NAME=\"string\"><INPUT TYPE=\"submit\" VALUE=\"Search\">\r\n</FORM> \r\n</FONT>\r\n</TD>\r\n<TD ALIGN=\"center\" VALIGN=\"top\">\r\n<A href=\"http://sourceforge.net\"><IMG src=\"http://sourceforge.net/sflogo.php?group_id=4901&type=1\" width=\"88\" height=\"31\" border=\"0\" alt=\"SourceForge Logo\"></A> \r\n</TD>\r\n<TD align=\"right\" valign=\"top\">\r\n<A HREF=\"http://scoop.kuro5hin.org\"><IMG SRC=\"%%imagedir%%/new_powered.gif\" ALT=\"Powered by Scoop\" BORDER=0></A>\r\n</TD>\r\n</TR>\r\n</TABLE>\r\n\r\n<FONT size=1 color=\"#303030\" face=\"arial,helvetica\">\r\nAll trademarks and copyrights on this page are owned by their respective companies.  Comments are owned by the Poster. The Rest  1999 The Management \r\n</FONT><P>\r\n</CENTER>\r\n','1','Whatever HTML you wish to have displayed at the bottom of every page generated.','site_html','default','en');
INSERT INTO blocks VALUES ('autorelated','Scoop,http://scoop.kuro5hin.org/\r\nKuro5hin,http://www.kuro5hin.org/\r\nSlashdot,http://www.slashdot.org/\r\nFreshmeat,http://www.freshmeat.net/','1','The \"What\'s related\" box lists all the links used in the story, but the autorelated box adds a link to that list if a word (listed here) shows up in the story, whether it is a link or not. List the word you want it to detect, a comma, and the URL, with no spaces and one per line.','block_programs','default','en');
INSERT INTO blocks VALUES ('index_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n</HEAD>\r\n<BODY bgcolor=\"#ffffff\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n    <!-- Main page block -->\r\n    <TR>\r\n\r\n        <!-- Left info column -->\r\n        <TD VALIGN=\"top\" WIDTH=\"20%\" HEIGHT=20 BGCOLOR=\"%%title_bgcolor%%\">\r\n            %%title_font%%Welcome to Scoop%%title_font_end%%\r\n        </TD>\r\n        <!-- X Left info column -->\r\n\r\n        <!-- Center content section -->\r\n        <TD VALIGN=\"top\" width=\"55%\" HEIGHT=20 BGCOLOR=\"%%title_bgcolor%%\">\r\n            %%BOX,section_title_subsections%%\r\n        </TD>\r\n        <!-- X center content section -->\r\n\r\n        <!-- Right boxes column -->\r\n        <TD VALIGN=\"top\" width=\"25%\" ROWSPAN=\"2\">\r\n        \r\n            %%BOX,main_menu%%\r\n            %%BOX,ad_box%%\r\n            %%BOX,user_box%%\r\n            %%BOX,rdf_feeds%%\r\n            %%BOX,hotlist_box%%\r\n            %%BOX,admin_tools%%\r\n            %%BOX,poll_box%%\r\n            %%BOX,older_list_box%%\r\n\r\n        </TD>\r\n        <!-- X Right boxes column -->\r\n\r\n    </TR>        \r\n        \r\n    <TR>\r\n        \r\n        <!-- Left info column -->\r\n        <TD VALIGN=\"top\" WIDTH=\"20%\" HEIGHT=\"100%\">\r\n            <TABLE HEIGHT=\"650\" WIDTH=\"100%\" BORDER=0 CELLPADDING=0 CELLSPACING=0>\r\n            <TR><TD VALIGN=\"top\">\r\n            \r\n            <!-- About Scoop -->\r\n            %%scoop_intro%%\r\n            <!-- X About Scoop -->\r\n            \r\n            </TD></TR>\r\n            </TABLE>        \r\n        </TD>\r\n        <!-- X Left info column -->\r\n\r\n        <!-- Center content section -->\r\n        <TD VALIGN=\"top\" width=\"55%\">\r\n            <TABLE HEIGHT=\"650\" WIDTH=\"100%\" BORDER=0 CELLPADDING=0 CELLSPACING=0>\r\n            <TR><TD VALIGN=\"top\">\r\n            %%CONTENT%%\r\n            </TD></TR>\r\n            </TABLE>        \r\n        </TD>\r\n        <!-- X center content section -->\r\n    \r\n    </TR>\r\n    <!-- X main page block -->\r\n</TABLE>\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</CENTER>\r\n</BODY>\r\n</HTML>\r\n','1','A page template. This is typically the template used for the front page and section pages, but rarely anything else.','templates','default','en');
INSERT INTO blocks VALUES ('header','<!-- header table -->\r\n<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 width=\"100%\">\r\n	<TR>\r\n		<TD>\r\n			<A href=\"%%rootdir%%/\"><IMG SRC=\"%%imagedir%%/small_logo.jpg\" BORDER=0 ALT=\"Scoop -- the free news and discussion system\"></A>\r\n		</TD>\r\n		<TD align=\"right\">\r\n			%%section_links%%\r\n		</TD>\r\n	</TR>\r\n</TABLE>\r\n<!-- X header table -->\r\n','1','Whatever HTML you wish to have displayed at the top of every page generated.','site_html','default','en');
INSERT INTO blocks VALUES ('comment','<!-- start comment -->\r\n<TABLE CELLPADDING=1 CELLSPACING=0 BORDER=0 BGCOLOR=\"#006699\">\r\n  <TR>\r\n    <TD width=\"100%\">\r\n      <TABLE CELLPADDING=2 CELLSPACING=0 BORDER=0 BGCOLOR=\"%%comment_head_bg%%\" width=\"100%\">\r\n        <TR>\r\n          <TD WIDTH=\"100%\"><A NAME=\"%%cid%%\"></A>\r\n          %%norm_font%% %%new%% <B>%%subject%%</B>\r\n(<A HREF=\"%%rootdir%%/comments/%%sid%%/%%cid%%?mode=alone;showrate=1#%%cid%%\">%%score%% / %%num_ratings%%</A>)\r\n(<A CLASS=\"light\" HREF=\"%%rootdir%%/comments/%%sid%%/%%cid%%#%%cid%%\">#%%cid%%</A>)%%norm_font_end%% <BR>\r\n          %%norm_font%%by %%name%% %%email%% on %%date%%<BR>%%user_info%% %%url%%%%norm_font_end%%\r\n          </TD>\r\n        </TR>\r\n      </TABLE>\r\n    </TD>\r\n  </TR>\r\n</TABLE>\r\n<BR>\r\n<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>\r\n  <TR>\r\n    <TD>\r\n    %%norm_font%%%%comment%%<BR>%%sig%%<BR>%%actions%%%%norm_font_end%%\r\n    </TD>\r\n  </TR>\r\n</TABLE>\r\n<BR><BR>\r\n%%norm_font%%%%replies%%%%norm_font_end%%\r\n\r\n<!-- end comment -->\r\n\r\n','1','The structure of comments attached to a story. This should be mostly self-contained and have the replies at the end.  See http://guide.kuro5hin.org for details on the special vars.','content','default','en');
INSERT INTO blocks VALUES ('story_info','<!-- Story info -->\r\n<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=0 ALIGN=\"center\" WIDTH=\"100%\">\r\n	<TR BGCOLOR=\"%%story_mod_bg%%\">\r\n		<TD align=\"center\">\r\n			%%smallfont%%%%story_info%%%%smallfont_end%%\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD ALIGN=\"center\" BGCOLOR=\"%%story_mod_bg%%\">\r\n			%%smallfont%%%%comment_controls%%%%smallfont_end%%\r\n		</TD>\r\n	</TR>\r\n</TABLE>\r\n<!-- X Story info -->\r\n\r\n','1','The bar placed at the top and bottom of the comments. It contains the story name, number and type of comments, and the \'post a comment\' link.','content','default','en');
INSERT INTO blocks VALUES ('story_summary','<TABLE WIDTH=100% BORDER=0 CELLPADDING=0 CELLSPACING=2>\r\n<TR>\r\n<TD>\r\n%%title_font%%%%title%%%%title_font_end%%\r\n</TD>\r\n<TD ALIGN=\"right\" VALIGN=\"top\" ROWSPAN=2>%%norm_font%%<CENTER>%%hotlist%%%%norm_font_end%%<BR>%%topic_img%%</TD>\r\n</TR>\r\n\r\n<TR>\r\n<TD>\r\n%%smallfont%%By %%info%%, Section %%section_link%%<BR>Posted on %%time%%%%smallfont_end%%\r\n</TD>\r\n</TR>\r\n\r\n<TR>\r\n<TD BGCOLOR=\"#000000\" HEIGHT=2 COLSPAN=2><IMG SRC=\"%%imagedir%%/spacer.gif\" HEIGHT=2></TD>\r\n</TR>\r\n\r\n<TR><TD COLSPAN=2>\r\n%%norm_font%%%%introtext%% \r\n<P>\r\n%%stats%% %%readmore%%%%norm_font_end%%\r\n</TD>\r\n</TR>\r\n</TABLE>\r\n<P>','1','The layout of the story header and introtext. This should be a reasonably self-contained bit of HTML.  See http://guide.kuro5hin.org for details on the special vars.','content','default','en');
INSERT INTO blocks VALUES ('box','<TABLE WIDTH=\"100%\" BORDER=1 CELLPADDING=2 CELLSPACING=0>\r\n	<TR>\r\n		<TD BGCOLOR=\"#006699\">\r\n			%%box_title_font%%%%title%%%%box_title_font_end%%\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD>\r\n			%%smallfont%%\r\n			%%content%%\r\n			%%smallfont_end%%\r\n		</TD>\r\n	</TR>\r\n</TABLE>\r\n<P>','1','A box template - the default one with the blue title bar. The special vars |title| and |content| are supplied by the box code','boxes','default','en');
INSERT INTO blocks VALUES ('submission_message','<FONT =\"+1\">Thank you for your submission. This is a community-edited site, so hopefully your fellow readers will see fit to post your story. Good Luck!</FONT>','1','The message displayed at the bottom of the story when it has just been posted to the moderation queue, thanking the user for submitting a story.','site_html','default','en');
INSERT INTO blocks VALUES ('submission_guidelines','Thank you for taking the time to submit a story!<P>\r\nHere are some general guidelines for new stories:\r\n<UL>\r\n<LI>Pick the topic carefully! Try your best to match the topic with the story you\'re submitting.\r\n<LI>Only the html tags listed are allowed in story text. No HTML is allowed in \"title\" or \"dept.\"\r\n<LI>You must preview at least once. Please read over your story carefully. <LI>Check all URLS!\r\n<LI>Check all facts! :-)\r\n<LI>This site is community-edited (mostly), so don\'t whine to the admins if your story doesn\'t get posted. If you\'re logged in, you\'ll see a \"Moderate Submissions\" link to the right. This is how you decide what gets posted here! Use it!\r\n</UL>\r\nNow post away!','1','Warnings and instructions displayed on the story submission page, just above the form. This is basically free-form HTML.','site_html','default','en');
INSERT INTO blocks VALUES ('moderate_head','%%norm_font%%Current score:<B>%%score%%</B><BR>\r\nTotal votes: <B>%%votes%%</B></FONT><P>\r\n','1','This is the text put at the top of the moderation box after a visitor has voted on a story.','site_html','default','en');
INSERT INTO blocks VALUES ('moderation_comment','<!-- start comment -->\r\n\r\n<TABLE CELLPADDING=1 CELLSPACING=0 BORDER=0 BGCOLOR=\"#FF0000\">\r\n  <TR>\r\n    <TD width=\"100%\">\r\n      <TABLE CELLPADDING=2 CELLSPACING=0 BORDER=0 BGCOLOR=\"%%comment_head_bg%%\" width=\"100%\">\r\n        <TR>\r\n          <TD WIDTH=\"100%\"><A NAME=\"%%cid%%\"></A>\r\n          %%norm_font%% %%new%% <B>%%subject%%</B> %%score%%</A> (<A CLASS=\"light\" HREF=\"%%rootdir%%/comments/%%sid%%/%%cid%%#%%cid%%\">#%%cid%%</A>)%%norm_font_end%% <BR>\r\n          %%norm_font%%by %%name%% %%email%% on %%date%%<BR>%%user_info%% %%url%%%%norm_font_end%%\r\n          </TD>\r\n        </TR>\r\n      </TABLE>\r\n    </TD>\r\n  </TR>\r\n</TABLE>\r\n<BR>\r\n<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>\r\n  <TR>\r\n    <TD>\r\n    %%norm_font%%%%comment%%<BR>%%sig%%<BR>%%actions%%%%norm_font_end%%\r\n    </TD>\r\n  </TR>\r\n</TABLE>\r\n<BR><BR>\r\n%%norm_font%%%%replies%%%%norm_font_end%%\r\n\r\n<!-- end comment -->\r\n\r\n','1','This is just like the block comment, only it is used for \'editorial\' instead of \'topical\' comments.  This uses all the same special and normal vars as the block comment.','content','default','en');
INSERT INTO blocks VALUES ('commentdisclaimer','Trolling is <B>not</B> tolerated here. Any comment may be \r\ndeleted by a site admin, and all trolls <B>will</B> be \r\ndeleted. This is fair warning. If you don\'t know what \r\ntrolling is, then you\'re probably not about to do it, so \r\ndon\'t worry. :-)','1','Anything you want to display above the comment posting form.','site_html','default','en');
INSERT INTO blocks VALUES ('login_box','<TABLE BORDER=0 align=\"center\" CELLPADDING=1 CELLSPACING=0 BGCOLOR=\"%%box_content_bgcolor%%\">\r\n	<TR>\r\n		<TD COLSPAN=2>\r\n			<CENTER>%%LOGIN_ERROR%%</CENTER>\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD COLSPAN=2>\r\n			<CENTER>\r\n			%%norm_font%%\r\n			<B><A CLASS=\"light\" HREF=\"%%rootdir%%/newuser\">Make a new account</A></B>\r\n			%%norm_font_end%%\r\n			</CENTER>\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD align=\"right\">\r\n			<FORM NAME=\"login\" ACTION=\"%%rootdir%%/\" METHOD=\"post\">\r\n			%%norm_font%%<SMALL>Username:</SMALL>%%norm_font_end%%\r\n		</TD>\r\n		<TD>\r\n			%%norm_font%%<SMALL><INPUT TYPE=\"text\" SIZE=12 NAME=\"uname\"></SMALL>%%norm_font_end%%\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD align=\"right\">\r\n			%%norm_font%%<SMALL>Password:</SMALL>%%norm_font_end%%\r\n		</TD>\r\n		<TD>\r\n			%%norm_font%%<SMALL><INPUT TYPE=\"password\" SIZE=12 NAME=\"pass\"></SMALL>%%norm_font_end%%\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD align=\"right\" COLSPAN=2>\r\n    		%%norm_font%%\r\n    			<INPUT TYPE=\"submit\" NAME=\"login\" VALUE=\"Login\">\r\n			<INPUT TYPE=\"submit\" NAME=\"mailpass\" VALUE=\"Mail Password\">\r\n		%%norm_font_end%%</FORM>\r\n    	</TD>\r\n	</TR>\r\n</TABLE>\r\n\r\n','1','Not a box template. This is the content put into the user box if a visitor is not logged in.  This should contain a form with two text inputs, one named \"uname\" and one named \"pass\" for the visitor to input their username and password, respectively, and two submit buttons, one named \"login\" with a value of \"login\" and one named \"mailpass\" with a value of \"Mail Password\".','site_html','default','en');
INSERT INTO blocks VALUES ('hotlist_link','+Hotlist','1','The text of the link provided beside each story title that allows people to add stories to their hotlist.','site_html','default','en');
INSERT INTO blocks VALUES ('hotlist_remove_link','-Hotlist','1','The text of the link provided beside each story title that allows people to remove stories from their hotlist.','site_html','default','en');
INSERT INTO blocks VALUES ('poll_block','<!-- Poll Block -->\r\n<TABLE WIDTH=100% BORDER=0 CELLPADDING=1 CELLSPACING=0>\r\n	<TR>\r\n		<TD BGCOLOR=\"%%title_bgcolor%%\" colspan=2>\r\n			%%title_font%%<B>%%title%%</B></FONT>\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD BGCOLOR=\"%%topic_bg%%\">\r\n			%%norm_font%%%%info%%%%norm_font_end%%\r\n		</TD>\r\n		<TD BGCOLOR=\"%%topic_bg%%\" align=\"right\">\r\n			%%norm_font%%%%hotlist%%%%norm_font_end%%\r\n		</TD>\r\n	</TR>\r\n	<tr><td><br></td></tr>\r\n	%%poll_image%%\r\n</TABLE>\r\n<!-- X Poll Block -->','1','Used by Scoop to format and display a poll.','content','default','en');
INSERT INTO blocks VALUES ('dot','<FONT SIZE=\"+1\"></FONT>','1','Any bit of HTML code that produces a dot or bullet or something for lists in the boxes along the side.','site_html','default','en');
INSERT INTO blocks VALUES ('vote_console','<!-- vote_console -->\r\n<TABLE BGCOLOR=\"#006699\" BORDER=0 CELLPADDING=1 CELLSPACING=0 WIDTH=\"100%\" ALIGN=\"center\">\r\n    <TR>\r\n        <TD>\r\n            <TABLE BGCOLOR=\"%%story_mod_bg%%\" BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=\"100%\" ALIGN=\"center\">\r\n                <TR>\r\n                    <TD>\r\n                    %%norm_font%%\r\n                    Your vote really does count! \r\n                    <B>You</B> decide whether this story ever sees the \r\n                    light of the front page. So vote!\r\n                    %%norm_font_end%%\r\n                    </TD>\r\n                </TR>\r\n     <TR>\r\n        <TD ALIGN=\"center\" VALIGN=\"middle\">\r\n        %%norm_font%%\r\n        %%vote_form%%\r\n        %%norm_font_end%%\r\n        </TD>\r\n    </TR>\r\n           </TABLE>\r\n        </TD>\r\n    </TR>\r\n </TABLE>\r\n<!-- X vote_console -->\r\n','1','The story moderation form, displayed below the story for stories in the moderation queue. There is only one special var: |vote_form| is replaced with the actual form used to register votes.','site_html','default','en');
INSERT INTO blocks VALUES ('blank_box','<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"99%\">\r\n    <tr>\r\n        <td>%%content%%</td>\r\n    </tr>\r\n</table>','1','A box template - no title bar or border.','boxes','default','en');
INSERT INTO blocks VALUES ('story_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n</HEAD>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n	<!-- Main page block -->\r\n	<TR>\r\n		\r\n		<!-- Center content section -->\r\n		<TD VALIGN=\"top\" width=\"75%\">\r\n		<!-- Story stuff -->\r\n			%%STORY%%\r\n		<!-- X story stuff -->\r\n		</TD>\r\n		<!-- X center content section -->\r\n		\r\n		<!-- Right boxes column -->\r\n		<TD VALIGN=\"top\" WIDTH=\"25%\">\r\n			%%BOX,main_menu%%\r\n			%%BOX,user_box%%\r\n			%%BOX,hotlist_box%%\r\n			%%BOX,admin_tools%%\r\n			%%BOX,poll_box%%\r\n			%%BOX,related_links%%\r\n			%%BOX,mod_stats%%\r\n		\r\n		</TD>\r\n		<!-- X Right boxes column -->\r\n	</TR>\r\n	<!-- X main page block -->\r\n</TABLE>\r\n\r\n<!-- comments -->\r\n	%%CONTENT%%\r\n	%%BOX,comment_controls%%\r\n	%%COMMENTS%%\r\n	%%BOX,comment_controls%%\r\n<!-- X comments -->\r\n\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</CENTER>\r\n</BODY>\r\n</HTML>\r\n','1','A page template. This one is used to display the full story and its comments.','templates','default','en');
INSERT INTO blocks VALUES ('poll_guidelines','These are poll guidelines','1','Not used','site_html','default','en');
INSERT INTO blocks VALUES ('attach_poll_message','Below you can attach a poll to this story, if you like. \r\nPolls are not required, but if you want one, fill in a question \r\nand some answers below.','1','The message displayed just above the poll form, below the story submission form, telling the user about the poll.','site_html','default','en');
INSERT INTO blocks VALUES ('default_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n</HEAD>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n	<!-- Main page block -->\r\n	<TR>\r\n		\r\n		<!-- Center content section -->\r\n		<TD VALIGN=\"top\" width=\"73%\">\r\n          			%%STORY%%\r\n			%%BOX,comment_controls%%\r\n			%%CONTENT%%\r\n         			%%BOX,comment_controls%%\r\n		</TD>\r\n		<!-- X center content section -->\r\n		\r\n		<!-- Right boxes column -->\r\n		<TD VALIGN=\"top\" WIDTH=\"27%\">\r\n\r\n			%%BOX,main_menu%%\r\n			%%BOX,hotlist_box%%\r\n			%%BOX,user_box%%\r\n			%%BOX,admin_tools%%\r\n		\r\n		</TD>\r\n		<!-- X Right boxes column -->\r\n	</TR>\r\n	<!-- X main page block -->\r\n</TABLE>\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</CENTER>\r\n</BODY>\r\n</HTML>\r\n','1','A page template. This is the default template, used for most pages on the site.  Be EXTREMELY careful when changing this template! If you mess it up, you may not be able to do anything - the admin pages may use this template!  See http://guide.kuro5hin.org for details on the special vars.','templates','default','en');
INSERT INTO blocks VALUES ('poll_box','<TABLE BGCOLOR=\"#000000\" WIDTH=\"100%\" BORDER=0 CELLPADDING=2 CELLSPACING=0>\r\n	<TR>\r\n		<TD><TABLE WIDTH=\"100%\" BORDER=0 CELLPADDING=2 CELLSPACING=0 BGCOLOR=\"#FFFFFF\">\r\n				<TR>\r\n					<TD>\r\n						%%box_title_font%%%%title%%%%box_title_font_end%%\r\n					</TD>\r\n				</TR>\r\n				<TR>\r\n					<TD>\r\n						%%smallfont%%\r\n						%%content%%\r\n						%%smallfont_end%%\r\n					</TD>\r\n				</TR>\r\n				<TR>\r\n					<TD><IMG SRC=\"%%imagedir%%/spacer.gif\" HEIGHT=5></TD>\r\n				</TR>\r\n			</TABLE></TD>\r\n	</TR>\r\n</TABLE>\r\n','1','A box template. This one is used for the poll.','boxes','default','en');
INSERT INTO blocks VALUES ('submit_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n</HEAD>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n	<!-- Main page block -->\r\n	<TR>\r\n		\r\n		<!-- Center content section -->\r\n		<TD VALIGN=\"top\" width=\"75%\">\r\n			%%STORY%%\r\n			%%CONTENT%%\r\n		</TD>\r\n		<!-- X center content section -->\r\n		\r\n		<!-- Right boxes column -->\r\n		<TD VALIGN=\"top\" WIDTH=\"25%\">\r\n\r\n			%%BOX,main_menu%%\r\n			%%BOX,hotlist_box%%\r\n			%%BOX,user_box%%\r\n			%%BOX,admin_tools%%\r\n			%%BOX,poll_box%%\r\n		\r\n		</TD>\r\n		<!-- X Right boxes column -->\r\n	</TR>\r\n	<!-- X main page block -->\r\n</TABLE>\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</CENTER>\r\n</BODY>\r\n</HTML>\r\n','1','A page template. This one is used when a user is composing a story.','templates','default','en');
INSERT INTO blocks VALUES ('admin_alert','scoop@thissite.com','1','The email address of administrators - used to email alerts when Scoop detects a problem.','block_programs','default','en');
INSERT INTO blocks VALUES ('story_body','<table>\r\n    <tr>\r\n        <td>%%norm_font%%%%bodytext%%%%norm_font_end%%</td>\r\n    </tr>\r\n</table>','1','How the body text of a story is displayed. This should be a reasonably self-contained piece of HTML. There is only one special var used: |bodytext| is replaced by the text of the story body.','content','default','en');
INSERT INTO blocks VALUES ('readmore_txt','Full Story','1','The text of the link at the bottom of the story summary if the story has body text that is not displayed. If the story does not have body text, the block no_body_text is used instead.','site_html','default','en');
INSERT INTO blocks VALUES ('section_links','%%norm_font%%  \r\n  <A HREF=\"%%rootdir%%/\">Front Page</A> \r\n  \r\n  <A HREF=\"%%rootdir%%/section/__all__\">Everything</A> \r\n  \r\n  <A HREF=\"%%rootdir%%/section/news\">News</A> \r\n  \r\n  <A HREF=\"%%rootdir%%/section/Diary\">Diaries</A>\r\n%%norm_font_end%%','1','The links to the different sections. Usually only displayed in the block header.','site_html','default','en');
INSERT INTO blocks VALUES ('diary_submission_message','<FONT SIZE=\"+1\">Your new entry has been posted. Enjoy!</FONT>','1','The message displayed underneath a user\'s diary entry when they have just posted it. Basically free-form HTML.','site_html','default','en');
INSERT INTO blocks VALUES ('box_title_bg','#006699','1','The background colour of the title bar used in a box template. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('comment_head_bg','#eeeeee','1','The background colour of the comment title bar. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('dept_font','<FONT FACE=\"arial, helvetica, sans-serif\" SIZE=2>','1','A complete opening font tag. Used if use_dept is enabled.','display','default','en');
INSERT INTO blocks VALUES ('pendingstory_bg','#c0c0c0','1','The background colour of a story that is still in moderation. Used only in the story list. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('no_body_txt','Comments >>','1','This is the text of the link used instead of readmore_txt if there is nothing in the body of the story.','site_html','default','en');
INSERT INTO blocks VALUES ('sectiononlystory_bg','#eeeeee','1','The background colour of a story that is displayed only in the section. Used only in the story list. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('smallfont','<FONT FACE=\"arial, Helvetica, Sans-Serif\" SIZE=2>','1','A complete opening font tag for text that must be smaller than normal.','display','default','en');
INSERT INTO blocks VALUES ('smallfont_end','</FONT>','1','A closing font tag to match block smallfont.','display','default','en');
INSERT INTO blocks VALUES ('story_mod_bg','#EEEEEE','1','The background colour of a story in moderation that the user has not yet voted on.  A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('story_nav_bg','#EEEEEE','1','The background colour of the story navigation bar. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('submittedstory_bg','#c6dae4','1','The background colour of a story in the moderation queue. Used only in the story list. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('title_bgcolor','#EEEEEE','1','The background colour used for titles. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('undisplayedstory_bg','#c0c0c0','1','The background colour used for stories that have been hidden. Used only in the story list. A hexadecimal colour value: #rrggbb (r = red, g = green, b = blue)','display','default','en');
INSERT INTO blocks VALUES ('scoop_intro','<TABLE WIDTH=\"100%\" BORDER=1 CELLPADDING=2 CELLSPACING=0>\r\n	<TR>\r\n		<TD BGCOLOR=\"#006699\">\r\n			%%box_title_font%%Where to learn about Scoop%%box_title_font_end%%\r\n		</TD>\r\n	</TR>\r\n	<TR>\r\n		<TD>\r\n			%%norm_font%%\r\nHoly Crap! You have your own <A HREF=\"http://scoop.kuro5hin.org\">Scoop</A> site now. Well, there\'s too many features for me to explain right here, but I can give you some places to look for help and whatnot.\r\n<P>\r\nThe main development site is at <A HREF=\"http://scoop.kuro5hin.org\">scoop.kuro5hin.org</A>. This contains links to all the other stuff, so poke around a little.\r\n<P>\r\nFor immediate help and assistance from the Scoop code monkeys, join the <A HREF=\"http://sourceforge.net/mail/?group_id=4901\">scoop-help mailing list</A>. This is practically a requirement for a pleasant Scoop administrative experience, since the docs kind of suck right now.\r\n<P>\r\nSpeaking of docs, there\'s a start at Sourceforge: <A HREF=\"http://sourceforge.net/docman/display_doc.php?docid=100&group_id=4901\">The Scoop Admin\'s Guide</A>. Not complete yet, but it might help.\r\n<P>\r\nOther things of note: \r\n<UL>\r\n<LI> Many Scoop developers can often be found on IRC, channel #scoop at irc.slashnet.org.  If nobody is in that channel, try #kuro5hin\r\n<LI> The main Sourceforge page is <A HREF=\"http://sourceforge.net/project/?group_id=4901\">here</A>\r\n<LI> The latest code is always <A HREF=\"http://sourceforge.net/cvs/?group_id=4901\">in CVS</A>\r\n<LI> You can look at a convenient <A HREF=\"http://scoop.kuro5hin.org/?op=special;page=sites\">list of other Scoop sites</A> to see what folks are doing with it			\r\n</UL>\r\n			%%norm_font_end%%\r\n		</TD>\r\n	</TR>\r\n</TABLE>\r\n<P>','1','The \'introduction to scoop\' box shown in the left column of the front page of a fresh install. You probably want to note the addresses of the links and remove it from the page before your site goes live.','site_html','default','en');
INSERT INTO blocks VALUES ('rss_template','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n<rdf:RDF\r\nxmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\r\nxmlns:fz=\"http://www.zapogee.com/rdf/forumzilla/\"\r\n>\r\n\r\n%%BOX,fzdescribe%%\r\n\r\n</rdf:RDF>','1','Page template used for ForumZilla. Shouldn\'t change this either.','templates','default','en');
INSERT INTO blocks VALUES ('fz_navigation_url','%%site_url%%%%rootdir%%/blank','1','Forumzilla stuff.','forumzilla','default','en');
INSERT INTO blocks VALUES ('fz_ad_url','%%site_url%%%%rootdir%%/blank','1','Forumzilla stuff.','forumzilla','default','en');
INSERT INTO blocks VALUES ('blank_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%slogan%%</TITLE>\r\n</HEAD>\r\n<BODY BGCOLOR=\"#FFFFFF\"></body>\r\n</html>','1','A page template - no header, footer, or content. This must be a complete HTML page.','templates','default','en');
INSERT INTO blocks VALUES ('empty_box','%%content%%','1','A box template that contains no framing, no formatting, just the content via the special var |content|','boxes','default','en');
INSERT INTO blocks VALUES ('fzdisplay_template','<html>\r\n<head><title>%%slogan%%</title></head>\r\n<body bgcolor=\"#EEEEEE\">\r\n<table width=\"80%\" align=\"center\" cellpadding=0 cellspacing=0 bgcolor=\"#000000\" border=0>\r\n<tr><td>\r\n<table width=\"100%\" align=\"center\" cellpadding=10 cellspacing=0 bgcolor=\"#ffffff\" border=0>\r\n<tr><td>\r\n%%BOX,fzdisplay%%</center>\r\n</td></tr>\r\n</table>\r\n</td></tr>\r\n</table>\r\n</body>\r\n</html>','1','Forumzilla stuff.','templates','default','en');
INSERT INTO blocks VALUES ('rss_box','<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n\r\n<rdf:RDF\r\nxmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\r\nxmlns:fz=\"http://www.zapogee.com/rdf/forumzilla/\"\r\n>\r\n\r\n%%BOX,fzdescribe%%\r\n\r\n</rdf:RDF>','1','Template for the ForumZilla boxes. Probably shouldn\'t change this, since doing so will probably break ForumZilla support.','boxes','default','en');
INSERT INTO blocks VALUES ('new_comment_marker','<FONT COLOR=\"#FF0000\"><B>[new]</B></FONT>','1','This is inserted by the code with the comment title if a visitor has not yet read that title.','site_html','default','en');
INSERT INTO blocks VALUES ('allowed_html','A, HREF, NAME, -close\r\nB, -close\r\nP\r\nI, -close\r\nOL, -close\r\nUL, -close\r\nLI\r\nDL, -close\r\nDT\r\nDD\r\nEM, -close\r\nBR\r\nSTRONG, -close\r\nBLOCKQUOTE, TYPE=cite, -close\r\nCITE, -close\r\nTT, -close\r\nCODE, -close\r\n','1','The HTML tags Scoop will allow users to use in stories and comments. Lists the tag name, followed by an optional comma-separated list of elements allowed inside that tag. If the tag must be closed, end the list with \'-close\'.','block_programs','default','en');
INSERT INTO blocks VALUES ('submit_rdf_message','Know of any good sites that syndicate their headlines, but aren\'t carried by this site yet? Well, most likely this is because the admins don\'t know about the site yet, or that they syndicate headlines with RDF. All it takes is for you to find a URL for the site where their RDF file is, and copy it to the form below. Once submitted, and admin will review it, and will either approve it or delete it.','1','The message displayed explaining how to submit an rdf feed.','site_html','default','en');
INSERT INTO blocks VALUES ('submitrdf_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</title>\r\n</head>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n	<!-- Main page block -->\r\n	<TR>\r\n		\r\n		<!-- Center content section -->\r\n		<TD VALIGN=\"top\" width=\"75%\">\r\n			%%BOX,submit_rdf%%\r\n		</td>\r\n		<!-- X center content section -->\r\n		\r\n		<!-- Right boxes column -->\r\n		<TD VALIGN=\"top\" WIDTH=\"25%\">\r\n\r\n			%%BOX,main_menu%%\r\n			%%BOX,hotlist_box%%\r\n			%%BOX,user_box%%\r\n			%%BOX,admin_tools%%\r\n		\r\n		</td>\r\n		<!-- X Right boxes column -->\r\n	</tr>\r\n	<!-- X main page block -->\r\n</table>\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</center>\r\n</body>\r\n</html>\r\n','1','A page template. This one is used when users submit RDF feeds. No special vars, just the submit_rdf box.','templates','default','en');
INSERT INTO blocks VALUES ('titled_box','<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=2 WIDTH=\"100%\">\n	<TR>\n		<TD BGCOLOR=\"%%title_bgcolor%%\">%%title_font%%<B>%%title%%</B>%%title_font_end%%</TD>\n	</TR>\n	<TR>\n		<TD>\n			%%content%%\n		</TD>\n	</TR>\n</TABLE>\n','1','A box template. This one has both |title| and |content| but is otherwise plain.','boxes','default','en');
INSERT INTO blocks VALUES ('cron_template','<html>\r\n<head>\r\n<title>%%slogan%% %%%% Cron</title>\r\n</head>\r\n<body bgcolor=\"#FFFFFF\"><pre>%%CONTENT%%</pre></body>\r\n</html>','1','A page template. No header or footer, only |CONTENT| and title. This must be a complete HTML page. This is used for when cron is run, and is parsed (to an extent) by run_cron.pl, so you\'d best just leave this be.','templates','default','en');
INSERT INTO blocks VALUES ('digest_storyformat','\\n__title__ \\n  By __aid__, __time__ \\n  Section: __section__, Topic: __tid__ \\n\\n__introtext__ \\n\\n__url__\\n\\n----\\n','1','The format of the stories listed in the digest email.  See http://guide.kuro5hin.org for details on the string substitution','email','default','en');
INSERT INTO blocks VALUES ('digest_headerfooter','---------------------------------------------------------\\nThis is the __FREQUENCY__ digest for SITENAME.\\nIf you have received this email in error, just reply to \\nthis message and say that you got it in error.\\nPlease mention that this email was sent for user number __USERID__.\\n---------------------------------------------------------\\n','1','The text of the header and footer of emails sent with the story digest system. The strings __FREQUENCY__ and __USERID__ are replaced with the appropriate values when the email is sent. \n is a newline character, though a normal newline also works.','email','default','en');
INSERT INTO blocks VALUES ('next_page_link','%%norm_font%%Next %%maxstories%% >>%%norm_font_end%%','1','This is the text of the link to the next page of stories. It is placed after the last story on a page.','site_html','default','en');
INSERT INTO blocks VALUES ('prev_page_link','%%norm_font%%<< Previous %%maxstories%%%%norm_font_end%%','1','This is the text of the link to the previous page of stories. It is placed at the top and bottom of the page when a visitor is on a page other than the first, or only the bottom when on the first page.','site_html','default','en');
INSERT INTO blocks VALUES ('op_aliases','queue=modsub,\r\nmoderate=modsub,\r\nforumzilla=fz,\r\nstory=displaystory,\r\nsubmit=submitstory,\r\nwhois=user,\r\nmy=user,\r\ncomment=comments,\r\nfind=search,\r\nviewpoll=view_poll,\r\npoll=view_poll,\n~.+=user','1','This is a list of aliases to various op codes: alias=real, one per line.','block_programs','default','en');
INSERT INTO blocks VALUES ('op_templates','displaystory.length=6:/mode/sid{5}/,\r\ndisplaystory=/sid{5}/,\r\n\r\nuser=EVAL{\r\n  my $p = {};\r\n  if ($S->cgi->param(\'caller_op\') eq \'my\') {\r\n    unshift @path\\, $S->{NICK};\r\n  } elsif ($S->cgi->param(\'caller_op\') =~ m/^~(.+)$/) {\r\n    unshift @path\\, $1;\r\n  }\r\n  my $uid;\r\n  if ($path[0] =~ /uid:/) {\r\n    $path[0] =~ s/^uid://;\r\n    $uid = $path[0];\r\n    $path[0] = $S->get_nick_from_uid($uid);\r\n  } else {\r\n    $uid=$S->get_uid_from_nick($path[0]); \r\n  }\r\n  if ($path[1] eq \'edit\') { $path[1] = \'prefs\' }\r\n  if ($path[1] eq \'diary\') {\r\n    $p = {\r\n      op      => \'section\'\\,\r\n      user    => \"diary_$uid\"\\,\r\n      section => \'Diary\'\\,\r\n      page    => $path[2]\r\n    };\r\n  } elsif ($path[1] =~ /comment/) {\r\n    $p->{op}      = \'search\';\r\n    $p->{type}    = \'comment_by\';\r\n    $p->{string}  = $path[0];\r\n  } elsif ($path[1] eq \'ads\') {\r\n    $p->{op}      = \'adinfo\';\r\n    $p->{ad_id}   = \"uid:$uid\";\r\n  } elsif ($path[1] eq \'stories\' || $path[1] eq \'story\') {\r\n    $p->{op}      = \'search\';\r\n    $p->{type}    = \'author\';\r\n    $p->{string}  = $path[0];\r\n  } else {\r\n    $p->{op}      = \'user\';\r\n    $p->{tool}    = $path[1];\r\n    $p->{nick}    = $path[0];\r\n  }\r\n  return $p;\r\n},\r\n\r\nsearch.length=2:/type/string/,\r\nsearch=/string/,\r\n\r\nsection=/section/page/,\r\n\r\nspecial=/page/,\r\n\r\nsubmitstory=/section/,\r\n\r\ninterface=/tool/,\r\n\r\nview_poll=/qid/,\r\n\r\nhotlist=/tool/sid{5}/new_op/page/section/,\r\n\r\ncomments.1=poll:/null/sid/cid/tool/,\r\ncomments.length=2:/sid/cid/,\r\ncomments.length=3:/sid/cid/tool/,\r\ncomments=/sid{5}/cid/tool/,\r\n\r\nadmin.1=story:/tool/sid{5}/,\r\nadmin.1=editpoll:/tool/editqid/option/,\r\nadmin.1=vars:/tool/cat/,\r\nadmin.1=blocks:/tool/mode/theme/item/,\r\nadmin.1=topics:/tool/tid/,\r\nadmin.1=sections:/tool/section/,\r\nadmin.1=special:/tool/id/,\r\nadmin.1=boxes:/tool/id,\r\nadmin.1=optemplates:/tool/opcode,\r\nadmin.1=groups:/tool/perm_group_id/,\r\nadmin.1=rdf:/tool/action/,\r\nadmin.1=cron:/tool/action/which/,\r\nadmin.1=ads:/tool/type/which,\r\nadmin.1=ops:/tool/opcode/,\nadmin=tool,\r\n\r\nprint=/sid{5}/,\r\n\r\nfzdisplay=/action/sid{5}/cid/,\r\n\r\nnewuser=/tool/uname/confirm/,\r\n\r\nmain=/page/,\r\nconfirmpass=/nick/key/,\r\nshowad=/ad_id/,\r\nsubmitad=/step/,\r\nredirect=/ad_id/,\r\nadinfo=/ad_id/,\r\n\r\nads=/distribute,','1','This block sets the rules used for the new URL style. Unless you add an op, or want to tweak the rules, you won\'t need to change this.  For details on the format, see http://guide.kuro5hin.org.','block_programs','default','en');
INSERT INTO blocks VALUES ('subscribe','You are not currently a subscriber. Why not become one?','1','Text of a \"please subscribe\" message.','site_html','default','en');
INSERT INTO blocks VALUES ('story_separator','\n','1','Placed between the story summary and the story body to separate them visually.','site_html','default','en');
INSERT INTO blocks VALUES ('spell_err','<font color=\"red\">','1','A complete opening font tag for marking spelling errors.  Only used if spell checking is active.','display','default','en');
INSERT INTO blocks VALUES ('spell_err_end','</font>','1','A closing font tag matching spell_err','display','default','en');
INSERT INTO blocks VALUES ('all_html','TT, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nI, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nB, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nU, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nS, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nBIG, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nSMALL, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nEM, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nSTRONG, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nDFN, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nCODE, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nSAMP, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nKBD, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nVAR, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nCITE, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nABBR, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nACRONYM, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nSUB, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nSUP, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nSPAN, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nBDO, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nBASEFONT, id, size, color, face\nFONT, id, class, style, title, lang, dir, size, color, face, -close\nBR, id, class, style, title, clear=\"(?i)^(left|all|right|none)$\"\nBODY, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, onload, onunload, background, bgcolor, text, link, vlink, alink, -close\nADDRESS, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nDIV, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\", -close\nCENTER, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nA, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, charset, type, name, href, hreflang, target, rel, rev, accesskey, shape, coords, tabindex, onfocus, onblur, -close\nMAP, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, name, -close\nAREA, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, shape, coords, href, target, nohref, alt, tabindex, accesskey, onfocus, onblur\nLINK, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, charset, href, hreflang, type, rel, rev, media, target\nIMG, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, src, alt, longdesc, name, height, width, usemap, ismap, align=\"(?i)^(top|middle|bottom|left|right)$\", border, hspace, vspace\nOBJECT, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, declare, classid, codebase, data, type, codetype, archive, standby, height, width, usemap, name, tabindex, align, border, hspace, vspace, -close\nPARAM, id, name, value, valuetype=\"(?i)^(DATA|REF|OBJECT)$\", type\nAPPLET, id, class, style, title, codebase, archive, code, object, alt, name, width, height, align, hspace, vspace, -close\nHR, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right)$\", size, width\nP, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\"\nH1, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\", -close\nH2, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\", -close\nH3, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\", -close\nH4, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\", -close\nH5, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\", -close\nH6, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify)$\", -close\nPRE, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, width, -close\nQ, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, cite, -close\nBLOCKQUOTE, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, cite, -close\nINS, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, cite, datetime, -close\nDEL, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, cite, datetime, -close\nDL, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, compact, -close\nDT, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nDD, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nOL, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, type=\"^(1|a|A|i|I)$\", compact, start, -close\nUL, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, type=\"(?i)^(disk|square|circle)$\", compact, -close\nDIR, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, compact, -close\nMENU, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, compact, -close\nLI, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, type=\"^(1|a|A|i|I|((?i)disk|square|circle))$\", value\nFORM, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, action, method=\"(?i)^(GET|POST)$\", enctype, accept, name, onsubmit, onreset, target, accept-charset, -close\nLABEL, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, for, accesskey, onfocus, onblur, -close\nINPUT, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, type=\"(?i)^(text|password|checkbox|radio|submit|reset|file|hidden|image|button)$\", name, value, checked, disabled, readonly, size, maxlength, src, alt, usemap, ismap, tabindex, accesskey, onfocus, onblur, onselect, onchange, accept, align\nSELECT, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, name, size, multiple, disabled, tabindex, onfocus, onblur, onchange, -close\nOPTGROUP, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, disabled, label, -close\nOPTION, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, selected, disabled, label, value\nTEXTAREA, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, name, rows, cols, disabled, readonly, tabindex, accesskey, onfocus, onblur, onselect, onchange, -close\nFIELDSET, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nLEGEND, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, accesskey, align=\"(?i)^(top|bottom|left|right)$\", -close\nBUTTON, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, name, value, type, disabled, tabindex, accesskey, onfocus, onblur, -close\nTABLE, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, summary, width, border, frame=\"(?i)^(void|above|below|hsides|lhs|rhs|vsides|box|border)$\", rules=\"(?i)^(none|groups|rows|cols|all)$\", cellspacing, cellpadding, align=\"(?i)^(left|center|right)$\", bgcolor, -close\nCAPTION, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(top|bottom|left|right)$\", -close\nCOLGROUP, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, span, width, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\", -close\nCOL, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, span, width, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\"\nTHEAD, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\", -close\nTBODY, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\", -close\nTFOOT, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\", -close\nTR, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\", bgcolor, -close\nTH, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\", abbr, acis, headers, scope=\"(?i)^(row|col|rowgroup|colgroup)$\", rowspan, colspan, nowrap, bhcolor, width, height, -close\nTD, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, align=\"(?i)^(left|center|right|justify|char)$\", char, charoff, valign=\"(?i)^(top|middle|bottom|baseline)$\", abbr, acis, headers, scope=\"(?i)^(row|col|rowgroup|colgroup)$\", rowspan, colspan, nowrap, bhcolor, width, height, -close\nFRAMESET, id, class, style, title, rows, cols, onload, onunload, -close\nFRAME, id, class, style, title, longdesc, name, src, frameborder=\"^(1|0)$\", marginwidth, marginheight, noresize, scrolling=\"(?i)^(yes|no|auto)$\"\nIFRAME, id, class, style, title, longdesc, name, src, frameborder=\"^(1|0)$\", marginwidth, marginheight, scrolling=\"(?i)^(yes|no|auto)$\", align, height, width, -close\nNOFRAMES, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nHEAD, lang, dir, profile, -close\nTITLE, lang, dir, -close\nISINDEX, id, class, style, title, lang, dir, prompt\nBASE, href, target\nMETA, lang, dir, http-equiv, name, content, scheme\nSTYLE, lang, dir, type, media, title, -close\nSCRIPT, charset, type, language, src, defer, event, for, -close\nNOSCRIPT, id, class, style, title, lang, dir, onclick, ondblclick, onmousedown, onmouseup, onmouseover, onmousemove, onmouseout, onkeypress, onkeydown, onkeyup, -close\nHTML, lang, dir, version, -close\n','1','All HTML tags','block_programs','default','en');
INSERT INTO blocks VALUES ('new_user_html','  <TR>\r\n   <TD COLSPAN=2 BGCOLOR=\"%%title_bgcolor%%\">%%title_font%%\r\n   <B>Create New User Account</B>%%title_font_end%%<P>\r\n   <FORM NAME=\"adduser\" METHOD=\"post\" ACTION=\"%%rootdir%%/\">\r\n   <INPUT TYPE=\"hidden\" name=\"tool\" VALUE=\"writeuser\">\r\n   <INPUT TYPE=\"hidden\" name=\"op\" VALUE=\"newuser\">\r\n   <INPUT TYPE=\"hidden\" name=\"formkey\" VALUE=\"%%formkey%%\">\r\n   </TD>\r\n  </TR>\r\n  <TR><TD COLSPAN=2><FONT COLOR=\"#FF0000\"><H3><CENTER>%%error%%</CENTER></H3></FONT></TD></TR>\r\n  <TR><TD COLSPAN=2>%%norm_font%%\r\n  This is where you start the two-step process of creating a new user account. Here is what you will do:\r\n  <UL><LI>Fill out this form. You will receive a confirmation email immediately, at the address you provide here.\r\n  <LI>Follow the instructions on that email to activate your account.\r\n  </UL>\r\n  It\'s that easy. Why do I require a working email account, and a confirmation? Mainly this is to prevent abuse of the story moderation system. It should at least make it harder for malicious users to create an arbitrary number of accounts and spam the site with stories. Your password will be mailed to this address, so it *must* work!\r\n  <P>\r\n  If you are concerned about privacy, this email does not have to be in any way traceable to you. I will never use the email you provide here for anything else, ever. All it needs to be is working, and accessable to you, at the time the account is created. \r\n  <P>\r\n  Now get started, and we hope you enjoy %%sitename%%!\r\n  %%norm_font_end%%</TD></TR>\r\n  <TR><TD COLSPAN=2>&nbsp;</TD></TR>\r\n  <TR>\r\n   <TD>\r\n   %%norm_font%%\r\n   Please enter your desired username:<BR>\r\n   %%norm_font_end%%\r\n   </TD>\r\n   <TD>\r\n   %%norm_font%%<INPUT TYPE=\"text\" NAME=\"nickname\" SIZE=30 VALUE=\"%%uname%%\">%%norm_font_end%%<BR>\r\n   </TD>\r\n  </TR>\r\n   <TD COLSPAN=2>\r\n   %%smallfont%%(Legal characters: a-z, A-Z, 0-9, space. Names may not start or end with a space, and may not contain more than one space in a row.)%%smallfont_end%%\r\n   </TD>\r\n  </TR>\r\n  <TR>\r\n   <TD>\r\n   %%norm_font%%\r\n   and a working email (this will never be made public!):<BR>\r\n   <B><FONT COLOR=\"#FF0000\">Check this for typos!</FONT></B>\r\n   %%norm_font_end%%\r\n   </TD>\r\n   <TD>\r\n   %%norm_font%%<INPUT TYPE=\"text\" NAME=\"email\" VALUE=\"%%email%%\" SIZE=30>%%norm_font_end%%\r\n   </TD>\r\n  </TR>','1','The HTML form and explanation text used on the page a new user visits to create an account.','site_html','default','en');
INSERT INTO blocks VALUES ('new_advertiser_html','<tr><td colspan=\"2\"><input type=\"hidden\" name=\"advertiser\" value=\"1\">&nbsp;</td></tr>\r\n <TR>\r\n  <TD colspan=\"2\">%%norm_font%%\r\nSince you have expressed an interest in advertising on this site, I\'ll be needing a bit more\r\ninformation about you, for billing purposes. \r\n%%norm_font_end%%</TD>\r\n </TR>\r\n <TR>\r\n  <TD colspan=\"2\">%%norm_font%% %%advertising_account_disclaimer%% %%norm_font_end%% </TD>\r\n </TR>\r\n <TR>\r\n  <TD align=\"right\">%%norm_font%% Your Name: %%norm_font_end%%</TD>\r\n  <TD align=\"left\"> <input type=\"text\" name=\"realname\" value=\"%%yourname%%\" size=\"30\"></TD>\r\n </TR>\r\n <TR>\r\n  <TD align=\"right\">%%norm_font%% Business name: %%norm_font_end%%</TD>\r\n  <TD align=\"left\"><input type=\"text\" name=\"bizname\" value=\"%%bizname%%\" size=\"40\"> </TD>\r\n </TR>\r\n <TR>\r\n  <TD align=\"right\">%%norm_font%% Contact phone number: %%norm_font_end%%</TD>\r\n  <TD align=\"left\"><input type=\"text\" name=\"bizphone\" value=\"%%bizphone%%\" size=\"12\"> </TD>\r\n </TR>\r\n <TR>\r\n  <TD align=\"right\">%%norm_font%% Mailing Address: %%norm_font_end%%</TD>\r\n  <TD align=\"left\"><textarea cols=\"30\" rows=\"5\" name=\"snailmail\" value=\"%%snailmail%%\"></textarea></TD>\r\n </TR>\r\n','1','A form used for collecting contact information from new advertisers.','advertising','default','en');
INSERT INTO blocks VALUES ('advertising_account_disclaimer','Please remember the following with your new advertising account. <br><br><blockquote> <b>Any stories posted to this site for purely advertising purposes will void your contract with us.</b> The articles and diaries on this site are <b>not for advertising purposes</b>.  This account entitles you to submit ads for posting in specified places on the page only.  If you are caught abusing this account, you\'re ads will be disabled, no money will be refunded, and your account will be disabled.  If you have any questions about this send mail to %%local_email%%.\r\n</blockquote><br>  Thank you for your understanding.','1','A warning and reminder of the terms of use of an advertising account.','advertising','default','en');
INSERT INTO blocks VALUES ('ad_test_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%slogan%%</TITLE>\r\n</HEAD>\r\n<BODY BGCOLOR=\"#FFFFFF\">%%BOX,show_ad,fromurl%%</body>\r\n</html>','1','A page template with just the ad on it','advertising','default','en');
INSERT INTO blocks VALUES ('text_ad_template','<TABLE bgcolor=\"FFFFFF\" fgcolor=\"000000\" border=\"0\" cellpadding=\"2\" cellspacing=\"1\">\r\n<TR><TD><a href=\"%%REDIRECT_URL%%?to_url=%%LINK_URL%%\" title=\"%%LINK_URL%%\" %%TARGET%%>\r\n%%norm_font%% %%TITLE%%%%norm_font_end%%</a> </TD></TR>\r\n<TR><TD>%%norm_font%%%%TEXT1%%%%norm_font_end%%</TD></TR>\r\n</TABLE>','1','The template used for text ads.','advertising','default','en');
INSERT INTO blocks VALUES ('preview_text_ad_template','<TABLE bgcolor=\"FFFFFF\" fgcolor=\"000000\" border=\"0\" cellpadding=\"2\" cellspacing=\"1\" width=\"200\">\r\n<TR><TD><a href=\"%%LINK_URL%%\" title=\"%%LINK_URL%%\">%%norm_font%% %%TITLE%%%%norm_font_end%% </a></TD></TR>\r\n<TR><TD>%%norm_font%%%%TEXT1%%%%norm_font_end%%</TD></TR>\r\n</TABLE>','1','The text ad template used when previewing a new ad.','templates','default','en');
INSERT INTO blocks VALUES ('ad_step1_rules','<!-- ad_step1_rules.  Do not take out the |NEXT_LINK| text, as it will be replaced with a button to get the user to the next step in the process -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n<TR>\r\n        <TD VALIGN=\"top\" width=\"55%\" BGCOLOR=\"%%title_bgcolor%%\">\r\n            %%title_font%% Rules for Submitting Ads %%title_font_end%%\r\n        </TD>\r\n</TR>\r\n<TR>\r\n<TD>%%norm_font%%\r\n<ul>\r\n<li>These are the rules for submitting ads on this Scoop site.\r\n</ul>\r\n%%norm_font_end%%\r\n</TD>\r\n</TR>\r\n<TR><TD>%%norm_font%% %%NEXT_LINK%% %%norm_font_end%%\r\n</TABLE>','1','Rules for submitting ads.  Insert your site\'s rules in the list.','advertising','default','en');
INSERT INTO blocks VALUES ('error_template','<h1>%%ERROR_TYPE%%</h1>\r\n<p>\r\n<b>Time:</b> %%thetime%%<br>\r\n<b>Package:</b> %%package%%<br>\r\n<b>File:</b> %%file%% <br>\r\n<b>Line:</b> %%line%% <br>\r\n<b>Additional Messages:</b> %%ERROR_MSG%%\r\n<b>Var Dump:</b><br>\r\n%%VARDUMP%%\r\n</p>','1','A layout for error messages when scoop really chokes.','templates','default','en');
INSERT INTO blocks VALUES ('ad_confirm_text','<p>Your ad is shown above for you to make sure that its how you want it.  If you see any problems,\r\nhit back and fix them.  Make sure that you take note of how much this will cost, as the next step\r\nis where you pay. If you like what you see, hit \"Purchase Ad\" below, if not, hit back and make your\r\nchanges.</p>','1','Text shown on ad preview page, just before purchase.','advertising','default','en');
INSERT INTO blocks VALUES ('no_submit_ad_perm','<TABLE BORDER=0 CELLPADDING=1 CELLSPACING=1 WIDTH=\"99%\"> \r\n<TR><TD bgcolor=\"%%title_bgcolor%%\">%%title_font%% Submit Ad Error %%title_font_end%%</TD></TR>\r\n<TR><TD >%%norm_font%% Sorry, but you must have a user account or login before you can submit ads on this site.  You may login using the box to your right.  To create an account you may go <a href=\"%%rootdir%%/newuser\">here</a>%%norm_font_end%%</TD></TR>\r\n</TABLE>\r\n','1','Error message telling a user they don\'t have the permissions required to submit ads to the site.','advertising','default','en');
INSERT INTO blocks VALUES ('ad_disapproval_mail','The ad that you submitted to %%sitename%% was disapproved today\r\nfor the following reason:\r\n\r\n%%REASON%%\r\n\r\nAdvertisement details:\r\nTitle: %%TITLE%%\r\nText1: %%TEXT1%%\r\nURL: %%URL%%\r\n\r\nIf you have received this message in error, please reply and let us know.\r\n\r\n-%%sitename%%\r\n%%local_email%%\r\n','1','The text of the email sent when an ad is disapproved.','advertising,email','default','en');
INSERT INTO blocks VALUES ('ad_approval_mail','The ad that you submitted to %%sitename%% was accepted for display on our site.\r\n\r\nAdvertisement details:\r\nTitle: %%TITLE%%\r\nText1: %%TEXT1%%\r\nURL: %%URL%%\r\n\r\nIf you have received this message in error, please reply and let us know.\r\n\r\n-%%sitename%%\r\n%%local_email%%\r\n','1','The text of the email sent when an ad is approved.','advertising,email','default','en');
INSERT INTO blocks VALUES ('perms','edit_perms,\r\nshow_perms,\r\nedit_user,\r\nedit_special,\r\nedit_boxes,\r\nedit_vars,\r\nlist_polls,\r\nedit_topics,\r\nedit_polls,\r\nedit_sections,\r\nstory_admin,\r\nstory_post,\r\nstory_list,\r\ncomment_post,\r\ncomment_delete,\r\ncomment_rate,\r\nmoderate,\r\nattach_poll,\r\npoll_vote,\r\npoll_post_comments,\r\npoll_read_comments,\r\nview_polls,\r\nedit_groups,\r\nsuper_mojo,\r\nrdf_admin,\r\nsubmit_rdf,\r\ncron_admin,\r\nad_admin,\r\nedit_blocks,\r\nsubmit_ad,\r\nhotlist,\nuse_spellcheck,\nview_comment_ip,\nshow_hidden_sections,\nedit_own_story,\nedit_ops,\nedit_hooks','1','A list of all the perms used on the system.','block_programs','default','en');
INSERT INTO blocks VALUES ('mail_ad_almost_done_msg','The ad that you submitted to %%sitename%% has is almost finished wth its campaign. You only have %%VIEWS_LEFT%% impressions left before its gone.  If you would like to not receive these reminders, please reply and let us know.\r\n\r\nAdvertisement details:\r\nTitle: %%TITLE%%\r\nText1: %%TEXT1%%\r\nURL: %%URL%%\r\n\r\nIf you have received this message in error, please reply and let us know.\r\n\r\n-%%sitename%%\r\n%%local_email%%\r\n','1','The text of the email sent by the system when impressions are almost gone from a given ad.','advertising,email','default','en');
INSERT INTO blocks VALUES ('mail_ad_done_msg','The ad that you submitted to %%sitename%% has finished its campaign.  Thank you for advertising on our site, we look forward to doing business with you again.\r\n\r\nAdvertisement details:\r\nTitle: %%TITLE%%\r\nText1: %%TEXT1%%\r\nURL: %%URL%%\r\n\r\nIf you have received this message in error, please reply and let us know.\r\n\r\n-%%sitename%%\r\n%%local_email%%\r\n','1','The text of the email sent by the system when impressions are gone from a given ad.','advertising,email','default','en');
INSERT INTO blocks VALUES ('buyimpressions_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n</HEAD>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n	<!-- Main page block -->\r\n	<TR>\r\n		\r\n		<!-- Center content section -->\r\n		<TD VALIGN=\"top\" width=\"73%\">\r\n			%%BOX,buyimpressions_box%%\r\n		</TD>\r\n		<!-- X center content section -->\r\n		\r\n		<!-- Right boxes column -->\r\n		<TD VALIGN=\"top\" WIDTH=\"27%\">\r\n\r\n			%%BOX,main_menu%%\r\n			%%BOX,hotlist_box%%\r\n			%%BOX,user_box%%\r\n			%%BOX,admin_tools%%\r\n		\r\n		</TD>\r\n		<!-- X Right boxes column -->\r\n	</TR>\r\n	<!-- X main page block -->\r\n</TABLE>\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</CENTER>\r\n</BODY>\r\n</HTML>\r\n','1','A page template to hold the box buyimpressions_box.','templates','default','en');
INSERT INTO blocks VALUES ('buy_ad_impression_message','From here you can pre-pay for ad impressions.  Once you have prepaid impressions on your account, you can distribute them to any ad you have submitted, from the <a href=\"%%rootdir%%/ads/dist\">distribution</a> page.','1','directions on buying ad impressions separately from ads.','advertising','default','en');
INSERT INTO blocks VALUES ('confirm_purchase_impressions','If you\'re sure that you want to buy this many impressions, click \"Purchase\" below, and proceed to the payment page.  If you need to make a change, change the number and hit confirm again.','1','Text of the confirm message just before purchase.','advertising','default','en');
INSERT INTO blocks VALUES ('editqueuestory_bg','#99ccdd','1','Background colour of a story in the edit queue','display','default','en');
INSERT INTO blocks VALUES ('author_edit_console','<!-- author_edit_console -->\r\n<TABLE BGCOLOR=\"#006699\" BORDER=0 CELLPADDING=1 CELLSPACING=0 WIDTH=\"100%\" ALIGN=\"center\">\r\n    <TR>\r\n        <TD>\r\n            <TABLE BGCOLOR=\"%%story_mod_bg%%\" BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=\"100%\" ALIGN=\"center\">\r\n                <TR>\r\n                    <TD>\r\n                    %%norm_font%%\r\n                    As the author of this story, you may cancel the submission at any time during voting. Simply check the confirm box below, and click \"Cancel Submission\". If the story is still in editing, you may also edit it using the \"Edit\" button. To finish the editing period and move the story to voting, click \"Edit\", uncheck \"Request editorial feedback\" and save.\r\n                    %%norm_font_end%%\r\n                    </TD>\r\n                </TR>\r\n    <TR>\r\n        <TD ALIGN=\"center\" VALIGN=\"middle\">\r\n        %%norm_font%%\r\n        %%author_edit_form%%\r\n        %%norm_font_end%%\r\n        </TD>\r\n    </TR>\r\n           </TABLE>\r\n        </TD>\r\n    </TR>\r\n</TABLE>\r\n<!-- X vote_console -->\r\n','1','The editing console for the story author, when the story is in the edit queue.','site_html','default','en');
INSERT INTO blocks VALUES ('edit_instructions','<!-- vote_console -->\r\n<TABLE BGCOLOR=\"#006699\" BORDER=0 CELLPADDING=1 CELLSPACING=0 WIDTH=\"100%\" ALIGN=\"center\">\r\n    <TR>\r\n        <TD>\r\n            <TABLE BGCOLOR=\"%%story_mod_bg%%\" BORDER=0 CELLPADDING=3 CELLSPACING=0 WIDTH=\"100%\" ALIGN=\"center\">\r\n                <TR>\r\n                    <TD>\r\n                    %%norm_font%%\r\n<b>Please Help.</b> The author of this story has requested editorial help from you, and the rest of the community. Please read, and post your editorial suggestions below. The author can edit at any time, so some suggestions may already have been fixed when you read them. After editing, the story will continue on to voting as usual.\r\n                    %%spam_form%%\r\n                    %%norm_font_end%%\r\n                    </TD>\r\n                </TR>\r\n            </TABLE>\r\n        </TD>\r\n    </TR>\r\n</TABLE>\r\n<!-- X vote_console -->','1','Instructions to the author regarding story editing','site_html','default','en');
INSERT INTO blocks VALUES ('renewad_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n</HEAD>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\">\r\n\r\n%%header%%\r\n\r\n<!-- Main layout table -->\r\n<TABLE BORDER=0 WIDTH=\"99%\" ALIGN=\"center\" CELLPADDING=0 CELLSPACING=10>\r\n	<!-- Main page block -->\r\n	<TR>\r\n		\r\n		<!-- Center content section -->\r\n		<TD VALIGN=\"top\" width=\"73%\">\r\n			%%BOX,renewad_box%%\r\n		</TD>\r\n		<!-- X center content section -->\r\n		\r\n		<!-- Right boxes column -->\r\n		<TD VALIGN=\"top\" WIDTH=\"27%\">\r\n\r\n			%%BOX,main_menu%%\r\n			%%BOX,hotlist_box%%\r\n			%%BOX,user_box%%\r\n			%%BOX,admin_tools%%\r\n		\r\n		</TD>\r\n		<!-- X Right boxes column -->\r\n	</TR>\r\n	<!-- X main page block -->\r\n</TABLE>\r\n<!-- X Main layout table -->\r\n<P>\r\n%%footer%%\r\n<P>\r\n<CENTER>%%BOX,menu_footer%%</CENTER>\r\n</BODY>\r\n</HTML>\r\n','1','Page template to hold the renewad box','templates','default','en');
INSERT INTO blocks VALUES ('renew_ad_message','Renew an ad.  Right here!  Today!','1','Text displayed to get people to renew ads','advertising','default','en');
INSERT INTO blocks VALUES ('renew_choose_ad','%%norm_font%% You need to choose an ad to renew.  Check <a href=\"%%rootdir%%/my/ads\">your ad listing page</a> to \r\nchoose an ad to renew. %%norm_font_end%%','1','Message displayed to tell the person that they need to choose an ad to renew before they can renew anything','advertising','default','en');
INSERT INTO blocks VALUES ('renew_ad_no_permission','%%norm_font%% Sorry, but you cannot renew another person\'s advertisement.  Please choose an ad from <a href=\"%%rootdir%%/my/ads\">your ad list</a> to renew.%%norm_font_end%%','1','Message displayed if somebody tries to renew a different user\'s ad','advertising','default','en');
INSERT INTO blocks VALUES ('renew_confirm_message','%%norm_font%% Be sure that you entered the correct amount of impressions to buy, and click confirm below when you are satisfied and ready to purchase. %%norm_font_end%%','1','Message displayed just before ad renewal purchase, getting the user to double-check that everything is correct','advertising','default','en');
INSERT INTO blocks VALUES ('confirm_ad_renew','%%norm_font%% Be sure this is the number of impressions you want to purchase, and hit \"Purchase\" below when you are ready to renew your ad %%norm_font_end%%','1','Text of the confirm message just before ad renewal.','advertising','default','en');
INSERT INTO blocks VALUES ('dynamic_template','<HTML>\r\n<HEAD>\r\n<TITLE>%%sitename%% || %%subtitle%%</TITLE>\r\n<SCRIPT TYPE=\"text/javascript\" SRC=\"/dynamic-comments.js\"></SCRIPT>\r\n</HEAD>\r\n<BODY bgcolor=\"#FFFFFF\" text=\"#000000\" link=\"#006699\" vlink=\"#003366\" onload=\"copyContent(%%mainpid%%,%%dynamicmode%%)\">\r\n%%CONTENT%%\r\n</BODY>\r\n</HTML>\r\n','1','Page template for dynamic comment display mode','templates','default','en');
INSERT INTO blocks VALUES ('ad_renewal_mail','Your ad on %%sitename%% has been renewed.\r\n\r\nAdvertisement details:\r\nTitle: %%TITLE%%\r\nText1: %%TEXT1%%\r\nURL: %%URL%%\r\nAdditional Impressions: %%IMPRESSIONS%%\r\n\r\nIf you have received this message in error, please reply and let us know.\r\n\r\n-%%sitename%%\r\n%%local_email%%\r\n','1','The text of the email sent when an ad is renewed.','advertising,email','default','en');
INSERT INTO blocks VALUES ('paypal_finished','Thank you for your order! An administrator will soon review your ad to \r\nensure that it meets our guidelines. You will receive a notice by email \r\nwhen your ad is reviewed. If your ad is not approved, the charge to your \r\naccount will be reversed. If it is approved, it will begin running \r\nimmediately.\r\n','1','Text displayed after somebody finished paying for their ad through paypal','advertising','default','en');
INSERT INTO blocks VALUES ('paypal_canceled','We\'re sorry you decided to cancel your order.','1','Text displayed if somebody cancelled their order of ads','advertising','default','en');
INSERT INTO blocks VALUES ('dynamic_loading_link','<img src=%%imagedir%%/dyn_wait.gif width=12 height=16 ALT=x border=0>','1','Text or image of the comment loading message','site_html','default','en');
INSERT INTO blocks VALUES ('dynamic_collapse_bottom_link','<img src=%%imagedir%%/dyn_colb.gif width=12 height=12 ALT=- border=0>','1','Text or image of the link to collapse a comment, placed at the bottom of the comment.','site_html','default','en');
INSERT INTO blocks VALUES ('block_category_list','<tr>\r\n<td>%%norm_font%%<a href=\"%%rootdir%%/admin/blocks/%%item_url%%\">%%item%%</a>%%norm_font_end%%</td>\r\n<td>%%norm_font%%<a href=\"%%rootdir%%/admin/blocks/%%item_url%%\">%%item%%</a>%%norm_font_end%%</td>\r\n<td>%%norm_font%%<a href=\"%%rootdir%%/admin/blocks/%%item_url%%\">%%item%%</a>%%norm_font_end%%</td>\r\n</tr>\r\n',NULL,'One line of the block category list.  Usually one table row.','admin_pages','default','en');
INSERT INTO blocks VALUES ('edit_block','<form name=\"editblocks\" action=\"%%rootdir%%/admin/blocks/\" method=\"post\">\r\n<input type=\"hidden\" name=\"cat\" value=\"%%category%%\" />\r\n\r\n<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">\r\n<tr><td bgcolor=\"%%title_bgcolor%%\">%%title_font%%Blocks: %%category%%%%title_font_end%%</td></tr>\r\n<tr><td>%%norm_font%%%%update_msg%%%%norm_font_end%%</td></tr>\r\n<tr><td> </td></tr>\r\n<tr><td>%%norm_font%%Choose a category to edit:%%norm_font_end%%</td></tr>\r\n<tr><td>\r\n	<table border=\"0\" cellpadding=\"0\" cellspacing=\"2\" width=\"100%\">%%catlist%%</table>\r\n</td></tr>\r\n<tr><td>%%norm_font%%<input type=\"submit\" name=\"save\" value=\"Save\"> <input type=\"submit\" name=\"edit\" value=\"Get\" />%%norm_font_end%%</td></tr>\r\n<tr><td>%%norm_font%%%%html_check%%%%norm_font_end%%</td></tr>\r\n<tr><td>\r\n	<table border=0 cellpadding=1 cellspacing=0 width=\"100%\">%%form_body%%</table>\r\n</td></tr>\r\n<tr><td>%%norm_font%%<input type=\"submit\" name=\"save\" value=\"Save\"> <input type=\"submit\" name=\"edit\" value=\"Get\" />%%norm_font_end%%</td></tr>\r\n</table>\r\n</form>\r\n',NULL,'The main edit block page.  the special var \"form_body\" is either the single-block edit form, or the category table, depending on which view you\'re using.','admin_pages','default','en');
INSERT INTO blocks VALUES ('edit_cat_blocks','<!-- category line begin -->\r\n<tr>\r\n	<td>\r\n		%%norm_font%%%%name%%<br />\r\n		%%description%%%%norm_font_end%%\r\n	</td>\r\n	<td>%%norm_font%%%%value%%%%norm_font_end%%</td>\r\n</tr>\r\n<!--category line end -->\r\n',NULL,'One line of the table all blocks in one category are placed in.  Special vars name, description, and value are a link, plain text, and a textarea, respectively, that are substituted in.','admin_pages','default','en');
INSERT INTO blocks VALUES ('edit_cat_vars','<tr>\r\n	<td>%%norm_font%%%%name%%%%norm_font_end%%</td>\r\n	<td>%%norm_font%%%%value%%%%norm_font_end%%</td>\r\n	<td>%%norm_font%%%%description%%%%norm_font_end%%</td>\r\n</tr>\r\n',NULL,'One line of the table all vars in one category are placed in.  Special vars name, value, and description are a link, the appropriate input element for the var type, and text, respectively','admin_pages','default','en');
INSERT INTO blocks VALUES ('edit_one_block','<tr><td>%%norm_font%%Or edit a block directly:%%norm_font_end%%</td></tr>\r\n<tr><td><table cellspacing=\"2\" cellpadding=\"0\" width=\"100%\">\r\n	<tr>\r\n		<td colspan=\"2\">%%norm_font%%<b>Delete:</b><input type=\"checkbox\" name=\"delete\" value=\"1\">%%norm_font_end%%</td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Select Block:</b>%%norm_font_end%%</td>\r\n		<td>%%blockselect%%</td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Select Categories:</b>%%norm_font_end%%</td>\r\n		<td>%%catselect%%</td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Name:</b>%%norm_font_end%%</td>\r\n		<td><input type=\"text\" size=\"60\" name=\"name\" value=\"%%bid%%\"></td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Theme:</b>%%norm_font_end%%</td>\r\n		<td><input type=\"text\" size=\"60\" name=\"theme\" value=\"%%theme%%\"></td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>New Category:</b>%%norm_font_end%%</td>\r\n		<td><input type=\"text\" size=\"60\" name=\"category\" value=\"\"><br>\r\n			%%norm_font%%<i>(seperate multiple categories with commas)</i>%%norm_font_end%%\r\n		</td>\r\n	</tr>\r\n	<tr>\r\n		<td colspan=\"2\">\r\n			%%norm_font%%<b>Value:</b>%%norm_font_end%%<br>\r\n			<textarea cols=\"60\" rows=\"20\" name=\"value\" wrap=\"soft\">%%value%%</textarea>\r\n		</td>\r\n	</tr>\r\n	<tr>\r\n		<td colspan=\"2\">\r\n			%%norm_font%%<b>Description:</b>%%norm_font_end%%<br>\r\n			<textarea cols=\"60\" rows=\"5\" name=\"description\"\r\n			wrap=\"soft\">%%description%%</textarea>\r\n		</td>\r\n	</tr>\r\n</table></td></tr>\r\n',NULL,'The form to edit all aspects of a single block','admin_pages','default','en');
INSERT INTO blocks VALUES ('edit_one_var','<tr><td>%%norm_font%%Or edit a variable directly:%%norm_font_end%%</td></tr>\r\n<tr><td><table cellspacing=\"2\" cellpadding=\"0\" width=\"100%\">\r\n	<tr>\r\n		<td colspan=\"2\">%%norm_font%%<b>Delete:</b><input type=\"checkbox\" name=\"delete\" value=\"1\" />%%norm_font_end%%</td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Type:</b>%%norm_font_end%%</td>\r\n		<td>%%typeselect%%</td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Select Variable:</b>%%norm_font_end%%</td>\r\n		<td>%%varselect%%</td>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Select Categories:</b>%%norm_font_end%%</td>\r\n		<td>%%catselect%%</td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>Name:</b>%%norm_font_end%%</td>\r\n		<td><input type=\"text\" size=\"60\" name=\"name\" value=\"%%name%%\" /></td>\r\n	</tr>\r\n	<tr>\r\n		<td>%%norm_font%%<b>New Category:</b>%%norm_font_end%%</td>\r\n		<td><input type=\"text\" size=\"60\" name=\"category\" value=\"\"><br />\r\n			%%norm_font%%<i>(seperate multiple categories with commas)</i>%%norm_font_end%%\r\n		</td>\r\n	</tr>\r\n	<tr>\r\n		<td colspan=\"2\">\r\n			%%norm_font%%<b>Value:</b>%%norm_font_end%%<br />\r\n			<textarea cols=\"60\" rows=\"2\" name=\"value\" wrap=\"soft\">%%value%%</textarea>\r\n		</td>\r\n	</tr>\r\n	<tr>\r\n		<td colspan=\"2\">\r\n			%%norm_font%%<b>Description:</b>%%norm_font_end%%<br />\r\n			<textarea cols=\"60\" rows=\"3\" name=\"description\" wrap=\"soft\">%%description%%</textarea>\r\n		</td>\r\n	</tr>\r\n</table></td></tr>\r\n',NULL,'','admin_pages','default','en');
INSERT INTO blocks VALUES ('edit_var','<form name=\"editvars\" action=\"%%rootdir%%/admin/vars/\" method=\"post\">\r\n<input type=\"hidden\" name=\"cat\" value=\"%%category%%\" />\r\n\r\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\r\n<tr><td bgcolor=\"%%title_bgcolor%%\">%%title_font%%Site Controls: %%category%%%%title_font_end%%</td></tr>\r\n<tr><td>%%norm_font%%%%update_msg%%%%norm_font_end%%</td></tr>\r\n<tr><td> </td></tr>\r\n<tr><td>%%norm_font%%Choose a category to edit:%%norm_font_end%%</td></tr>\r\n<tr><td>\r\n	<table border=\"0\" cellpadding=\"0\" cellspacing=\"2\" width=\"100%\">%%catlist%%</table>\r\n</td></tr>\r\n<tr><td>%%norm_font%%<input type=\"submit\" name=\"save\" value=\"Save\" /> <input type=\"submit\" name=\"edit\" value=\"Get\" />%%norm_font_end%%</td></tr>\r\n<tr><td><table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\">%%form_body%%</table></td></tr>\r\n<tr><td>%%norm_font%%<input type=\"submit\" name=\"save\" value=\"Save\" /> <input type=\"submit\" name=\"edit\" value=\"Get\" />%%norm_font_end%%</td></tr>\r\n</table>\r\n</form>\r\n',NULL,'The main edit var page.  The special var \"form_body\" is either the single-var edit form, or the category table, depending on which view you\'re using.','admin_pages','default','en');
INSERT INTO blocks VALUES ('var_category_list','<tr>\r\n	<td>%%norm_font%%<a href=\"%%rootdir%%/admin/vars/%%item_url%%\">%%item%%</a>%%norm_font_end%%</td>\r\n	<td>%%norm_font%%<a href=\"%%rootdir%%/admin/vars/%%item_url%%\">%%item%%</a>%%norm_font_end%%</td>\r\n	<td>%%norm_font%%<a href=\"%%rootdir%%/admin/vars/%%item_url%%\">%%item%%</a>%%norm_font_end%%</td>\r\n</tr>\r\n',NULL,'One line of the var category list.  Usually one table row.','admin_pages','default','en');
INSERT INTO blocks VALUES ('edit_instructions_abuse','<P>\r\nIf this article is abusing the edit queue please indicate this by pressing the button below.',NULL,'Message displayed to explain the spam vote while in the edit queue.','content','default','en');
INSERT INTO blocks VALUES ('admin_boxes_form','<form name=\"boxes\" action=\"%%rootdir%%/admin/boxes\" method=\"post\">\r\n  <table width=\"100%\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\">\r\n    <tr>\r\n      <td bgcolor=\"%%title_bgcolor%%\">%%title_font%%Edit Boxes</font></td>\r\n    </tr>\r\n    <tr><td>%%title_font%%<font color=\"#FF0000\">%%admin_boxes_errormsg%%</font></font></td></tr>\r\n    <tr>   \r\n      <td>%%norm_font%%<b>Box:</b> %%admin_boxes_box_menu%%\r\n        <input type=\"submit\" name=\"get\" value=\"Get Box\" /></font></td>\r\n    </tr><tr><td>\r\n%%norm_font%%<b>%%admin_boxes_delete_check%%</b></font>\r\n</td></tr>\r\n    <tr>\r\n      <td>%%norm_font%%<b>Box ID:</b>\r\n        <input type=\"text\" name=\"boxid\" value=\"%%admin_boxes_boxid%%\" size=\"40\" />\r\n      </font></td>\r\n    </tr>\r\n    <tr>\r\n      <td>%%norm_font%%<b>Title:</b>\r\n        <input type=\"text\" name=\"title\" value=\"%%admin_boxes_title%%\" size=\"40\" />\r\n      </font></td>\r\n    </tr>\r\n    <tr>\r\n      <td>%%norm_font%%<b>Template:</b>%%admin_boxes_template_menu%%</font></td>\r\n    </tr>\r\n    <tr>\r\n      <td><input type=\"checkbox\" name=\"choose\" value=\"1\" %%admin_boxes_choose_checked%% />\r\n        %%norm_font%%Allow users to toggle box off%%norm_font_end%%\r\n      </td>\r\n    </tr>\r\n    <tr><td>%%norm_font%%<b>Description:</b></td></tr>\r\n    <tr>\r\n      <td>%%norm_font%%\r\n        <textarea cols=\"50\" rows=\"3\" name=\"description\" wrap=\"soft\">%%admin_boxes_description%%</textarea>\r\n      </font></td>\r\n    </tr>\r\n    <tr><td>%%norm_font%%<b>Content:</b></td></tr>\r\n    <tr><td>%%norm_font%%\r\n      <textarea cols=\"50\" rows=\"25\" name=\"content\">%%admin_boxes_content%%</textarea>\r\n    </font></td></tr>\r\n    <tr><td>%%norm_font%%\r\n      <input type=\"submit\" name=\"write\" value=\"Save Box\" /> <input type=\"reset\" />\r\n    </font></td></tr>\r\n  </table>\r\n</form>  \r\n',NULL,'The box editor form.','admin_pages','default','en');
INSERT INTO blocks VALUES ('hooks','comment_new(sid, cid)\ncomment_rate(sid, cid, uid, rating)\nstory_hide(sid)\nstory_leave_editing(sid)\nstory_new(sid)\nstory_post(sid, where)\nstory_update(sid)\nstory_vote(sid, uid, vote, section_only)\nuser_new(nick)',NULL,'A list of all the hooks available on the system. One hook per line, with the hook name followed by a comma-seperated list of arguments, in parenthesis.','block_programs','default','en');

--
-- Table structure for table 'box'
--

CREATE TABLE box (
  boxid varchar(50) NOT NULL default '',
  title varchar(50) NOT NULL default '',
  content text NOT NULL,
  description text,
  template varchar(39) NOT NULL default '',
  user_choose int(1) default '0',
  PRIMARY KEY  (boxid),
  KEY user_choose_idx (user_choose)
);

--
-- Dumping data for table 'box'
--


INSERT INTO box VALUES ('cron_edit_queue','','#main sub\r\n\r\n# Get the expire time\r\nmy $expire = $S->{UI}->{VARS}->{queue_edit_max_time};\r\nmy $factors = {\r\n	d => \'86400\',\r\n	h => \'3600\',\r\n	m => \'60\',\r\n	s => \'1\'\r\n};\r\n$expire =~ s/([^\\d])$//;\r\nmy $time_sub = $expire * $factors->{$1};\r\n\r\nmy $select = {\r\n	DEBUG => 0,\r\n	WHAT => \"sid, score, time, displaystatus\",\r\n	FROM => \'stories\',\r\n	WHERE => \"displaystatus = -3 AND UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(time) >= $time_sub\",\r\n	ORDER_BY => \'time DESC\'\r\n};\r\n\r\nmy ($rv, $sth) = $S->db_select($select);\r\n\r\nmy $sid_move_to_moderate;\r\nwhile (my $story = $sth->fetchrow_hashref()) {\r\n	# only move if the time has expired\r\n	$sid_move_to_moderate = $story->{sid};\r\n	$S->move_story_to_voting($story->{sid});\r\n}\r\n\r\n$sth->finish();\r\n\r\nreturn 1;\r\n','','empty_box',0);
INSERT INTO box VALUES ('user_box','Login','my $content;\r\nif ($S->{UID} > 0) {\r\n  if ($S->have_perm(\'moderate\')) {\r\n    my ($nstories, $tstories) = $S->_count_new_sub();\r\n    my $color = \'\';\r\n    my $c_end = \'\';\r\n    if ($nstories) {\r\n       $color = \'<FONT COLOR=\"#FF0000\"><B>\';\r\n       $c_end = \'</b></font>\';\r\n    }\r\n    $content = qq|\r\n    %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/modsub\">Moderate Submissions</a> ($tstories/$color$nstories$c_end new)<BR>|;\r\n  }\r\n\r\n  if ($S->{TRUSTLEV} == 2 || $S->have_perm(\'super_mojo\')) {\r\n    $content .= qq{\r\n	%%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/search?type=comment;hidden_comments=show\">Review Hidden Comments</a><BR>};\r\n  }\r\n  \r\n  my $urlnick = $S->urlify($S->{NICK});\r\n  my $diary_link = ( $S->{UI}->{VARS}->{use_diaries} ? \r\n		qq{ %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/user/$urlnick/diary\">Your Diary</a><BR>} :\r\n		qq{} );\r\n\r\n  $content .= qq|\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/user/$urlnick\">User Info</a><BR>\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/user/$urlnick/comments\">Your Comments</a><BR>\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/user/$urlnick/stories\">Your Stories</a><BR>\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/user/$urlnick/ads\">Your Advertisements</a><BR>\r\n      $diary_link\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/submitstory/Diary\">New Diary Entry</a><BR>\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/user/$urlnick/prefs\">User Preferences</a><BR>\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/interface/prefs\">Display Preferences</a><BR>\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/interface/comments\">Comment Preferences</a><BR>\r\n      %%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/logout\">Logout $S->{NICK}</a><BR>|;\r\n\r\n    $title = \"$S->{NICK}\";\r\n} else {\r\n    $content = $S->{UI}->{BLOCKS}->{login_box};\r\n    $content =~ s/%%LOGIN_ERROR%%/$S->{LOGIN_ERROR}/;\r\n}\r\nreturn {content => $content, title => $title };','the login box','box',0);
INSERT INTO box VALUES ('hotlist_box','Your Hotlist','if ($S->{HOTLIST} && $#{$S->{HOTLIST}} >= 0) {\r\n	my $box_content;\r\n\r\n	foreach my $sid (@{$S->{HOTLIST}}) {\r\n		my $stories = $S->getstories(\r\n			{-type => \'fullstory\',\r\n			-sid => $sid});\r\n		my $story = $stories->[0];\r\n\r\n		my $show = $S->{UI}->{VARS}->{show_new_comments};\r\n		my $num_new = $S->new_comments_since_last_seen($sid) if ($show eq \"hotlist\" || $show eq \"all\");\r\n\r\n		my $end_s = ($story->{commentcount} == 1) ? \'\' : \'s\';\r\n		$box_content .= qq~%%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/story/$sid\">$story->{title}</a> ($story->{commentcount} comment$end_s~;\r\n		$box_content .= \", $num_new new\" if defined($num_new);\r\n		$box_content .= \")<BR>\";\r\n	}\r\n\r\n	my $title = \"$S->{NICK}\'s Hotlist\";\r\n	return {title => $title, content => $box_content };\r\n}\r\n','the hotlist box','box',1);
INSERT INTO box VALUES ('menu_footer','','my $submit = \'\';\r\nmy $acct = \'\';\r\n\r\nif ( $S->have_perm(\'story_post\') ) {\r\n    $submit = \'<A HREF=\"%%rootdir%%/submit\">submit story</A> |\';\r\n}\r\n\r\nif ($S->{UID} < 0) {\r\n    $acct = \'<A HREF=\"%%rootdir%%/newuser\">create account</A> |\';\r\n}\r\n\r\nmy $content = qq{\r\n%%norm_font%%\r\n$submit\r\n$acct\r\n<A HREF=\"%%rootdir%%/special/faq\">faq</A> |\r\n<A HREF=\"%%rootdir%%/search\">search</A>\r\n%%norm_font_end%%};\r\n\r\nreturn $content;','Text-mode main menu','blank_box',0);
INSERT INTO box VALUES ('older_list_box','Front Page','my $section = $S->{CGI}->param(\'section\') || \'front\';\r\nmy $stories = [];\r\n\r\nif ($section eq \'front\') {\r\n    $stories = $S->getstories({-type => \'titlesonly\', -displaystatus => \'0\'});\r\n} elsif ($section eq \'__all__\') {\r\n    $stories = $S->getstories({-type => \'titlesonly\', -section => \'!Diary\'});\r\n} else {\r\n    $stories = $S->getstories({-type => \'titlesonly\', -section => $section});\r\n}\r\nmy $box_content;\r\n\r\nmy $date = undef;\r\nforeach my $story (@{$stories}) {\r\n    if (($story->{ftime} ne $date) || !$date) {\r\n        $date = $story->{ftime};\r\n        $box_content .= qq|\r\n	<P>\r\n                <B>$story->{ftime}</B>|;\r\n    }\r\n    $box_content .= qq|\r\n    <BR>%%dot%% <A CLASS=\"light\" HREF=\"%%rootdir%%/story/$story->{sid}\">$story->{title}</A> ($story->{commentcount} comments)|;\r\n    \r\n	if ($S->have_perm(\'story_list\')) {\r\n        $box_content .= qq| [<A CLASS=\"light\" HREF=\"%%rootdir%%/admin/story/$story->{sid}\">edit</A>]|;\r\n    }\r\n}\r\n\r\nmy $offset = $S->{UI}->{VARS}->{maxstories} + $#{$stories};\r\nmy $search_url = qq{%%rootdir%%/?op=search;offset=$offset};\r\n$search_url .= \';section=\'.$section if ($section ne \'front\');\r\n\r\n$box_content .= qq|\r\n            <P>\r\n            <A CLASS=\"light\" HREF=\"$search_url\">Older Stories...</A>\r\n            </P>|;\r\nmy $return = {content => \"%%smallfont%%$box_content%%smallfont_end%%\"};\r\nif ($section ne \'front\' && $section ne \'__all__\') {\r\n    $return->{title} = $S->{SECTION_DATA}->{$section}->{title};\r\n} elsif ($section eq \'__all__\') {\r\n    $return->{title} = \'All Stories\';\r\n}\r\n\r\nreturn $return;','\"Older stories\" list','box',0);
INSERT INTO box VALUES ('fortune_box','Inspiration','my $content = `/usr/games/fortune -s`;\r\n$content =~ s/\\n\\s+-/%%norm_font_end%%<\\/I><\\/TD><\\/TR><TR><TD ALIGN=\"right\" BGCOLOR=\"%%box_content_bg%%\">%%norm_font%%<I>/g;\r\n\r\nreturn \"%%norm_font%%<I>$content</I>%%end_norm_font%%\";\r\n','Output of the fortune program, for kicks.','box',0);
INSERT INTO box VALUES ('admin_tools','Admin Tools','my $content;\r\n\r\nmy @tools = sort { $a->{pos} <=> $b->{pos} } values %{ $S->{ADMIN_TOOLS} };\r\n\r\nforeach my $t (@tools) {\r\n	if ( $S->have_perm($t->{perm}) ) {\r\n		$content .= qq|\r\n	%%dot%% <a class=\"light\" href=\"%%rootdir%%/admin/$t->{tool}\">$t->{menuname}</a><br>|;\r\n	}\r\n}\r\n\r\nif ($S->have_perm(\'edit_user\')) {\r\n $content .= qq{<br>\r\n <FORM NAME=\"uedit\" METHOD=\"GET\" ACTION=\"%%rootdir%%/\">\r\n Edit User:<BR>\r\n <INPUT TYPE=\"hidden\" NAME=\"op\" VALUE=\"user\">\r\n <SMALL><INPUT TYPE=\"text\" NAME=\"nick\" VALUE=\"\" SIZE=10>\r\n <INPUT TYPE=\"SUBMIT\" NAME=\"tool\" VALUE=\"prefs\">\r\n <INPUT TYPE=\"SUBMIT\" NAME=\"tool\" VALUE=\"info\">\r\n </SMALL></FORM>};\r\n}\r\n\r\nreturn \'\' unless $content;\r\n\r\nreturn $content;\r\n','Admin Tools box','box',0);
INSERT INTO box VALUES ('main_menu','Menu','my $submit = \'\';\r\nmy $acct = \'\';\r\n\r\nif ( $S->have_perm(\'story_post\') ) {\r\n    $submit = qq{%%dot%% <A HREF=\"%%rootdir%%/submit\">submit story</A><BR>};\r\n}\r\nif ($S->{UID} < 0) {\r\n    $acct = \'%%dot%% <A HREF=\"%%rootdir%%/newuser\">create account</A><BR>\';\r\n}\r\n\r\nmy $content = qq{\r\n%%smallfont%%\r\n$submit\r\n$acct\r\n%%dot%% <A HREF=\"%%rootdir%%/special/faq\">faq</A><BR>\r\n%%dot%% <A HREF=\"%%rootdir%%/search\">search</A>\r\n%%smallfont_end%%};\r\n\r\nreturn $content;','The menu block-- variable for perms','box',0);
INSERT INTO box VALUES ('poll_box','Poll','my $pollqid = shift @ARGS;\r\nmy $preview = 0;\r\n\r\nmy ($pollqid, $action) = $S->get_qid_to_show();\r\n$preview = 1 if ($action eq \'preview\');\r\nreturn \'\' if ($pollqid == 0);\r\n\r\n# if this is an attached poll, don\'t display if the story is hidden, unless\r\n# the current user can view all polls. also make sure the current user has\r\n# permission to view stories in this section\r\nif (my $sid = $S->get_sid_from_qid($pollqid)) {\r\n	return \'\'\r\n		if (($S->_check_story_mode($sid) == -1) && !$S->have_perm(\'list_polls\'))\r\n		|| (!$S->have_section_perm(\'norm_read_stories\', $S->_get_story_section($sid)));\r\n}\r\n\r\nmy $poll_hash = $S->get_poll_hash( $pollqid, $action );\r\n\r\n# first get the poll form all set up except for the answers\r\nmy $poll_form = qq|\r\n	<!-- begin poll form -->\r\n	<FORM ACTION=\"%%rootdir%%/\" METHOD=\"POST\">\r\n    <INPUT TYPE=\"hidden\" NAME=\"op\" VALUE=\"view_poll\">\r\n    <INPUT TYPE=\"hidden\" NAME=\"qid\" VALUE=\"$poll_hash->{\'qid\'}\">\r\n    <INPUT type=\"hidden\" name=\"ispoll\" value=\"1\">|;\r\n\r\n$poll_form .= \"<b>$poll_hash->{\'question\'}</b><br>\";\r\n\r\n# here is where all the answer fields get filled in\r\nmy $answer_array = $S->get_poll_answers($poll_hash->{\'qid\'}, $action);\r\n\r\n# now check if they have already voted or haven\'t logged in\r\nmy $row;\r\nif ( $S->_can_vote($poll_hash->{\'qid\'}) ) {\r\n    foreach $row ( @{$answer_array} ) {	\r\n        $poll_form .= qq|\r\n   	        <INPUT TYPE=\"radio\" NAME=\"aid\" VALUE=\"$row->{\'aid\'}\"> $row->{\'answer\'}<BR>|;\r\n   	}\r\n} else {\r\n    my $total_votes = $poll_hash->{\'voters\'};\r\n\r\n    if($total_votes == 0) {\r\n        $total_votes = 1;  # so we don\'t get a divide by 0 error\r\n    }\r\n\r\n	$poll_form .= qq|\r\n		<TABLE BORDER=0 CELLPADDING=2 CELLSPACING=0>|;\r\n\r\n	foreach $row ( @{$answer_array} ) {\r\n		my $percent = int($row->{\'votes\'} / $total_votes * 100);\r\n		$poll_form .= qq|\r\n			<TR>\r\n				<TD valign=\"top\">%%norm_font%%%%dot%%%%norm_font_end%%</TD>\r\n				<TD valign=\"top\">%%norm_font%%$row->{\'answer\'}%%norm_font_end%%</TD>\r\n				<TD valign=\"top\">%%norm_font%% $percent% %%norm_font_end%%</TD>\r\n			</TR>|;\r\n   	}\r\n	$poll_form .= qq|\r\n		</TABLE>|;\r\n		\r\n}\r\n\r\n# get the # of comments\r\nmy $comment_num = $S->poll_comment_num($poll_hash->{\'qid\'});\r\n   \r\n# only show the vote button if they havn\'t voted\r\nif ( $S->_can_vote($poll_hash->{\'qid\'}) && ! $preview ) {\r\n	$poll_form .= qq|<BR><INPUT TYPE=\"submit\" name=\"vote\" VALUE=\"Vote\">|;\r\n}\r\n\r\n\r\n# now finish up the form\r\nmy $op = $S->{CGI}->param(\'op\');\r\nmy $comm_disp = ($op ne \'displaystory\') ? \r\n	qq{\r\n	<TD>%%norm_font%%Votes: <b>$poll_hash->{\'voters\'}</b>%%norm_font_end%%</TD>\r\n	<TD ALIGN=\"center\" WIDTH=15>%%norm_font%%|%%norm_font_end%%</TD>\r\n	<TD ALIGN=\"right\">%%norm_font%% Comments: <b>$comment_num</b>%%norm_font_end%%</TD></TR>\r\n	} : \r\n	qq{\r\n	<TD COLSPAN=\"3\" ALIGN=\"center\">%%norm_font%%Votes: <b>$poll_hash->{\'voters\'}</b>%%norm_font_end%%</TD>\r\n	};\r\n\r\n$poll_form .= qq{\r\n	</FORM>\r\n	<!-- end poll form -->\r\n	<P>\r\n	%%norm_font%%\r\n    <TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 ALIGN=\"center\">\r\n	<TR>\r\n		$comm_disp\r\n	<TR> };\r\n\r\nif( $preview ) {\r\n    $poll_form .= qq{\r\n	<TD>%%norm_font%%Results%%norm_font_end%%</TD>\r\n	<TD ALIGN=\"center\" WIDTH=15>%%norm_font%%|%%norm_font_end%%</TD>\r\n    <TD ALIGN=\"right\">%%norm_font%% Other Polls%%norm_font_end%%</TD></TR>\r\n	};\r\n\r\n} else {\r\n    $poll_form .= qq{\r\n	<TD>%%norm_font%%<a href=\"%%rootdir%%/poll/$poll_hash->{\'qid\'}\">Results</a>%%norm_font_end%%</TD>\r\n	<TD ALIGN=\"center\" WIDTH=15>%%norm_font%%|%%norm_font_end%%</TD>\r\n    <TD ALIGN=\"right\">%%norm_font%% <a href=\"%%rootdir%%/?op=search;type=polls;search=Search\">Other Polls</a>%%norm_font_end%%</TD></TR>\r\n	};\r\n}\r\n\r\n$poll_form .= qq{\r\n	</TABLE>\r\n	%%norm_font_end%%\r\n	<!-- end poll content -->};\r\n\r\n## don\'t forget to tell them its a poll preview if it is\r\nif( $preview ) {\r\n	$title = \"Poll Preview\";\r\n}\r\n\r\nif ($poll_form) {\r\n	return {content => qq{%%norm_font%%$poll_form%%norm_font_end%%}, title => $title};\r\n} else {\r\n	return \'\';\r\n}\r\n','Box to display polls.','box',1);
INSERT INTO box VALUES ('related_links','Related Links','my $sid = $S->{CGI}->param(\'sid\');\r\nmy $f_sid = $S->{DBH}->quote($sid);\r\n\r\nmy ($rv, $sth) = $S->db_select({\r\n WHAT => \'introtext, bodytext, aid, tid\',\r\n FROM => \'stories\',\r\n WHERE => qq|sid = $f_sid|});\r\n\r\nmy $data = $sth->fetchrow_hashref;\r\n$sth->finish;\r\n\r\nmy $text = $data->{introtext}.$data->{bodytext};\r\n\r\nmy @link_arr;\r\n\r\nmy @first_related = split /\\n/, $S->{UI}->{BLOCKS}->{autorelated};\r\nmy (%related, $word, $url);\r\n\r\nforeach my $rel (@first_related) {\r\n ($word, $url) = split /,/, $rel;\r\n chop($url);\r\n $related{$word} = $url;\r\n}\r\n\r\nforeach $word (keys %related) {\r\n if ($text =~ /$word/gi) {\r\n  push @link_arr, $word, qq|<A CLASS=\"light\" HREF=\"$related{$word}\">|;\r\n }\r\n}\r\n\r\nmy $text_2 = $text;\r\nwhile ( $text_2 =~ /(<a href.*?>)(.*?)(<\\/a>)/gis ) {\r\n my $link = $1.$2.$3;\r\n my $start = $1;\r\n my $end = $3;\r\n my $word = $2;\r\n if ( !($link =~ /<IMG/gi) && !($related{$word}) ) {\r\n  $related{$word} = 1;\r\n  $start =~ s/<A HREF/<A CLASS=\"light\" HREF/i;\r\n  $word =~ s/^\\s*(.*?)\\s*$/$1/s;\r\n  $word =~ s/^(\\S{30})(.*)/$1 $2/;\r\n  push @link_arr, $word, qq|$start|;\r\n }\r\n}\r\n\r\n# Use the get_topic method, since it accounts for diaries\r\nmy $t = $S->get_topic($data->{\'tid\'});\r\n\r\nmy $auth_urlenc = $data->{aid};\r\n$auth_urlenc =~ s/\\s/%20/g;\r\n\r\nif ($data->{\'tid\'} =~ /^diary_/) {\r\n push @link_arr, \"$data->{aid}\'s Diary\", qq|<A CLASS=\"light\" HREF=\"%%rootdir%%/?op=section;section=Diary;user=$data->{\'tid\'}\">|;\r\n} else {\r\n push @link_arr, \"More on $t->{alttext}\", qq|<A CLASS=\"light\" HREF=\"%%rootdir%%/?op=search;topic=$data->{tid}\">|;\r\n push @link_arr, \"Also by $data->{aid}\", qq|<A CLASS=\"light\" HREF=\"%%rootdir%%/?op=search;type=author;string=$auth_urlenc\">|;\r\n}\r\n\r\n\r\nmy $content;\r\nmy $i = 0;\r\nwhile ($i <= $#link_arr) {\r\n  $content .= qq|%%dot%% $link_arr[$i+1]$link_arr[$i]</A><BR>|;\r\n  $i += 2;\r\n}\r\n\r\nreturn {content => $content };','The Related links box which appears with stories','box',0);
INSERT INTO box VALUES ('comment_controls','Comment Controls','my $op = $S->{CGI}->param(\'op\');\r\nmy $tool = $S->{CGI}->param(\'tool\');\r\nreturn \'\' unless ($op eq \'displaystory\' || \r\n                            $op eq \'comments\' ||\r\n                            $op eq \'view_poll\'  ||\r\n                            $op eq \'poll_vote\' );\r\nreturn \'\' if( $op eq \'comments\' && $tool eq \'post\' );\r\n\r\nmy $sid = $S->{CGI}->param(\'sid\');\r\nmy $pid = $S->{CGI}->param(\'pid\');\r\nmy $cid = $S->{CGI}->param(\'cid\');\r\nmy $qid = $S->{CGI}->param(\'qid\');\r\n\nreturn \'\' unless ($S->{STORIES}->{$sid}->{commentstatus} == 0);\n\r\nreturn \'\' unless( $S->have_section_perm(\'norm_read_comments\',$S->_get_story_section($sid)));\r\n\r\nmy $form_extra;\r\nmy $anchor = qq{#$cid};\r\nif ($cid) {\r\n    $form_extra = qq{\r\n	<INPUT TYPE=\"hidden\" NAME=\"cid\" VALUE=\"$cid\">};\r\n} elsif ($pid) {\r\n    $form_extra = qq{\r\n	<INPUT TYPE=\"hidden\" NAME=\"pid\" VALUE=\"$pid\">};\r\n}\r\n\r\nmy $commentmode_select = $S->_comment_mode_select();\r\nmy $comment_order_select = $S->_comment_order_select();\r\nmy $comment_rating_select = $S->_comment_rating_select();\r\nmy $rating_choice = $S->_comment_rating_choice();\r\nmy $comment_type_select = $S->_comment_type_select();\r\n\r\nmy $form_op = \'op\';\r\nmy $form_op_value = $op;\r\nmy $id = \'sid\';\r\n\r\nif ( $qid ) {\r\n	$form_op = \'op\';\r\n	$form_op_value = \'view_poll\';\r\n	$id = \'qid\';\r\n	$sid = $qid;\r\n}\r\n	\r\nmy $comment_sort = qq|\r\n		<FORM NAME=\"commentmode\" ACTION=\"%%rootdir%%/$anchor\" METHOD=\"post\">\r\n		<INPUT TYPE=\"hidden\" NAME=\"$form_op\" VALUE=\"$form_op_value\">\r\n		<INPUT TYPE=\"hidden\" NAME=\"$id\" VALUE=\"$sid\">\r\n		$form_extra\r\n	<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0 BGCOLOR=\"%%box_content_bg%%\" align=\"center\">\r\n	\r\n		<TR>\r\n			<TD VALIGN=\"middle\">\r\n				%%smallfont%%View:\r\n				<SMALL>\r\n					$comment_type_select\r\n				</SMALL>\r\n				Display:\r\n				<SMALL>\r\n				$commentmode_select\r\n				</SMALL>\r\n				Sort:\r\n				<SMALL>\r\n				$comment_rating_select\r\n				</SMALL>\r\n				<SMALL>\r\n				$comment_order_select\r\n				</SMALL>\r\n|;\r\n	\r\n		\r\nif ($S->have_perm( \'comment_rate\' )) {\r\n	$comment_sort .= qq|\r\n	Rate?\r\n	<SMALL>$rating_choice</SMALL>|;\r\n}\r\n\r\n$comment_sort .= qq|\r\n<INPUT TYPE=\"submit\" NAME=\"setcomments\" VALUE=\"Set\">\r\n%%smallfont_end%%\r\n</TD></TR>\r\n</TABLE>\r\n</FORM>|;\r\n\r\n$template =~ s/CELLSPACING=0>/CELLSPACING=0 ALIGN=\"center\">/;\r\n\r\nreturn { content => $comment_sort, template => $template };','Comment display prefs','blank_box',0);
INSERT INTO box VALUES ('mod_stats','Moderation Stats','my $sid = $ARGS[0];\r\n$sid = $S->{CGI}->param(\'sid\') unless $sid;\r\nreturn unless $sid;\r\n\r\nmy $q_sid = $S->{DBH}->quote($sid);\r\n\r\nmy ($rv, $t_sth) = $S->db_select({\r\n    WHAT => \'displaystatus\',\r\n    FROM => \'stories\',\r\n    WHERE => qq{sid = $q_sid}});\r\n\r\nmy $disp = $t_sth->fetchrow();\r\n\r\nreturn unless ($disp == \'-2\');\r\n\r\nmy ($stat, $trash) = $S->_mod_or_show($sid);\r\nreturn \'\' unless ($stat eq \'show\');\r\n\r\nmy ($totalvotes, $score) = $S->_get_total_votes($sid);\r\nmy $sth = $S->_get_story_mods($sid);\r\n\r\nmy $head = $S->{UI}->{BLOCKS}->{moderate_head};\r\n\r\n$head =~ s/%%votes%%/$totalvotes/g;\r\n$head =~ s/%%score%%/$score/g;\r\n\r\nmy ($this_row, $user);\r\n\r\nmy $for = qq{<FORM NAME=\"mod_stat_show\" ACTION=\"%%rootdir%%/\" METHOD=\"get\">\r\n<INPUT TYPE=\"hidden\" NAME=\"op\" VALUE=\"user\">\r\n<INPUT TYPE=\"hidden\" NAME=\"tool\" VALUE=\"info\">};\r\nmy $against = qq{<FORM NAME=\"mod_stat_show\" ACTION=\"%%rootdir%%/\" METHOD=\"get\">\r\n<INPUT TYPE=\"hidden\" NAME=\"op\" VALUE=\"user\">\r\n<INPUT TYPE=\"hidden\" NAME=\"tool\" VALUE=\"info\">};\r\nmy $neutral = qq{<FORM NAME=\"mod_stat_show\" ACTION=\"%%rootdir%%/\" METHOD=\"get\">\r\n<INPUT TYPE=\"hidden\" NAME=\"op\" VALUE=\"user\">\r\n<INPUT TYPE=\"hidden\" NAME=\"tool\" VALUE=\"info\">};\r\n#\'\r\nmy $f = 0;\r\nmy $a = 0;\r\nmy $n = 0;\r\n\r\n$for .= qq{<small>\r\n	<SELECT NAME=\"uid\" SIZE=1>\r\n	<OPTION VALUE=\"\">Voted for: (%%for%%)};\r\n$against .= qq{<small>\r\n	<SELECT NAME=\"uid\" SIZE=1>\r\n	<OPTION VALUE=\"\">Voted against: (%%against%%)};\r\n$neutral .= qq{<small>\r\n	<SELECT NAME=\"uid\" SIZE=1>\r\n	<OPTION VALUE=\"\">Didn\'t care: (%%neutral%%)};	\r\n\r\nwhile (my $mod_rec = $sth->fetchrow_hashref) {\r\n	my $nick = $S->get_nick($mod_rec->{uid});\r\n	$nick =~ s/^(.{0,20})/$1/;\r\n	my $link = qq{\r\n	<OPTION VALUE=\"$mod_rec->{uid}\">$nick};\r\n	if ($mod_rec->{vote} == 1) {\r\n		$for .= qq|\r\n		$link|;\r\n		$f++;\r\n	} elsif ($mod_rec->{vote} == 0) {\r\n		$neutral .= qq|\r\n		$link|;\r\n		$n++;\r\n	} elsif ($mod_rec->{vote} == -1) {\r\n		$against .= qq|\r\n		$link|;\r\n		$a++;\r\n	}\r\n}\r\n$sth->finish;\r\n\r\n$for .= qq{</SELECT> <INPUT TYPE=\"submit\" NAME=\"get\" VALUE=\"Get User Info\"></small></FORM>};\r\n$against .= qq{</SELECT> <INPUT TYPE=\"submit\" NAME=\"get\" VALUE=\"Get User Info\"></small></FORM>};\r\n$neutral .= qq{</SELECT> <INPUT TYPE=\"submit\" NAME=\"get\" VALUE=\"Get User Info\"></small></FORM>};\r\n\r\n$for =~ s/%%for%%/$f/;\r\n$against =~ s/%%against%%/$a/;\r\n$neutral =~ s/%%neutral%%/$n/;\r\n\r\nmy $content = $head.\'%%smallfont%%\'.$for.$against.$neutral.\'%%smallfont_end%%\';\r\n\r\nreturn { content => $content };','Show the stats for story mod','box',0);
INSERT INTO box VALUES ('section_title','null','my $content = \'Latest News\';\r\n\r\nmy $op = $S->{CGI}->param(\'op\');\r\nmy $page_num = $S->cgi->param(\'page\');\r\nmy $page = \'\';\r\nif ($page_num && $page_num != 1) {\r\n  $page = \"(page $page_num)\";\r\n}\r\n\r\nif ($op eq \'section\') {\r\n  my $section = $S->{CGI}->param(\'section\');\r\n  unless($S->have_section_perm(\'hide_read_stories\',$section)) {\r\n    $content = $S->{SECTION_DATA}->{$section}->{title} || \'All Stories\';\r\n  } else {\r\n    $content = \'\';\r\n  }\r\n}\r\n\r\nreturn {\'content\' => \"%%title_font%%$content $page%%title_font_end%%\" };','Display title of current section','blank_box',0);
INSERT INTO box VALUES ('show_comment_raters','Others have rated this comment as follows:','my $content = qq{\r\n	<table width=\"100%\" border=0 cellpadding=2 cellspacing=0>};\r\n\r\nmy $cid = $S->{CGI}->param(\'cid\');\r\nmy $sid = $S->{CGI}->param(\'sid\');\r\n\r\nmy $f_cid = $S->{DBH}->quote($cid);\r\nmy $f_sid = $S->{DBH}->quote($sid);\r\n\r\n#Check for hidden\r\nmy ($rv, $sth) = $S->db_select({\r\n	WHAT => \'points\',\r\n	FROM => \'comments\',\r\n	WHERE => qq{sid = $f_sid AND cid = $f_cid}});\r\n\r\nmy $points = $sth->fetchrow();\r\n$sth->finish();\r\n\r\nif (($points < $S->{UI}->{VARS}->{rating_min}) && ($S->{TRUSTLEV} != 2)) {\r\n	return \'\';\r\n}\r\n\r\nmy ($rv, $sth) = $S->db_select({\r\n	WHAT => \'uid, rating\',\r\n	FROM => \'commentratings\',\r\n	WHERE => qq{sid = $f_sid AND cid = $f_cid}});\r\n\r\nmy $zeros = 0;\r\n\r\nwhile (my $rating = $sth->fetchrow_hashref()) {\r\n	my $user = $S->user_data($rating->{uid});\r\n	\r\n	if (($rating->{\'rating\'} < $S->{UI}->{VARS}->{rating_min}) && ($S->{TRUSTLEV} != 2)) {\r\n		$zeros++;\r\n	} else {\r\n		$content .= qq{\r\n			<tr>\r\n			<td>%%norm_font%%<A HREF=\"%%rootdir%%/user/uid:$rating->{uid}\">$user->{nickname}</A>%%norm_font_end%%</td>\r\n			<td>%%norm_font%%$rating->{rating}%%norm_font_end%%</td>\r\n			</tr>};\r\n	}\r\n}\r\n\r\n$sth->finish();\r\n\r\nif ($zeros) {\r\n	my $word = ($zeros == 1) ? \"Rating\" : \"Ratings\";\r\n	\r\n	$content .= qq{\r\n		<tr>\r\n			<td colspan=2>%%norm_font%%Zero $word: $zeros%%norm_font_end%%</td>\r\n		</tr>};\r\n}\r\n\r\n$content .= qq{\r\n    </table>};\r\n\r\nreturn {\'content\' => $content};','Display who rated a comment what','',0);
INSERT INTO box VALUES ('fzdescribe','ForumZilla Support code','my $action = $S->{CGI}->param(\'action\'); \r\nmy $page; \r\n\r\nif ($action eq \'describestory\') { \r\n    $page = $S->fzDescribeStory(); \r\n} else { \r\n    $page = $S->fzDescribeForum(); \r\n} \r\n\r\nreturn {\'content\'=>$page};','This is the interface to the FormZilla lib, to support ForumZilla. See http://www.zapogee.com/forumzilla/docs/server-howto.html for more','empty_box',0);
INSERT INTO box VALUES ('fzdisplay','ForumZilla Support code','my $action = $S->{CGI}->param(\'action\'); \r\nmy $sid = $S->{CGI}->param(\'sid\');\r\nmy $cid = $S->{CGI}->param(\'cid\');\r\nmy $pid = $S->{CGI}->param(\'pid\');\r\n\r\nmy $page; \r\n\r\nif ($action eq \'story\') {\r\n	$page = $S->displaystory($sid)\r\n} elsif ($action eq \'comment\') { \r\n	$page = $S->display_comments($sid, $pid, \'alone\', $cid);\r\n} \r\n\r\nreturn {\'content\'=>$page};','This is the interface to display stories and comments in FormZilla. See http://www.zapogee.com/forumzilla/docs/server-howto.html for more','empty_box',0);
INSERT INTO box VALUES ('rdf_feeds','External Feeds','return unless $S->{UI}->{VARS}->{use_rdf_feeds};\r\n\r\nmy $to_display = {};\r\nif (@ARGS || $S->{CGI}->param(\'rdf\')) {\r\n	my $rdf_arg = $S->{CGI}->param(\'rdf\');\r\n	@ARGS = split(/,/, $rdf_arg) if $rdf_arg;\r\n	foreach (@ARGS) {\r\n		$to_display->{$_} = 1;\r\n	}\r\n}\r\n\r\nmy $content;\r\nmy $channels = $S->rdf_channels();\r\nmy $user_feeds = $S->rdf_get_prefs() unless @ARGS;\r\nmy $item_limit = defined($S->{prefs}->{rdf_max_headlines}) ?\r\n	$S->{prefs}->{rdf_max_headlines} :\r\n	defined($S->{UI}->{VARS}->{rdf_max_headlines}) ?\r\n	$S->{UI}->{VARS}->{rdf_max_headlines} : 15;\r\n\r\nif ($S->have_perm(\'submit_rdf\')) {\r\n	$content = qq|<A CLASS=\"light\" HREF=\"%%rootdir%%/submitrdf\">Submit Feed</A><BR><BR>\\n|;\r\n}	\r\n\r\nforeach my $c (@{$channels}) {\r\n	if (@ARGS) {\r\n		next unless $to_display->{ $c->{rid} };\r\n	} else {\r\n		next unless $user_feeds->{ $c->{rid} };\r\n	}\r\n	next unless $c->{title};\r\n	unless ($S->have_perm(\'rdf_admin\')) {\r\n		next if $c->{submitted} || !$c->{enabled};\r\n	}\r\n\r\n	if ($S->{UI}->{VARS}->{rdf_use_images} && $c->{image_url}) {\r\n		$content .= qq~<A HREF=\"$c->{image_link}\"><IMG SRC=\"$c->{image_url}\" ALT=\"$c->{image_title}\" BORDER=\"1\"></a><br>\\n~;\r\n	} else {\r\n		$content .= qq~<B><A CLASS=\"light\" HREF=\"$c->{link}\">$c->{title}</a></b><BR>\\n~;\r\n	}\r\n\r\n	my $items = $S->rdf_items($c->{rid}, $item_limit);\r\n	foreach my $i (@{$items}) {\r\n		$content .= qq~%%dot%% <A CLASS=\"light\" HREF=\"$i->{link}\">$i->{title}</a><BR>\\n~;\r\n	}\r\n\r\n	if ($S->{UI}->{VARS}->{rdf_use_forms} && $c->{form_link}) {\r\n		$content .= qq~<FORM ACTION=\"$c->{form_link}\" METHOD=\"GET\">$c->{form_title}: <INPUT TYPE=\"TEXT\" NAME=\"$c->{form_name}\"></form><br>\\n~;\r\n	}\r\n\r\n	$content .= \"<BR>\\n\";\r\n}\r\n\r\nreturn $content;\r\n','contains RDF feeds from other sites','box',1);
INSERT INTO box VALUES ('submit_rdf','Submit Feed','return \"Sorry, you don\'t have permission to submit a feed.\"\r\n\r\nunless $S->have_perm(\'submit_rdf\');\r\n\r\nmy $action = $S->{CGI}->param(\'action\') || \'showform\';\r\n\r\nif ($action eq \'showform\') {\r\n\r\nreturn &disp_form();\r\n\r\n} elsif ($action eq \'save\') {\r\n\r\nmy $url = $S->{CGI}->param(\'url\');\r\n\r\nreturn (\'Please fill in the URL field\') unless $url;\r\n\r\n# check to see if this RDF already exists\r\n\r\nmy $is_dup = 0;\r\n\r\nmy $channels = $S->rdf_channels;\r\n\r\nforeach my $c (@{$channels}) {\r\n\r\n$is_dup = 1 if $c->{rdf_link} eq $url;\r\n\r\n}\r\n\r\nreturn &disp_form(\'That RDF already exists, or has been submitted already.\') if $is_dup;\r\n\r\n\r\n\r\nmy $do_fetch = $S->{UI}->{VARS}->{allow_rdf_fetch} ? 1 : 0;\r\n\r\nmy ($id, $res) = $S->rdf_add_channel($url, $do_fetch, $S->{NICK});\r\n\r\nunless ($res) {\r\n\r\n$S->rdf_remove_channel($id);\r\n\r\nreturn &disp_form(\'Error adding RDF file: $res\');\r\n\r\n}\r\n\r\nmy $fetched_msg = qq|\r\n\r\n%%norm_font%%Your RDF has been fetched. An admin will check it out as soon as possible%%norm_font_end%%|;\r\n\r\nreturn $fetched_msg;\r\n\r\n}\r\n\r\n\r\n\r\nsub disp_form {\r\n\r\nmy $form = qq|\r\n\r\n%%norm_font%% %%submit_rdf_message%% %%norm_font_end%%\r\n\r\n<p>\r\n\r\n<form action=\"%%rootdir%%/?\" method=\"GET\">\r\n\r\n<input type=\"hidden\" name=\"op\" value=\"submitrdf\">\r\n\r\n<input type=\"hidden\" name=\"action\" value=\"save\">\r\n\r\n<table border=0 cellspacing=0 cellpadding=0>|;\r\n\r\n$form .= qq|\r\n\r\n<tr>\r\n\r\n<td><FONT color=\"#FF0000\">%%norm_font%%$_[0]%%norm_font_end%%</font></td>\r\n\r\n</tr>| if $_[0];\r\n\r\n$form .= qq|\r\n\r\n<tr>\r\n\r\n<td>%%norm_font%%URL of RDF file:%%norm_font_end%% <input type=\"text\" name=\"url\" size=\"50\"></td>\r\n\r\n</tr>\r\n\r\n<tr>\r\n\r\n<td><input type=\"submit\" value=\"Submit\"></td>\r\n\r\n</tr>\r\n\r\n</table>\r\n\r\n</form>\r\n\r\n|;\r\n\r\nreturn $form;\r\n\r\n}\r\n\r\n','Box to do submitrdf op and such.','titled_box',0);
INSERT INTO box VALUES ('whos_online','','## begin whos_online\nreturn if $S->{UID} == -1;\nif (($S->cache->{CACHE}->{WHOBOX}->{TIME}) &&\n    ($S->cache->{CACHE}->{WHOBOX}->{TIME} < (time + 120))) {\n	return {\n		content => $S->cache->{CACHE}->{WHOBOX}->{CONTENT},\n		title => $S->cache->{CACHE}->{WHOBOX}->{TITLE}\n	};\n}\n\nrequire Storable;\n\nmy $interval = 5;\nmy ($rv,$sth) = $S->db_select({\n	FROM => \'sessions\',\n	WHAT => \'a_session\',\n	WHERE => \"last_accessed > DATE_SUB(NOW(), INTERVAL $interval MINUTE)\",\n	ORDER_BY => \'last_accessed DESC\',\n	DEBUG => 0\n});\n\n\nmy %uids;\nmy $total;\nwhile (my ($s) = $sth->fetchrow_array) {\n	my $d = Storable::thaw($s);\n\n	next if $d->{UID} eq \'\';\n	$uids{ $d->{UID} } = 0 unless $uids{ $d->{UID} };\n	$total++;\n	$uids{ $d->{UID} }++;\n}\n\n$sth->finish;\nmy @sorted = sort {\n	return 1 if $a == -1; return -1 if $b == -1; return 0;\n} keys %uids;\nreturn unless @sorted;\n\n$S->user_data(\\@sorted); # pre-cache user data\n\nmy $out;\nmy $hidden;\nmy $list;\nmy $max_show = 75;\nforeach (@sorted) {\n	$_ = -1 if $_ eq \'anon\';\n	if ($S->user_data($_)->{prefs}->{online_cloak}) {\n		$hidden++;\n		next;\n	}\n	next unless (($list < $max_show) || $_ == -1);\n	$list++ unless $_ == -1;\n	my $nick = $S->user_data($_)->{nickname};\n	my $linknick = $S->urlify($nick);\n	$out .= qq~%%dot%%~;\n	$out .= qq~ <A HREF=\"%%rootdir%%/user/$linknick\">~ unless $_ == -1;\n	$out .= \' \' if $_ == -1;\n	$out .= $nick;\n	$out .= \"</A>\" unless $_ == -1;\n	$out .= \" ($uids{$_})\" if $uids{$_} > 1;\n	$out .= \"<BR>\\n\";\n}\n\nif ($total > ($list + $hidden + $uids{-1})) {\n	my $more = ($total - $list - $hidden - $uids{-1});\n	$out .= qq~%%dot%% ...and $more more. :-)<br>~;\n}\n\nif ($hidden) {\n	$out .= qq~%%dot%% Cloaked Users ($hidden)<p>~;\n} else {\n	$out .= \'<p>\';\n}\n\n$out .= qq~<small>\n$interval minute interval.<br>You may cloak yourself from appearing here in your <A HREF=\"%%rootdir%%/interface/prefs\">Display Preferences</A></small>.~;\n\nmy $title = \"Who\'s Online? ($total)\";\n\n$S->cache->{CACHE}->{WHOBOX}->{CONTENT} = $out;\n$S->cache->{CACHE}->{WHOBOX}->{TITLE}   = $title;\n$S->cache->{CACHE}->{WHOBOX}->{TIME}    = time;\n\nreturn {content => $out, title => $title};\n',NULL,'',1);
INSERT INTO box VALUES ('show_ad','Show Advertisement','my $arg0 = $ARGS[0];\r\nmy $arg1 = $ARGS[1];\r\nmy $ad_id;\r\nmy $adhash = {};\r\nmy $content = \'\';\r\n\r\n# if the ad_id is in the url, use the url\r\nif( $arg0 eq \'fromurl\' || $arg0 eq \'allcgi\' ) {\r\n $ad_id = $S->{CGI}->param(\'ad_id\');\r\n\r\n# if they want to see what the fields are...\r\n} elsif( $arg0 eq \'showfields\' ){\r\n\r\n	my $ex_ad = $S->get_example_ad($arg1);\r\n	return \'\' unless( defined($ex_ad) && (ref($ex_ad) eq \'HASH\') );\r\n\r\n	if( exists $S->{UI}->{BLOCKS}->{\"preview_\" . $ex_ad->{ad_tmpl}} ) {\r\n		$content = $S->{UI}->{BLOCKS}->{ \"preview_\". $ex_ad->{ad_tmpl} };\r\n	} else {\r\n		$content = $S->{UI}->{BLOCKS}->{ $ex_ad->{ad_tmpl} };\r\n	}\r\n\r\n	$content =~ s/%%FILE_PATH%%//g;\r\n	$content =~ s/%%TEXT1%%/This is text1/g;\r\n	$content =~ s/%%TEXT2%%/This is text2/g;\r\n	$content =~ s/%%TITLE%%/This is the title/g;\r\n	$content =~ s/%%LINK_URL%%/This is the link url/g;\r\n	$content =~ s[%%REDIRECT_URL%%][%%rootdir%%]g;\r\n\r\n	return { content => $content };\r\n\r\n# else if ad_id is specified in template, use that\r\n} elsif( $arg0 =~ /\\d/ ) {\r\n $ad_id = $arg0;\r\n}\r\n\r\nunless( defined( $ad_id ) || $arg0 eq \'allcgi\' ) {\r\n	return \'\';\r\n}\r\n\r\n# if we need everything from cgi, let get_ad_hash know\r\nmy $source = \'db\';\r\n$source = \'cgi\' if( $arg0 eq \'allcgi\' );\r\n\r\n$adhash = $S->get_ad_hash($ad_id, $source);\r\n\r\nmy $image = $adhash->{ad_file};\r\nmy $subdir = $adhash->{sponser};\r\n$subdir = \'example\' if( $adhash->{example} == 1 );\r\n\r\nmy $image_path = $subdir . \'/\' . $image;\r\n\r\nif( exists $S->{UI}->{BLOCKS}->{\"preview_\" . $adhash->{ad_tmpl}} ) {\r\n	$content = $S->{UI}->{BLOCKS}->{ \"preview_\". $adhash->{ad_tmpl} };\r\n} else {\r\n	$content = $S->{UI}->{BLOCKS}->{ $adhash->{ad_tmpl} };\r\n}\r\n\r\n$content =~ s/%%FILE_PATH%%/$image_path/g;\r\n$content =~ s/%%TEXT1%%/$adhash->{ad_text1}/g;\r\n$content =~ s/%%TEXT2%%/$adhash->{ad_text2}/g;\r\n$content =~ s/%%TITLE%%/$adhash->{ad_title}/g;\r\n$content =~ s/%%LINK_URL%%/$adhash->{ad_url}/g;\r\n$content =~ s/%%SID%%/$adhash->{ad_sid}/g;\r\n$content =~ s[%%REDIRECT_URL%%][%%rootdir%%/redirect/$ad_id]g;\r\n\r\nreturn { content => $content };\r\n','Just a simple box that will show the ad specified','box',0);
INSERT INTO box VALUES ('submit_ad_pay_box','Ad Submitted','my $content = qq{\r\n<p> Now that you\'ve submitted the ad, it has to be approved.  Our crack team of site maintainers who pore over all of the ad submissions daily will notice yours has arrived, and approve it so that it can be displayed on the site.  If for some reason they don\'t see fit to approve it, you will get an email sent to your real_email address explaining why.</p>\r\n<p> But wait! There\'s more!  Your ad will not be approved until it has been paid for.  Depending on how we do payment, that could be sooner or later.</p>\r\n<p> Thanks for advertising with %%sitename%% </p>\r\n};\r\n\r\nreturn { content => $content };','This generates the page the user will see when they have successfully submitted an ad.  This should direct them on how to pay for the ad, and\r\nexplain the details of what will happen now. ','box',0);
INSERT INTO box VALUES ('ad_box','Advertisement','return \'\' unless( $S->{UI}->{VARS}->{use_ads} );\r\n\r\nmy $adhash = $S->get_next_ad();\r\nreturn \'\' unless( $adhash->{ERROR} != 1 );\r\n\r\nmy $content = $S->{UI}->{BLOCKS}->{$adhash->{ad_tmpl}};\r\n\r\n$content =~ s/%%LINK_URL%%/$adhash->{ad_url}/g;\r\n$content =~ s/%%TITLE%%/$adhash->{ad_title}/g;\r\n$content =~ s/%%TEXT1%%/$adhash->{ad_text1}/g;\r\n$content =~ s/%%TEXT2%%/$adhash->{ad_text2}/g;\r\n$content =~ s/%%FILE_PATH%%/$adhash->{ad_file}/g;\r\n$content =~ s/%%SID%%/$adhash->{ad_sid}/g;\r\n$content =~ s[%%REDIRECT_URL%%][%%rootdir%%/redirect/$adhash->{ad_id}];\r\n\r\nif( $S->pref(\'ad_open_new_win\') eq \'Yes\' ) {\r\n  $content =~ s/%%TARGET%%/target=\"_blank\"/g;\r\n}\r\n\r\nreturn { content => $content };\r\n','Simple ad box for the side of the page','box',0);
INSERT INTO box VALUES ('ad_types','Advertisement Type Listing','my $content = $S->make_ad_type_list(\'no_choice\');\r\n\r\nreturn { content => $content };\r\n','Shows a list of all of the advertisement types','blank_box',0);
INSERT INTO box VALUES ('buyimpressions_box','Purchase Ad Impressions','# This box controls /ads\r\n# -> If no argument is given, assumes the user wants to purchase\r\n# more impressions.\r\n# -> If distribute=1 will bring up ad impression distribution\r\n# page.\r\n\r\nmy $content = \'\';\r\n\r\nmy $distribute = $S->cgi->param(\'distribute\');\r\n\r\nif( $distribute eq \'dist\' ) {\r\n	$content = $S->ad_impression_distribute();\r\n}\r\nelse {\r\n	$content = $S->purchase_impressions();\r\n}\r\n\r\nreturn { content => $content };\r\n','controls /ads.  Displays either a form to distribute impressions between multiple ads, or to just buy impressions directly.','blank_box',0);
INSERT INTO box VALUES ('ad_story_format','Ad Story formatter','my $ad_id = $ARGS[0];\r\n\r\nmy $content = qq{\r\n%%BOX,show_ad,$ad_id%%\r\n};\r\n\r\nreturn { content => $content };','Use this to format the advertisments in the introtext of their stories.','blank_box',0);
INSERT INTO box VALUES ('section_title_subsections','null','my $content;\r\nmy $op = $S->{CGI}->param(\'op\');\r\nmy $section = $S->cgi->param(\'section\');\r\n\r\nif( $op eq \'section\' ) {\r\n  if( $S->{UI}->{VARS}->{enable_subsections} ) {\r\n\r\n    my @paths = $S->section_paths($section);\r\n    while( my $path = shift(@paths) ){\r\n\r\n      $path =~ s/\\/?$section$//;       # Remove if Current Section\r\n      $path =~ s/([^\\/]+)/<\\/b>%%norm_font_end%%<a href=\"%%rootdir%%\\/section\\/$1\">%%norm_font%%<b>$S->{SECTION_DATA}->{$1}->{title}<\\/b>%%norm_font_end%%<\\/a>%%norm_font%%<b>/g;\r\n      $path =~ s/^<\\/b>%%norm_font_end%%//;   # Clean Up After Ourselves\r\n      $path = ($path) ? \"%%norm_font%%<b>/</b>%%norm_font_end%%$path\" : \'\';\r\n      $content .= qq{<a href=\"%%rootdir%%/\">%%norm_font%%<b>Home</b>%%norm_font_end%%</a>$path%%norm_font%%<b>/$S->{SECTION_DATA}->{$section}->{title}</b>%%norm_font_end%%<br>\\n};\r\n    }\r\n    $content=~s/<\\/br>$//;\r\n  } else {\r\n    $content = $S->{SECTION_DATA}->{$section}->{title} || \'All Stories\';\r\n    $content = \"%%title_font%%$content%%title_font_end%%\";\r\n  }\r\n}\r\nelse {\r\n	$content = \'%%title_font%%Latest News%%title_font_end%%\';\r\n}\r\n\r\nreturn { content=>$content }\r\n','Display title of current section','blank_box',0);
INSERT INTO box VALUES ('renewad_box','Renew Advertisement','my $content = \'\';\r\nmy $err = \'\';\r\nmy $ad_id = $S->cgi->param(\'ad_id\') || 0;\r\nmy $confirm = $S->cgi->param(\'confirm\') || \'nope\';\r\nmy $purchase = $S->cgi->param(\'purchase\') || \'nope\';\r\nmy $cgi_amount = $S->cgi->param(\'amount\');\r\nmy $confirm_amt = $S->cgi->param(\'confirm_amt\') || \'1.11\'; # 1.11 so that it != $cgi_amount\r\n\r\n# first get the page set up\r\n$content = qq{\r\n<form name=\"buyimpressions\" action=\"%%rootdir%%/renew\" method=\"POST\" enctype=\"multipart/form-data\">\r\n<input type=\"hidden\" name=\"confirm_amt\" value=\"$cgi_amount\" />\r\n<table border=\"0\" cellpadding=\"1\" cellspacing=\"1\" width=\"99%\"> \r\n<tr><td colspan=\"2\" bgcolor=\"%%title_bgcolor%%\">%%title_font%% Renew Advertisement %%title_font_end%%</td></tr>\r\n<tr><td colspan=\"2\"> <input type=\"hidden\" name=\"ad_id\" value=\"$ad_id\"> &nbsp; </td></tr>\r\n};\r\n\r\n###########################################\r\n### Check to make sure they can renew the ad, then renew\r\n###  else show error message.  SEt up links on user ad list\r\n###  make sure they all direct to the right box\r\n###  get cron from rusty to set up to handle renewals right\r\n###  make sure db fields are there.\r\n###  maybe write some functions to handle renewals\r\n\r\nmy $ad_hash = $S->get_ad_hash($ad_id, \'db\');\r\n\r\n# first make sure they have chosen an ad\r\nunless( $ad_id ) {\r\n	$content .= qq{ <tr><td colspan=\"2\">%%norm_font%% %%renew_choose_ad%% %%norm_font_end%%</td></tr>\r\n</table></form>};\r\n	return { content => $content };\r\n}\r\n\r\nunless( $ad_hash->{sponsor} eq $S->{UID} ) {\r\n	$content .= qq{ <tr><td colspan=\"2\">%%norm_font%% %%renew_ad_no_permission%% %%norm_font_end%%</td></tr>\r\n</table></form>};\r\n	return { content => $content };\r\n}\r\n\r\n# check if confirm, and if so, change the action \r\nif( $purchase && $purchase eq \'Purchase\' && ($confirm_amt == $cgi_amount) ) {\r\n	warn \"sucessful purchase\" if $DEBUG;\r\n	return qq[%%BOX,submit_ad_pay_box,renew,$ad_hash->{ad_id},$confirm_amt%%];\r\n}\r\nelsif( $purchase && $purchase eq \'Purchase\' && ($confirm_amt != $cgi_amount) )  {\r\n	# they changed their amount, let them know why they\'re at the same page again.\r\n	$err = qq|<font color=\"ff0000\"> You have changed the amount you wanted to purchase, please click Purchase again to purchase the new amount</font>|;\r\n}\r\n\r\n\r\n# if we get here, and they clicked either button, then mark it as confirmed.\r\n# its possible that they changed their amount w/out confirming again.\r\nmy $purchase_button = \'\';\r\nmy $confirmed = 0;\r\nif( ($confirm && $confirm eq \'Confirm\') or ($purchase && $purchase eq \'Purchase\') ) {\r\n	$purchase_button = q{<input type=\"submit\" name=\"purchase\" value=\"Purchase\" />};\r\n	$confirmed = 1;\r\n}\r\n\r\n# need to check the input a little and generate the amount to populate the form with\r\nmy $ad_type = $S->get_ad_tmpl_info( $ad_hash->{ad_tmpl} );\r\nmy $min_impressions = $ad_type->{min_purchase_size};\r\nmy $cpm = $ad_type->{cpm};\r\nmy $amount = \'\';\r\nif( $confirmed && $cgi_amount && $cgi_amount !~ /^\\d+$/ ) {\r\n	$err = qq{<font color=\"ff0000\"> \'$cgi_amount\' is not a valid number of ads to purchase, you must purchase at least $min_impressions ad impressions</font>};\r\n	$purchase_button = \'\';\r\n}\r\nelsif( $confirmed && $cgi_amount && ($cgi_amount < $min_impressions) ) {\r\n	$err = qq{<font color=\"ff0000\"> $cgi_amount is not a valid purchase amount, the minimum amount you may purchase is $min_impressions ad impressions</font>};\r\n	$purchase_button = \'\';\r\n}\r\nelsif( $confirmed ) {\r\n	$amount = $cgi_amount;\r\n}\r\n\r\nmy $confirm_msg = $S->{UI}->{BLOCKS}->{confirm_ad_renew};\r\n$confirm_msg = \'\' unless $confirmed;\r\n\r\n$content .= qq{\r\n<tr><td colspan=\"2\"> &nbsp; </td></tr>\r\n<tr><td colspan=\"2\"> %%BOX,show_ad,$ad_id%% </td></tr>\r\n<tr><td colspan=\"2\"> %%norm_font%% $err %%norm_font_end%% </td></tr>\r\n<tr><td colspan=\"2\"> %%norm_font%% %%renew_ad_message%% %%norm_font_end%% </td></tr>\r\n<tr><td colspan=\"2\"> &nbsp; </td></tr>\r\n<tr><td align=\"left\" valign=\"top\"> %%norm_font%% <b>Order Size:</b> %%norm_font_end%% </td>\r\n<td align=\"left\" valign=\"top\"> %%norm_font%% <input type=\"text\" name=\"amount\" value=\"$amount\" /> %%norm_font_end%%</td>\r\n</tr>\r\n<tr><td colspan=\"2\"> %%norm_font%% <i>Minimum order size is $min_impressions impressions</i> %%norm_font_end%%</td></tr>\r\n<tr><td colspan=\"2\"> %%norm_font%% $confirm_msg %%norm_font_end%% </td></tr>\r\n<tr><td colspan=\"2\"> &nbsp; </td></tr>\r\n<tr><td colspan=\"2\" align=\"center\"> %%norm_font%% <input type=\"submit\" name=\"confirm\" value=\"Confirm\" /> $purchase_button </td></tr>\r\n};\r\n\r\n$content .= q{</table></form>};\r\n\r\n\r\n\r\n\r\nreturn { content => $content };\r\n','A page to let users renew the impressions on their ads.','blank_box',0);
INSERT INTO box VALUES ('ad_pay_type_select','','my $type = $S->cgi->param(\'type\');\r\nmy $ad_id = $S->cgi->param(\'ad_id\');\r\nmy $renew = $S->cgi->param(\'renew\');\r\nmy $count = $S->cgi->param(\'count\');\r\n\r\nunless ($type && $ad_id) {\r\n  return \'Error: No payment type or ad ID.\';\r\n}\r\n\r\nreturn \"%%BOX,ad_pay_cc,$ad_id,$count%%\" if ($type eq \'cc\');\r\nreturn \"%%BOX,ad_pay_paypal,$ad_id,$count%%\" if ($type eq \'paypal\');','Implant the right payment type box','blank_box',0);
INSERT INTO box VALUES ('ad_pay_cc','','my $ad_id = $ARGS[0];\r\nmy $count = $ARGS[1];\r\nmy $content;\r\n\r\n\r\n# If we\'re ordering, do it now.\r\nif ($S->cgi->param(\'final_pay\')) {\r\n	$content .= $S->cc_place_order();\r\n}\r\n\r\n\r\nunless ($content) {\r\n	my ($num, $price);\r\n	if ($count) {\r\n		# Get total price\r\n		my ($rv, $sth) = $S->db_select({\r\n			WHAT  => \'ad_types.cpm\',\r\n			FROM  => \'ad_info, ad_types\',\r\n			WHERE => \"ad_info.ad_id = $ad_id AND ad_info.ad_tmpl = ad_types.type_template\"\r\n		});\r\n		my ($cpm) = $sth->fetchrow();\r\n		$price = ($count/1000) * $cpm;\r\n		$num = $count;\r\n	} else {	\r\n		my ($rv, $sth) = $S->db_select({\r\n			WHAT => \'purchase_size,purchase_price\',\r\n			FROM => \'ad_info\',\r\n			WHERE => \"ad_id=$ad_id\"});\r\n\r\n		($num, $price) = $sth->fetchrow();\r\n		$sth->finish();\r\n	}\r\n	\r\n	$content .= qq{\r\n<b>Your ad:</b><br>\r\n<center>%%BOX,show_ad,$ad_id%%</center>\r\n<p>};\r\n	if ($S->cgi->param(\'pay\')) {\r\n    	$content .= $S->cc_preview_order($price,$num);\r\n	}\r\n\r\n	my $p_form = $S->cc_make_person_form();\r\n	my $c_form = $S->cc_make_card_form();\r\n\r\n	$content .= qq{\r\n	<p>\r\n	Please fill in the payment form below. Required fields are in <font color=\"#ff0000\">red</font>. When you are done, click \"Preview Order\". You will <b>not</b> be billed yet, and you will be able to change what you\'ve entered before confirming the order.\r\n	<form name=\"adpay\" ACTION=\"/special/adpay\" METHOD=\"POST\">\r\n	<input type=\"hidden\" name=\"ad_id\" value=\"$ad_id\">\r\n	<input type=\"hidden\" name=\"type\" value=\"cc\">\r\n	<input type=\"hidden\" name=\"count\" value=\"$count\">\r\n	<p>\r\n	<b>Billing Information:</b>\r\n	<p>\r\n	$p_form\r\n	<p>\r\n	<b>Credit/Debit Card Information:</b>\r\n	<p>\r\n	$c_form\r\n	<p>\r\n	<input type=\"submit\" name=\"pay\" value=\"Preview Order\">\r\n	</form>};\r\n}\r\n#\'\r\nreturn $content;','','blank_box',0);
INSERT INTO box VALUES ('cc_bill_orders','','my $DEBUG = 0;\r\nmy $err;\r\n\r\nmy ($rv, $sth) = $S->db_select({\r\n    WHAT => \'ad_payments.order_id, ad_payments.cost, ad_payments.ad_id\',\r\n    FROM => \'ad_payments, ad_info\',\r\n    WHERE => \'ad_payments.ad_id = ad_info.ad_id AND \r\n              ad_info.paid = 1 AND \r\n              ad_info.judged = 1 AND\r\n              ad_info.approved = 1 AND \r\n              ad_info.active = 0 AND \r\n              ad_info.example = 0 AND \r\n              ad_info.views_left > 0 AND \r\n              ad_payments.pay_type != \\\'paypal\\\' AND\r\n              ad_payments.paid IS NULL\'\r\n});\r\n\r\nmy $orders = [];\r\nwhile (my ($order_id, $cost, $ad_id) = $sth->fetchrow()) {\r\n	$err .=  \"Order: $order_id, Cost: $cost<br>\" if $DEBUG;\r\n	push @{$orders}, {\'ad_id\'   => $ad_id,\r\n	                  \'orderID\' => $order_id,\r\n	                  \'amount\'  => $cost};\r\n}\r\n$sth->finish();\r\n\r\nif ($#{$orders} >= 0) {	\r\n    $err = $S->cc_bill_approved_ads($orders);\r\n}\r\n\r\n# Set finished ads inactive to svae the database\r\n($rv, $sth) = $S->db_update({\r\n	WHAT => \'ad_info\',\r\n	SET  => \'active = 0\',\r\n	WHERE => \'views_left <= 0 AND perpetual != 1 AND active = 1\'\r\n});\r\n$sth->finish();\r\n\r\nreturn $err;\r\n		','Post-auth CC orders','blank_box',0);
INSERT INTO box VALUES ('ad_pay_paypal','Pay using paypal','my $ad_id = $ARGS[0];\r\nmy $count = $ARGS[1];\r\nmy $content;\r\nmy $site = $S->{UI}->{VARS}->{site_url}.$S->{UI}->{VARS}->{rootdir};\r\nmy $secure_site = $S->{UI}->{VARS}->{secure_site_url}.$S->{UI}->{VARS}->{rootdir};\r\nmy $business_id = \'paypal@mysite.org\';\r\n\r\nunless ($ad_id) {\r\n	return \"No ad id passed.\";\r\n}\r\n\r\nmy ($num, $price, $item);\r\nif ($count) {\r\n	# Get total price\r\n	my ($rv, $sth) = $S->db_select({\r\n		WHAT  => \'ad_types.cpm\',\r\n		FROM  => \'ad_info, ad_types\',\r\n		WHERE => \"ad_info.ad_id = $ad_id AND ad_info.ad_tmpl = ad_types.type_template\"\r\n	});\r\n	my ($cpm) = $sth->fetchrow();\r\n	$price = ($count/1000) * $cpm;\r\n	$price = sprintf(\"%1.2f\", $price);\r\n	$num = $count;\r\n	$item = \"Ad Renewal\";\r\n} else {\r\n	my ($rv, $sth) = $S->db_select({\r\n	  WHAT => \'purchase_size,purchase_price\',\r\n	  FROM => \'ad_info\',\r\n	  WHERE => \"ad_id=$ad_id\"});\r\n	($num, $price) = $sth->fetchrow();\r\n	$sth->finish();\r\n	$item = \"Advertisement\";\r\n}\r\n\r\nmy $finished = $S->cgi->param(\'finished\');\r\nmy $canceled = $S->cgi->param(\'canceled\');\r\n\r\nif ($finished) {\r\n	my $content = $S->{UI}->{BLOCKS}->{paypal_finished};	\r\n	return $content;\r\n} elsif ($canceled) {\r\n	my $content = $S->{UI}->{BLOCKS}->{paypal_canceled};\r\n	return $content;\r\n}\r\n\r\nmy $paypal_form = qq{\r\n<form action=\"https://www.paypal.com/cgi-bin/webscr\" method=\"post\">\r\n<input type=\"hidden\" name=\"cmd\" value=\"_xclick\">\r\n<input type=\"hidden\" name=\"business\" value=\"$business_id\">\r\n<input type=\"hidden\" name=\"notify_url\" value=\"$site/special/paypal_confirm\">\r\n<input type=\"hidden\" name=\"item_name\" value=\"$item\">\r\n<input type=\"hidden\" name=\"item_number\" value=\"$ad_id\">\r\n<input type=\"hidden\" name=\"no_shipping\" value=\"1\">\r\n<input type=\"hidden\" name=\"return\" value=\"$secure_site/special/adpay?type=paypal;ad_id=$ad_id;finished=1\">\r\n<input type=\"hidden\" name=\"cancel_return\" value=\"$secure_site/special/adpay?type=paypal;ad_id=$ad_id;canceled=1\">\r\n<input type=\"hidden\" name=\"amount\" value=\"$price\">\r\n<input type=\"hidden\" name=\"custom\" value=\"$num\">\r\n<input type=\"image\" src=\"%%imagedir%%/paypal.gif\" border=\"0\" name=\"submit\" alt=\"Make payments with PayPal - it\'s fast, free and secure!\">\r\n</form>};\r\n\r\n$content = qq{\r\n<b>Your ad:</b><br>\r\n<center></center>\r\n<p>\r\nYour purchase details are below. Click the Paypal button, and you will go to a page on Paypal where you will finish the payment process.\r\n<table border=0 cellpadding=1 cellspacing=0 bgcolor=\"#000000\" align=\"center\">\r\n  <tr>\r\n    <td>\r\n	  <table width=\"100%\" cellpadding=5 cellspacing=0 border=0 bgcolor=\"#eeeeee\">\r\n	    <tr>\r\n		  <td>\r\n			<FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=\"2\"><b>Impressions:</b></font>\r\n		  </td>\r\n		  <td>\r\n		    <FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=\"2\">$num</font>\r\n		  </td>\r\n		</tr>\r\n	    <tr>\r\n		  <td>\r\n			<FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=\"2\"><b>Total Price:</b></font>\r\n		  </td>\r\n		  <td>\r\n		    <FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=\"2\">\\$$price</font>\r\n		  </td>\r\n		</tr>\r\n		<tr>\r\n		  <td colspan=2 align=\"center\">\r\n		  <FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=\"2\">\r\n		  Click below to purchase.<br>\r\n		  $paypal_form\r\n		  </font>\r\n		  </td>\r\n		</tr>\r\n	  </table>\r\n	</td>\r\n  </tr>\r\n</table>};\r\n\r\nreturn $content;','','blank_box',0);
INSERT INTO box VALUES ('paypal_bill_orders','Bill paypal orders','my $DEBUG = 0;\r\nmy $err;\r\n\r\nmy ($rv, $sth) = $S->db_select({\r\n	WHAT => \'ad_payments.order_id, ad_payments.cost, ad_payments.ad_id, ad_info.approved\',\r\n    FROM => \'ad_payments, ad_info\',\r\n    WHERE => \'ad_payments.ad_id = ad_info.ad_id AND \r\n              ad_info.paid = 1 AND \r\n              ad_info.judged = 1 AND\r\n              ad_info.active = 0 AND \r\n              ad_info.example = 0 AND \r\n              ad_info.views_left > 0 AND \r\n              ad_payments.pay_type = \\\'paypal\\\' AND\r\n              ad_payments.paid IS NULL\'\r\n});\r\n\r\nmy @orders;\r\nwhile (my $o = $sth->fetchrow_hashref()) {\r\n	push @orders, $o;\r\n}\r\n$sth->finish();\r\n\r\nmy @disapproved_oids;\r\nforeach my $order (@orders) {\r\n	my ($paid, $active);\r\n	if ($order->{approved} == 0) {\r\n		push @disapproved_oids, $order->{order_id};\r\n		$paid = 0;\r\n		$active = 0;\r\n	} else {\r\n		$paid = 1;\r\n		$active = 1;\r\n	}\r\n\r\n	my ($rv, $sth) = $S->db_update({\r\n		WHAT  => \'ad_payments\',\r\n		SET   => \"paid=$paid, final_date=NOW()\",\r\n		WHERE => \"ad_id=$order->{ad_id}\"});\r\n	$sth->finish();\r\n	\r\n	($rv, $sth) = $S->db_update({\r\n		WHAT  => \'ad_info\',\r\n		SET   => \"active=$active\",\r\n		WHERE => \"ad_id=$order->{ad_id}\"});\r\n	$sth->finish();\r\n\r\n	if ($active) {\r\n		($rv, $sth) = $S->db_select({\r\n				WHAT => \'ad_sid\',\r\n				FROM => \'ad_info\',\r\n				WHERE => qq{ad_id = $order->{ad_id}}});\r\n		my $sid = $sth->fetchrow();\r\n			\r\n		if ($sid) {\r\n			$S->activate_ad_story($sid);\r\n		}\r\n	}\r\n}\r\n\r\nif ($#disapproved_oids >= 0) {\r\n	my $subject = \'Paypal Order Refund Alert\';\r\n	my $message = qq{\r\nThe following paypal orders were disapproved and need a refund.\r\n};\r\n	\r\n	foreach my $oid (@disapproved_oids) {\r\n		$message .= qq{\r\nhttps://www.paypal.com/vst/id=$oid};\r\n	}\r\n	\r\n	foreach my $to (split /,/, $S->{UI}->{BLOCKS}->{admin_alert}) {\r\n		$S->mail($to, $subject, $message);\r\n	}\r\n\r\n}','','blank_box',0);
INSERT INTO box VALUES ('paypal_confirm','','my $DEBUG = 0;\r\nmy $state;\r\n\r\n\r\nmy $answer = $S->paypal_ipn_confirm();\r\n\r\nif ($answer ne \'VERIFIED\') {\r\n	$S->paypal_invalid_mail();\r\n	return;\r\n}\r\n\r\nmy $vars = $S->cgi->Vars();\r\n# Check payment status\r\nmy $stat = $vars->{\'payment_status\'};\r\nreturn unless ($stat =~ /completed/i);\r\n\r\n# Check that it\'s an ad or a renewal. Add in subscription notify later\r\nif ($vars->{item_name} eq \'Advertisement\') {\r\n\r\n	$S->paypal_activate_ad($vars);\r\n\r\n} elsif ($vars->{item_name} eq \'Ad Renew\') {\r\n\r\n	$S->paypal_do_renewal($vars);\r\n\r\n}\r\n\r\n\r\nreturn;','','blank_box',0);
INSERT INTO box VALUES ('unpaid_ad_reap','','my ($rv, $sth) = $S->db_delete({\r\n    FROM => \'ad_info\',\r\n    WHERE => \'paid is null and TO_DAYS(NOW()) - TO_DAYS(submitted_on) >= 14 and example != 1\'});\r\n$sth->finish();\r\n','Reap unpaid ads after 14 days. They are unlikely to ever be paid for then.','blank_box',0);
INSERT INTO box VALUES ('logout_box','Logout','$S = $S->reset_user;\r\n\r\nmy $logout_url = $S->{UI}->{VARS}->{logout_url}\r\n	|| ($S->{UI}->{VARS}->{rootdir} . \'/\');\r\n\r\n$S->{APACHE}->header_out( Location => $logout_url );\r\n\r\n# the following is probably unessesary, but just in case...\r\nreturn { content => qq{Redirecting to <a href=\"$logout_url\">$logout_url</a>} }\r\n','This logs a user out.  For /logout','blank_box',0);

--
-- Table structure for table 'cache_time'
--

CREATE TABLE cache_time (
  resource varchar(50) NOT NULL default '',
  last_update int(11) NOT NULL default '0',
  PRIMARY KEY  (resource)
);

--
-- Dumping data for table 'cache_time'
--



--
-- Table structure for table 'commentcodes'
--

CREATE TABLE commentcodes (
  code int(1) NOT NULL default '0',
  name varchar(32) default NULL,
  PRIMARY KEY  (code)
);

--
-- Dumping data for table 'commentcodes'
--


INSERT INTO commentcodes VALUES (0,'Comments Enabled');
INSERT INTO commentcodes VALUES (1,'Read-Only');
INSERT INTO commentcodes VALUES (-1,'Comments Disabled');

--
-- Table structure for table 'commentratings'
--

CREATE TABLE commentratings (
  uid int(1) NOT NULL default '0',
  rating int(11) NOT NULL default '0',
  cid int(15) NOT NULL default '0',
  sid varchar(30) NOT NULL default '',
  rating_time datetime default '0000-00-00 00:00:00',
  PRIMARY KEY  (sid,cid,uid)
);

--
-- Dumping data for table 'commentratings'
--



--
-- Table structure for table 'comments'
--

CREATE TABLE comments (
  sid varchar(30) NOT NULL default '',
  cid int(15) NOT NULL default '0',
  pid int(15) NOT NULL default '0',
  date datetime default NULL,
  name varchar(50) default NULL,
  email varchar(50) default NULL,
  host_name varchar(50) default NULL,
  url varchar(50) default NULL,
  rank int(1) default NULL,
  subject varchar(50) NOT NULL default '',
  comment text NOT NULL,
  pending int(1) default '0',
  uid int(1) NOT NULL default '-1',
  points decimal(4,2) default NULL,
  lastmod int(1) default '-1',
  sig_status int(1) default '1',
  sig varchar(160) default NULL,
  commentip varchar(16) default NULL,
  PRIMARY KEY  (sid,cid),
  KEY stuff (uid,pid),
  FULLTEXT KEY commentsearch_idx (subject,comment)
);

--
-- Dumping data for table 'comments'
--



--
-- Table structure for table 'cron'
--

CREATE TABLE cron (
  name varchar(20) NOT NULL default '',
  func varchar(20) default NULL,
  run_every int(11) default NULL,
  last_run datetime default '0000-00-00 00:00:00',
  enabled int(1) default '1',
  is_box int(1) default '0',
  PRIMARY KEY  (name)
);

--
-- Dumping data for table 'cron'
--


INSERT INTO cron VALUES ('rdf','cron_rdf',21600,'0000-00-00 00:00:00',1,0);
INSERT INTO cron VALUES ('rdf_fetch','cron_rdf_fetch',3600,'0000-00-00 00:00:00',1,0);
INSERT INTO cron VALUES ('sessionreap','cron_sessionreap',86400,'0000-00-00 00:00:00',1,0);
INSERT INTO cron VALUES ('digest','cron_digest',86400,'0000-00-00 00:00:00',1,0);
INSERT INTO cron VALUES ('edit_queue','cron_edit_queue',3600,'0000-00-00 00:00:00',1,0);
INSERT INTO cron VALUES ('cc_bill_orders','cc_bill_orders',300,'2002-04-20 17:21:35',0,1);
INSERT INTO cron VALUES ('paypal_bill_orders','paypal_bill_orders',300,'0000-00-00 00:00:00',0,1);
INSERT INTO cron VALUES ('unpaid_ad_reap','unpaid_ad_reap',86400,'0000-00-00 00:00:00',0,1);

--
-- Table structure for table 'displaycodes'
--

CREATE TABLE displaycodes (
  code int(1) NOT NULL default '0',
  name varchar(32) default NULL,
  PRIMARY KEY  (code)
);

--
-- Dumping data for table 'displaycodes'
--


INSERT INTO displaycodes VALUES (0,'Always Display');
INSERT INTO displaycodes VALUES (1,'Only Display Within Section');
INSERT INTO displaycodes VALUES (-1,'Never Display');
INSERT INTO displaycodes VALUES (-2,'Submitted');
INSERT INTO displaycodes VALUES (-3,'Editing');

--
-- Table structure for table 'hooks'
--

CREATE TABLE hooks (
  hook varchar(50) NOT NULL default '',
  func varchar(50) NOT NULL default '',
  is_box int(1) default '0',
  PRIMARY KEY  (hook,func)
);

--
-- Dumping data for table 'hooks'
--



--
-- Table structure for table 'ops'
--

CREATE TABLE ops (
  op varchar(50) NOT NULL default '',
  template varchar(30) NOT NULL default '',
  func varchar(50) default NULL,
  is_box int(1) default '0',
  enabled int(1) default '1',
  perm varchar(50) default '',
  description text,
  PRIMARY KEY  (op)
);

--
-- Dumping data for table 'ops'
--


INSERT INTO ops VALUES ('main','index_template','main_page',0,1,'','Displays the front page.');
INSERT INTO ops VALUES ('blank','blank_template',NULL,0,1,'','Uses a blank template to do nothing and show nothing.');
INSERT INTO ops VALUES ('poll_vote','default_template','just_vote',0,1,'poll_vote','Registers a user vote in a poll.');
INSERT INTO ops VALUES ('modsub','default_template','moderate_subs',0,1,'moderate','Display the moderation queue.');
INSERT INTO ops VALUES ('submitstory','submit_template','submit_story',0,1,'story_post','Submits a story to the moderation queue.');
INSERT INTO ops VALUES ('admin','default_template','admin_main',0,1,'','Entry point to the various admin tools.');
INSERT INTO ops VALUES ('displaystory','story_template','focus_view',0,1,'','Formats and shows a story according to the params.');
INSERT INTO ops VALUES ('view_poll','default_template','poll_focus_view',0,1,'','Displays a poll or the results of one.');
INSERT INTO ops VALUES ('poll_list','default_template','poll_listing',0,1,'','Gives a list of all the polls that have been created');
INSERT INTO ops VALUES ('comments','default_template','comment_dig',0,1,'','Displays comments in various formats.');
INSERT INTO ops VALUES ('newuser','default_template','new_user',0,1,'','Starts the process of creating a new user.');
INSERT INTO ops VALUES ('special','default_template','special',0,1,'','Displays special pages.');
INSERT INTO ops VALUES ('olderlist','default_template','olderlist',0,1,'','Gives a listing of older stories.');
INSERT INTO ops VALUES ('search','default_template','search',0,1,'','Everything related to searching content on the site.');
INSERT INTO ops VALUES ('interface','default_template','interface_prefs',0,1,'','Displays and edits preferences.');
INSERT INTO ops VALUES ('user','default_template','edit_user',0,1,'','Display and edit registered users.');
INSERT INTO ops VALUES ('section','index_template','main_page',0,1,'','Lists the stories, with intros, that are in a specified section.');
INSERT INTO ops VALUES ('confirmpass','default_template',NULL,0,1,'','Confirms a password change request.');
INSERT INTO ops VALUES ('logout','blank_template','logout_box',1,1,'','Logs the user out and removes their session.');
INSERT INTO ops VALUES ('default','index_template',NULL,0,1,'','The template used when no other is known. \'main\' is actually the default op');
INSERT INTO ops VALUES ('fz','rss_template',NULL,0,1,'','Interacts with ForumZilla to provide support for it.');
INSERT INTO ops VALUES ('fzdisplay','fzdisplay_template',NULL,0,1,'','Displays stories and comments for ForumZilla.');
INSERT INTO ops VALUES ('submitrdf','submitrdf_template',NULL,0,1,'','Walks the user through submitting an RDF feed.');
INSERT INTO ops VALUES ('cron','cron_template','cron',0,1,'','Run waiting cron jobs.');
INSERT INTO ops VALUES ('showad','ad_test_template',NULL,0,1,'','Displays a single advertisment.');
INSERT INTO ops VALUES ('submitad','submit_template','choose_submit_ad_step',0,1,'','Start the process of submitting an ad.');
INSERT INTO ops VALUES ('redirect','','redirect',0,1,'','Does ad redirections to other sites, with logging.');
INSERT INTO ops VALUES ('adinfo','default_template','ad_info_page',0,1,'','Displays everything related to an ad.');
INSERT INTO ops VALUES ('ads','buyimpressions_template',NULL,0,1,'','Used for purchasing ad impressions.');
INSERT INTO ops VALUES ('hotlist','',NULL,0,1,'','Edits a user\'s story hotlist.');
INSERT INTO ops VALUES ('renew','renewad_template',NULL,0,1,'','Used to renew ads that are already running.');
INSERT INTO ops VALUES ('dynamic','dynamic_template','comment_dig',0,1,'','Same as comments, except is used for dynamic comment mode.');

--
-- Table structure for table 'patches'
--

CREATE TABLE patches (
  scoop_ver varchar(20) NOT NULL default '',
  patch_num int(2) NOT NULL default '0',
  patch_name varchar(30) default NULL,
  patch_type varchar(10) NOT NULL default '',
  PRIMARY KEY  (scoop_ver,patch_num,patch_type)
);

--
-- Dumping data for table 'patches'
--


INSERT INTO patches VALUES ('0_7-dev',0,'Upgrades','sql');
INSERT INTO patches VALUES ('0_7-dev',1,'SiteControls','sql');
INSERT INTO patches VALUES ('0_7-dev',2,'RDF','sql');
INSERT INTO patches VALUES ('0_7-dev',3,'StickySig','sql');
INSERT INTO patches VALUES ('0_7-dev',4,'NewHotlist','sql');
INSERT INTO patches VALUES ('0_7-dev',4,NULL,'post');
INSERT INTO patches VALUES ('0_7-dev',5,'RDFChanges','sql');
INSERT INTO patches VALUES ('0_7-dev',6,'AdminNotes','sql');
INSERT INTO patches VALUES ('0_7-dev',7,'AllowedHTML','sql');
INSERT INTO patches VALUES ('0_7-dev',8,'StickySig2','sql');
INSERT INTO patches VALUES ('0_7-dev',9,'RDFupdate','sql');
INSERT INTO patches VALUES ('0_7-dev',10,'RatingTimes','sql');
INSERT INTO patches VALUES ('0_7-dev',11,'UserSecure','sql');
INSERT INTO patches VALUES ('0_7-dev',12,'SectionPerms','sql');
INSERT INTO patches VALUES ('0_7-dev',12,NULL,'post');
INSERT INTO patches VALUES ('0_7-dev',13,'Cron','sql');
INSERT INTO patches VALUES ('0_7-dev',13,NULL,'post');
INSERT INTO patches VALUES ('0_7-dev',14,'SectionPages','sql');
INSERT INTO patches VALUES ('0_7-dev',15,'NewAccountLimit','sql');
INSERT INTO patches VALUES ('0_7-dev',16,'NewURLs','sql');
INSERT INTO patches VALUES ('0_7-dev',17,'NewSections','sql');
INSERT INTO patches VALUES ('0_7-dev',17,NULL,'post');
INSERT INTO patches VALUES ('0_7-dev',18,'Index-Changes','sql');
INSERT INTO patches VALUES ('0_7-dev',19,'Subscriptions','sql');
INSERT INTO patches VALUES ('0_7-dev',20,'CommentControl','sql');
INSERT INTO patches VALUES ('0_7-dev',21,'StorySection','sql');
INSERT INTO patches VALUES ('0_7-dev',22,'PollPerms','sql');
INSERT INTO patches VALUES ('0_7-dev',23,'LastSectionStuff','sql');
INSERT INTO patches VALUES ('0_7-dev',24,'NewURLs2','sql');
INSERT INTO patches VALUES ('0_7-dev',25,'StoryEmail','sql');
INSERT INTO patches VALUES ('0_7-dev',26,'ConfirmPass','sql');
INSERT INTO patches VALUES ('0_9-dev',1,'StaticPageCache','sql');
INSERT INTO patches VALUES ('0_9-dev',2,'UserBoxPrefs','sql');
INSERT INTO patches VALUES ('0_9-dev',3,'HTMLandSpelling','sql');
INSERT INTO patches VALUES ('0_9-dev',4,'AdPatch1','sql');
INSERT INTO patches VALUES ('0_9-dev',5,'WipeRatings','sql');
INSERT INTO patches VALUES ('0_9-dev',6,'SomeVars','sql');
INSERT INTO patches VALUES ('0_9-dev',7,'ResetBoxPrefs','sql');
INSERT INTO patches VALUES ('0_9-dev',8,'AdPatch2','sql');
INSERT INTO patches VALUES ('0_9-dev',9,'AdPatch3','sql');
INSERT INTO patches VALUES ('0_9-dev',10,'24hTime','sql');
INSERT INTO patches VALUES ('0_9-dev',11,'OpsPerms','sql');
INSERT INTO patches VALUES ('0_9-dev',12,'AdPatch4','sql');
INSERT INTO patches VALUES ('0_9-dev',12,NULL,'post');
INSERT INTO patches VALUES ('0_9-dev',13,'OpAliases','sql');
INSERT INTO patches VALUES ('0_9-dev',13,NULL,'post');
INSERT INTO patches VALUES ('0_9-dev',14,'Formkeys','sql');
INSERT INTO patches VALUES ('0_9-dev',15,'AdPatch5','sql');
INSERT INTO patches VALUES ('0_9-dev',16,'AdPatch6','sql');
INSERT INTO patches VALUES ('0_9-dev',17,'AdPatch7','sql');
INSERT INTO patches VALUES ('0_9-dev',18,'NotifyAuthor','sql');
INSERT INTO patches VALUES ('0_9-dev',19,'AutoPostVars','sql');
INSERT INTO patches VALUES ('0_9-dev',20,'AutoPostTimeBasedVars','sql');
INSERT INTO patches VALUES ('0_9-dev',21,'AdPosition','sql');
INSERT INTO patches VALUES ('0_9-dev',22,'RelatedLinks','sql');
INSERT INTO patches VALUES ('0_9-dev',23,'AdDiscussions','sql');
INSERT INTO patches VALUES ('0_9-dev',24,'MoreSpelChek','sql');
INSERT INTO patches VALUES ('0_9-dev',25,'CommentIPlog','sql');
INSERT INTO patches VALUES ('0_9-dev',26,'SubSections','sql');
INSERT INTO patches VALUES ('0_9-dev',27,'MojoIgnoreDiaries','sql');
INSERT INTO patches VALUES ('0_9-dev',28,'EditQueue','sql');
INSERT INTO patches VALUES ('0_9-dev',29,'AdRenewal','sql');
INSERT INTO patches VALUES ('0_9-dev',30,'Dynamic','sql');
INSERT INTO patches VALUES ('0_9-dev',31,'AdPayment','sql');
INSERT INTO patches VALUES ('0_9-dev',32,'Dynamic2','sql');
INSERT INTO patches VALUES ('0_9-dev',33,'Dynamic3','sql');
INSERT INTO patches VALUES ('0_9-dev',34,'AutoFormat','sql');
INSERT INTO patches VALUES ('0_9-dev',35,'OpsAdminTools','sql');
INSERT INTO patches VALUES ('0_9-dev',35,NULL,'post');
INSERT INTO patches VALUES ('0_9-dev',36,'BlockCat','sql');
INSERT INTO patches VALUES ('0_9-dev',36,NULL,'post');
INSERT INTO patches VALUES ('0_9-dev',37,'MoreEditQueue','sql');
INSERT INTO patches VALUES ('0_9-dev',38,'Interpolate','sql');
INSERT INTO patches VALUES ('0_9-dev',39,'BarsBlock','sql');
INSERT INTO patches VALUES ('0_9-dev',40,'LogoutBox','sql');
INSERT INTO patches VALUES ('0_9-dev',41,'Subscriptions','sql');
INSERT INTO patches VALUES ('0_9-dev',42,'NewCache','sql');
INSERT INTO patches VALUES ('0_9-dev',43,'Dynamic4','sql');
INSERT INTO patches VALUES ('0_9-dev',44,'EditQueue3','sql');
INSERT INTO patches VALUES ('0_9-dev',44,NULL,'post');
INSERT INTO patches VALUES ('0_9-dev',45,'Hooks','sql');
INSERT INTO patches VALUES ('0_9-dev',46,'DefaultUser','sql');
INSERT INTO patches VALUES ('0_9-dev',47,'PollBox','sql');
INSERT INTO patches VALUES ('0_9-dev',47,NULL,'post');

--
-- Table structure for table 'perm_groups'
--

CREATE TABLE perm_groups (
  perm_group_id varchar(50) NOT NULL default '',
  group_perms text,
  default_user_group int(1) default '0',
  group_description text,
  PRIMARY KEY  (perm_group_id)
);

--
-- Dumping data for table 'perm_groups'
--


INSERT INTO perm_groups VALUES ('Anonymous','comment_post,poll_vote,story_post,poll_post_comments,poll_read_comments,view_polls',0,'Anonymous users');
INSERT INTO perm_groups VALUES ('Users','attach_poll,comment_post,comment_rate,moderate,poll_post_comments,poll_read_comments,poll_vote,story_post,submit_ad,submit_rdf,view_polls,use_spellcheck',1,'Normal users. This should be the default perm level probably.');
INSERT INTO perm_groups VALUES ('Editors','attach_poll,comment_post,comment_rate,edit_polls,edit_special,list_polls,moderate,poll_post_comments,poll_read_comments,poll_vote,story_admin,story_list,story_post,submit_ad,submit_rdf,view_polls,use_spellcheck',0,'Editorial administrators');
INSERT INTO perm_groups VALUES ('Admins','ad_admin,attach_poll,comment_delete,comment_post,comment_rate,edit_blocks,edit_polls,edit_sections,edit_special,edit_user,edit_vars,list_polls,moderate,poll_post_comments,poll_read_comments,poll_vote,rdf_admin,show_perms,story_admin,story_list,story_post,submit_ad,view_polls,use_spellcheck,view_comment_ip',0,'Site administrators and junk');
INSERT INTO perm_groups VALUES ('Superuser','ad_admin,attach_poll,comment_delete,comment_post,comment_rate,cron_admin,edit_blocks,edit_boxes,edit_groups,edit_perms,edit_polls,edit_sections,edit_special,edit_topics,edit_user,edit_vars,list_polls,moderate,poll_post_comments,poll_read_comments,poll_vote,rdf_admin,show_perms,story_admin,story_list,story_post,submit_ad,submit_rdf,super_mojo,view_polls,use_spellcheck,view_comment_ip,edit_ops,edit_hooks',0,'All permissions');
INSERT INTO perm_groups VALUES ('Advertisers','attach_poll,comment_post,comment_rate,moderate,poll_post_comments,poll_read_comments,poll_vote,story_post,submit_ads,submit_rdf,view_polls,submit_ad,use_spellcheck',0,'Advertiser group, these people should be able to submit ads.');

--
-- Table structure for table 'pollanswers'
--

CREATE TABLE pollanswers (
  qid varchar(20) NOT NULL default '',
  aid int(11) NOT NULL default '0',
  answer varchar(255) default NULL,
  votes int(11) default NULL,
  PRIMARY KEY  (qid,aid)
);

--
-- Dumping data for table 'pollanswers'
--


INSERT INTO pollanswers VALUES ('967438666_MdZJbSqm',2,'No.',0);
INSERT INTO pollanswers VALUES ('967438666_MdZJbSqm',1,'Yes.',0);
INSERT INTO pollanswers VALUES ('967438565_opsmxIVg',1,'Scoop',1);
INSERT INTO pollanswers VALUES ('967438565_opsmxIVg',2,'Slash',0);
INSERT INTO pollanswers VALUES ('967438565_opsmxIVg',3,'Squishdot',0);
INSERT INTO pollanswers VALUES ('967438565_opsmxIVg',4,'PHPSlash',0);
INSERT INTO pollanswers VALUES ('967438565_opsmxIVg',5,'Wikki',0);
INSERT INTO pollanswers VALUES ('967438565_opsmxIVg',6,'That homebrew stuff I wrote',0);

--
-- Table structure for table 'pollquestions'
--

CREATE TABLE pollquestions (
  qid varchar(20) NOT NULL default '',
  question varchar(255) NOT NULL default '',
  voters int(11) default NULL,
  post_date datetime default NULL,
  PRIMARY KEY  (qid)
);

--
-- Dumping data for table 'pollquestions'
--


INSERT INTO pollquestions VALUES ('967438666_MdZJbSqm','Was it easy to install?',0,'2000-08-28 00:58:09');
INSERT INTO pollquestions VALUES ('967438565_opsmxIVg','What\'s your favorite weblog app?',1,'2000-08-28 00:56:55');

--
-- Table structure for table 'pollvoters'
--

CREATE TABLE pollvoters (
  qid varchar(20) NOT NULL default '',
  id varchar(35) NOT NULL default '',
  time datetime default NULL,
  uid int(11) NOT NULL default '-1',
  user_ip varchar(15) NOT NULL default '',
  KEY qid (qid,id,uid)
);

--
-- Dumping data for table 'pollvoters'
--


INSERT INTO pollvoters VALUES ('967438565_opsmxIVg','scoop','2000-08-28 00:57:28',1,'127.0.0.1');

--
-- Table structure for table 'post_throttle'
--

CREATE TABLE post_throttle (
  uid int(11) NOT NULL default '0',
  created_time datetime NOT NULL default '0000-00-00 00:00:00',
  post_lock int(1) NOT NULL default '0',
  lock_timeout int(11) NOT NULL default '0',
  PRIMARY KEY  (uid)
);

--
-- Dumping data for table 'post_throttle'
--



--
-- Table structure for table 'rdf_channels'
--

CREATE TABLE rdf_channels (
  rid smallint(6) NOT NULL auto_increment,
  rdf_link varchar(200) NOT NULL default '',
  link varchar(200) default NULL,
  title varchar(60) default NULL,
  description text,
  image_title varchar(40) default NULL,
  image_url varchar(200) default NULL,
  image_link varchar(200) default NULL,
  form_title varchar(40) default NULL,
  form_description tinytext,
  form_name varchar(20) default NULL,
  form_link varchar(200) default NULL,
  enabled int(1) default '1',
  submitted int(1) default NULL,
  submittor varchar(50) default NULL,
  PRIMARY KEY  (rid)
);

--
-- Dumping data for table 'rdf_channels'
--


INSERT INTO rdf_channels VALUES (1,'http://www.kuro5hin.org/backend.rdf','http://www.kuro5hin.org/','kuro5hin.org','technology and culture, from the trenches','kuro5hin.org','http://www.kuro5hin.org/images/kuro5hin.png','http://www.kuro5hin.org/','Search kuro5hin.org','','string','http://www.kuro5hin.org/search/',1,NULL,NULL);
INSERT INTO rdf_channels VALUES (4,'http://freshmeat.net/backend/fm.rdf','http://freshmeat.net/','freshmeat.net','The one-stop-shop for all your Linux software needs','freshmeat.net','http://freshmeat.net/img/fm-logo-my-netscape.jpg','http://freshmeat.net/','quick finder','Use the text input below to search the freshmeat application database','q','http://freshmeat.net/search/',1,NULL,NULL);
INSERT INTO rdf_channels VALUES (3,'http://www.slashdot.org/slashdot.rdf','http://slashdot.org','Slashdot','News for nerds, stuff that matters','Slashdot','http://images.slashdot.org/topics/topicslashdot.gif','http://slashdot.org','','','','',1,NULL,NULL);

--
-- Table structure for table 'rdf_items'
--

CREATE TABLE rdf_items (
  rid smallint(6) NOT NULL default '0',
  idx tinyint(4) NOT NULL default '0',
  title varchar(100) default NULL,
  link varchar(200) default NULL,
  description tinytext,
  PRIMARY KEY  (rid,idx)
);

--
-- Dumping data for table 'rdf_items'
--



--
-- Table structure for table 'section_perms'
--

CREATE TABLE section_perms (
  group_id varchar(50) NOT NULL default '',
  section varchar(30) NOT NULL default '',
  sect_perms text,
  default_sect_perm int(1) default '0',
  PRIMARY KEY  (group_id,section)
);

--
-- Dumping data for table 'section_perms'
--


INSERT INTO section_perms VALUES ('Superuser','Diary',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',0);
INSERT INTO section_perms VALUES ('Admins','Diary',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',0);
INSERT INTO section_perms VALUES ('Editors','Diary',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',0);
INSERT INTO section_perms VALUES ('Users','Diary',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',0);
INSERT INTO section_perms VALUES ('Anonymous','Diary',',norm_read_comments,norm_post_comments,norm_read_stories,deny_post_stories',0);
INSERT INTO section_perms VALUES ('Superuser','news',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',1);
INSERT INTO section_perms VALUES ('Admins','news',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',1);
INSERT INTO section_perms VALUES ('Editors','news',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',1);
INSERT INTO section_perms VALUES ('Users','news',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',1);
INSERT INTO section_perms VALUES ('Anonymous','news',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',1);
INSERT INTO section_perms VALUES ('Advertisers','Diary',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',0);
INSERT INTO section_perms VALUES ('Advertisers','news',',norm_read_comments,norm_post_comments,norm_read_stories,norm_post_stories',1);

--
-- Table structure for table 'sections'
--

CREATE TABLE sections (
  section varchar(30) NOT NULL default '',
  title varchar(64) NOT NULL default '',
  description text,
  icon varchar(255) default NULL,
  PRIMARY KEY  (section)
);

--
-- Dumping data for table 'sections'
--


INSERT INTO sections VALUES ('Diary','Diaries','Reader diaries','');
INSERT INTO sections VALUES ('news','News','Just the news, ma\'am','');

--
-- Table structure for table 'sessions'
--

CREATE TABLE sessions (
  last_accessed timestamp(14) NOT NULL,
  id varchar(32) NOT NULL default '',
  length int(11) default NULL,
  a_session text,
  PRIMARY KEY  (id)
);

--
-- Dumping data for table 'sessions'
--



--
-- Table structure for table 'special'
--

CREATE TABLE special (
  pageid varchar(50) NOT NULL default '',
  title varchar(255) NOT NULL default '',
  description text,
  content text,
  PRIMARY KEY  (pageid)
);

--
-- Dumping data for table 'special'
--


INSERT INTO special VALUES ('mission','Mission Statement','The site\'s purpose','This is this site\'s mission. To be as cool as possible. That is all.');
INSERT INTO special VALUES ('faq','Frequently Asked Questions','The FAQ, duh.','This is the FAQ for this fine Scoop site. It\'s brand new, so there haven\'t been any questions asked frequently yet. But if there were, you bet they\'d be right here!');
INSERT INTO special VALUES ('rate_warn','Warning: Posting rate exceeded','The page that explains what\'s going on when they exceed the defined post limit','You have exceeded this site\'s maximum posting rate. You are only allowed to post a certain number of comments or stories in a short period of time. Your user account is now locked from posting for a few minutes, after which it will become normal again. Be warned though: if you attempt to post again while you\'re locked out, the timeout period will double, and this will keep happening as long as you keep trying to post. Walk away for a few minutes, have a nice cup of coffee, come back, and everything will be cool. Thanks.');
INSERT INTO special VALUES ('rdf_preview','External Feeds Preview','Used to preview external feeds\'s boxes.','Below is a preview of what the selected feed will look like once it\'s been added. The headlines within it are the current ones.<p>\r\n<table align=\"center\" width=\"40%\" border=\"0\">\r\n<tr><td>\r\n%%BOX,rdf_feeds%%\r\n</td></tr>\r\n</table>');
INSERT INTO special VALUES ('adtypes','Advertisement Type Listing','Lists the different types of advertisements','%%BOX,ad_types%%');
INSERT INTO special VALUES ('adlist','Advertisement Types','This is just a list of all the types of advertisements.','%%BOX,ad_types%%');
INSERT INTO special VALUES ('adpay','Pay for Ad Order','','%%BOX,ad_pay_type_select%%');
INSERT INTO special VALUES ('paypal_confirm','Paypal auto-confirm','','%%BOX,paypal_confirm%%');
INSERT INTO special VALUES ('autoformat_syntax','Auto Format Mode Syntax','Description of the Auto Format syntax.','<p>If you don\'t know HTML, that won\'t stop you from making your stories and posts as nicely formatted and fancy as posts by those who do. If you set your \"Post Mode\" in Comment Preferences to \"Auto Format\", Scoop will do its best to format your comment based on its contents, instead of forcing you to litter it with tags. The following page will describe the mechanics used by Scoop to format comments and stories posted in \"Auto Format\" mode.</p>\r\n\r\n<h4>Paragraphs and line breaks</h4>\r\n\r\n<p>In order to start a new paragraph, simply press \r\nEnter twice. To insert a line break, press Enter once. Note that text will automatically wrap to fit the size of the screen, so line breaks like that are generally unnecessary. In most cases, you shouldn\'t need to hit Enter at all except for paragraph breaks.</p>\r\n\r\n<h4>Bold and Italics</h4>\r\n\r\n<p>If you want to emphasize a word or phrase, you can type it into the text box surrounded in asterisks (*), <code>*like this*</code>. This will cause the text between the asterisks to be rendered in <b>bold type</b>. Similarly, you can also enter text between underscores (_) or slashes (/), <code>_like this_ /or this/</code>, in order to render the given text in <i>italics</i>.</p>\r\n\r\n<h4>Making links</h4>\r\n\r\n<p>Of course, you can\'t post on the Web without needing to insert a link every now and then. Creating a link is as simple as typing in the URL (the address shown in your browser\'s toolbar at the top of the window). Auto Format mode will automatically turn all URLs into links. For example, if you were to type the following text:</p>\r\n<blockquote><code>This website runs weblog software from http://scoop.kuro5hin.org.</code></blockquote>\r\n<p>the resulting comment will look like this:</p>\r\n<blockquote>This website runs weblog software from <a href=\"http://scoop.kuro5hin.org\">http://scoop.kuro5hin.org</a>.</blockquote>\r\n<p>Of course, it\'s not always desirable to have the text of the link be the same as the target of the link. You can use brackets (\'[\' and \']\') in order to specify both the link text and link target. For example, if you wanted the text \"<code>This search engine</code>\" to point to <code>http://www.google.com/</code>, you would type the following:</p>\r\n<blockquote><code>[This search engine http://www.google.com/]</code></blockquote>\r\n<p>Which will render like so:</p>\r\n<blockquote><a href=\"http://www.google.com/\">This search engine</a></blockquote>\r\n\r\n<h4>Making lists</h4>\r\n\r\n<p>You can create bulleted lists by entering a series of lines starting with an asterisk followed by a space (\'* \'). Numbered lists can be created similarly, by typing a series of lines beginning with a number follwed by a period (\'1. \'). For example, typing in the following text:</p>\r\n<blockquote><pre>I had these items for breakfast this morning:\r\n* Eggs\r\n* Bacon\r\n* Toast\r\n* Hot grits\r\n</pre></blockquote>\r\n<p>will give the following result:</p>\r\n<blockquote>I had these items for breakfast this morning:\r\n<ul>\r\n<li>Eggs</li>\r\n<li>Bacon</li>\r\n<li>Toast</li>\r\n<li>Hot grits</li>\r\n</ul></blockquote>\r\n');

--
-- Table structure for table 'statuscodes'
--

CREATE TABLE statuscodes (
  code int(1) NOT NULL default '0',
  name varchar(32) default NULL,
  PRIMARY KEY  (code)
);

--
-- Dumping data for table 'statuscodes'
--


INSERT INTO statuscodes VALUES (-1,'Pending');
INSERT INTO statuscodes VALUES (0,'Normal');
INSERT INTO statuscodes VALUES (-2,'Submitted');

--
-- Table structure for table 'stories'
--

CREATE TABLE stories (
  sid varchar(20) NOT NULL default '',
  tid varchar(20) NOT NULL default '',
  aid varchar(30) NOT NULL default '',
  title varchar(100) default NULL,
  dept varchar(100) default NULL,
  time datetime NOT NULL default '0000-00-00 00:00:00',
  introtext text,
  bodytext text,
  writestatus int(1) NOT NULL default '0',
  hits int(1) NOT NULL default '0',
  section varchar(30) NOT NULL default '',
  displaystatus int(1) NOT NULL default '0',
  commentstatus int(1) default NULL,
  totalvotes int(11) NOT NULL default '0',
  score int(11) NOT NULL default '0',
  rating int(11) NOT NULL default '0',
  attached_poll varchar(20) default NULL,
  sent_email int(1) NOT NULL default '0',
  PRIMARY KEY  (sid),
  KEY section_idx (section,displaystatus),
  KEY displaystatus_idx (displaystatus),
  FULLTEXT KEY storysearch_idx (title,introtext,bodytext)
);

--
-- Dumping data for table 'stories'
--


INSERT INTO stories VALUES ('2000/8/27/224648/707','scoop','scoop','Congratulations! You\'ve installed Scoop!',NULL,'2000-08-28 00:17:18','Well, if you\'re seeing this, then hot damn, it worked! I hope the install wasn\'t too hairy for ya. Read below for a little more info about how to get started with this thing, and I wish you the best of luck! Oh, yeah, and why don\'t you email <A HREF=\"mailto:rusty@kuro5hin.org\">rusty@kuro5hin.org</A> while you\'re at it, and give me the url? Thanks!','What you\'ll want to do now is login as \'scoop\', password \'scoop\', and edit some stuff. Likely the first thing you\'ll want to do is make a different admin account, and disable this one, since it\'s the default and everyone will know about it. Just do a normal \"create account\", and when your account is created, look at the User Info link for the new user, while you\'re logged in as \'scoop\'. Click on \"Edit User\", and set the group to \"Superuser\". You\'ll probably also want to change the password for \'scoop\'. Log out, and log back in as your new user. And there you go! Then start editing your vars and blocks man!',0,0,'news',0,0,1,1,0,'967438666_MdZJbSqm',1);

--
-- Table structure for table 'storymoderate'
--

CREATE TABLE storymoderate (
  sid varchar(20) NOT NULL default '',
  uid int(11) NOT NULL default '0',
  time datetime default NULL,
  vote int(11) NOT NULL default '0',
  comment text,
  section_only enum('N','Y','X') NOT NULL default 'X',
  PRIMARY KEY  (sid,uid)
);

--
-- Dumping data for table 'storymoderate'
--



--
-- Table structure for table 'subsections'
--

CREATE TABLE subsections (
  section varchar(32) NOT NULL default '',
  child varchar(32) NOT NULL default '',
  inheritable tinyint(1) NOT NULL default '0',
  invisible tinyint(1) NOT NULL default '0',
  time timestamp(14) NOT NULL,
  PRIMARY KEY  (section,child)
);

--
-- Dumping data for table 'subsections'
--



--
-- Table structure for table 'topics'
--

CREATE TABLE topics (
  tid varchar(20) NOT NULL default '',
  image varchar(30) default NULL,
  alttext varchar(40) default NULL,
  width int(11) default NULL,
  height int(11) default NULL,
  PRIMARY KEY  (tid)
);

--
-- Dumping data for table 'topics'
--


INSERT INTO topics VALUES ('all','scoop.jpg','All Topics',80,50);
INSERT INTO topics VALUES ('scoop','scoop.jpg','Scoop',80,50);
INSERT INTO topics VALUES ('diary','scoop.jpg','Diary',80,50);

--
-- Table structure for table 'userprefs'
--

CREATE TABLE userprefs (
  uid int(11) NOT NULL default '0',
  prefname varchar(200) NOT NULL default '',
  prefvalue text,
  PRIMARY KEY  (uid,prefname)
);

--
-- Dumping data for table 'userprefs'
--



--
-- Table structure for table 'users'
--

CREATE TABLE users (
  uid int(11) NOT NULL default '0',
  nickname varchar(50) default NULL,
  realname varchar(50) default NULL,
  realemail varchar(50) default NULL,
  origemail varchar(50) default NULL,
  fakeemail varchar(50) default NULL,
  homepage varchar(100) default NULL,
  passwd varchar(12) default NULL,
  mode varchar(10) default NULL,
  posttype varchar(10) default NULL,
  bio varchar(255) default NULL,
  sig varchar(160) default NULL,
  mailreplies int(1) default NULL,
  trustlev int(1) default NULL,
  threshold int(1) default NULL,
  score int(1) default NULL,
  points int(1) default NULL,
  commentsort int(1) default '0',
  defaultpoints int(1) default '0',
  publickey text,
  perms varchar(255) default NULL,
  perm_group varchar(50) default NULL,
  mojo varchar(5) default NULL,
  admin_notes text,
  creation_ip varchar(16) NOT NULL default '',
  creation_time datetime NOT NULL default '0000-00-00 00:00:00',
  pass_confirm varchar(12) default NULL,
  pass_sent_at datetime default NULL,
  PRIMARY KEY  (uid)
);

--
-- Dumping data for table 'users'
--


INSERT INTO users VALUES (1,'scoop','','scoop@thissite.org','scoop@thissite.org','scoop@thissite.org','http://www.kuro5hin.org/','MioQ79w6.4o','thread','plaintext','','',0,1,0,0,0,NULL,0,'',NULL,'Superuser',NULL,'','','0000-00-00 00:00:00',NULL,NULL);
INSERT INTO users VALUES (-1,'Anonymous Hero','','','','','','','','','','',0,0,0,0,0,NULL,0,'',NULL,'Anonymous',NULL,NULL,'','0000-00-00 00:00:00',NULL,NULL);

--
-- Table structure for table 'vars'
--

CREATE TABLE vars (
  name varchar(32) NOT NULL default '',
  value varchar(127) default NULL,
  description text,
  type varchar(5) NOT NULL default 'text',
  category varchar(128) NOT NULL default '',
  PRIMARY KEY  (name)
);

--
-- Dumping data for table 'vars'
--


INSERT INTO vars VALUES ('max_edit_stories','1','How many stories allowed in the edit queue at one time?','num','Stories');
INSERT INTO vars VALUES ('queue_edit_max_time','2h','How long can a story remain in editing mode before it gets forced into the moderation queue?','text','General');
INSERT INTO vars VALUES ('rootdir','','The url path to scoop, inserted before all system urls, mostly used only in location installs.','text','General');
INSERT INTO vars VALUES ('imagedir','/images','where do we put the images?  This is what comes after the rootdir in the url of your site','text','General');
INSERT INTO vars VALUES ('slogan','Collaborative Media for the Masses','gotta have a slogan.','text','General');
INSERT INTO vars VALUES ('sitename','Scoop','The name of your site to display in the browser title','text','General');
INSERT INTO vars VALUES ('default_comment_view','mixed','Default View: \'mixed\', \'topical\', \'editorial\', \'all\'.  If none set, it uses mixed.  Which actually is just like all topical.','text','Comments');
INSERT INTO vars VALUES ('maxstories','8','Default maximum number of story summaries for main page, can be overridden in the users\' Display Preferences.','num','Stories');
INSERT INTO vars VALUES ('maxtitles','10','Default maximum number of older stuff titles, again can be overridden in the User Preferences menu','num','Stories');
INSERT INTO vars VALUES ('local_email','scoop@thissite.com','scoop local mail, for automailer. Needs to work!  If this is not valid, noone will be able to create new accounts.','text','General');
INSERT INTO vars VALUES ('norm_font_end','</FONT>','the font end tag from norm_font, will be moved to a block soon.','text','Fonts');
INSERT INTO vars VALUES ('box_title_font','<FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=2 COLOR=\"#FFFFFF\"><B>','font tag for box titles.  Will be moved to a block soon.','text','Fonts');
INSERT INTO vars VALUES ('title_font_end','</B></FONT>','end font tag for story titles.  will be changed to a block soon','text','Fonts');
INSERT INTO vars VALUES ('topics','/topics','This is what goes after the imagedir var to get to the directory of topic images. really.  it is.','text','General');
INSERT INTO vars VALUES ('norm_font_face','verdana, arial, helvetica, sans-serif','the font face for normal text. Used in user prefs','text','Fonts');
INSERT INTO vars VALUES ('default_comment_display','thread','This is the default comment display mode.  It can be either: \'nested\', \'flat\', \'minimal\',  or \'thread\'.   If none of those is set, it just uses thread','text','Comments');
INSERT INTO vars VALUES ('storylist','30','This is how many stories will be displayed at once in the Story List admin tool','num','Stories');
INSERT INTO vars VALUES ('title_font','<FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=3><B>','font tag for story titles.  Will be changed to a block soon.','text','Fonts');
INSERT INTO vars VALUES ('box_title_font_end','</B></FONT>','end font tag for box titles.  Will be moved to a block soon','text','Fonts');
INSERT INTO vars VALUES ('norm_font_size','2','\'the font size for normal text. Used in user prefs','text','Fonts');
INSERT INTO vars VALUES ('default_comment_order','oldest','Default comment ordering: \'oldest\' or \'newest\', If none set, it uses newest.','text','Comments');
INSERT INTO vars VALUES ('post_story_threshold','4','This is the total score a story must have to be posted automatically. If it\'s a percent (i.e. 5%) it\'ll be the score that is 5% of the total users of the site.   So if you have 1000 users, it will be 50.','num','Stories');
INSERT INTO vars VALUES ('hide_story_threshold','-2','The number of minus votes before a story is hidden from users in the mod list. Can be a percentage of registered users, or a hard coded number.  If its a percentage it doesn\'t need to be a negative percentage.','num','Stories');
INSERT INTO vars VALUES ('show_dept','0','Set to 1 to show the department text in stories.  (i.e. from the i-love-scoop dept.)','bool','Stories');
INSERT INTO vars VALUES ('rating_min','1','Minimum comment rating value, if you are using mojo, trusted users can rate people 1 less than this, to hide comments.','num','Comments');
INSERT INTO vars VALUES ('rating_max','5','This is the maximum comment rating value, the highest score you can rate a comment.','num','Comments');
INSERT INTO vars VALUES ('time_zone','EST','The time zone your server lives in, to be used as the default for users','text','General');
INSERT INTO vars VALUES ('current_poll','967438565_opsmxIVg','The pid of the current front page poll. DO NOT edit manually unless you want to break the current poll!  It can be fixed by changing the poll via the List Poll menu though. It\'s here for programming convenience.','text','Polls');
INSERT INTO vars VALUES ('poll_img','pollbar.gif','Image to use for the poll display.  This is what makes the poll bar.  Doesn\'t look too good if it has too much detail, better to keep with a solid color.','text','Polls');
INSERT INTO vars VALUES ('story_count_words','1','1 == display word count on main page, 0 == display byte count','bool','Stories');
INSERT INTO vars VALUES ('poll_num_ans','10','Maximum number of answer fields for when creating polls.','num','Polls');
INSERT INTO vars VALUES ('default_comment_sort','highest','default rating sort: \'unrate_highest\', \'highest\', \'lowest\', \'dontcare\'.  if none set, it uses dontcare, which ignores the ratings','text','Comments');
INSERT INTO vars VALUES ('max_comments_submit','4','max # of comments to allow anyone to post in time period rate_limit_minutes before locking them out from posting for a little while.','num','Comments,Post Throttle');
INSERT INTO vars VALUES ('max_stories_submit','2','max # of stories to allow anyone to post in time period rate_limit_minutes before locking them out for a short time.','num','Stories,Post Throttle');
INSERT INTO vars VALUES ('rate_limit_minutes','10','time period to do rate limiting on.  If they post more comments than max_comments_submit or more stories than max_stories_submit in this time they get locked out for timeout_minutes minutes.','num','Post Throttle');
INSERT INTO vars VALUES ('timeout_minutes','2','when a user posts more comments or stories than max_post_comments/stories in time period rate_limit_minutes, they are locked out for timeout_minutes.  It is doubled everytime they try to post again without timeout up.','num','Post Throttle');
INSERT INTO vars VALUES ('max_timeout','300','Max minutes of earned timeout until users are locked out for good. Every time a user tries to post again when they have hit the posting limit it doubles the amount of time they have to wait to post again. If they hit this number, they lose posting ability','num','Post Throttle');
INSERT INTO vars VALUES ('template_recurse','5','The number of times the template system should loop, looking for keys.  Set too high and you will slow down your server, too low and it might not substitute all the vars/blocks it needs to.  5 is a good value :)','num','General');
INSERT INTO vars VALUES ('use_mojo','1','If this is 1 then the mojo system for determining user trust will be used.  A good description of it is here: http://www.kuro5hin.org/?op=special;page=','bool','Comments');
INSERT INTO vars VALUES ('use_topics','1','If this is 1 then there will be topic icons beside every story.  Users can turn topic icons off if they want in their Display Preferences','bool','Stories');
INSERT INTO vars VALUES ('use_ref_check','0','If this is 1 it causes scoop to check your referrer before you can get to any admin menu\'s or user menu\'s, to make sure you are coming from the current site.','bool','Security');
INSERT INTO vars VALUES ('default_post_type','html','text or html, This is the default post type for users when submitting a comment.','text','Comments');
INSERT INTO vars VALUES ('norm_font','<FONT FACE=\"verdana, arial, helvetica, sans-serif\" SIZE=2>','The fornt to use for normal text, will be moved to a block soon.','text','Fonts');
INSERT INTO vars VALUES ('enable_story_digests','0','1 to be able to email digests, 0 otherwise.  If this is 1 users get a select box in their User Preferences page where they can select whether to recieve story digests from your site.  If this is 1, Don\'t forget to enable the Digest.pl cron.','bool','Stories');
INSERT INTO vars VALUES ('auto_post_alert','1','When this is 1 local_email gets mailed everytime a story is auto_posted.','bool','Stories');
INSERT INTO vars VALUES ('use_auto_post','0','If this is 1 stories will be automatically posted given a metric of the avg. scores of the comments to that story + their current score','bool','Stories');
INSERT INTO vars VALUES ('auto_post_frontpage','4','This is the value needed for a story to be automatically posted to the front page.  This is not sum of moderation to the story, but an average.  See use_auto_post for more description.','num','Stories');
INSERT INTO vars VALUES ('auto_post_section','3.25','This is the value needed for a story to be automatically posted to its section page.  See use_auto_post for more description.','num','Stories');
INSERT INTO vars VALUES ('allow_ballot_stuffing','0','If this var is 1, allow editors to set how many votes a poll answer has recieved when creating or editing the poll.  Users can never set how many votes.','bool','Polls');
INSERT INTO vars VALUES ('max_intro_words','0','This is the maximum number of words allowed in the introtext of an article.  Set to 0 to disable.  If they try to post a story with more than this number of words in the intro, it doesn\'t let them, and tells them to get it under this number.','num','Stories');
INSERT INTO vars VALUES ('max_intro_chars','0','This is the maximum number of characters allowed in the introtext of an article.  Set to 0 to disable.  If they try to post a story with more than this number of characters in the intro, it doesn\'t let them, and tells them to keep it under this number.','num','Stories');
INSERT INTO vars VALUES ('use_db_cache','0','Cache DB queries? DO NOT USE ME!!!! I AM VERY DANGEROUS AND BROKEN!!','bool','General');
INSERT INTO vars VALUES ('db_cache_max','1M','Maximum size for DB query cache. DO NOT USE ME!!!! I AM VERY DANGEROUS AND BROKEN!!','text','General');
INSERT INTO vars VALUES ('site_url','http://www.mysite.com/','Enter the base url for your site above, excluding rootdir!','text','General');
INSERT INTO vars VALUES ('max_rdf_intro','15','This is the maximum number of words allowed in the rdf intro description.  Everything over this will be cut off (not deleted, just not shown), and replaced by a \'...\'','num','RDF');
INSERT INTO vars VALUES ('use_diaries','1','If this is 0 nobody will be able to post diaries, or view a users\' diary.','bool','Stories');
INSERT INTO vars VALUES ('rdf_use_images','1','If set to\r\n1, then RDF images will be displayed. Otherwise, they won\'t','bool','RDF');
INSERT INTO vars VALUES ('rdf_use_forms','1','If set to\r\n1, then RDF textinputs will be displayed. Otherwise, they won\'t','bool','RDF');
INSERT INTO vars VALUES ('use_rdf_feeds','1','If set to 1, then RDF feeds are availible. Otherwise, they aren\'t','bool','RDF');
INSERT INTO vars VALUES ('default_sig_behavior','regular','\'regular\' (new sigs apply to old comments) or \'sticky\' (persistant sigs that become part of the comment)','text','Comments');
INSERT INTO vars VALUES ('allow_sig_behavior','1','Set to 0 to disable users choosing between having a sticky sig (one that doesn\'t change on that comment when they change their sig) or regular sig (retroactive sig changes).  Warning: Depending on your placement of comment vs. sig in the comment block, sticky_sig/no_sig may not render correctly','bool','Comments');
INSERT INTO vars VALUES ('show_new_comments','all','Controls the saving of story view times and displaying of new comments. Possible values are all, hotlist, or never.','text','Comments,Stories');
INSERT INTO vars VALUES ('allow_admin_notes','1','If set to 1, this creates a small field in the User Preferences page that only people with edit_user permissions can see.  This is so that admins may share information on problem users, or on changes made to accounts.','bool','Security,General');
INSERT INTO vars VALUES ('allow_rdf_fetch','1','If on, then fetches can be done from the admin interface, otherwise they can\'t. Turn this on unless you have a problem with adding or refetching feeds, in which case Apache probably needs to be recompiled. This var is a hack to prevent admins from messing up the server when recompiling isn\'t an option.','bool','RDF');
INSERT INTO vars VALUES ('rdf_http_proxy','','If set, then the proxy to use when fetching RDF\'s. Otherwise, disables proxy use. Should be in the form http://host:port/','text','RDF');
INSERT INTO vars VALUES ('rdf_max_headlines','15','Default max number of titles to display for each RDF channel.','num','RDF');
INSERT INTO vars VALUES ('rdf_max_stories','7','The maximum number of stories to include in the RDF file','num','RDF');
INSERT INTO vars VALUES ('rdf_file','/www/scoop/html/backend.rdf','The file to save the site\'s RDF file to. Must be writeable by web server.','text','RDF');
INSERT INTO vars VALUES ('rdf_image','http://myscoopsite.com/images/logo.jpg','The full URL of an image, to put with the RDF file','text','RDF');
INSERT INTO vars VALUES ('rdf_days_to_show','30','How many days worth of stories to include in the RDF file','num','RDF');
INSERT INTO vars VALUES ('rdf_copyright','Copyright 2000 - My Site','A short copyright notice to include in the RDF file.','text','RDF');
INSERT INTO vars VALUES ('digest_subject','My Site Digest','The subject of the digest e-mail that gets sent.','text','Stories,Cron');
INSERT INTO vars VALUES ('keep_sessions_for','21 day','How long to keep unused sessions around before getting rid of them (in format \"time unit\")','text','Cron');
INSERT INTO vars VALUES ('mojo_max_comments','30','How many comments count toward mojo?','num','Comments');
INSERT INTO vars VALUES ('notify_author','1','If this is on, an email will be sent to the author on a story post or drop. For now, really busy sites (>=100,000 hits a day) should have this off.','bool','Stories');
INSERT INTO vars VALUES ('mojo_max_days','60','How many days, max, count toward mojo?','num','Comments');
INSERT INTO vars VALUES ('mojo_min_trusted','10','How many comments must a user have to be trusted?','num','Comments');
INSERT INTO vars VALUES ('mojo_rating_trusted','3.5','What mojo makes you a candidate for trusted?','num','Comments');
INSERT INTO vars VALUES ('mojo_min_untrusted','3.5','How many comments does a user have to be untrusted?','num','Comments');
INSERT INTO vars VALUES ('use_subscriptions','0','Toggle whether to enable the subscription system or not','bool','General');
INSERT INTO vars VALUES ('max_accounts_per_day','2','Set this value to the maximum number of accounts that you want people to be able to create per ip per day, 2 is a good value generally.','num','Security');
INSERT INTO vars VALUES ('confirms_valid_for','120','Length of time, in minutes, that confirm strings for new passwords should remain valid.','num','General');
INSERT INTO vars VALUES ('use_static_pages','0','Toggle whether to enable filesystem static pages for performance','bool','Static Pages');
INSERT INTO vars VALUES ('page_path','/www/scoop/cache','Full path to root of cache directory. Must be readable/writeable by apache user!','text','Static Pages');
INSERT INTO vars VALUES ('wrap_long_lines','1','If true, then long lines will be split so that they don\'t mess with formatting. See also wrap_long_lines_at.','bool','Security');
INSERT INTO vars VALUES ('wrap_long_lines_at','100','How many characters to split long lines at. After this many, a newline will be inserted. See also wrap_long_lines.','num','Security');
INSERT INTO vars VALUES ('wrap_pre','1','If true, then lines in PRE sections will be word-wrapped. Only useful if\nyou\'ve allowed the PRE tag. See also wrap_pre_at.','bool','Security');
INSERT INTO vars VALUES ('wrap_pre_at','100','How many character to word wrap PRE data at. After this many, a newline will be inserted. See also wrap_pre.','num','Security');
INSERT INTO vars VALUES ('spellcheck_enabled','0','Controls if comments, stories, etc. can be spellchecked. This requires the Pspell module to be installed.','bool','Spellchecker');
INSERT INTO vars VALUES ('spellcheck_default','0','Should text be spellchecked by default (this can be toggled off individually).','bool','Spellchecker');
INSERT INTO vars VALUES ('spellcheck_spelling','american','Which spelling variant should be the default when spell checking? (can be american, canadian, or british)','text','Spellchecker');
INSERT INTO vars VALUES ('advertiser_group','Advertisers','This is the group that all new advertising accounts will get assigned to.  DO NOT CHANGE THIS AFTER SOME AD ACCOUNTS HAVE BEEN CREATED.  You will cause problems, unforseen ones, and probably the old accounts will cease\r\nto be even User level accounts.  NOTE:  not working yet either.  Doesn\'t matter what this is.','text','Advertising');
INSERT INTO vars VALUES ('use_ads',NULL,'If 1, then your site will allow submission of ads.  Be sure to read the Enabling Ads section of the Scoop Administrators Guide before enabling these.  DO NOT ENABLE ADS!! This is in development.  Though it *shouldn\'t crash your machine, combust small pets, etc.  It could...  So DO NOT ENABLE on a site you are not using for pure development purposes.','bool','Advertising');
INSERT INTO vars VALUES ('ad_server_url','http://ads.myscoopsite.com','This is the url of your ad server.  I would reccomend putting the ads on a subdomain of your site, for easy logging and parsing by scripts.','text','Advertising');
INSERT INTO vars VALUES ('ad_files_base','/www/scoop/html/images/ads','This is the base directory for storing of all ads when uploaded. Make sure that this directory is readable and writeable by the user apache runs as.','text','Advertising');
INSERT INTO vars VALUES ('rating_wipe_group','','Group to change users to if their ratings are undone by an admin','text','Security');
INSERT INTO vars VALUES ('sendmail_program','/usr/sbin/sendmail','This is the path to your sendmail program.  This only matters if you set your SMTP setting in httpd.conf to \'-\', in which case this program will be used to send all site mail.','text','General');
INSERT INTO vars VALUES ('paranoid_logging','0','If this var is turned on, a log of every request that comes to scoop will be kept in the error log, including time, date, IP of client, username, and all form parameters passed in.','bool','Security');
INSERT INTO vars VALUES ('req_extra_advertiser_info','0','If this is on, then to submit an ad you have to fill out the advertiser information form.  NOTE: Leave this off for now, its being put to the back burner until we get a working implementation of text ads, which don\'t require this.','bool','Advertising');
INSERT INTO vars VALUES ('time_24h_format','0','Select this to use 24-hour time output instead of AM/PM.','bool','General');
INSERT INTO vars VALUES ('use_fulltext_indexes',NULL,'Set to true if your DB is capable of using FULLTEXT indexes and you have created the proper indexes','bool','General');
INSERT INTO vars VALUES ('formkey_timeout','21600','Number of seconds before a formkey becomes invalid (default is the same as 6 hours).','num','Comments,Stories');
INSERT INTO vars VALUES ('log_ip_for_ads','0','If this is on it logs the ip of each ad view or clickthrough in the ad_logs table','bool','Advertising');
INSERT INTO vars VALUES ('mail_ad_reminders','1','If turned on then Scoop will mail reminders to advertisers when their ad has \'mail_ad_reminder_on\' impressions left.','bool','Advertising');
INSERT INTO vars VALUES ('mail_ad_reminder_on','100','If \'mail_ad_reminders\' is on, then when there are this many impressions left Scoop will send a reminder to the advertiser about their ad.','num','Advertising');
INSERT INTO vars VALUES ('mail_ad_finished_reminder','1','If turned on then Scoop will mail the advertisers letting them know when their ad has finished its campaign.','bool','Advertising');
INSERT INTO vars VALUES ('activate_upon_approve','1','If you are not getting payments via CC or paypal or whatever, set this to 1.  That way, when you activate an ad, it will automatically get in the rotation, instead of waiting for the ad_cron script to activate it.','bool','Advertising');
INSERT INTO vars VALUES ('default_box_template','box','This is the default template that boxes will use if they don\'t have a box template defined.','text','General');
INSERT INTO vars VALUES ('min_ad_prepay_amount','12.00','This is the minimum amount of money that scoop will let people prepay','text','Advertising');
INSERT INTO vars VALUES ('auto_post_floor','0','The minimum score to consider for auto-posting stories. If the story\'s score is lower than this, it will not trigger the auto-poster; it will just be dropped.','num','Stories');
INSERT INTO vars VALUES ('auto_post_min_ratings','0','The minimum number of comment ratings to assume for auto-posting. If there are fewer rating points than this, this number will be used instead. AKA the boring story penalty.','num','Stories');
INSERT INTO vars VALUES ('auto_post_use_time','0','Set if you want to define a maximum time for a story in the queue, instead of a max number of votes (which is the default). See also auto_post_max_minutes to set the actual value','bool','Stories');
INSERT INTO vars VALUES ('auto_post_max_minutes','2160','Number of minutes to leave a story in voting before making a decision, if thresholds aren\'t reached. See also auto_post_use_time to turn this on or off.','num','Stories');
INSERT INTO vars VALUES ('ad_story_section','advertisements','This is the section that all ad stories will go into if you set use_ad_discussions to 1.  Not a good idea to change this after you\'ve already got some ads in this section.','text','Advertising');
INSERT INTO vars VALUES ('ads_judge_unpaid','1','Turn this off if you only want to see ads on the judge submissions page after they\'ve been paid for.','bool','Advertising');
INSERT INTO vars VALUES ('ad_story_topic','ads','This is the topic that all ad stories will use if you set use_ad_discussions to 1.  Not a good idea to change this after you\'ve already got some ads in this topic.','text','Advertising');
INSERT INTO vars VALUES ('comment_ip_log','0','If this var is set to 1, then the IP that a comment was posted from will be logged in the db. Hopefully it will be able to be used to identify possible problematic multiple account holders.','bool','Comments');
INSERT INTO vars VALUES ('view_ip_log','0','If this var is set to 1 and comment_ip_log is on, then admins and superusers can see the IP a comment was posted from.','bool','Comments');
INSERT INTO vars VALUES ('charset','ISO-8859-1','This is the charater set passed within the Content-Type Header. \'ISO-8859-1\' is the default and will be used unless this variable is defined to be some other character set','text','General');
INSERT INTO vars VALUES ('no_cache','0','Set to 1 if you want scoop to send cache-prevention headers','bool','General');
INSERT INTO vars VALUES ('enable_subsections','1','Enable or Disable the subsections feature. The feature adds no user runtime queries but adds some optimied iterative processing of cached data.','bool','General');
INSERT INTO vars VALUES ('mojo_ignore_diaries','0','If set, mojo calc will ignore ratings of comments posted in Diaries','bool','Comments');
INSERT INTO vars VALUES ('allow_ad_renewal','1','If this is on people can renew the impressions left in their ads via /renew, and a link from their ad listing page.','bool','Advertising');
INSERT INTO vars VALUES ('allow_dynamic_comment_mode','0','Turn this on to allow users to set the \"Dynamic\" comment threading mode (which requires Javascript and at least a 5.x-generation browser)','bool','Comments');
INSERT INTO vars VALUES ('secure_site_url','https://scoop.mysite.org/','If you have a secure URL, enter it above. Should probably be the same as \'site_url\', but with https://','text','General');
INSERT INTO vars VALUES ('default_theme','default','Sets the name of the default theme, used as a base for all new themes','text','Themes');
INSERT INTO vars VALUES ('use_themes','0','Should we use themes at all','bool','Themes');
INSERT INTO vars VALUES ('default_textarea_cols','50','Number of columns displayed in the comment and story textareas by default','num','Stories, Comments');
INSERT INTO vars VALUES ('default_textarea_rows','15','Number of rows displayed in the comment and story textareas by default','num','Stories, Comments');
INSERT INTO vars VALUES ('spam_votes_percentage','0.25','Percentage of spam votes required to forced a story into the normal moderation queue','num','Stories, Comments');
INSERT INTO vars VALUES ('spam_votes_threshold','100','Number of spam votes required before the % calculation can take place.','num','Stories, Comments');
INSERT INTO vars VALUES ('logout_url','','This is the URL users will be redirected to when they logout. The default is to use rootdir.','text','General');
INSERT INTO vars VALUES ('use_anti_spam','1','If enabled, articles in the edit queue will have a button which a user can use to mark an article as spam. If enough spam votes are cast, it is moved into the voting queue.','bool','Stories');
INSERT INTO vars VALUES ('default_uid',NULL,'If set, new accounts will have their preferences copied over from this UID upon confirmation.','num','General');
INSERT INTO vars VALUES ('default_commentstatus','0','Default commentstatus when creating a new story. Possible values are 0 for Enabled, -1 for Disabled, and 1 for Read-Only.','num','Stories, Comments');

--
-- Table structure for table 'viewed_stories'
--

CREATE TABLE viewed_stories (
  uid int(11) NOT NULL default '0',
  sid varchar(20) NOT NULL default '',
  lastseen int(11) NOT NULL default '0',
  highest_idx int(11) NOT NULL default '0',
  hotlisted tinyint(4) NOT NULL default '0',
  PRIMARY KEY  (uid,sid),
  KEY hotlist_idx (uid,hotlisted)
);

--
-- Dumping data for table 'viewed_stories'
--



