INSERT INTO vars (name, value, description, type, category) VALUES ('use_anti_spam', '1', 'If enabled, articles in the edit queue will have a button which a user can use to mark an article as spam. If enough spam votes are cast, it is moved into the voting queue.', 'bool', 'Stories');

UPDATE box SET content = '#main sub\r\n\r\n# Get the expire time\r\nmy $expire = $S->{UI}->{VARS}->{queue_edit_max_time};\r\nmy $factors = {\r\n	d => \'86400\',\r\n	h => \'3600\',\r\n	m => \'60\',\r\n	s => \'1\'\r\n};\r\n$expire =~ s/([^\\d])$//;\r\nmy $time_sub = $expire * $factors->{$1};\r\n\r\nmy $select = {\r\n	DEBUG => 0,\r\n	WHAT => "sid, score, time, displaystatus",\r\n	FROM => \'stories\',\r\n	WHERE => "displaystatus = -3 AND UNIX_TIMESTAMP(NOW()) - UNIX_TIMESTAMP(time) >= $time_sub",\r\n	ORDER_BY => \'time DESC\'\r\n};\r\n\r\nmy ($rv, $sth) = $S->db_select($select);\r\n\r\nmy $sid_move_to_moderate;\r\nwhile (my $story = $sth->fetchrow_hashref()) {\r\n	# only move if the time has expired\r\n	$sid_move_to_moderate = $story->{sid};\r\n	$S->move_story_to_voting($story->{sid});\r\n}\r\n\r\n$sth->finish();\r\n\r\nreturn 1;\r\n' WHERE boxid = 'cron_edit_queue';
