/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdlib.h>
#include <gtk/gtk.h>
#include <gtkextra/gtkextra.h>
#include "sg_planes_dialog.h"
#include "sg_dialogs.h"
#include "sg.h"

static GtkWidget *xy_color_combo; 
static GtkWidget *yz_color_combo; 
static GtkWidget *zx_color_combo; 
static GtkWidget *xy_check; 
static GtkWidget *yz_check; 
static GtkWidget *zx_check; 
static GtkWidget *corner_check; 
static GtkWidget *corner_color_combo; 
static GtkWidget *thick_spin; 
static GtkWidget *style_combo; 
static SGlayer *layer;

void
sg_planes_dialog_update_plot(GtkWidget *widget)
{
  GtkPlot3D *plot;
  SGplot *parent;
  GtkPlotCanvas *canvas;
  GtkColorCombo *combo;
  GtkWidget *child;
  GdkColor color;
  gchar *color_name;
  gint page_size, units;
  gint orientation;

  plot = GTK_PLOT3D(layer->real_plot);

  combo = GTK_COLOR_COMBO(xy_color_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &color);
  gdk_color_alloc(xy_color_combo->style->colormap, &color);
  plot->color_xy = color;

  combo = GTK_COLOR_COMBO(yz_color_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &color);
  gdk_color_alloc(yz_color_combo->style->colormap, &color);
  plot->color_yz = color;

  combo = GTK_COLOR_COMBO(zx_color_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &color);
  gdk_color_alloc(zx_color_combo->style->colormap, &color);
  plot->color_zx = color;

  plot->xy_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(xy_check));
  plot->yz_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(yz_check));
  plot->zx_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(zx_check));

  plot->corner_visible = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(corner_check));

  combo = GTK_COLOR_COMBO(corner_color_combo);
  color_name = gtk_color_combo_get_color_at(combo, combo->row, combo->column);
  gdk_color_parse(color_name, &color);
  gdk_color_alloc(zx_color_combo->style->colormap, &color);
  plot->corner.color = color;

  child = (GtkWidget *)GTK_LIST(GTK_COMBO(style_combo)->list)->selection->data;
  plot->corner.line_style = (GtkPlotLineStyle)gtk_list_child_position(GTK_LIST(GTK_COMBO(style_combo)->list), child);

  combo = GTK_COLOR_COMBO(zx_color_combo);
  plot->corner.line_width = gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(thick_spin));

  parent = (SGplot *)layer->parent;
  canvas = GTK_PLOT_CANVAS(parent->real_canvas);
  gtk_plot_canvas_paint(canvas);
  gtk_plot_canvas_refresh(canvas);
}

static void
init_dialog()
{
  GtkPlot3D *plot;

  plot = GTK_PLOT3D(layer->real_plot);

  sg_color_combo_init(GTK_COLOR_COMBO(xy_color_combo), plot->color_xy);
  sg_color_combo_init(GTK_COLOR_COMBO(yz_color_combo), plot->color_yz);
  sg_color_combo_init(GTK_COLOR_COMBO(zx_color_combo), plot->color_zx);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(xy_check), plot->xy_visible);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(yz_check), plot->yz_visible);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(zx_check), plot->zx_visible);

  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(corner_check), plot->corner_visible);
  sg_color_combo_init(GTK_COLOR_COMBO(corner_color_combo), plot->corner.color);
  gtk_list_select_item(GTK_LIST(GTK_COMBO(style_combo)->list), plot->corner.line_style);

  gtk_spin_button_set_value(GTK_SPIN_BUTTON(thick_spin), plot->corner.line_width);

}

GtkWidget *
sg_planes_dialog_new (SGlayer *the_layer)
{
  GtkWidget *frame;
  GtkWidget *main_table;
  GtkWidget *table;
  GtkWidget *label;
  GtkAdjustment *adj;
  GtkRequisition req;

  layer = the_layer;

  /* Create widgets */
  main_table = gtk_table_new (2, 2, FALSE);
  gtk_container_set_border_width(GTK_CONTAINER(main_table), 10);
  gtk_table_set_col_spacings(GTK_TABLE(main_table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(main_table), 5);

  /* Poperties */

  frame = gtk_frame_new("Planes");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 0, 2, 0, 1);

  table=gtk_table_new(3, 2, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  xy_check = gtk_check_item_new_with_label("XY visible");
  yz_check = gtk_check_item_new_with_label("YZ visible");
  zx_check = gtk_check_item_new_with_label("ZX visible");
  gtk_table_attach_defaults(GTK_TABLE(table), xy_check, 0, 1, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), yz_check, 0, 1, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), zx_check, 0, 1, 2, 3);

  xy_color_combo = gtk_color_combo_new();
  yz_color_combo = gtk_color_combo_new();
  zx_color_combo = gtk_color_combo_new();

  gtk_table_attach_defaults(GTK_TABLE(table), xy_color_combo, 1, 2, 0, 1);
  gtk_table_attach_defaults(GTK_TABLE(table), yz_color_combo, 1, 2, 1, 2);
  gtk_table_attach_defaults(GTK_TABLE(table), zx_color_combo, 1, 2, 2, 3);

  frame = gtk_frame_new("Oposite corner");
  gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_ETCHED_IN);
  gtk_table_attach_defaults(GTK_TABLE(main_table), frame, 0, 2, 1, 2);

  table = gtk_table_new(4, 2, FALSE);  
  gtk_container_set_border_width(GTK_CONTAINER(table), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table), 5);
  gtk_table_set_row_spacings(GTK_TABLE(table), 5);
  gtk_container_add(GTK_CONTAINER(frame), table);

  corner_check = gtk_check_item_new_with_label("visible");
  gtk_table_attach_defaults(GTK_TABLE(table), corner_check, 0, 1, 0, 1);
 
  label = gtk_label_new("Color ");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
  corner_color_combo = gtk_color_combo_new();
  gtk_table_attach_defaults(GTK_TABLE(table), corner_color_combo, 1, 2, 1, 2);

 
  label = gtk_label_new("Thickness ");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 2, 3);

  adj = (GtkAdjustment *)gtk_adjustment_new(0., 0., 6., 1., 1., 0.);
  thick_spin = gtk_spin_button_new(adj, 0, 0);
  gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(thick_spin), TRUE);
  gtk_table_attach_defaults(GTK_TABLE(table), thick_spin, 1, 2, 2, 3);

  label = gtk_label_new("Style ");
  gtk_misc_set_alignment(GTK_MISC(label), 1., 0.5);
  gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 3, 4);
  style_combo = gtk_combo_new();
  sg_combo_set_items(GTK_COMBO(style_combo), line_styles);
  gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(style_combo)->entry), FALSE);
  gtk_table_attach_defaults(GTK_TABLE(table), style_combo, 1, 2, 3, 4);


  /* connect signals */
  init_dialog();
  init_dialog();
  return main_table;
}
