/*  SciGraphica - Scientific graphics and data manipulation
 *  Copyright (C) 2001 Adrian E. Feiguin <feiguin@ifir.edu.ar>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __SG_H__
#define __SG_H__

#ifdef WITH_GNOME
#include <gnome.h>
#endif

#include <gtkextra/gtkextra.h>

#include "config.h"
#include "sg_config.h" 

#include "sg_project.h"
#include "sg_project_autosave.h"
#include "sg_project_file_xml.h"
#include "sg_project_file_sax.h"
#include "sg_project_rescue.h"

#include "sg_worksheet.h"
#include "sg_worksheet_file.h"
#include "sg_worksheet_file_ascii.h"
#include "sg_worksheet_file_html.h"
#include "sg_worksheet_file_tex.h"
#include "sg_worksheet_file_xml.h"
#include "sg_worksheet_tools.h"

#include "sg_plot.h"
#include "sg_plot_file.h"
#include "sg_plot_file_xml.h"
#include "sg_plot_tools.h"

#include "sg_layer.h"
#include "sg_layer_control.h"

#include "sg_clipboard.h"
#include "sg_dataset.h"
#include "sg_entry.h"
#include "sg_file.h"
#include "sg_import_dialog.h"
#include "sg_matrix_convert.h"
#include "sg_misc.h"
#include "sg_plugin.h"
#include "sg_stock.h"
#include "sg_toggle_combos.h"
#include "sg_toolbox.h"

#define NUM_SYMBOLS 10
#define NUM_SYMBOL_STYLES 3
#define NUM_LINE_STYLES 7
#define NUM_CONNECTORS 6

extern GtkIconListItem *active_icon;
extern SGworksheet *active_worksheet;
extern SGplot *active_plot;
extern SGlayer *active_layer;
extern SGdataset *active_dataset;

extern gboolean rename_columns;
extern gboolean rename_worksheets;
extern gboolean rename_plots;
extern gboolean precision_mod;

extern GdkPixmap *icon_pixmap;
extern GdkPixmap *icon_mask;

extern GtkWidget *matrix_menu;
extern GtkWidget *plot_menu;
extern GtkWidget *worksheet_menu;

extern GtkWidget *main_window;
extern GtkWidget *gui_notebook;

extern GtkWidget *iconlist1;
extern GtkWidget *iconlist2;

extern GtkWidget *worksheet_menu;
extern GtkWidget *matrix_menu;
extern GtkWidget *plot_menu;

extern gchar *last_worksheet_path;
extern gchar *last_worksheet_filename;
extern gchar *last_plot_path;
extern gchar *last_plot_filename;
extern gchar *last_project_path;
extern gchar *last_project_filename;

extern gboolean project_changed;
extern gboolean project_name_changed;
extern gboolean plot_name_changed;
extern gboolean worksheet_name_changed;

extern gboolean gui_iconlist;
extern gboolean gui_worksheet;
extern gboolean gui_plot;

extern gchar comment_string[];
extern gchar block_start[];
extern gchar custom_delimiter[];
      
extern gint begin_line;
extern gint end_line;
extern gint blocknum;
extern gint read_method;
extern gboolean read_all_lines;
extern gboolean use_custom_delimiter;

extern gint sg_show_plot_toolbar;
extern gint sg_show_plot_menubar;

extern gint sg_canvas_label_pos;
extern gint sg_canvas_label_width;
extern gint sg_units;

extern gint sg_autoscale_left;
extern gint sg_autoscale_right;
extern gint sg_autoscale_top;
extern gint sg_autoscale_bottom;

void main_quit (GtkWidget *widget);

#endif /* __SG_H__ */
