
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer
//          Malolan Chetlur    
//          Krishnan Subramani 
//          Narayanan Thondugulam
//          Radharamanan Radhakrishnan

#include "IIRScram_LibraryUnitList.hh"
#include "IIR_LibraryUnit.hh"

IIRScram_LibraryUnitList::~IIRScram_LibraryUnitList() {}

void 
IIRScram_LibraryUnitList::_publish_vhdl_in_design_library(){
  IIR_LibraryUnit *lib_unit = first();
  while (lib_unit != NULL) {
    ASSERT(lib_unit->_get_declarator() != NULL);
    ostream *file_handle = library_manager::instance()->get_file_handle( lib_unit );
    ASSERT( file_handle != 0 );
    lib_unit->_publish_vhdl_decl( *file_handle );
    file_handle->flush();
    delete file_handle;

    lib_unit = successor(lib_unit);
  }
}

void 
IIRScram_LibraryUnitList::_publish_vhdl(ostream &_vhdl_out) {
  IIR_LibraryUnit *lib_unit = first();

  while (lib_unit != NULL) {
    lib_unit->_publish_vhdl_decl(_vhdl_out);
    lib_unit = successor(lib_unit);
  }
}

void 
IIRScram_LibraryUnitList::_publish_cc( ){
  IIR_LibraryUnit *lib_unit = first();

  while (lib_unit != NULL) {
    lib_unit->_publish_cc( );
    lib_unit = successor(lib_unit);
  }
}

void
IIRScram_LibraryUnitList::_publish_cc_elaborate(){
  IIR_LibraryUnit *unit = first();

  while (unit != NULL) {
    unit->_publish_cc_elaborate();
    unit = successor(unit);
  }  
}

visitor_return_type *IIRScram_LibraryUnitList::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_LibraryUnitList(this, arg);
};
