#ifndef IIRSCRAM_LABEL_HH
#define IIRSCRAM_LABEL_HH

// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ececs.uc.edu

//---------------------------------------------------------------------------
class IIR_List;

#include "IIRBase_Label.hh"

class IIRScram_Label : public IIRBase_Label {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl(ostream &);
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_elaborate( ostream &_cc_out );
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_binding_name( ostream& outstream );
  void _publish_cc_include( published_file &_cc_out );

  declaration_type _get_type();

  IIR_TypeDefinition *get_subtype(){ return NULL; }

  set<IIR_Declaration> *_find_declarations( IIR_Name * );

  void _make_interface_visible( symbol_table * );

  IIR_List *_get_statement_list();

  IIR *_clone();

  IIR_Boolean _is_iir_label(){ return TRUE; }

  IIR_Boolean _is_block_statement();
  IIR_Boolean _is_concurrent_generate_statement();

  IIR_AttributeSpecificationList* _get_attribute_specification_list(){ return &attributes; }

protected:
  IIRScram_Label(){ }
  virtual ~IIRScram_Label() = 0;
    
private:
};
#endif
