
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Timothy J. McBrayer 
//          Narayanan Thondugulam
//          Radharamanan Radhakrishnan
//	    Magnus Danielson	cfmd@swipnet.se

#include "IIR_EntityDeclaration.hh"
#include "IIR_AliasDeclaration.hh"
#include "IIR_ArchitectureDeclaration.hh"
#include "IIR_Attribute.hh"
#include "IIR_ComponentInstantiationStatement.hh"
#include "IIR_ConstantInterfaceDeclaration.hh"
#include "IIR_ConfigurationSpecification.hh"
#include "IIR_DesignatorExplicit.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"
#include "IIR_Name.hh"
#include "IIR_ProcessStatement.hh"
#include "IIR_SignalInterfaceDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_UseClause.hh"
#include "library_manager.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "symbol_table.hh"
#include "published_header_file.hh"
#include "published_cc_file.hh"
#include "sstream-wrap.hh"
#include "language_processing_control.hh"

extern symbol_table *cgen_sym_tab_ptr;
extern language_processing_control *lang_proc;

IIRScram_EntityDeclaration::IIRScram_EntityDeclaration() {
  cgen_sym_tab_ptr = NULL;
}

IIRScram_EntityDeclaration::~IIRScram_EntityDeclaration(){
}

set<IIR_Declaration> *
IIRScram_EntityDeclaration::_find_declarations( IIR_Name *to_find ) {
  set<IIR_Declaration> *retval = new set<IIR_Declaration>;

  set<IIR_Declaration> *current_set = port_clause._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
    delete current_set;
  }
  current_set = generic_clause._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
    delete current_set;
  }
  current_set = entity_declarative_part._find_declarations( to_find );
  if( current_set != NULL ){
    retval->add( current_set );
    delete current_set;
  }
  if( retval->num_elements() == 0 ){
    delete retval;
    retval = NULL;
  }
  return retval;
}

void 
IIRScram_EntityDeclaration::_make_interface_visible( symbol_table *sym_tab ) {
  ASSERT( sym_tab != NULL );

  context_items._make_visible_as_context_list( sym_tab );
  sym_tab->make_visible( this );
  sym_tab->make_visible( &generic_clause );
  sym_tab->make_visible( &port_clause );
  sym_tab->make_visible( &entity_declarative_part );
}

IIR_PortList *
IIRScram_EntityDeclaration::_get_port_list(){
  return &port_clause;
}

IIR_GenericList *
IIRScram_EntityDeclaration::_get_generic_list(){
  return &generic_clause;
}

IIR_ArchitectureDeclaration *
IIRScram_EntityDeclaration::_get_cc_instantiated_architecture(){
  return library_manager::instance()->lookup_default_architecture( 
	  static_cast<IIR_EntityDeclaration *>(this) 
	  );
}

IIR_EntityDeclaration *
IIRScram_EntityDeclaration::_get_cc_instantiated_entity(){
  return static_cast<IIR_EntityDeclaration *>(this);
}


IIRScram_Declaration::declaration_type 
IIRScram_EntityDeclaration::_get_type() {
  return ENTITY;
}

IIR_EntityDeclaration*
IIRScram_EntityDeclaration::_get_entity() {
  return (IIR_EntityDeclaration*)this;
}

void 
IIRScram_EntityDeclaration::_publish_vhdl_decl(ostream &_vhdl_out) {
  context_items._publish_vhdl(_vhdl_out);
  PublishedUnit oldUnit = _get_currently_publishing_vhdl_unit();

  _set_currently_publishing_vhdl_unit(ENTITY_DECL);
  
  _vhdl_out << "\nentity ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " is\n";

  if(generic_clause.num_elements() != 0) {
    _vhdl_out << "generic (\n";
    generic_clause._publish_vhdl(_vhdl_out);
    _vhdl_out << ");\n";
  }

  if(port_clause.num_elements() != 0) {
    _vhdl_out << " port (\n";
    port_clause._publish_vhdl(_vhdl_out);
    _vhdl_out << ");\n";
  }

  entity_declarative_part._publish_vhdl_decl(_vhdl_out);

  if( entity_statement_part.num_elements() != 0) {
    _vhdl_out << "begin\n";
    entity_statement_part._publish_vhdl(_vhdl_out);
  }
  _vhdl_out << "end entity ";
  get_declarator()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ";\n\n";

  _set_currently_publishing_vhdl_unit(oldUnit);
}

void 
IIRScram_EntityDeclaration::_publish_vhdl(ostream &_vhdl_out) {
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_EntityDeclaration::_publish_cc(){
  IIR *old_node = _get_current_publish_node();
  symbol_table cgen_sym_tab( 4093, false );

  _set_current_publish_name( "" );
  _set_current_entity_name( _get_declarator()->_convert_to_string() );

  published_header_file header_file( _get_library_directory(),
				     _get_current_entity_name(),
				     this );
  SCRAM_CC_REF( header_file, "IIRScram_EntityDeclaration::_publish_cc" );;
    
  cgen_sym_tab_ptr = &cgen_sym_tab;

  _set_current_publish_node( this );
  _set_currently_publishing_unit(ENTITY_DECL);

  IIRScram::_publish_cc_include( header_file, "tyvis/STDTypes.hh" );

  context_items._publish_cc( header_file );
  generic_clause._publish_cc_elaborate_as_pointers( header_file, FALSE );
  entity_declarative_part._publish_cc( header_file );

  published_cc_file cc_file( _get_library_directory(),
			     _get_current_entity_name(),
			     this );

  SCRAM_CC_REF( cc_file, "IIRScram_EntityDeclaration::_publish_cc" );;
  _publish_cc_include_decls( cc_file );
  _publish_cc_include_elab( cc_file );

  generic_clause._publish_cc_elaborate_as_pointers( cc_file, TRUE );
  entity_declarative_part._publish_cc_decl( cc_file );

  entity_statement_part._publish_cc( cc_file );
  _set_current_publish_node( old_node );
  _set_currently_publishing_unit(NONE);

  cgen_sym_tab_ptr = NULL;
}

void
IIRScram_EntityDeclaration::_publish_cc_elaborate(){
  _set_current_publish_node( this );
  _publish_cc_headerfile();
  _publish_cc_ccfile();
  _set_current_publish_node( 0 );  
}

void
IIRScram_EntityDeclaration::_publish_cc_headerfile(){
  ostringstream filename;
  _publish_cc_entity_file_name( filename );

  published_header_file header_file( _get_library_directory(),
				     filename.str(),
				     this );
  SCRAM_CC_REF( header_file, "IIRScram_EntityDeclaration::_publish_cc_headerfile" );
  
  IIRScram::_publish_cc_include( header_file, "tyvis/_savant_entity_elab.hh" );
  
  // For AMS constructs
  if (lang_proc->processing_vhdl_ams()) {
    IIRScram::_publish_cc_include( header_file, "tyvis/_savant_entity_ams_elab.hh");
  }
  
  IIRScram::_publish_cc_include( header_file, "tyvis/SignalNetinfo.hh" );
  IIRScram::_publish_cc_include( header_file, "tyvis/STDTypes.hh" );

  // All the declarations are included through this file 
  _publish_cc_include_decls( header_file );
  _publish_cc_class_includes( header_file, &entity_statement_part );
  _publish_cc_class( header_file );
}

void
IIRScram_EntityDeclaration::_publish_cc_class( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_class" );
  
  _cc_out <<"class " << _get_cc_elaboration_class_name();
  if(lang_proc->processing_vhdl_ams()) {
    _cc_out << " : public _savant_entity_ams_elab";
  }
  else {
    _cc_out << " : public _savant_entity_elab";
  }
  _cc_out.start_block();
  _cc_out << "\npublic:\n";
  _cc_out.indent();
  
  _cc_out << _get_cc_elaboration_class_name() << "(";
  port_clause._publish_cc_unconstrained_ports( _cc_out, TRUE, FALSE, FALSE );
  _cc_out << ")";
  _cc_out.end_statement();
  
  if( generic_clause.num_elements() > 0 ){
    _cc_out << _get_cc_elaboration_class_name() << "(" << NL();
    generic_clause._publish_generic_parameter_list( _cc_out );
    port_clause._publish_cc_unconstrained_ports( _cc_out, TRUE, FALSE, TRUE );
    _cc_out << ")";
    _cc_out.end_statement();
  }

  _cc_out << "~" << _get_cc_elaboration_class_name() << "()";
  _cc_out.end_statement();

  generic_clause._publish_cc_elaborate( _cc_out );
  port_clause._publish_cc_elaborate( _cc_out );
  //Aliases for signal objects are also published
  _publish_cc_signals( _cc_out, &entity_declarative_part );
  _publish_cc_object_pointers( _cc_out, &entity_statement_part );
  
  if (generic_clause.first() != NULL) {
    _cc_out << "void copyGenericsToGlobals()";
    _cc_out.end_statement();
  }

  entity_declarative_part._publish_cc_extern_type_info( _cc_out );
  entity_declarative_part._publish_cc_constants( _cc_out );
  _cc_out.end_class();
}

void
IIRScram_EntityDeclaration::_publish_cc_object_pointers_init( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_object_pointers_init" );
  
  IIRScram::_publish_cc_object_pointers_init( _cc_out, 
					      &entity_statement_part, 
					      &entity_declarative_part );
}

///####WARNING THIS PROCEDURE NEEDS A LOT OF WORK TO KEEP THIS MODULARIZED
void
IIRScram_EntityDeclaration::_publish_cc_createNetInfo( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_createNetInfo" );
  int found = 0;
  
  //Publishing createNetInfo from entity statement part
  IIR_ArchitectureStatement *arch_stmt = entity_statement_part.first();
  while (arch_stmt != NULL) {
    ostringstream objectname;
    if (arch_stmt->get_kind() == IIR_PROCESS_STATEMENT) {
      arch_stmt->_publish_cc_binding_name( objectname );
      objectname << "_elab_obj";
      _set_current_elab_name( objectname.str() );
      arch_stmt->_publish_createNetInfo( _cc_out );
    }
    else if( arch_stmt->get_kind() == IIR_COMPONENT_INSTANTIATION_STATEMENT ){
      IIR_Name *componentname = 
	(IIR_Name *)((IIR_ComponentInstantiationStatement*)arch_stmt)->get_instantiated_unit();
      // Searching for configuration specification
      if( componentname->get_prefix()->get_kind() == IIR_COMPONENT_DECLARATION ){
	IIR_Declaration *decl = entity_declarative_part.first();
	while(decl != NULL) {
	  if(decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION) {
	    if(componentname->get_prefix() == ((IIR_ConfigurationSpecification*)decl)->get_component_name()) {
	      IIR_Designator* designator = decl->_get_instantiation_list()->first();
	      //By_others, By_all follows By_Explicit
	      while(designator != NULL) {
		switch(designator->get_kind()) {
		case IIR_DESIGNATOR_EXPLICIT:
		  if( designator->_get_name() == arch_stmt->get_label() ){
		    found = 1;
		    if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() 
		       == 0) {
		      _set_current_publish_node( componentname->get_prefix() );
		      objectname << " ((" << *decl->_get_entity_aspect()->_get_declarator() <<
			"_elab*)\n    " << *arch_stmt->get_label() <<
			"_elab_obj->boundedEntity)->";
		      _set_current_publish_name( objectname.str() );
		      ((IIR_EntityDeclaration*)decl->_get_entity_aspect())->port_clause._publish_cc_port_map_aspect( _cc_out );
		    }
		    else {
		      _set_current_publish_node( componentname->get_prefix() );
		      objectname << "  ((";
		      IIR_LibraryUnit *lib_unit = decl->_get_entity_aspect(); 
		      if(lib_unit->get_kind() == IIR_ENTITY_DECLARATION) {
			objectname << *decl->_get_entity_aspect()->_get_declarator();
		      }
		      else if( lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION ){
			IIR_ArchitectureDeclaration* arch_decl = 
			  (IIR_ArchitectureDeclaration*)decl->_get_entity_aspect();
			objectname << *arch_decl->_get_declarator();
		      }
		      objectname << "_elab *)\n    " << *arch_stmt->get_label();
		      objectname << "_elab_obj->boundedEntity)->";
		      _set_current_publish_name( objectname.str() );
		      ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate( _cc_out );
		    }
		  }
		  break;
		case IIR_DESIGNATOR_BY_ALL:
		case IIR_DESIGNATOR_BY_OTHERS:
		  found = 1;
		  if(((IIR_ConfigurationSpecification*)decl)->port_map_aspect.num_elements() == 0){
		    _set_current_publish_node( componentname->get_prefix() );
		    objectname << "(( ";
		    IIR_LibraryUnit* lib_unit = decl->_get_entity_aspect(); 
		    if( lib_unit->get_kind() == IIR_ENTITY_DECLARATION ){
		      objectname << *decl->_get_entity_aspect()->_get_declarator();
		    }
		    else if(lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION) {
		      IIR_ArchitectureDeclaration* arch_decl = 
			(IIR_ArchitectureDeclaration*)decl->_get_entity_aspect();
		      objectname << *arch_decl->_get_declarator();
		    }
		    else {
		      //Nothing to be done for now
		    }
		    objectname << "_elab*) " << *arch_stmt->get_label();
		    objectname << "_elab_obj->boundedEntity)->";
		    _set_current_publish_name( objectname.str() );
		    ((IIR_EntityDeclaration*)decl->_get_entity_aspect())->port_clause._publish_cc_port_map_aspect( _cc_out );
		  }
		  else {
		    _set_current_publish_node( componentname->get_prefix() );
		    objectname << "(( ";
		    IIR_LibraryUnit *lib_unit = decl->_get_entity_aspect(); 
		    if(lib_unit->get_kind() == IIR_ENTITY_DECLARATION) {
		      objectname << *decl->_get_entity_aspect()->_get_declarator();
		    }
		    else if(lib_unit->get_kind() == IIR_ARCHITECTURE_DECLARATION) {
		      IIR_ArchitectureDeclaration* arch_decl = 
			(IIR_ArchitectureDeclaration*)decl->_get_entity_aspect();
		      objectname << *arch_decl->_get_declarator();
		    }
		    else {
		      //Nothing to be done for now
		    }
		    objectname << "_elab*) " << *arch_stmt->get_label();
		    objectname << "_elab_obj->boundedEntity)->";
		    _set_current_publish_name( objectname.str() );
		    ((IIR_ConfigurationSpecification*)decl)->port_map_aspect._publish_cc_elaborate( _cc_out );
		  }
		  break;

		default:
		  break;
		}
		if(found ==1) {
		  ///Has to exit the two enclosing loops
		  designator = NULL;
		  decl = NULL;
		}
		else {
		  designator = decl->_get_instantiation_list()->successor(designator);
		}
	      }
	    }
	  }
	  decl = entity_declarative_part.successor(decl);
	}
      }
      //###yet to check for label
      objectname << *arch_stmt->get_label() << "_elab_obj";
      _set_current_elab_name( objectname.str() );
      arch_stmt->_publish_createNetInfo( _cc_out );
    }
    else {
      cerr << "ERROR! IIRScram_EntityDeclaration::"
	   << "_publish_cc_createNetInfo( _cc_out ): unknown concurrent statement "
	   << "type |" << arch_stmt->get_kind_text() << "| in entity" << endl;
      abort();
    }
    _set_current_elab_name( "" );
    arch_stmt = entity_statement_part.successor(arch_stmt);
  }
}

void
IIRScram_EntityDeclaration::_publish_cc_binding_name(ostream& outstream) {
//   SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_binding_name" );
  outstream << *_get_declarator();
}

void
IIRScram_EntityDeclaration::_publish_cc_ccfile(){
  ostringstream file_name;
  _publish_cc_entity_file_name( file_name );

  published_cc_file cc_file( _get_library_directory(),
			     file_name.str(),
			     this );
  SCRAM_CC_REF( cc_file, "IIRScram_EntityDeclaration::_publish_cc_ccfile" );

  cc_file << "#include \"" << file_name.str() << ".hh\"\n";

  cc_file << "class VHDLKernel;\n";
  cc_file << "extern VHDLKernel *proc_array[];\n";

  SCRAM_CC_REF( cc_file, "IIRScram_EntityDeclaration::_publish_cc_ccfile" );

  _publish_cc_headerfiles_for_cc( cc_file );
  _publish_cc_constructor( cc_file );
  _publish_cc_destructor( cc_file, &entity_statement_part );

  if (generic_clause.first() != NULL) {
    _publish_cc_copy_generics_to_globals( cc_file );
  }

  _publish_cc_component_decl( cc_file );
}

void 
IIRScram_EntityDeclaration::_publish_cc_entity_file_name( ostream &os ){
  os << _get_cc_elaboration_class_name();
}

void
IIRScram_EntityDeclaration::_publish_cc_headerfiles_for_cc( published_file &_cc_out ) {
  IIR_Declaration* decl;
  IIR_ArchitectureStatement* arch_stmt;

  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_headerfiles_for_cc" );
  
  IIRScram::_publish_cc_include( _cc_out, "tyvis/ObjectBase.hh" );
  decl = entity_declarative_part.first();
  while(decl != NULL) {
    if( decl->get_kind() == IIR_CONFIGURATION_SPECIFICATION ) {
      _get_entity_aspect()->_publish_cc_include_elab( _cc_out );
    }
    decl =  entity_declarative_part.successor(decl);
  }

  arch_stmt = entity_statement_part.first();
  while (arch_stmt != NULL) {
    //###currently the process name doesn't include its entity and
    //architecture name
    if( arch_stmt->get_kind() == IIR_PROCESS_STATEMENT ) {
      arch_stmt->_publish_cc_include( _cc_out );
    }
    //Nothing to be done for other statements
    arch_stmt = entity_statement_part.successor( arch_stmt );
  }
}

void
IIRScram_EntityDeclaration::_publish_cc_constructor( published_file &_cc_out ) {

  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_constructor" );
  
  _publish_cc_constructor_with_no_arguments( _cc_out );
  if (generic_clause.num_elements() > 0) {
    _publish_cc_constructor_with_arguments( _cc_out );
  }
}

void
IIRScram_EntityDeclaration::_publish_cc_constructor_with_no_arguments( published_file &_cc_out ) {
  int numGenericClause = generic_clause.num_elements();
  int numPortClause    = port_clause.num_elements();
  IIR_Boolean first    = TRUE;
  
  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_constructor_with_no_arguments" );

  _cc_out << _get_cc_elaboration_class_name() << "::" << _get_cc_elaboration_class_name() << "(";
  port_clause._publish_cc_unconstrained_ports( _cc_out, TRUE, TRUE, FALSE );
  _cc_out << ")";

  bool firstDeclFlag = false;  
  if( numGenericClause > 0 ){
    _cc_out << ":\n    ";
    generic_clause._publish_generic_init( _cc_out );
    if( numPortClause > 0 ){
      _cc_out << ",\n   ";
      port_clause._publish_cc_port_init( _cc_out );
    }    
  }
  else {
    if(numPortClause > 0) {
      _cc_out << ":\n    ";
      port_clause._publish_cc_port_init( _cc_out );
    }
    else {
      firstDeclFlag = true;
    }
  }
  
  first = entity_declarative_part._publish_cc_type_info( _cc_out, firstDeclFlag );
  first = entity_declarative_part._publish_cc_constants_init( _cc_out, first);
  _publish_cc_signal_objects_init( _cc_out, first );
  
  _cc_out << " {\n  ";
  // before newing the elab guys down the heirarchy copy generics of this
  // entity to the global generic pointers in the entity_decls file
  if (numGenericClause > 0) {
    _cc_out << "copyGenericsToGlobals();\n";
  }

  entity_declarative_part._publish_cc_global_constants_assignments(_cc_out);
  
  _publish_cc_object_pointers_init( _cc_out );
  _cc_out << "}\n\n\n";
}

void
IIRScram_EntityDeclaration::_publish_cc_constructor_with_arguments( published_file &_cc_out ) {
  int numGenericClause = generic_clause.num_elements();
  int numPortClause = port_clause.num_elements();

  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_constructor_with_arguments" );
  
  _cc_out << _get_cc_elaboration_class_name() << "::" << _get_cc_elaboration_class_name() << "(";
  generic_clause._publish_generic_parameter_list( _cc_out );
  port_clause._publish_cc_unconstrained_ports( _cc_out, TRUE, TRUE, TRUE );
  _cc_out << ")";
  
  if(numGenericClause > 0) {
    _cc_out << ":\n    ";
    generic_clause._publish_generic_init_by_arguments( _cc_out );
    if(numPortClause > 0) {
      _cc_out << ",\n    ";
      port_clause._publish_cc_port_init( _cc_out );
    }
  }
  else {
    if(numPortClause > 0) {
      _cc_out << ":\n    ";
      port_clause._publish_cc_port_init( _cc_out );
    }
  }
  _publish_cc_signal_objects_init( _cc_out );
  _cc_out << "{\n";
  // before newing the elab guys down the heirarchy copy generics of this entity 
  // to the global generic pointers in the entity_decls file
  if (numGenericClause > 0) {
    _cc_out << "  copyGenericsToGlobals();\n";
  }
  
  entity_declarative_part._publish_cc_global_constants_assignments(_cc_out);
  _publish_cc_object_pointers_init( _cc_out );
  _cc_out << "}\n\n\n";
}

void
IIRScram_EntityDeclaration::_publish_cc_component_decl( published_file &_cc_out ) {

  IIR_Declaration *decl;

  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_component_decl" );
  
  decl = entity_declarative_part.first();
  while (decl != NULL) {
    if (decl->get_kind() == IIR_COMPONENT_DECLARATION) {
      decl->_publish_cc_elaborate( _cc_out );
    }  
    decl = entity_declarative_part.successor(decl);
  }
}

void
IIRScram_EntityDeclaration::_publish_cc_signal_objects_init( published_file &_cc_out,
							     const IIR_Boolean firstFlag ){
  IIR_Declaration* decl;
  decl = entity_declarative_part.first();

  int numGenericClause = generic_clause.num_elements();
  int numPortClause    = port_clause.num_elements();
  IIR_Boolean first    = firstFlag;
  
  SCRAM_CC_REF( _cc_out, "IIRScram_EntityDeclaration::_publish_cc_signal_objects_init" );
  
  while (decl != NULL) {
    if (decl->get_kind() == IIR_SIGNAL_DECLARATION) {
      if (first == TRUE) {
	_cc_out << ":\n    ";
	first = FALSE;
      }
      else {
	_cc_out << ",\n    ";
      }
      decl->_publish_cc_elaborate( _cc_out );
      _cc_out << "(ObjectBase::SIGNAL_NETINFO";
      if( decl->get_subtype()->_is_array_type() ){
	_cc_out << ",\n";
	decl->get_subtype()->_publish_cc_range( _cc_out );
      }
      _cc_out << ")";
      // If the Signals has implicit signals, they are also needed for
      // elaboration info
      if( decl->_get_implicit_declarations() != NULL &&
          decl->_get_implicit_declarations()->num_elements() != 0) {
	IIR_Declaration* imp_decl = decl->_get_implicit_declarations()->get_element();
	while(imp_decl != NULL) {
	  if(imp_decl->_is_signal() == TRUE) {
	    _cc_out << ",\n    ";
	    (imp_decl->_get_declarator())->_publish_cc_elaborate( _cc_out );
	    _cc_out << "(ObjectBase::SIGNAL_NETINFO";
	    IIR_TypeDefinition* type_def = imp_decl->_get_attribute_name()->_get_explicit_signal_type();
	    if((type_def->_is_array_type() == TRUE ) &&
	       (type_def->_is_anonymous() == TRUE)) {
	      _cc_out << ",\n    ";
	      type_def->_publish_cc_range( _cc_out );
	    }	
	    _cc_out << ")";
	  }
	  imp_decl = decl->_get_implicit_declarations()->get_next_element();
	}
      }
    }
    else if(decl->get_kind() == IIR_ALIAS_DECLARATION) {
      if(((IIR_AliasDeclaration*)decl)->get_name()->_is_signal()) {
	if((first == 0)&& (numGenericClause == 0)&& (numPortClause ==0)) {
	  _cc_out << ":\n    ";
	  first = FALSE;
	}
	else {
	  _cc_out << ",\n    ";
	}
	((IIR_AliasDeclaration*)decl)->_publish_cc_elaborate_alias_init( _cc_out );
      }
    }
    decl = entity_declarative_part.successor(decl);
  }
}

void 
IIRScram_EntityDeclaration::_publish_cc_include_decls_prefix( ostream &os ){
  os << *_get_declarator();
}

#ifdef PROCESS_COMBINATION
void 
IIRScram_EntityDeclaration::_static_elaborate(IIR_ArchitectureDeclaration *arch, 
					      IIR_DeclarationList *cfglist, 
					      char *hier_location) {
  if (generic_clause.num_elements() != 0) {
    cerr << "Sorry, generics in entity declarations not handled in static "
	 << "elaboration yet!" << endl;  
    cerr << "The offending entity is |" << *get_declarator() << "|" << endl;

  }
  if (entity_statement_part.num_elements() != 0) {
    cerr << "Sorry, the entity declarative part not handled in static "
	 << "elaboration yet!" << endl;
    cerr << "The offending entity is |" << *get_declarator() << "|" << endl;
  }

  IIR_Declaration *decl = context_items.first();
  while ( decl != NULL ) {
    ASSERT( IIR_USE_CLAUSE == decl->get_kind() );
    if (arch->context_items.get_position( decl ) == -1 ) {
      arch->context_items.append( decl );
    }
    decl = context_items.successor( decl );
  }
}
#endif

void
IIRScram_EntityDeclaration::_publish_vhdl_binding_name(ostream &_vhdl_out){
  _vhdl_out << " entity ";
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void
IIRScram_EntityDeclaration::_publish_vhdl_with_library_name(ostream &_vhdl_out){
  _vhdl_out << " entity ";
  ASSERT(_get_declarative_region() != NULL);
  ASSERT(_get_declarative_region()->get_kind() == IIR_LIBRARY_DECLARATION);
  _get_declarative_region()->_publish_vhdl(_vhdl_out);
  _vhdl_out << ".";
  get_declarator()->_publish_vhdl(_vhdl_out);
}

void 
IIRScram_EntityDeclaration::_type_check(){
  entity_declarative_part._type_check_attribute_specifications( entity_statement_part );
  entity_declarative_part._type_check_disconnection_specifications( );
}

visitor_return_type *
IIRScram_EntityDeclaration::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_EntityDeclaration(this, arg);
};
