#ifndef IIRSCRAM_ARRAY_SUBTYPE_DEFINITION_HH
#define IIRSCRAM_ARRAY_SUBTYPE_DEFINITION_HH
// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRBase_ArraySubtypeDefinition.hh"
#include "IIR_ArrayTypeDefinition.hh"

class IIRScram_ArraySubtypeDefinition : public IIRBase_ArraySubtypeDefinition {

public:

  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl( ostream & );
  void _publish_vhdl_decl(ostream &);
  void _publish_vhdl_subtype_decl(ostream &_vhdl_out);
  void _publish_vhdl_type_decl( ostream & );

  virtual IIR_Boolean _is_subtype();

  ostream& _print(ostream& os);
  void _publish_cc_define_constructors( published_file &_cc_out );
  void _publish_cc_attribute_constructor_arguments( published_file &_cc_out );

  IIR_ScalarTypeDefinition *_get_index_subtype();

  virtual void _type_check();
  virtual IIR *_clone();

  IIR_FunctionDeclaration* _get_resolution_function(){ return get_resolution_function(); }

  IIR_Boolean _is_locally_static();
  IIR_Boolean _is_globally_static();

  virtual void _set_resolution_function( IIR_FunctionDeclaration *new_decl ){
    set_resolution_function( new_decl ); 
  }
  
protected:
  IIRScram_ArraySubtypeDefinition(){}
  virtual ~IIRScram_ArraySubtypeDefinition() = 0;
    
private:
  void _publish_cc_define_type_attribute_left( published_file &_cc_out );
  void _publish_cc_define_type_attribute_right( published_file &_cc_out );
  void _publish_cc_define_type_attribute_low( published_file &_cc_out );
  void _publish_cc_define_type_attribute_high( published_file &_cc_out );
  void _publish_cc_define_type_attribute_length( published_file &_cc_out );
  void _publish_cc_define_type_attribute_ascending( published_file &_cc_out );

  void _publish_cc_constructor_with_no_value( published_file &_cc_out );
  void _publish_cc_constructor_with_value( published_file &_cc_out );
  void _publish_cc_copy_constructor( published_file &_cc_out );
  void _publish_cc_constructor_with_string( published_file &_cc_out );
  void _publish_cc_constructor_for_alias_init( published_file &_cc_out );
  void _publish_cc_constructor_with_aggregates( published_file &_cc_out );
  void _publish_cc_constructor_with_base_type( published_file &_cc_out );
  void _publish_cc_constructor_with_ranges( published_file &_cc_out );
};
#endif
