
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_SignalAssignmentStatement.hh"
#include "savant.hh"

IIRBase_SignalAssignmentStatement::IIRBase_SignalAssignmentStatement() {
   set_target(NULL); 
   set_reject_time_expression(NULL);
}

IIRBase_SignalAssignmentStatement::~IIRBase_SignalAssignmentStatement() {
  delete get_target();
  delete get_reject_time_expression();
}

void
IIRBase_SignalAssignmentStatement::set_target(IIR* target) {
  this->target = target;
}

IIR*
IIRBase_SignalAssignmentStatement::get_target() {
  return target;
}

void
IIRBase_SignalAssignmentStatement::set_delay_mechanism( IIR_DelayMechanism delay_mechanism) {
  this->delay_mechanism =  delay_mechanism;
}

IIR_DelayMechanism
IIRBase_SignalAssignmentStatement::get_delay_mechanism() {
  return delay_mechanism;
}

void
IIRBase_SignalAssignmentStatement::set_reject_time_expression( IIR* reject_time_expression) {
  this->reject_time_expression =  reject_time_expression;
}

IIR*
IIRBase_SignalAssignmentStatement::get_reject_time_expression() {
return  reject_time_expression;
}
