
// Copyright (c) 1996-1999 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRBase_AttributeSpecification.hh"
#include "savant.hh"

IIRBase_AttributeSpecification::IIRBase_AttributeSpecification(){
  set_value( NULL );
  set_entity_class( NULL );
}

IIRBase_AttributeSpecification::~IIRBase_AttributeSpecification(){}

void 
IIRBase_AttributeSpecification::set_value( IIR *new_value ){
  value = new_value;
}

IIR *
IIRBase_AttributeSpecification::get_value(){
  return value;
}

void
IIRBase_AttributeSpecification::set_entity_class( IIR_Identifier *new_entity_class ){
  entity_class = new_entity_class ;
}

IIR_Identifier *
IIRBase_AttributeSpecification::get_entity_class(){
  return entity_class ;
}
