// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

// from Harbison&Steele by way of GNU cinfigure ...
// returns 1 for bigendian, 0 for littleendian

#include "nan.h"

static int is_bigendian()
{
  union {
    long l;
    char c[sizeof (long)];
  } u;
  u.l = 1;

  return (u.c[sizeof (long) - 1] == 1);
}

// getNaNf() -- return a float NaN

float getNaNf()
{
  unsigned char nan[4];

  for (int i=0; i<4; i++)
    nan[i] = 1;

  if (is_bigendian()) {
    nan[0] = 0x7F;
    nan[1] = 0x80;
  }
  else {
    nan[3] = 0x7F;
    nan[2] = 0x80;
  }

  return (*((float *)nan));
}

// getNaNd() -- return a double NaN

double getNaNd()
{
  unsigned char nan[8];
  
  for (int i=0; i<8; i++)
    nan[i] = 1;

  if (is_bigendian()) {
    nan[0] = 0x7F;
    nan[1] = 0xF0;
  }
  else {
    nan[7] = 0x7F;
    nan[6] = 0xF0;
  }

  return(*((double *)nan));
}
