// Copyright (C) 1999-2004
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscaletrue16.h"
#include "util.h"

ColorScaleTrueColor16::ColorScaleTrueColor16(int s, Visual* v, int msb)
  : ColorScale(s)
{
  colors_ = new unsigned char[s*2];

  int rs,gs,bs;
#ifndef _WIN32
  unsigned short rm = decodeMask((unsigned short)v->red_mask, &rs);
  unsigned short gm = decodeMask((unsigned short)v->green_mask, &gs);
  unsigned short bm = decodeMask((unsigned short)v->blue_mask, &bs);
#else
  unsigned short rm = decodeMask((unsigned short)0x7C00, &rs);
  unsigned short gm = decodeMask((unsigned short)0x03E0, &gs);
  unsigned short bm = decodeMask((unsigned short)0x001F, &bs);
#endif

  // we need to check to byteswap when we have cross platforms

  if ((!msb && lsb()) || (msb && !lsb())) {
    for (int i=0; i<s; i++) {
      unsigned short r = psColors_[i*3+2];
      unsigned short g = psColors_[i*3+1];
      unsigned short b = psColors_[i*3];
      unsigned short a = 0;
      a |= rs>0 ? ((r & rm) << rs) : ((r & rm) >> -rs);
      a |= gs>0 ? ((g & gm) << gs) : ((g & gm) >> -gs);
      a |= bs>0 ? ((b & bm) << bs) : ((b & bm) >> -bs);

      memcpy(colors_+i*2, &a, 2);
    }
  }
  else {
    for (int i=0; i<s; i++) {
      unsigned short r = psColors_[i*3+2];
      unsigned short g = psColors_[i*3+1];
      unsigned short b = psColors_[i*3];
      unsigned short a = 0;
      a |= rs>0 ? ((r & rm) << rs) : ((r & rm) >> -rs);
      a |= gs>0 ? ((g & gm) << gs) : ((g & gm) >> -gs);
      a |= bs>0 ? ((b & bm) << bs) : ((b & bm) >> -bs);

      unsigned char* rr = (unsigned char*)(&a);
      *(colors_+i*2) = *(rr+1);
      *(colors_+i*2+1) = *(rr);
    }
  }
}

ColorScaleTrueColor16::~ColorScaleTrueColor16()
{
  if (colors_)
    delete [] colors_;
}

LinearScaleTrueColor16::LinearScaleTrueColor16(int s, 
					       unsigned short* indexCells,
					       unsigned char* colorCells,
					       int count, Visual* v, int msb)
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor16(s, v, msb),
    ColorScale(s) {}

LogScaleTrueColor16::LogScaleTrueColor16(int s,
					 unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, Visual* v, int msb)
  : LogScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor16(s, v, msb),
    ColorScale(s) {}

SquaredScaleTrueColor16::SquaredScaleTrueColor16(int s,
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, Visual* v, int msb)
  : SquaredScale(s,indexCells,colorCells,count), 
    ColorScaleTrueColor16(s, v, msb), 
    ColorScale(s) {}

SqrtScaleTrueColor16::SqrtScaleTrueColor16(int s,
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count, Visual* v, int msb)
  : SqrtScale(s, indexCells, colorCells, count), 
    ColorScaleTrueColor16(s, v, msb),
    ColorScale(s) {}

IISScaleTrueColor16::IISScaleTrueColor16(unsigned short* indexCells,
					 unsigned char* colorCells,
					 int count, Visual* v, int msb)
  : IISScale(indexCells, colorCells, count),
    ColorScaleTrueColor16(IISSIZE, v, msb),
    ColorScale(IISSIZE) {}

HistEquScaleTrueColor16::HistEquScaleTrueColor16(int s, 
						 unsigned short* indexCells,
						 unsigned char* colorCells,
						 int count, 
						 double* hist, int histsize,
						 Visual* v, int msb)
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScaleTrueColor16(s, v, msb),
    ColorScale(s) {}

