#! /bin/sh

if [ "$2" = "val" ]; then
#    CMD="valgrind --leak-check=yes --show-reachable=yes ../ds9val"
    CMD="valgrind --leak-check=yes --logfile-fd=20 ../ds9val"
    XPA=ds9val
else
    CMD=../ds9
    XPA=ds9
fi

echo "XPA Tests"

echo "Starting DS9..."
if [ `xpaaccess $XPA` = no ]; then
    $CMD&

    i=1
    while [ "$i" -le 30 ]
	do
	sleep 2
	if [ `xpaaccess $XPA` = yes ]; then
	    break
	fi

	i=`expr $i + 1`
    done
fi

# load default image
xpaset -p $XPA scale zscale
xpaset -p $XPA file img16.fits

if [ "$1" = "about" -o  -z "$1" ]; then
echo "Testing About"
xpaget $XPA about > /dev/null
echo "PASSED"
fi

if [ "$1" = "array" -o  -z "$1" ]; then
echo "Testing Array"
xpaget $XPA array > /dev/null
echo "PASSED"
fi

if [ "$1" = "bin" -o  -z "$1" ]; then
echo "Testing Bin"
xpaset -p $XPA file new table.fits
xpaset -p $XPA bin factor 4
xpaset -p $XPA bin factor 8 8
xpaset -p $XPA scale log
xpaset -p $XPA scale minmax
xpaset -p $XPA bin buffersize 1024
xpaset -p $XPA bin filter 'circle(4096,4096,200)'
xpaset -p $XPA bin filter ""
xpaset -p $XPA bin cols rawx rawy
xpaset -p $XPA bin about 2048 2048
xpaset -p $XPA bin filter
xpaset -p $XPA bin function sum
xpaset -p $XPA bin to fit
xpaset -p $XPA bin smooth yes
xpaset -p $XPA bin smooth function tophat
xpaset -p $XPA bin smooth radius 5
xpaset -p $XPA bin smooth no
xpaget $XPA bin about > /dev/null
xpaget $XPA bin buffersize > /dev/null
xpaget $XPA bin cols > /dev/null
xpaget $XPA bin factor > /dev/null
xpaget $XPA bin filter > /dev/null
xpaget $XPA bin function > /dev/null
xpaget $XPA bin smooth > /dev/null
xpaget $XPA bin smooth function > /dev/null
xpaget $XPA bin smooth radius > /dev/null
xpaset -p $XPA frame delete
echo "PASSED"
fi

if [ "$1" = "contour" -o  -z "$1" ]; then
echo "Testing Contour"
xpaget $XPA contour > /dev/null
xpaset -p $XPA contour yes
xpaset -p $XPA contour save foo.con wcs fk5
xpaset -p $XPA contour copy
xpaset -p $XPA contour paste wcs fk5
xpaset -p $XPA contour clear
xpaset -p $XPA contour yes
xpaset -p $XPA contour load foo.con wcs fk5 red 2
xpaset -p $XPA contour clear
rm -f foo.con
echo "PASSED"
fi

if [ "$1" = "cmap" -o  -z "$1" ]; then
echo "Testing Cmap"
xpaget $XPA cmap > /dev/null
xpaget $XPA cmap file > /dev/null
xpaget $XPA cmap invert > /dev/null
xpaget $XPA cmap value > /dev/null
xpaset -p $XPA cmap Heat
xpaset -p $XPA cmap file blue.sao
xpaset -p $XPA cmap invert yes
xpaset -p $XPA cmap value 5 .2
xpaset -p $XPA cmap Grey
echo "PASSED"
fi

if [ "$1" = "crosshair" -o  -z "$1" ]; then
echo "Testing Crosshair"
xpaget $XPA crosshair > /dev/null
xpaget $XPA crosshair wcs fk5 sexagesimal > /dev/null
xpaset -p $XPA crosshair 13:29:55.287 +47:11:37.73 wcs fk5
xpaset -p $XPA mode pointer
echo "PASSED"
fi

if [ "$1" = "cursor" -o  -z "$1" ]; then
echo "Testing Cursor"
xpaset -p $XPA mode crosshair
xpaset -p $XPA cursor 10 10
xpaset -p $XPA mode pointer
echo "PASSED"
fi

if [ "$1" = "data" -o  -z "$1" ]; then
echo "Testing Data"
xpaget $XPA data image 450 520 3 3 yes > /dev/null
xpaget $XPA data physical 899 1039 6 6 no > /dev/null
xpaget $XPA data fk5 202.4709 47.19681 0.00016517 0.00016517 yes > /dev/null
xpaget $XPA data wcs fk5 202.4709 47.19681 0.00016517 0.00016517 no > /dev/null
echo "PASSED"
fi

if [ "$1" = "dss" ]; then
echo "Testing DSS"
xpaget $XPA dss server > /dev/null
xpaget $XPA dss survey > /dev/null
xpaget $XPA dss name > /dev/null
xpaget $XPA dss x > /dev/null
xpaget $XPA dss y > /dev/null
xpaget $XPA dss width > /dev/null
xpaget $XPA dss height > /dev/null
xpaget $XPA dss > /dev/null
xpaset -p $XPA dss server sao
xpaset -p $XPA dss survey dss
xpaset -p $XPA dss width 10
xpaset -p $XPA dss height 10
xpaset -p $XPA dss m31
echo "PASSED"
fi

if [ "$1" = "file" -o  -z "$1" ]; then
echo "Testing File"
xpaget $XPA file > /dev/null

echo "..fits new"
xpaset -p $XPA file new img16.fits
xpaset -p $XPA frame delete

echo "..file save"
xpaset -p $XPA file img16.fits
xpaset -p $XPA file save foo.fits
echo "..file save gz"
xpaset -p $XPA file save gz foo.fits.gz
echo "..file save resample"
xpaset -p $XPA file save resample foo.fits
echo "..file save resample gz"
xpaset -p $XPA file save resample gz foo.fits.gz
rm -f foo.fits foo.fits.gz

echo "PASSED"
fi

if [ "$1" = "fits" -o  -z "$1" ]; then
echo "Testing Fits"

echo "..fits new"
cat img16.fits | xpaset $XPA fits new 
xpaset -p $XPA frame delete

echo "..get table"
cat table.fits | xpaset $XPA fits
xpaget $XPA fits table > foo.fits
echo "..get table gz"
xpaget $XPA fits table gz > foo.fits.gz

echo "..get fits"
xpaset -p $XPA file img16.fits
xpaget $XPA fits size > /dev/null
xpaget $XPA fits size wcs arcsec > /dev/null
xpaget $XPA fits depth > /dev/null
xpaget $XPA fits header > /dev/null
xpaget $XPA fits header 1 > /dev/null
xpaget $XPA fits header keyword "'BITPIX'" > /dev/null
xpaget $XPA fits header 1 keyword "'BITPIX'" > /dev/null
xpaget $XPA fits type > /dev/null
xpaget $XPA fits > foo.fits

echo "..get image"
xpaget $XPA fits image > foo.fits
echo "..get image gz"
xpaget $XPA fits image gz > foo.fits.gz
echo "..get fits resample"
xpaget $XPA fits resample > foo.fits
echo "..get fits resample gz"
xpaget $XPA fits resample gz > foo.fits.gz
rm -f foo.fits foo.fits.gz

echo "PASSED"
fi

if [ "$1" = "frame" -o  -z "$1" ]; then
echo "Testing Frame"
xpaset -p $XPA frame new rgb
xpaset -p $XPA frame delete
xpaset -p $XPA frame new
xpaset -p $XPA file img16.fits
xpaget $XPA frame > /dev/null
xpaget $XPA frame frameno > /dev/null
xpaget $XPA frame all > /dev/null
xpaget $XPA frame active > /dev/null
xpaset -p $XPA frame center
xpaset -p $XPA frame center 1
xpaset -p $XPA frame center all
xpaset -p $XPA frame reset
xpaset -p $XPA frame reset 1
xpaset -p $XPA frame reset all
xpaset -p $XPA frame refresh
xpaset -p $XPA frame refresh 1
xpaset -p $XPA frame refresh all
xpaset -p $XPA frame hide
xpaset -p $XPA frame hide 1
xpaset -p $XPA frame hide all
xpaset -p $XPA frame show
xpaset -p $XPA frame show 1
xpaset -p $XPA frame show all
xpaset -p $XPA frame first
xpaset -p $XPA frame next
xpaset -p $XPA frame prev
xpaset -p $XPA frame last
xpaset -p $XPA frame frameno 1
xpaset -p $XPA frame 2
xpaset -p $XPA frame clear
xpaset -p $XPA frame clear 1
xpaset -p $XPA frame clear all
xpaset -p $XPA frame delete
xpaset -p $XPA frame delete 1
xpaset -p $XPA frame delete all
xpaset -p $XPA file new img16.fits
echo "PASSED"
fi

if [ "$1" = "grid" -o  -z "$1" ]; then
echo "Testing Grid"
xpaget $XPA grid > /dev/null
xpaget $XPA grid system > /dev/null
xpaget $XPA grid sky > /dev/null
xpaget $XPA grid skyformat > /dev/null
xpaget $XPA grid type > /dev/null
xpaget $XPA grid type axes > /dev/null
xpaget $XPA grid type numerics > /dev/null
xpaget $XPA grid view grid > /dev/null
xpaget $XPA grid view axes > /dev/null
xpaget $XPA grid view axes numbers > /dev/null
xpaget $XPA grid view axes tickmarks > /dev/null
xpaget $XPA grid view axes label > /dev/null
xpaget $XPA grid view title > /dev/null
xpaget $XPA grid view border > /dev/null
xpaget $XPA grid view vertical > /dev/null

xpaset -p $XPA grid yes
xpaset -p $XPA grid system wcs
xpaset -p $XPA grid sky fk5
xpaset -p $XPA grid skyformat degrees
xpaset -p $XPA grid type analysis
xpaset -p $XPA grid type axes interior
xpaset -p $XPA grid type numerics interior
xpaset -p $XPA grid view grid yes
xpaset -p $XPA grid view axes yes
xpaset -p $XPA grid view axes numbers yes
xpaset -p $XPA grid view axes tickmarks yes
xpaset -p $XPA grid view axes label yes
xpaset -p $XPA grid view title yes
xpaset -p $XPA grid view border yes
xpaset -p $XPA grid view vertical no

xpaset -p $XPA grid no
echo "PASSED"
fi

if [ "$1" = "iconify" -o  -z "$1" ]; then
echo "Testing Iconify"
xpaget $XPA iconify > /dev/null
xpaset -p $XPA iconify yes
xpaset -p $XPA iconify no
echo "PASSED"
fi

if [ "$1" = "iis" -o  -z "$1" ]; then
echo "Testing IIS"
xpaget $XPA iis file name > /dev/null
xpaget $XPA iis file name 1 > /dev/null
xpaset -p $XPA iis filename foo.fits
xpaset -p $XPA iis filename foo.fits 1
echo "PASSED"
fi

if [ "$1" = "imexam" -o  -z "$1" ]; then
echo "Testing imexam"
echo "Select coordinate point:"
xpaget $XPA imexam coordinate wcs fk5 degrees > /dev/null
echo "  ok"
echo "Select value point:"
xpaget $XPA imexam value > /dev/null
echo "  ok"
echo "PASSED"
fi

if [ "$1" = "raise" -o  -z "$1" ]; then
echo "Testing Lower/Raise"
xpaget $XPA iconify > /dev/null
xpaset -p $XPA lower
xpaset -p $XPA raise
echo "PASSED"
fi

if [ "$1" = "match" -o  -z "$1" ]; then
echo "Testing Match"
xpaset -p $XPA tile
xpaset -p $XPA file new img-32.fits
xpaset -p $XPA match frames wcs
xpaset -p $XPA match colorbars
xpaset -p $XPA match scales
xpaset -p $XPA single
xpaset -p $XPA frame delete
xpaset -p $XPA match frames image
echo "PASSED"
fi

if [ "$1" = "minmax" -o  -z "$1" ]; then
echo "Testing MinMax"
xpaget $XPA minmax > /dev/null
xpaget $XPA minmax mode > /dev/null
xpaget $XPA minmax sample > /dev/null
xpaset -p $XPA minmax scan
xpaset -p $XPA minmax mode scan
xpaset -p $XPA minmax sample 10
echo "PASSED"
fi

if [ "$1" = "mode" -o  -z "$1" ]; then
echo "Testing Mode"
xpaget $XPA mode > /dev/null
xpaset -p $XPA mode none
xpaset -p $XPA mode crosshair
xpaset -p $XPA mode colorbar
xpaset -p $XPA mode pan
xpaset -p $XPA mode zoom
xpaset -p $XPA mode rotate
xpaset -p $XPA mode examine
xpaset -p $XPA mode pointer
echo "PASSED"
fi

if [ "$1" = "nameserver" ]; then
echo "Testing NameServer"
xpaset -p $XPA nameserver server simbad-sao
xpaset -p $XPA nameserver skyformat sexagesimal
xpaset -p $XPA nameserver name m31
xpaget $XPA nameserver server > /dev/null
xpaget $XPA nameserver skyformat > /dev/null
echo "PASSED"
fi

if [ "$1" = "orient" -o  -z "$1" ]; then
echo "Testing Orient"
xpaset -p $XPA orient none
xpaset -p $XPA orient x
xpaset -p $XPA orient y
xpaset -p $XPA orient xy
xpaget $XPA orient > /dev/null
xpaset -p $XPA frame reset
echo "PASSED"
fi

if [ "$1" = "pagesetup" -o  -z "$1" ]; then
echo "Testing Page Setup"
xpaset -p $XPA page setup orientation portrait
xpaset -p $XPA page setup pagescale scaled
xpaset -p $XPA page setup pagesize letter
xpaget $XPA page setup orientation > /dev/null
xpaget $XPA page setup pagescale > /dev/null
xpaget $XPA page setup pagesize > /dev/null
echo "PASSED"
fi

if [ "$1" = "pan" -o  -z "$1" ]; then
echo "Testing Pan"
xpaget $XPA pan physical > /dev/null
xpaget $XPA pan wcs fk5 sexagesimal > /dev/null
xpaset -p $XPA pan 100 100 image
xpaset -p $XPA pan to 13:29:55.666 +47:12:16.29 wcs fk5
xpaset -p $XPA frame reset
echo "PASSED"
fi

if [ "$1" = "pixeltable" -o  -z "$1" ]; then
echo "Testing PixelTable"
xpaget $XPA pixeltable > /dev/null
xpaset -p $XPA pixeltable
xpaset -p $XPA pixeltable yes
xpaset -p $XPA pixeltable no
echo "PASSED"
fi

if [ "$1" = "plot" -o  -z "$1" ]; then
echo "Testing Plot"

xpaget $XPA plot > /dev/null

echo "..empty plot"
xpaset -p ds9 plot
xpaset -p ds9 plot new
xpaset -p ds9 plot new name foo
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..stdin 2|3|4|5"
cat stdin.2.dat | xpaset $XPA plot new stdin
cat stdin.3.dat | xpaset $XPA plot new stdin
cat stdin.4.dat | xpaset $XPA plot new stdin
cat stdin.5.dat | xpaset $XPA plot new stdin
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..named stdin 2|3|4|5"
cat stdin.2.dat | xpaset $XPA plot new name foo stdin
cat stdin.3.dat | xpaset $XPA plot new name foo stdin
cat stdin.4.dat | xpaset $XPA plot new name foo stdin
cat stdin.5.dat | xpaset $XPA plot new name foo stdin
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..stdin xy|xyex|xyey|xyexey"
cat stdin.xy.dat | xpaset $XPA plot new stdin
cat stdin.xyex.dat | xpaset $XPA plot new stdin
cat stdin.xyey.dat | xpaset $XPA plot new stdin
cat stdin.xyexey.dat | xpaset $XPA plot new stdin
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..named stdin xy|xyex|xyey|xyexey"
cat stdin.xy.dat | xpaset $XPA plot new name foo stdin
cat stdin.xyex.dat | xpaset $XPA plot new name foo stdin
cat stdin.xyey.dat | xpaset $XPA plot new name foo stdin
cat stdin.xyexey.dat | xpaset $XPA plot new name foo stdin
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..stdin text|error"
cat stdin.error.dat | xpaset $XPA plot new stdin
cat stdin.text.dat | xpaset $XPA plot new stdin
sleep 1
xpaset -p $XPA plot close

echo "..named stdin text|error"
cat stdin.error.dat | xpaset $XPA plot new name foo stdin
cat stdin.text.dat | xpaset $XPA plot new name foo stdin
sleep 1
xpaset -p $XPA plot close

echo "..4|5"
cat 4.dat | xpaset $XPA plot new "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset $XPA plot new "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..named 4|5"
cat 4.dat | xpaset $XPA plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" 4
cat 5.dat | xpaset $XPA plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" 5
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..xy|xyex|xyey|xyexey"
cat xy.dat | xpaset $XPA plot new "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset $XPA plot new "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset $XPA plot new "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset $XPA plot new "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..name xy|xyex|xyey|xyexey"
cat xy.dat | xpaset $XPA plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xy
cat xyex.dat | xpaset $XPA plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xyex
cat xyey.dat | xpaset $XPA plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xyey
cat xyexey.dat | xpaset $XPA plot new name foo "{The Title}" "{X Axis}" "{Y Axis}" xyexey
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..data"
xpaset -p $XPA plot new name foo
xpaset -p $XPA plot new
cat xy.dat | xpaset $XPA plot foo data xy
cat xy.dat | xpaset $XPA plot data xy
sleep 1
xpaset -p $XPA plot close
xpaset -p $XPA plot close

echo "..clear/close"
cat stdin.xy.dat | xpaset $XPA plot new stdin
xpaset -p $XPA plot clear
sleep 1
xpaset -p $XPA plot close

echo "..save/load"
xpaset -p $XPA plot new
xpaset -p $XPA plot load xy.dat xy
xpaset -p $XPA plot save foo.dat
xpaset -p $XPA plot saveconfig foo.plt
xpaset -p $XPA plot loadconfig foo.plt
sleep 1
xpaset -p $XPA plot close

echo "..print"
xpaset -p $XPA plot new
#xpaset -p $XPA plot print
xpaset -p $XPA plot print destination file
xpaset -p $XPA plot print command "lp"
xpaset -p $XPA plot print filename "foo.ps"
xpaset -p $XPA plot print palette gray
xpaset -p $XPA plot page orientation portrait
xpaset -p $XPA plot page pagescale scaled
xpaset -p $XPA plot page pagesize letter
sleep 1
xpaset -p $XPA plot close

echo "..grid"
xpaset -p $XPA plot new
xpaset -p $XPA plot graph grid yes
xpaset -p $XPA plot graph scale loglog
xpaset -p $XPA plot graph range x auto no
xpaset -p $XPA plot graph range x min 1
xpaset -p $XPA plot graph range x max 100
xpaset -p $XPA plot graph range y auto no
xpaset -p $XPA plot graph range y min 1
xpaset -p $XPA plot graph range y max 100
xpaset -p $XPA plot graph labels title "{The Title}"
xpaset -p $XPA plot graph labels xaxis "{X Axis}"
xpaset -p $XPA plot graph labels yaxis "{Y Axis}"

xpaset -p $XPA plot font numbers font times
xpaset -p $XPA plot font numbers size 12
xpaset -p $XPA plot font numbers style bold
xpaset -p $XPA plot font labels font times
xpaset -p $XPA plot font labels size 12
xpaset -p $XPA plot font labels style bold
xpaset -p $XPA plot font title font times
xpaset -p $XPA plot font title size 12
xpaset -p $XPA plot font title style bold
sleep 1
xpaset -p $XPA plot close

echo "..dataset"
xpaset -p $XPA plot new
cat xy.dat | xpaset $XPA plot data xy
cat xyey.dat | xpaset $XPA plot data xyey
xpaset -p $XPA plot dataset 2

xpaset -p $XPA plot view discrete yes
xpaset -p $XPA plot view line yes
xpaset -p $XPA plot view step yes
xpaset -p $XPA plot view quadratic yes
xpaset -p $XPA plot view errorbar yes

xpaset -p $XPA plot color discrete red
xpaset -p $XPA plot view line green
xpaset -p $XPA plot view step blue
xpaset -p $XPA plot view quadratic cyan
xpaset -p $XPA plot view errorbar yellow

xpaset -p $XPA plot line discrete cross
xpaset -p $XPA plot line line width 2
xpaset -p $XPA plot line line dash yes
xpaset -p $XPA plot line step width 2
xpaset -p $XPA plot line step dash yes
xpaset -p $XPA plot line quadratic width 2
xpaset -p $XPA plot line quadratic dash yes
xpaset -p $XPA plot line errorbar width 2
xpaset -p $XPA plot line errorbar style 2
sleep 1
xpaset -p $XPA plot close

echo "PASSED"
fi

if [ "$1" = "prefs" -o  -z "$1" ]; then
echo "Testing Prefs"
xpaget $XPA prefs mosaicfast > /dev/null
xpaget $XPA prefs bgcolor > /dev/null
xpaget $XPA prefs nancolor > /dev/null
xpaset -p $XPA prefs mosaicfast yes
xpaset -p $XPA prefs bgcolor black
xpaset -p $XPA prefs nancolor red
echo "PASSED"
fi

if [ "$1" = "preserve" -o  -z "$1" ]; then
echo "Testing Preserve"
xpaget $XPA preserve scale > /dev/null
xpaget $XPA preserve pan > /dev/null
xpaget $XPA preserve regions > /dev/null

xpaset -p $XPA prefs scale no
xpaset -p $XPA prefs pan no
xpaset -p $XPA prefs regions no
echo "PASSED"
fi

if [ "$1" = "print" -o  -z "$1" ]; then
echo "Testing Print"
xpaget $XPA print destination > /dev/null
xpaget $XPA print command > /dev/null
xpaget $XPA print palette > /dev/null
xpaget $XPA print level > /dev/null
xpaget $XPA print interpolate > /dev/null
xpaget $XPA print resolution > /dev/null
#xpaset -p $XPA print
xpaset -p $XPA print destination printer
xpaset -p $XPA print command lp
xpaset -p $XPA print filename ds9.ps
xpaset -p $XPA print palette rgb
xpaset -p $XPA print level 2
xpaset -p $XPA print interpolate no
xpaset -p $XPA print resolution 75
echo "PASSED"
fi

if [ "$1" = "regions" -o  -z "$1" ]; then
echo "Testing Regions"
echo "physical;circle(957,1027,40) # tag=foo" | xpaset $XPA regions

xpaget $XPA regions > /dev/null
xpaget $XPA regions fg > /dev/null
xpaget $XPA regions -format pros -system wcs -sky fk5 -skyformat sexagesimal -delim nl > /dev/null
xpaget $XPA regions format > /dev/null
xpaget $XPA regions system > /dev/null
xpaget $XPA regions sky > /dev/null
xpaget $XPA regions skyformat > /dev/null
xpaget $XPA regions strip > /dev/null
xpaget $XPA regions wcs > /dev/null
xpaget $XPA regions shape > /dev/null
xpaget $XPA regions color > /dev/null
xpaget $XPA regions width > /dev/null
xpaget $XPA regions delim > /dev/null
xpaget $XPA regions source > /dev/null
xpaget $XPA regions background > /dev/null
xpaget $XPA regions include > /dev/null
xpaget $XPA regions exclude > /dev/null
xpaget $XPA regions selected > /dev/null
xpaget $XPA regions -prop select yes > /dev/null
xpaget $XPA regions groups > /dev/null
xpaget $XPA regions -group foo > /dev/null

echo "image; circle 100 100 20" | xpaset $XPA regions
echo "image; circle 100 100 20" | xpaset $XPA regions bg
echo "fk5; circle 13:29:55 47:11:50 .5'" | xpaset $XPA regions
echo "physical; ellipse 100 100 20 40" | xpaset $XPA regions
echo "box 100 100 20 40 25" | xpaset $XPA regions
echo "image; line 100 100 200 400" | xpaset $XPA regions
echo "physical; ruler 200 300 200 400" | xpaset $XPA regions
echo "image; text 100 100 # text={Hello, World}" | xpaset $XPA regions
echo "fk4; boxcircle point 13:29:55 47:11:50" | xpaset $XPA regions

xpaset -p $XPA regions move front
xpaset -p $XPA regions move back
xpaset -p $XPA regions select all
xpaset -p $XPA regions select none
xpaset -p $XPA regions select group foo
xpaset -p $XPA regions delete all
xpaset -p $XPA regions delete select
xpaset -p $XPA regions load ds9.physical.reg
xpaset -p $XPA regions delete all
xpaset -p $XPA regions save foo.reg
xpaset -p $XPA regions format ds9
xpaset -p $XPA regions system wcs
xpaset -p $XPA regions sky fk5
xpaset -p $XPA regions skyformat degrees
xpaset -p $XPA regions delim nl
xpaset -p $XPA regions strip yes
xpaset -p $XPA regions wcs yes
xpaset -p $XPA regions shape ellipse
xpaset -p $XPA regions color red
xpaset -p $XPA regions width 2

xpaset -p $XPA regions group foo color red
xpaset -p $XPA regions group foo copy
xpaset -p $XPA regions group foo delete
xpaset -p $XPA regions group foo cut
xpaset -p $XPA regions group foo font {time 14 bold}
xpaset -p $XPA regions group foo move 100 100
xpaset -p $XPA regions group foo movefront
xpaset -p $XPA regions group foo moveback
xpaset -p $XPA regions group foo property delete no
xpaset -p $XPA regions group foo select

xpaset -p $XPA regions delete all
rm -f foo.reg
echo "PASSED"
fi

if [ "$1" = "rgb" -o  -z "$1" ]; then
echo "Testing RGB"
xpaset -p $XPA rgb > /dev/null
xpaget $XPA rgb channel > /dev/null
xpaget $XPA rgb view red > /dev/null
xpaget $XPA rgb view green > /dev/null
xpaget $XPA rgb view blue > /dev/null
xpaget $XPA rgb system > /dev/null
xpaget $XPA rgb lock scale > /dev/null
xpaget $XPA rgb lock bin > /dev/null
xpaget $XPA rgb lock colorbar > /dev/null
xpaset -p $XPA rgb green
xpaset -p $XPA rgb channel blue
xpaset -p $XPA rgb view blue off
xpaset -p $XPA rgb system wcs
xpaset -p $XPA rgb lock bin yes
xpaset -p $XPA rgb lock scale yes
xpaset -p $XPA rgb lock colorbar yes
xpaset -p $XPA frame delete
echo "PASSED"
fi

if [ "$1" = "rotate" -o  -z "$1" ]; then
echo "Testing Rotate"
xpaget $XPA rotate > /dev/null
xpaset -p $XPA rotate to 30
xpaset -p $XPA rotate 15
xpaset -p $XPA frame reset
echo "PASSED"
fi

if [ "$1" = "scale" -o  -z "$1" ]; then
echo "Testing Scale"
xpaget $XPA scale > /dev/null
xpaget $XPA scale limits > /dev/null
xpaget $XPA scale mode > /dev/null
xpaget $XPA scale scope > /dev/null
xpaget $XPA scale datasec > /dev/null
xpaset -p $XPA scale log
xpaset -p $XPA scale squared
xpaset -p $XPA scale sqrt
xpaset -p $XPA scale histequ
xpaset -p $XPA scale linear
xpaset -p $XPA scale minmax
xpaset -p $XPA scale zscale
xpaset -p $XPA scale zmax
xpaset -p $XPA scale user
xpaset -p $XPA scale mode zscale
xpaset -p $XPA scale mode zmax
xpaset -p $XPA scale mode 95
xpaset -p $XPA scale mode minmax
xpaset -p $XPA scale limits 0 100
xpaset -p $XPA scale global
xpaset -p $XPA scale local
xpaset -p $XPA scale scope global
xpaset -p $XPA scale scope local
xpaset -p $XPA scale mode minmax
xpaset -p $XPA scale zscale
xpaset -p $XPA scale datasec yes
echo "PASSED"
fi

if [ "$1" = "save" -o  -z "$1" ]; then
echo "Testing Save Image / Fits / MPEG"
xpaset -p $XPA saveimage fits foo.fits
xpaset -p $XPA saveimage jpeg foo.jpeg
xpaset -p $XPA saveimage tiff foo.tif
xpaset -p $XPA saveimage png foo.png
xpaset -p $XPA saveimage ppm foo.ppm
xpaset -p $XPA saveimage mpeg foo.mpg

xpaset -p $XPA savefits foo.fits
xpaset -p $XPA savempeg foo.mpg
echo "PASSED"
fi

if [ "$1" = "source" -o  -z "$1" ]; then
echo "Testing Source"
xpaset -p $XPA source source.tcl
echo "PASSED"
fi

if [ "$1" = "tcl" -o  -z "$1" ]; then
echo "Testing TCL"
#echo 'set bar "Hello Again, World"' | xpaset $XPA tcl
echo "PASSED"
fi

if [ "$1" = "single" -o  -z "$1" ]; then
echo "Testing Single/Blink/Tile"
xpaget $XPA tile > /dev/null
xpaget $XPA tile mode > /dev/null
xpaget $XPA blink > /dev/null
xpaset -p $XPA file new hst.fits
xpaset -p $XPA file new img16.fits
xpaset -p $XPA blink
xpaset -p $XPA single
xpaset -p $XPA tile
xpaset -p $XPA tile row
xpaset -p $XPA tile column
xpaset -p $XPA tile grid
xpaset -p $XPA single
xpaset -p $XPA frame delete
xpaset -p $XPA frame delete
echo "PASSED"
fi

if [ "$1" = "update" -o  -z "$1" ]; then
echo "Testing Update"
xpaset -p $XPA update
xpaset -p $XPA update 1 100 100 300 400
xpaset -p $XPA update off
xpaset -p $XPA update on
echo "PASSED"
fi

if [ "$1" = "version" -o  -z "$1" ]; then
echo "Testing Version"
xpaget $XPA version > /dev/null
echo "PASSED"
fi

if [ "$1" = "view" -o  -z "$1" ]; then
echo "Testing View"
sleep 1
xpaset -p $XPA frame delete
xpaget $XPA view info > /dev/null
xpaget $XPA view panner > /dev/null
xpaget $XPA view magnifier > /dev/null
xpaget $XPA view buttons > /dev/null
xpaget $XPA view colorbar > /dev/null
xpaget $XPA view horzgraph > /dev/null
xpaget $XPA view vertgraph > /dev/null
xpaget $XPA view horzgraph > /dev/null
xpaget $XPA view filename > /dev/null
xpaget $XPA view object > /dev/null
xpaget $XPA view minmax > /dev/null
xpaget $XPA view frame > /dev/null
xpaget $XPA view wcs > /dev/null
xpaget $XPA view detector > /dev/null
xpaget $XPA view amplifier > /dev/null
xpaget $XPA view physical > /dev/null
xpaget $XPA view image > /dev/null

xpaset -p $XPA view info no
xpaset -p $XPA view info yes
xpaset -p $XPA view panner no
xpaset -p $XPA view panner yes
xpaset -p $XPA view magnifier no
xpaset -p $XPA view magnifier yes
xpaset -p $XPA view buttons no
xpaset -p $XPA view buttons yes
xpaset -p $XPA view colorbar no
xpaset -p $XPA view colorbar yes
xpaset -p $XPA view horzgraph yes
xpaset -p $XPA view horzgraph no
xpaset -p $XPA view vertgraph yes
xpaset -p $XPA view vertgraph no
xpaset -p $XPA view filename no
xpaset -p $XPA view filename yes
xpaset -p $XPA view object yes
xpaset -p $XPA view object no
xpaset -p $XPA view minmax yes
xpaset -p $XPA view minmax no
xpaset -p $XPA view frame no
xpaset -p $XPA view frame yes
xpaset -p $XPA view wcs no
xpaset -p $XPA view wcs yes
xpaset -p $XPA view wcsa yes
xpaset -p $XPA view wcsa no
xpaset -p $XPA view detector yes
xpaset -p $XPA view detector no
xpaset -p $XPA view amplifier yes
xpaset -p $XPA view amplifier no
xpaset -p $XPA view physical no
xpaset -p $XPA view physical yes
xpaset -p $XPA view image no
xpaset -p $XPA view image yes
xpaset -p $XPA file new img16.fits
echo "PASSED"
fi

if [ "$1" = "wcs" -o  -z "$1" ]; then
echo "Testing WCS"
xpaget $XPA wcs > /dev/null
xpaget $XPA wcs system > /dev/null
xpaget $XPA wcs sky > /dev/null
xpaget $XPA wcs skyformat > /dev/null
xpaget $XPA wcs align > /dev/null
xpaset -p $XPA wcs wcs
xpaset -p $XPA wcs align yes
xpaset -p $XPA wcs system wcs
xpaset -p $XPA wcs sky galactic
xpaset -p $XPA wcs skyformat sexagesimal
xpaset -p $XPA wcs align no
xpaset -p $XPA wcs sky fk5
xpaset -p $XPA wcs skyformat degrees
cat image.wcs | xpaset $XPA wcs append
cat image.wcs | xpaset $XPA wcs replace
xpaset -p $XPA wcs append file image.wcs
xpaset -p $XPA wcs replace file image.wcs
xpaset -p $XPA wcs reset
echo "PASSED"
fi

if [ "$1" = "zoom" -o  -z "$1" ]; then
echo "Testing Zoom"
xpaset -p $XPA zoom 2
xpaset -p $XPA zoom to 4
xpaset -p $XPA zoom to fit
xpaget $XPA zoom > /dev/null
xpaset -p $XPA frame reset
echo "PASSED"
fi

if [ -z "$1" ]; then
echo "Testing Exit/Quit"
xpaset -p $XPA quit
echo "PASSED"
fi

echo "DONE"
