#! /bin/sh


# The following two are the ANSI sequences for start and end embolden
case $TERM in
vt*|ansi*|con*|xterm*|linux*|screen*)
  S=[1m
  E=[m
  ;;
*)
  S=
  E=
  ;;
esac

PW_DIR=`pwd`

if test x$UID != x; then
  TRUST="--with-trusted=0,2,$UID"
else
  TRUST="--with-trusted=0,2"
fi

echo; echo "${S}__ STARTING TEST TIMESERVER OPTION __${E}"; echo;
echo Working directory: $PW_DIR

MAKE=`which gmake`
if test "x$?" = x1 ; then
    MAKE="make -s"
else
    MAKE=`which gmake | sed -e "s%\([a-z:]\) .*%\1%g"` 
    if test x$MAKE = x; then
	MAKE="make -s"
    elif test x$MAKE = xno; then
	MAKE="make -s"
    else
	if test "x$MAKE" = "xwhich:"; then
		MAKE="make -s"
	else
		MAKE="gmake -s"
	fi
    fi
fi

echo MAKE is $MAKE
echo


testtime0 ()
{
	#
	# standalone compilation
	#
	echo "${S}Building standalone agent w/timeserver${E}"; echo;
	#
	if test -r "Makefile"; then
		$MAKE distclean
	fi
	#
	${TOP_SRCDIR}/configure --quiet --enable-debug --prefix=$PW_DIR --localstatedir=$PW_DIR --with-config-file=$PW_DIR/test/testrc_1  --with-timeserver=www.foo.bar --with-alttimeserver=127.0.0.1 --with-log-file=$PW_DIR/.samhain_log --with-pid-file=$PW_DIR/.samhain_lock --with-data-file=$PW_DIR/.samhain_file
	#
	if test x$? = x0; then
		echo "configure completed, exit status 0"; echo;
		$MAKE  > /dev/null
		echo "$MAKE completed, exit status $?"; echo;
	else
		echo "ERROR: configure failed"; echo;
	fi


	rm -f $PW_DIR/.samhain_file $PW_DIR/.samhain_log $PW_DIR/.samhain_lock

	./samhain -t init
	
	if test x$? = x0; then
		echo
		echo "${S}init completed${E}"
		echo
		./samhain -t check
		if test x$? = x0; then
		    echo "${S}check completed${E}"
		else
		    echo "${S}ERROR:${E} -- check -- failed, exit status $?"
		    echo
		    exit
		fi
	else
		echo "${S}ERROR:${E} -- init -- failed, exit status $?"; echo;
		exit
	fi

}



	testtime0


echo; echo "${S}__ END TEST TIMESERVER OPTION __${E}"; echo;

exit

