#!/bin/sh
#5 July 96 Dan.Shearer@unisa.edu.au  removed hardcoded values
#7 July 2000 Hiroshi MIURA, add japanese man page

MANDIR=$1
SRCDIR=$2/
if [ $# -ge 3 ] ; then
  GROFF=$3                    # sh cmd line, including options 
fi

echo Installing man pages in $MANDIR
# 'langs' is a list of languages of the translated mans.
# '.' means original version of the document.
# if you feel bad on 'ja', please move man-docs by your hand....
langs=". ja"

for ln in $langs; do
  langdir=$MANDIR/$ln
 for d in $MANDIR $langdir $langdir/man1 $langdir/man5 $langdir/man7 $langdir/man8; do
 if [ ! -d $d ]; then
 mkdir $d
 if [ ! -d $d ]; then
  echo Failed to make directory $d, does $USER have privileges?
  exit 1
 fi
 fi
 done

 for sect in 1 5 7 8 ; do
  for m in $langdir/man$sect ; do
    for s in $SRCDIR../docs/$ln/manpages/*$sect $SRCDIR../docs/$ln/manpages/*$sect.man; do
      FNAME=$m/`basename $s |sed -e 's/\.man//'`
 
      if [ -f $s ]; then
       # Test for writability.  Involves 
       # blowing away existing files.
 
       if (rm -f $FNAME && touch $FNAME); then
         rm $FNAME
         if [ "x$GROFF" = x ] ; then
           cp $s $FNAME          # Copy raw nroff 
         else
           echo "$FNAME"         # groff'ing can be slow, give the user
                                 #   a warm fuzzy.
           $GROFF $s > $FNAME    # Process nroff, because man(1) (on
                                 #   this system) doesn't .
         fi
         chmod 0644 $FNAME
       else
         echo Cannot create $FNAME... does $USER have privileges?
       fi
      fi
    done
  done
 done
done

cat << EOF
======================================================================
The man pages have been installed. You may uninstall them using the command
the command "make uninstallman" or make "uninstall" to uninstall binaries,
man pages and shell scripts.
======================================================================
EOF

exit 0

