#include <stdio.h>
#include <strings.h>

static char *rcsid = "$Id: ana.c,v 1.5 2000/09/26 03:48:23 root Exp $";

/* 
 * $Log: ana.c,v $
 * Revision 1.5  2000/09/26 03:48:23  root
 * #
 *
 * Revision 1.4  2000/09/26 03:44:29  root
 * #
 *
 * Revision 1.3  2000/07/16 13:18:10  root
 * #
 *
 * Revision 1.1  2000/07/16 13:16:33  root
 * #
 *
 * Revision 1.2  1999/09/13 12:37:06  root
 * #
 *
 * Revision 1.1  1999/09/13 12:36:18  root
 * #
 *
 * Revision 1.4  1999/09/02 09:59:02  root
 * #
 *
 * Revision 1.3  1999/09/02 09:58:02  root
 * #
 *
 */

#include <sys/time.h>
#include "nit.h"

#define ETH_ALEN 6
unsigned char pbuf[4096];
int plen;


int
pull_short (unsigned char *c)
{
  int ret;
  ret = *c;
  c++;
  ret <<= 8;
  ret += *c;
  return (ret);
}
unsigned int
pull_long (unsigned char *c)
{
  unsigned int ret;

  ret = *c;
  c++;
  ret <<= 8;
  ret += *c;
  c++;
  ret <<= 8;
  ret += *c;
  c++;
  ret <<= 8;
  ret += *c;

  return (ret);
}

dump_hex (unsigned char *pp, int pl)
{
  while (pl--)
    {
      printf (" %02x", *(pp++));
    }
}

dump_hexa (unsigned char *pp, int pl)
{
  while (pl--)
    {
      int j = *pp;
      if ((j < ' ') || (j > 126))
        j = '.';
      printf (" %02x%c", *pp, j);
      pp++;
    }
}

ana_token (int s, unsigned char *pp, int pl)
{
  int i;
  printf ("    Token 0x%04x:", s);
  switch (s)
    {
    case 0x4003:
      printf (" The mighty zero: %d\n", pull_long (pp));
      return;
    case 0x4006:
      printf (" My MAC addr: %02x:%02x:%02x:%02x:%02x:%02x\n",
              pp[0], pp[1], pp[2], pp[3], pp[4], pp[5]);
      return;
    case 0x4007:
      printf (" My SAP addr: %02x\n", pp[0]);
      return;
    case 0x4009:
      printf (" Frame len: %d\n", pull_short (pp));
      return;
    case 0x400b:
      printf (" The small zero: %d\n", *pp);
      return;
    case 0x400c:
      printf (" Your MAC addr: %02x:%02x:%02x:%02x:%02x:%02x\n",
              pp[0], pp[1], pp[2], pp[3], pp[4], pp[5]);
      return;
    case 0x4011:
      printf (" Block number: %d\n", pull_long (pp));
      return;
    case 0x4018:
      printf (" data block: (ommitted %d bytes of guff)\n", pl);
      return;
    case 0xc005:
      printf (" IDENT: ");
      dump_hexa (pp, pl);
      printf ("\n");
      return;
    case 0xc014:
      printf (" addr block: Load @ 0x%08x, Run @ 0x%08x, Flags: 0x%02x",
              pull_long (pp), pull_long (pp + 4), pp[8]);
      switch (pp[8])
        {
        case 0x20:
          printf (" (More to come)");
          break;
        case 0xc0:
          printf (" (All done, execute)");
          break;
        default:
          printf (" ?");
        }

      printf ("\n");
      return;
    default:
      printf (" ?: ");
      dump_hex (pp, pl);
      printf ("\n");

    }

}

int
ana_frag (unsigned char *pp, int pl)
{
  int s;

  while (pl > 0)
    {

      s = pull_short (pp);

      if (s & 0xc000)
        {
          ana_token (s, pp + 2, pl - 2);
          return;
        }
      else
        {
          ana_frag (pp + 2, s - 2);
          pp += s;
          pl -= s;
        }

    }

}




int
main (int argc, char *argv[])
{
  int i, s;
  char *pptr;
  struct nit *n;
  struct timeval tv;


  if (argc == 2)
    {
      n = nit_open (argv[1]);
    }
  else
    {
      n = nit_open (NULL);
    }

  if (!n)
    {
      printf ("Failed to open network device\n");
    }
  while (!feof (stdin))
    {
      unsigned char from[ETH_ALEN];

      plen = nit_recv (n, pbuf, sizeof (pbuf), from, NULL);
      gettimeofday (&tv, NULL);

      if (
          (pbuf[0] == 0xfc) || (pbuf[1] == 0xfc) ||
          (pbuf[0] == 0xf8) || (pbuf[1] == 0xf8) ||
          (pbuf[0] == 0xf4) || (pbuf[1] == 0xf4))
        {

          printf ("%d.%06d  From %02x:%02x:%02x:%02x:%02x:%02x \n",
                  (int) tv.tv_sec,
                  (int) tv.tv_usec,
                  from[0], from[1], from[2], from[3], from[4], from[5]);
          printf (" Ssap %02x Dsap %02x Cmd %02x Length %d(%d)\n",
                  pbuf[0],
                  pbuf[1], pbuf[2], plen, ntohs (*(short *) &pbuf[3]));


          pptr = pbuf;
          pptr += 5;            /*Length */
          plen -= 5;

          printf ("  ");
          dump_hex (pptr, plen);
          printf ("\n");

          printf ("  Pack Type:");
          switch (pull_short (pptr))
            {
            case 0x1:
              printf (" FIND:");
              break;
            case 0x2:
              printf (" FOUND:");
              break;
            case 0x10:
              printf (" SEND.FILE.REQUEST:");
              break;
            case 0x20:
              printf (" FILE.DATA.RESPONSE:");
              break;
            default:
              printf (" 0x%04x ?:", pull_short (pptr));
            }
          printf (" Length=%d\n", plen);
          pptr += 2;
          plen -= 2;

          s = ana_frag (pptr, plen);


          printf ("\n\n");
        }
    }

  exit (0);

}
