
/*
 * Copyright (C) 1999-2001, Ian Main <imain@stemwinder.org>.
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject
 * to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
 * CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */

#include <roy.h>

void
decode_msg (char *msg, unsigned int len);

void
decode_msg (char *msg, unsigned int len)
{
    RXpDecoder *decoder;
    unsigned int length;
    RBuf *bufval;
    int intval;
    float floatval;
    double doubleval;
    RXpDataType type;


    decoder = rxp_decoder_new (msg, len);
    length = rxp_decoder_msg_length (decoder);
    printf ("total message length is %u bytes\n", length);
    
    while (1) {

        type = rxp_decode_peek_next_type (decoder);
        printf ("next type: %d\n", type);

	if (0 == type) {
	    printf ("peek failed\n");
	    break;
	}

        if (type == RXP_TYPE_RBUF) {
	    if (rxp_decode_rbuf (decoder, &bufval)) {
		printf ("Couldn't decode rbuf.\n");
		break;
	    }
            printf ("received rbuf: '%s'\n", rbuf_str (bufval));
            rbuf_free (bufval);
        } else if (type == RXP_TYPE_NULL_RBUF) {
	    if (rxp_decode_rbuf (decoder, &bufval)) {
		printf ("Couldn't decode NULL rbuf.\n");
		break;
	    }
            printf ("received NULL rbuf\n");
        } else if (type == RXP_TYPE_INT32) {
	    if (rxp_decode_rint32 (decoder, &intval)) {
		printf ("Couldn't decode int32.\n");
		break;
	    }
            printf ("received rint32: %d\n", intval);
        } else if (type == RXP_TYPE_FLOAT) {
	    if (rxp_decode_float (decoder, &floatval)) {
		printf ("Couldn't decode float.\n");
		break;
	    }
            printf ("received float: %f\n", floatval);
        } else if (type == RXP_TYPE_DOUBLE) {
	    if (rxp_decode_double (decoder, &doubleval)) {
		printf ("Couldn't decode double.\n");
		break;
	    }
            printf ("received double: %f\n", doubleval);
        }
    }
}

int main (void)
{
    RXpEncoder *encoder;
    char *buffer;
    int length;

   
    rinit ();
    
    encoder = rxp_encoder_new ();
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("Hello there everyone!"));
    buffer = rxp_encoder_get_buffer (encoder, &length);
    decode_msg (buffer, length);

    rxp_encoder_reset (encoder);
    rxp_encode_rint32 (encoder, 1234567);
    rxp_encode_rint32 (encoder, 1);
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("asdfa;sldkjfa;lsdkfja;lskdjfa;lskdjfa;lskdjfa;lskdjfa;slkdfja;sdlkfj"));
    rxp_encode_rint32 (encoder, -1234567);
    rxp_encode_rint32 (encoder, 1234567);
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("string 1"));
    rxp_encode_rbuf (encoder, rbuf_new_with_str ("string 2"));
    rxp_encode_rbuf (encoder, NULL);
    rxp_encode_rint32 (encoder, 1234567);
    buffer = rxp_encoder_get_buffer (encoder, &length);
    decode_msg (buffer, length);
    

    rxp_encoder_reset (encoder);
    rxp_encode_float (encoder, 1.234F);
    rxp_encode_double (encoder, 678.678);
    buffer = rxp_encoder_get_buffer (encoder, &length);
    decode_msg (buffer, length);

    rxp_encoder_reset (encoder);
    buffer = rxp_encoder_get_buffer (encoder, &length);
    decode_msg (buffer, length);
   
    rxp_encoder_free (encoder);

    rcleanup ();

    return 0;
}



