/*
 *  main.c               - Gwne funkcje programu
 *
 *  Created: 20011213
 *
 *  Copyright (c) 2001 by Tomasz Trojanowski
 *  All rights reserved
 *
 *  $Id: main.c,v 1.22 2002/03/19 23:06:35 tomek Exp $
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <main-window.h>

#include <getopt.h>
#include <locale.h>
#include <intl.h>
#include <globals.h>
#include <database.h>
#include <fields-list.h>
#include <appointment-list.h>
#include <contact-list.h>
#include <appointment-window.h>
#include <contact-window.h>

extern const char version[];

/* Inicjalizuje zmienne globalne. */
static void init_globals()
{
    /* Inicjalizacja zmiennej przechowujcej elementy listy kontaktw. */
    list_params[LT_CONTACT].id_list = g_list_append(list_params[LT_CONTACT].id_list,
                                                    (gpointer)IDCF_ID);
    list_params[LT_CONTACT].id_list = g_list_append(list_params[LT_CONTACT].id_list,
                                                    (gpointer)IDCF_SAVE_AS);
    
    /* Inicjalizacja zmiennej przechowujcej elementy listy terminw. */
    list_params[LT_APPOINTMENT].id_list = g_list_append(list_params[LT_APPOINTMENT].id_list,
                                                        (gpointer)IDAF_ID);
    list_params[LT_APPOINTMENT].id_list = g_list_append(list_params[LT_APPOINTMENT].id_list,
                                                        (gpointer)IDAF_SUMMARY);
}

/* Wypisuje numer wersji programu. */
static void print_version()
{
    g_print(_("rigel version %s\n\n"
              "Copyright (c) 2001 by Tomasz Trojanowski\n"
	      "All rights reserved\n\n"
	      "Reports bugs to <bugs@rigel.un.pl>\n"), version);
}

/* Wypisuje skadni opcji programu. */
static void print_help()
{
    g_print(_("Usage: rigel [OPTIONS]\n\n"
              "  -h, --help        display this help and exit\n"
	      "  -v, --version     output version information and exit\n\n"
	      "Report bugs to <bugs@rigel.un.pl>\n"));
}

/* Parsowanie opcji programu. Zwraca warto, ktra okrela czy program ma
   zakoczy dziznie. */
static int parse_options(int argc, char **argv)
{
    while (1)
    {
        int c;
    
        static struct option long_options[] = {
	    { "help",    no_argument, 0, 'h' },
	    { "version", no_argument, 0, 'v' },
	    { 0, 0, 0, 0 } };
	
	int option_index = 0;
	
	c = getopt_long(argc, argv, "hv", long_options, &option_index);
	
	if (-1 == c)
	    break;
	
	switch (c)
	{
	    case 'h':
	        print_help();
		return TRUE;
	    case 'v':
	        print_version();
		return TRUE;
	    case '?':
	        exit(1);
		return TRUE;
	    default:
	        abort();
	}
    }
    
    return FALSE;
}

int main(int argc, char *argv[])
{
    gtk_set_locale();
    bindtextdomain(PACKAGE, LOCALEDIR);
    textdomain(PACKAGE);

    init_gettext_main_window();    
    init_gettext_appointment_window();
    init_gettext_contact_window();

    /* Parsowanie opcji programu. */
    if (parse_options(argc, argv))
        return 0;
    
    init_globals();

    /* Inicjalizacja bazy danych. */
    db_init();
    
    /* Inicjalizacja biblioteki GTK. */
    gtk_init(&argc, &argv);
    
    /* Utworzenie okienka gwnego programu. */
    create_main_window();
    
    gtk_main();
    
    /* Deinicjalizacja bazy danych. */
    db_close();

    return 0;
}
