# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Kernel", "", "module")
aClass.addFragment(Paragraph.new("The <code>Kernel</code> module is included by class <code>Object</code>, so its methods are available in every Ruby object. The <code>Kernel</code> instance methods are documented in class <code>Object</code> beginning on page 356. This section documents the module methods. These methods are called without a receiver and thus can be called in functional form.\n"))
m0002 = MethodDesc.new("Array", "class", "Array( <em>arg</em> ) -> <i>anArray</i>")
m0002.addFragment(Paragraph.new("Returns <em>arg</em><code>.to_a</code>.\n"))
m0002.addFragment(Verbatim.new("Array(1..5)   \#=> [1, 2, 3, 4, 5]\n"))
aClass.addMethod(m0002)
m0003 = MethodDesc.new("Float", "class", "Float( <em>arg</em> ) -> <i>aFloat</i>")
m0003.addFragment(Paragraph.new("Returns <em>arg</em> converted to a float. Numeric types are converted directly, <code>nil</code> is converted to <code>0.0</code>, and the rest are converted using <em>arg</em>.to_f.\n"))
m0003.addFragment(Verbatim.new("Float(1)           \#=> 1.0\nFloat(nil)         \#=> 0.0\nFloat(\"123.456\")   \#=> 123.456\n"))
aClass.addMethod(m0003)
m0004 = MethodDesc.new("Integer", "class", "Integer( <em>arg</em> ) -> <i>anInteger</i>")
m0004.addFragment(Paragraph.new("Converts <em>arg</em> to a <code>Fixnum</code> or <code>Bignum</code>. Numeric types are converted directly (with floating point numbers being truncated). If <em>arg</em> is a <code>String</code>, leading radix indicators (<code>0</code>, <code>0b</code>, and <code>0x</code>) are honored. This behavior is different from that of <code>String\#to_i</code>.\n"))
m0004.addFragment(Verbatim.new("Integer(123.999)    \#=> 123\nInteger(\"0x1a\")     \#=> 26\nInteger(Time.new)   \#=> 983770240\n"))
aClass.addMethod(m0004)
m0005 = MethodDesc.new("String", "class", "String( <em>arg</em> ) -> <i>aString</i>")
m0005.addFragment(Paragraph.new("Converts <em>arg</em> to a <code>String</code> by calling its <code>to_s</code> method.\n"))
m0005.addFragment(Verbatim.new("String(self)        \#=> \"main\"\nString(self.type)   \#=> \"Object\"\nString(123456)      \#=> \"123456\"\n"))
aClass.addMethod(m0005)
m0006 = MethodDesc.new("`", "class", "`<em>cmd</em>` -> <i>aString</i>")
m0006.addFragment(Paragraph.new("Returns the standard output of running <em>cmd</em> in a subshell. The built-in syntax <code>%x{...}</code> described on page 75 uses this method.\n"))
m0006.addFragment(Verbatim.new("`date`                  \#=> \"Sun Mar  4 23:30:40 CST 2001\\n\"\n`ls testdir`.split[1]   \#=> \"main.rb\"\n"))
aClass.addMethod(m0006)
m0007 = MethodDesc.new("abort", "class", "abort")
m0007.addFragment(Paragraph.new("Terminate execution immediately, effectively by calling <code>Kernel.exit(1)</code>.\n"))
aClass.addMethod(m0007)
m0008 = MethodDesc.new("at_exit", "class", "at_exit { block } -> <i>aProc</i>")
m0008.addFragment(Paragraph.new("Converts <em>block</em> to a <code>Proc</code> object (and therefore binds it at the point of call) and registers it for execution when the program exits. If multiple handlers are registered, they are executed in reverse order of registration.\n"))
m0008.addFragment(Verbatim.new("def do_at_exit(str1)\n  at_exit { print str1 }\nend\nat_exit { puts \"cruel world\" }\ndo_at_exit(\"goodbye \")\nexit"))
m0008.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0008.addFragment(Verbatim.new("goodbye cruel world"))
aClass.addMethod(m0008)
m0009 = MethodDesc.new("autoload", "class", "autoload( <i>aModule</i>, <i>aFile</i> ) -> <code>nil</code>")
m0009.addFragment(Paragraph.new("Registers <i>aFile</i> to be loaded (using <code>Kernel::require</code>) the first time that <i>aModule</i> (which may be a <code>String</code> or a symbol) is accessed.\n"))
m0009.addFragment(Verbatim.new("autoload :MyModule, \"/usr/local/lib/modules/my_module.rb\""))
aClass.addMethod(m0009)
m0010 = MethodDesc.new("binding", "class", "binding -> <i>aBinding</i>")
m0010.addFragment(Paragraph.new("Returns a <code>Binding</code> object, describing the variable and method bindings at the point of call. This object can be used when calling <code>eval</code> to execute the evaluated command in this environment. Also see the description of <code>Binding</code> beginning on page 295.\n"))
m0010.addFragment(Verbatim.new("def getBinding(param)\n  return binding\nend\nb = getBinding(\"hello\")\neval \"param\", b   \#=> \"hello\"\n"))
aClass.addMethod(m0010)
m0011 = MethodDesc.new("block_given?", "class", "block_given? -> <code>true</code> or <code>false</code>")
m0011.addFragment(Paragraph.new("Returns <code>true</code> if <code>yield</code> would execute a block in the current context.\n"))
m0011.addFragment(Verbatim.new("def try\n  if block_given?\n    yield\n  else\n    \"no block\"\n  end\nend\ntry               \#=> \"no block\"\ntry { \"hello\" }   \#=> \"hello\"\ntry do\n  \"hello\"\nend\n"))
aClass.addMethod(m0011)
m0012 = MethodDesc.new("callcc", "class", "callcc {| cont | block } -> <i>anObject</i>")
m0012.addFragment(Paragraph.new("Generates a <code>Continuation</code> object, which it passes to the associated block. Performing a <em>cont</em><code>.call</code> will cause the <code>callcc</code> to return (as will falling through the end of the block). The value returned by the <code>callcc</code> is the value of the block, or the value passed to <em>cont</em><code>.call</code>. See <code>Continuation</code> on page 298 for more details. Also see <code>Kernel::throw</code> for an alternative mechanism for unwinding a call stack.\n"))
aClass.addMethod(m0012)
m0013 = MethodDesc.new("caller", "class", "caller( <i>[</i><i>anInteger</i><i>]</i> ) -> <i>anArray</i>")
m0013.addFragment(Paragraph.new("Returns the current execution stack---an array containing strings in the form ``<em>file:line</em>'' or ``<em>file:line: in `method'</em>''. The optional <em>anInteger</em> parameter determines the number of initial stack entries to omit from the result.\n"))
m0013.addFragment(Verbatim.new("def a(skip)\n  caller(skip)\nend\ndef b(skip)\n  a(skip)\nend\ndef c(skip)\n  b(skip)\nend\nc(0)   \#=> [\"prog:2:in `a'\", \"prog:5:in `b'\", \"prog:8:in `c'\", \"prog:10\"]\nc(1)   \#=> [\"prog:5:in `b'\", \"prog:8:in `c'\", \"prog:11\"]\nc(2)   \#=> [\"prog:8:in `c'\", \"prog:12\"]\nc(3)   \#=> [\"prog:13\"]\n"))
aClass.addMethod(m0013)
m0014 = MethodDesc.new("catch", "class", "catch( <em>symbol</em> ) {| | block } <p></p> -> anObject")
m0014.addFragment(Paragraph.new("<code>catch</code> executes its block. If a <code>throw</code> is executed, Ruby searches up its stack for a <code>catch</code> block with a tag corresponding to the <code>throw</code>'s <em>symbol</em>. If found, that block is terminated, and <code>catch</code> returns the value given to <code>throw</code>. If <code>throw</code> is not called, the block terminates normally, and the value of <code>catch</code> is the value of the last expression evaluated. <code>catch</code> expressions may be nested, and the <code>throw</code> call need not be in lexical scope.\n"))
m0014.addFragment(Verbatim.new("def routine(n)\n  puts n\n  throw :done if n <= 0\n  routine(n-1)\nend\n\n\ncatch(:done) { routine(3) }"))
m0014.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0014.addFragment(Verbatim.new("3\n2\n1\n0"))
aClass.addMethod(m0014)
m0015 = MethodDesc.new("chomp", "class", "chomp( <i>[</i><i>aString</i><i>]</i> ) -> $_ or <em>aString</em>")
m0015.addFragment(Paragraph.new("Equivalent to <code>$_ = $_.chomp(<em>aString</em>)</code>. See <code>String\#chomp</code> on page 372.\n"))
m0015.addFragment(Verbatim.new("$_ = \"now\\n\"\nchomp         \#=> \"now\"\n$_            \#=> \"now\"\nchomp \"ow\"    \#=> \"n\"\n$_            \#=> \"n\"\nchomp \"xxx\"   \#=> \"n\"\n$_            \#=> \"n\"\n"))
aClass.addMethod(m0015)
m0016 = MethodDesc.new("chomp!", "class", "chomp!( <i>[</i><i>aString</i><i>]</i> ) -> $_ or <code>nil</code>")
m0016.addFragment(Paragraph.new("Equivalent to <code>$_.chomp!(<em>aString</em>)</code>. See <code>String\#chomp!</code>\n"))
m0016.addFragment(Verbatim.new("$_ = \"now\\n\"\nchomp!       \#=> \"now\"\n$_           \#=> \"now\"\nchomp! \"x\"   \#=> nil\n$_           \#=> \"now\"\n"))
aClass.addMethod(m0016)
m0017 = MethodDesc.new("chop", "class", "chop -> <em>aString</em>")
m0017.addFragment(Paragraph.new("Equivalent to <code>($_.dup).chop!</code>, except <code>nil</code> is never returned. See <code>String\#chop!</code> on page 372.\n"))
m0017.addFragment(Verbatim.new("a  =  \"now\\r\\n\"\n$_ = a\nchop   \#=> \"now\"\n$_     \#=> \"now\"\nchop   \#=> \"no\"\nchop   \#=> \"n\"\nchop   \#=> \"\"\nchop   \#=> \"\"\na      \#=> \"now\\r\\n\"\n"))
aClass.addMethod(m0017)
m0018 = MethodDesc.new("chop!", "class", "chop! -> $_ or <code>nil</code>")
m0018.addFragment(Paragraph.new("Equivalent to <code>$_.chop!</code>.\n"))
m0018.addFragment(Verbatim.new("a  = \"now\\r\\n\"\n$_ = a\nchop!   \#=> \"now\"\nchop!   \#=> \"no\"\nchop!   \#=> \"n\"\nchop!   \#=> \"\"\nchop!   \#=> nil\n$_      \#=> \"\"\na       \#=> \"\"\n"))
aClass.addMethod(m0018)
m0019 = MethodDesc.new("eval", "class", "eval( <em>aString</em> <i>[</i>, <em>aBinding</em> <i>[</i><em>file</em> <i>[</i><em>line</em><i>]</i><i>]</i><i>]</i>) -> <i>anObject</i>")
m0019.addFragment(Paragraph.new("Evaluates the Ruby expression(s) in <em>aString</em>. If <em>aBinding</em> is given, the evaluation is performed in its context. The binding may be a <code>Binding</code> object or a <code>Proc</code> object. If the optional <em>file</em> and <em>line</em> parameters are present, they will be used when reporting syntax errors.\n"))
m0019.addFragment(Verbatim.new("def getBinding(str)\n  return binding\nend\nstr = \"hello\"\neval \"str + ' Fred'\"                      \#=> \"hello Fred\"\neval \"str + ' Fred'\", getBinding(\"bye\")   \#=> \"bye Fred\"\n"))
aClass.addMethod(m0019)
m0020 = MethodDesc.new("exec", "class", "exec( <em>command</em> <i>[</i>, <em>args</em><i>]</i>)")
m0020.addFragment(Paragraph.new("Replaces the current process by running the given external command. If <code>exec</code> is given a single argument, that argument is taken as a line that is subject to shell expansion before being executed. If multiple arguments are given, the second and subsequent arguments are passed as parameters to <em>command</em> with no shell expansion. If the first argument is a two-element array, the first element is the command to be executed, and the second argument is used as the <code>argv[0]</code> value, which may show up in process listings. In MSDOS environments, the command is executed in a subshell; otherwise, one of the <code>exec(2)</code> system calls is used, so the running command may inherit some of the environment of the original program (including open file descriptors).\n"))
m0020.addFragment(Verbatim.new("exec \"echo *\"       \# echoes list of files in current directory\n\# never get here\n\n\nexec \"echo\", \"*\"    \# echoes an asterisk\n\# never get here"))
aClass.addMethod(m0020)
m0021 = MethodDesc.new("exit", "class", "exit( <i>anInteger</i>=0 )")
m0021.addFragment(Paragraph.new("Initiates the termination of the Ruby script by raising the <code>SystemExit</code> exception. This exception may be caught. The optional parameter is used to return a status code to the invoking environment.\n"))
m0021.addFragment(Verbatim.new("begin\n  exit\n  puts \"never get here\"\nrescue SystemExit\n  puts \"rescued a SystemExit exception\"\nend\nputs \"after begin block\""))
m0021.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0021.addFragment(Verbatim.new("rescued a SystemExit exception\nafter begin block"))
m0021.addFragment(Paragraph.new("Just prior to termination, Ruby executes any <code>at_exit</code> functions and runs any object finalizers (see <code>ObjectSpace</code> beginning on page 434).\n"))
m0021.addFragment(Verbatim.new("at_exit { puts \"at_exit function\" }\nObjectSpace.define_finalizer(self,  proc { puts \"in finalizer\" })\nexit"))
m0021.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0021.addFragment(Verbatim.new("at_exit function\n0x4019ac90\nn finals=>0"))
aClass.addMethod(m0021)
m0022 = MethodDesc.new("exit!", "class", "exit!( <i>anInteger</i>=-1 )")
m0022.addFragment(Paragraph.new("Similar to <code>Kernel::exit</code>, but exception handling, <code>at_exit</code> functions, and finalizers are bypassed.\n"))
aClass.addMethod(m0022)
m0023 = MethodDesc.new("fail", "class", "fail<br></br>fail( <i>aString</i> )<br></br>fail( <i>anException</i> <i>[</i>, <i>aString</i> <i>[</i><i>anArray</i><i>]</i><i>]</i> )")
m0023.addFragment(Paragraph.new("Synonym for <code>Kernel::raise</code>.\n"))
aClass.addMethod(m0023)
m0024 = MethodDesc.new("fork", "class", "fork <i>[</i>{ block } <i>]</i> -> <i>aFixnum</i> or <code>nil</code>")
m0024.addFragment(Paragraph.new("Creates a subshell. If a block is specified, that block is run in the subshell, and the subshell terminates with a status of zero. Otherwise, the <code>fork</code> call returns twice, once in the parent, returning the process id of the child, and once in the child, returning <code>nil</code>. The child process can exit using <code>Kernel::exit!</code> to avoid running any <code>at_exit</code> functions. The parent process should use <code>Process::wait</code> to collect the termination statuses of its children; otherwise, the operating system may accumulate zombie processes.\n"))
m0024.addFragment(Verbatim.new("fork do\n  3.times {|i| puts \"Child: \#{i}\" }\nend\n3.times {|i| puts \"Parent: \#{i}\" }\nProcess.wait"))
m0024.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0024.addFragment(Verbatim.new("Parent: 0\nChild: 0\nChild: 1\nParent: 1\nParent: 2\nChild: 2"))
aClass.addMethod(m0024)
m0025 = MethodDesc.new("format", "class", "format( <i>aString</i> <i>[</i>, <i>anObject</i><i>]*</i> ) -> <i>aString</i>")
m0025.addFragment(Paragraph.new("Synonym for <code>Kernel::sprintf</code>.\n"))
aClass.addMethod(m0025)
m0026 = MethodDesc.new("gets", "class", "gets( <i>aString</i>=<code>$/</code> ) -> <i>aString</i> or <code>nil</code>")
m0026.addFragment(Paragraph.new("Returns (and assigns to <code>$_</code>) the next line from the list of files in <code>ARGV</code> (or <code>$*</code>), or from standard input if no files are present on the command line. Returns <code>nil</code> at end of file. The optional argument specifies the record separator. The separator is included with the contents of each record. A separator of <code>nil</code> reads the entire contents, and a zero-length separator reads the input one paragraph at a time, where paragraphs are divided by two consecutive newlines. If multiple filenames are present in <code>ARGV</code>, <code>gets(nil)</code> will read the contents one file at a time.\n"))
m0026.addFragment(Verbatim.new("ARGV << \"testfile\"\nprint while gets"))
m0026.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0026.addFragment(Verbatim.new("This is line one\nThis is line two\nThis is line three\nAnd so on..."))
aClass.addMethod(m0026)
m0027 = MethodDesc.new("global_variables", "class", "global_variables -> <i>anArray</i>")
m0027.addFragment(Paragraph.new("Returns an array of the names of global variables.\n"))
m0027.addFragment(Verbatim.new("global_variables.grep /std/   \#=> [\"$stderr\", \"$stdout\", \"$stdin\"]\n"))
aClass.addMethod(m0027)
m0028 = MethodDesc.new("gsub", "class", "gsub( <i>pattern</i>, <i>replacement</i> ) -> <i>aString</i><br></br>gsub( <i>pattern</i> ) {| | block } <p></p> -> <i>aString</i>")
m0028.addFragment(Paragraph.new("Equivalent to <code>$_.gsub...</code>, except that <code>$_</code> receives the modified result.\n"))
m0028.addFragment(Verbatim.new("$_ = \"quick brown fox\"\ngsub /[aeiou]/, '*'   \#=> \"q**ck br*wn f*x\"\n$_                    \#=> \"q**ck br*wn f*x\"\n"))
aClass.addMethod(m0028)
m0029 = MethodDesc.new("gsub!", "class", "gsub!( <i>pattern</i>, <i>replacement</i> ) -> <i>aString</i> or <code>nil</code><br></br>gsub!( <i>pattern</i> ) {| | block } <p></p> -> <i>aString</i> or <code>nil</code>")
m0029.addFragment(Paragraph.new("Equivalent to <code>Kernel::gsub</code>, except <code>nil</code> is returned if <code>$_</code> is not modified.\n"))
m0029.addFragment(Verbatim.new("$_ = \"quick brown fox\"\ngsub! /cat/, '*'   \#=> nil\n$_                 \#=> \"quick brown fox\"\n"))
aClass.addMethod(m0029)
m0030 = MethodDesc.new("iterator?", "class", "iterator? -> <code>true</code> or <code>false</code>")
m0030.addFragment(Paragraph.new("Synonym for <code>Kernel::block_given?</code>. The <code>iterator?</code> method will be removed in Ruby 1.8.\n"))
aClass.addMethod(m0030)
m0031 = MethodDesc.new("lambda", "class", "lambda {| | block } -> <i>aProc</i>")
m0031.addFragment(Paragraph.new("Synonym for <code>Kernel::proc</code>.\n"))
aClass.addMethod(m0031)
m0032 = MethodDesc.new("load", "class", "load( <i>aFileName</i>, <i>wrap</i>=<code>false</code> ) -> <code>true</code>")
m0032.addFragment(Paragraph.new("Loads and executes the Ruby program in the file <i>aFileName</i>. If the filename does not resolve to an absolute path, the file is searched for in the library directories listed in <code>$:</code>. If the optional <i>wrap</i> parameter is <code>true</code>, the loaded script will be executed under an anonymous module, protecting the calling program's global namespace. Any local variables in the loaded file will not be propagated to the loading environment.\n"))
aClass.addMethod(m0032)
m0033 = MethodDesc.new("local_variables", "class", "local_variables -> <i>anArray</i>")
m0033.addFragment(Paragraph.new("Returns the names of the current local variables.\n"))
m0033.addFragment(Verbatim.new("fred = 1\nfor i in 1..10\n   \# ...\nend\nlocal_variables   \#=> [\"fred\", \"i\"]\n"))
aClass.addMethod(m0033)
m0034 = MethodDesc.new("loop", "class", "loop {| | block } <p></p>")
m0034.addFragment(Paragraph.new("Repeatedly executes the block.\n"))
m0034.addFragment(Verbatim.new("loop {\n  print \"Input: \"\n  break if !gets or $_ =~ /^qQ/\n  \# ...\n}"))
aClass.addMethod(m0034)
m0035 = MethodDesc.new("open", "class", "open( <i>aString</i> <i>[</i>, <i>aMode</i> <i>[</i><i>perm</i><i>]</i><i>]</i> ) -> <i>anIO</i> or <code>nil</code><br></br>open( <i>aString</i> <i>[</i>, <i>aMode</i> <i>[</i><i>perm</i><i>]</i><i>]</i> ) {| anIO | block } <p></p> -> <code>nil</code>")
m0035.addFragment(Paragraph.new("Creates an <code>IO</code> object connected to the given stream, file, or subprocess.\n"))
m0035.addFragment(Paragraph.new("If <i>aString</i> does not start with a pipe character (``<code>|</code>''), treat it as the name of a file to open using the specified mode defaulting to ``<code>r</code>'' (see the table of valid modes on page 331). If a file is being created, its initial permissions may be set using the integer third parameter.\n"))
m0035.addFragment(Paragraph.new("If a block is specified, it will be invoked with the <code>File</code> object as a parameter, and the file will be automatically closed when the block terminates. The call always returns <code>nil</code> in this case.\n"))
m0035.addFragment(Paragraph.new("If <i>aString</i> starts with a pipe character, a subprocess is created, connected to the caller by a pair of pipes. The returned <code>IO</code> object may be used to write to the standard input and read from the standard output of this subprocess. If the command following the ``<code>|</code>'' is a single minus sign, Ruby forks, and this subprocess is connected to the parent. In the subprocess, the <code>open</code> call returns <code>nil</code>. If the command is not ``<code>-</code>'', the subprocess runs the command. If a block is associated with an <code>open(\"|-\")</code> call, that block will be run twice---once in the parent and once in the child. The block parameter will be an <code>IO</code> object in the parent and <code>nil</code> in the child. The parent's <code>IO</code> object will be connected to the child's <code>$stdin</code> and <code>$stdout</code>. The subprocess will be terminated at the end of the block.\n"))
m0035.addFragment(Verbatim.new("open(\"testfile\") do |f|\n  print f.gets\nend"))
m0035.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0035.addFragment(Verbatim.new("This is line one"))
m0035.addFragment(Paragraph.new("Open a subprocess and read its output:\n"))
m0035.addFragment(Verbatim.new("cmd = open(\"|date\")\nprint cmd.gets\ncmd.close"))
m0035.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0035.addFragment(Verbatim.new("Sun Mar  4 23:30:41 CST 2001"))
m0035.addFragment(Paragraph.new("Open a subprocess running the same Ruby program:\n"))
m0035.addFragment(Verbatim.new("f = open(\"|-\", \"w+\")\nif f == nil\n  puts \"in Child\"\n  exit\nelse\n  puts \"Got: \#{f.gets}\"\nend"))
m0035.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0035.addFragment(Verbatim.new("Got: in Child"))
m0035.addFragment(Paragraph.new("Open a subprocess using a block to receive the I/O object:\n"))
m0035.addFragment(Verbatim.new("open(\"|-\") do |f|\n  if f == nil\n    puts \"in Child\"\n  else\n    puts \"Got: \#{f.gets}\"\n  end\nend"))
m0035.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0035.addFragment(Verbatim.new("Got: in Child"))
aClass.addMethod(m0035)
m0036 = MethodDesc.new("p", "class", "p( <i>[</i><i>anObject</i><i>]+></i> ) -> <code>nil</code>")
m0036.addFragment(Paragraph.new("For each object, directly writes <code><i>anObject</i>.inspect</code> followed by the current output record separator to the program's standard output. <code>p</code> bypasses the Ruby I/O libraries.\n"))
m0036.addFragment(Verbatim.new("p self"))
m0036.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0036.addFragment(Verbatim.new("main"))
aClass.addMethod(m0036)
m0037 = MethodDesc.new("print", "class", "print( <i>[</i><i>anObject</i><i>]*</i> ) -> <code>nil</code>")
m0037.addFragment(Paragraph.new("Prints each object in turn to <code>$defout</code>. If the output field separator (<code>$,</code>) is not <code>nil</code>, its contents will appear between each field. If the output record separator (<code>$\\</code>) is not <code>nil</code>, it will be appended to the output. If no arguments are given, prints <code>$_</code>. Objects that aren't strings will be converted by calling their <code>to_s</code> method.\n"))
m0037.addFragment(Verbatim.new("print \"cat\", [1,2,3], 99, \"\\n\"\n$, = \", \"\n$\\ = \"\\n\"\nprint \"cat\", [1,2,3], 99"))
m0037.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0037.addFragment(Verbatim.new("cat12399\ncat, 1, 2, 3, 99"))
aClass.addMethod(m0037)
m0038 = MethodDesc.new("printf", "class", "printf( <i>anIO</i>, <i>aString</i> <i>[</i>, <i>anObject</i><i>]*</i> ) -> <code>nil</code><br></br>printf( <i>aString</i> <i>[</i>, <i>anObject</i><i>]*</i> ) -> <code>nil</code>")
m0038.addFragment(Paragraph.new("Equivalent to:\n"))
m0038.addFragment(Paragraph.new("<i>anIO.</i><code>write sprintf(</code><i>aString, anObject</i><code>...)</code><em>or</em><code>$defout.write sprintf(</code><i>aString, anObject</i><code>...)</code>\n"))
aClass.addMethod(m0038)
m0039 = MethodDesc.new("proc", "class", "proc { block } -> <i>aProc</i>")
m0039.addFragment(Paragraph.new("Creates a new procedure object from the given block. Equivalent to <code>Proc::new</code>.\n"))
m0039.addFragment(Verbatim.new("aProc = proc { \"hello\" }\naProc.call   \#=> \"hello\"\n"))
aClass.addMethod(m0039)
m0040 = MethodDesc.new("putc", "class", "putc( <i>anInteger</i> ) -> <i>anInteger</i>")
m0040.addFragment(Paragraph.new("Equivalent to <code>$defout.putc(</code><i>anInteger</i><code>)</code>.\n"))
aClass.addMethod(m0040)
m0041 = MethodDesc.new("puts", "class", "puts( <i>[</i><i>args</i><i>]*</i> ) -> <code>nil</code>")
m0041.addFragment(Paragraph.new("Equivalent to <code>$defout.puts(</code><i>args</i><code>)</code>.\n"))
aClass.addMethod(m0041)
m0042 = MethodDesc.new("raise", "class", "raise<br></br>raise( <i>aString</i> )<br></br>raise( <i>anException</i> <i>[</i>, <i>aString</i> <i>[</i><i>anArray</i><i>]</i><i>]</i> )")
m0042.addFragment(Paragraph.new("With no arguments, raises the exception in <code>$!</code> or raises a <code>RuntimeError</code> if <code>$!</code> is <code>nil</code>. With a single <code>String</code> argument, raises a <code>RuntimeError</code> with the string as a message. Otherwise, the first parameter should be the name of an <code>Exception</code> class (or an object that returns an <code>Exception</code> when sent <code>exception</code>). The optional second parameter sets the message associated with the exception, and the third parameter is an array of callback information. Exceptions are caught by the <code>rescue</code> clause of <code>begin...end</code> blocks.\n"))
m0042.addFragment(Verbatim.new("raise \"Failed to create socket\"\nraise ArgumentError, \"No parameters\", caller"))
aClass.addMethod(m0042)
m0043 = MethodDesc.new("rand", "class", "rand( <i>max</i>=0 ) -> <i>aNumber</i>")
m0043.addFragment(Paragraph.new("Converts <i>max</i> to an integer using max1 = max<code>.to_i.abs</code>. If the result is zero, returns a pseudorandom floating point number greater than or equal to 0.0 and less than 1.0. Otherwise, returns a pseudorandom integer greater than or equal to zero and less than max1. <code>Kernel::srand</code> may be used to ensure repeatable sequences of random numbers between different runs of the program.\n"))
m0043.addFragment(Verbatim.new("srand 1234                 \#=> 0\n[ rand,  rand ]            \#=> [0.7408769294, 0.2145348572]\n[ rand(10), rand(1000) ]   \#=> [3, 323]\nsrand 1234                 \#=> 1234\n[ rand,  rand ]            \#=> [0.7408769294, 0.2145348572]\n"))
aClass.addMethod(m0043)
m0044 = MethodDesc.new("readline", "class", "readline( <i>[</i><i>aString</i>=<code>$/</code><i>]</i> ) -> <i>aString</i>")
m0044.addFragment(Paragraph.new("Equivalent to <code>Kernel::gets</code>, except <code>readline</code> raises <code>EOFError</code> at end of file.\n"))
aClass.addMethod(m0044)
m0045 = MethodDesc.new("readlines", "class", "readlines( <i>[</i><i>aString</i>=<code>$/</code><i>]</i> ) -> <i>anArray</i>")
m0045.addFragment(Paragraph.new("Returns an array containing the lines returned by calling <code>Kernel.gets(<i>aString</i>)</code> until the end of file.\n"))
aClass.addMethod(m0045)
m0046 = MethodDesc.new("require", "class", "require( <i>aString</i> ) -> <code>true</code> or <code>false</code>")
m0046.addFragment(Paragraph.new("Ruby tries to load the library named <i>aString</i>, returning <code>true</code> if successful. If the filename does not resolve to an absolute path, it will be searched for in the directories listed in <code>$:</code>. If the file has the extension ``.rb'', it is loaded as a source file; if the extension is ``.so'', ``.o'', or ``.dll'',<em>[Or whatever the default shared library extension is on the current platform.]</em> Ruby loads the shared library as a Ruby extension. Otherwise, Ruby tries adding ``.rb'', ``.so'', and so on to the name. The name of the loaded feature is added to the array in <code>$\"</code>. A feature will not be loaded if it already appears in <code>$\"</code>. <code>require</code> returns <code>true</code> if the feature was successfully loaded.\n"))
m0046.addFragment(Verbatim.new("require \"my-library.rb\"\nrequire \"db-driver\""))
aClass.addMethod(m0046)
m0047 = MethodDesc.new("scan", "class", "scan( <i>pattern</i> ) -> <i>anArray</i><br></br>scan( <i>pattern</i> ) {| | block } -> $_")
m0047.addFragment(Paragraph.new("Equivalent to calling <code>$_.scan</code>. See <code>String\#scan</code> on page 378.\n"))
aClass.addMethod(m0047)
m0048 = MethodDesc.new("select", "class", "select( <i>readArray</i> <i>[</i>, <i>writeArray</i> <i>[</i><i>errorArray</i> <i>[</i><i>timeout</i><i>]</i><i>]</i><i>]</i> ) -> <i>anArray</i> or <code>nil</code>")
m0048.addFragment(Paragraph.new("Performs a low-level <code>select</code> call, which waits for data to become available from input/output devices. The first three parameters are arrays of <code>IO</code> objects or <code>nil</code>. The last is a timeout in seconds, which should be an <code>Integer</code> or a <code>Float</code>. The call waits for data to become available for any of the <code>IO</code> objects in <i>readArray</i>, for buffers to have cleared sufficiently to enable writing to any of the devices in <i>writeArray</i>, or for an error to occur on the devices in <i>errorArray</i>. If one or more of these conditions are met, the call returns a three-element array containing arrays of the <code>IO</code> objects that were ready. Otherwise, if there is no change in status for <i>timeout</i> seconds, the call returns <code>nil</code>. If all parameters are <code>nil</code>, the current thread sleeps forever.\n"))
m0048.addFragment(Verbatim.new("select( [$stdin], nil, nil, 1.5 )   \#=> [[\#<IO:0x4019202c>], [], []]\n"))
aClass.addMethod(m0048)
m0049 = MethodDesc.new("set_trace_func", "class", "set_trace_func( <i>aProc</i> ) -> <i>aProc</i><br></br>set_trace_func( <code>nil</code> ) -> <code>nil</code>")
m0049.addFragment(Paragraph.new("Establishes <i>aProc</i> as the handler for tracing, or disables tracing if the parameter is <code>nil</code>. <i>aProc</i> takes up to six parameters: an event name, a filename, a line number, an object id, a binding, and the name of a class. <i>aProc</i> is invoked whenever an event occurs. Events are: <code>c-call</code> (call a C-language routine), <code>c-return</code> (return from a C-language routine), <code>call</code> (call a Ruby method), <code>class</code> (start a class or module definition), <code>end</code> (finish a class or module definition), <code>line</code> (execute code on a new line), <code>raise</code> (raise an exception), and <code>return</code> (return from a Ruby method). Tracing is disabled within the context of <i>aProc</i>.\n"))
m0049.addFragment(Paragraph.new("See the example starting on page 271 for more information.\n"))
aClass.addMethod(m0049)
m0050 = MethodDesc.new("singleton_method_added", "class", "singleton_method_added( <i>aFixnum</i> ) -> <code>nil</code>")
m0050.addFragment(Paragraph.new("Invoked with a symbol id whenever a singleton method is added to a module or a class. The default implementation in <code>Kernel</code> ignores this, but subclasses may override the method to provide specialized functionality.\n"))
m0050.addFragment(Verbatim.new("class Test\n  def Test.singleton_method_added(id)\n    puts \"Added \#{id.id2name} to Test\"\n  end\n  def a() end\n  def Test.b() end\nend\ndef Test.c() end"))
m0050.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0050.addFragment(Verbatim.new("Added singleton_method_added to Test\nAdded b to Test\nAdded c to Test"))
aClass.addMethod(m0050)
m0051 = MethodDesc.new("sleep", "class", "sleep( <i>[</i><i>aNumeric</i><i>]</i> ) -> <i>aFixnum</i>")
m0051.addFragment(Paragraph.new("Suspends the current thread for <i>aNumber</i> seconds (which may be a <code>Float</code> with fractional seconds). Returns the actual number of seconds slept (rounded), which may be less than that asked for if the thread was interrupted by a <code>SIGALRM</code>, or if another thread calls <code>Thread\#run</code>. An argument of zero causes <code>sleep</code> to sleep forever.\n"))
m0051.addFragment(Verbatim.new("Time.new    \#=> Sun Mar 04 23:30:41 CST 2001\nsleep 1.2   \#=> 2\nTime.new    \#=> Sun Mar 04 23:30:43 CST 2001\nsleep 1.9   \#=> 2\nTime.new    \#=> Sun Mar 04 23:30:45 CST 2001\n"))
aClass.addMethod(m0051)
m0052 = MethodDesc.new("split", "class", "split( <i>[</i><i>pattern</i> <i>[</i><i>limit</i><i>]</i><i>]</i> ) -> <i>anArray</i>")
m0052.addFragment(Paragraph.new("Equivalent to <code>$_.split(<i>pattern</i>, <i>limit</i>)</code>. See <code>String\#split</code> on page 379.\n"))
aClass.addMethod(m0052)
m0053 = MethodDesc.new("sprintf", "class", "sprintf( <i>aFormatString</i> <i>[</i>, <i>arguments</i><i>]*</i> ) -> <i>aString</i>")
m0053.addFragment(Paragraph.new("Returns the string resulting from applying <i>aFormatString</i> to any additional arguments. Within the format string, any characters other than format sequences are copied to the result. A format sequence consists of a percent sign, followed by optional flags, width, and precision indicators, then terminated with a field type character. The field type controls how the corresponding <code>sprintf</code> argument is to be interpreted, while the flags modify that interpretation. The flag characters are shown in Table 23.1 on page 428, and the field type characters are listed in Table 23.2.\n"))
m0053.addFragment(Paragraph.new("The field width is an optional integer, followed optionally by a period and a precision. The width specifies the minimum number of characters that will be written to the result for this field. For numeric fields, the precision controls the number of decimal places displayed. For string fields, the precision determines the maximum number of characters to be copied from the string. (Thus, the format sequence <code>%10.10s</code> will always contribute exactly ten characters to the result.)\n"))
m0053.addFragment(Verbatim.new("sprintf(\"%d %04x\", 123, 123)               \#=> \"123 007b\"\nsprintf(\"%08b '%4s'\", 123, 123)            \#=> \"01111011 ' 123'\"\nsprintf(\"%*2$s %d\", \"hello\", 10)           \#=> \"     hello 10\"\nsprintf(\"%*2$s %d\", \"hello\", -10)          \#=> \"hello      -10\"\nsprintf(\"%+g:% g:%-g\", 1.23, 1.23, 1.23)   \#=> \"+1.23: 1.23:1.23\"\n"))
aClass.addMethod(m0053)
m0054 = MethodDesc.new("srand", "class", "srand( <i>[</i><i>aNumber</i><i>]</i> ) -> <i>oldSeed</i>")
m0054.addFragment(Paragraph.new("Seeds the pseudorandom number generator to the value of <i>aNumber</i>.<code>to_i.abs</code>. If <i>aNumber</i> is omitted or zero, seeds the generator using a combination of the time, the process id, and a sequence number. (This is also the behavior if <code>Kernel::rand</code> is called without previously calling <code>srand</code>, but without the sequence.) By setting the seed to a known value, scripts can be made deterministic during testing. The previous seed value is returned. Also see <code>Kernel::rand</code> on page 425.\n"))
aClass.addMethod(m0054)
m0055 = MethodDesc.new("sub", "class", "sub( <i>pattern</i>, <i>replacement</i> ) -> $_<br></br>sub( <i>pattern</i> ) { <i>block</i> } -> $_")
m0055.addFragment(Paragraph.new("Equivalent to <code>$_.sub(<i>args</i>)</code>, except that <code>$_</code> will be updated if substitution occurs.\n"))
aClass.addMethod(m0055)
m0056 = MethodDesc.new("sub!", "class", "sub!( <i>pattern</i>, <i>replacement</i> ) -> $_ or <code>nil</code><br></br>sub!( <i>pattern</i> ) { <i>block</i> } -> $_ or <code>nil</code>")
m0056.addFragment(Paragraph.new("Equivalent to <code>$_.sub!(<i>args</i>)</code>.\n"))
aClass.addMethod(m0056)
m0057 = MethodDesc.new("syscall", "class", "syscall( <i>aFixnum</i> <i>[</i>, <i>args</i><i>]*</i> ) -> <i>anInteger</i>")
m0057.addFragment(Paragraph.new("Calls the operating system function identified by <i>aFixnum</i>, passing in the arguments, which must be either <code>String</code> objects, or <code>Integer</code> objects that ultimately fit within a native <code>long</code>. Up to nine parameters may be passed (14 on the Atari-ST). The function identified by <i>Fixnum</i> is system dependent. On some Unix systems, the numbers may be obtained from a header file called <code>syscall.h</code>.\n"))
m0057.addFragment(Verbatim.new("syscall 4, 1, \"hello\\n\", 6   \# '4' is write(2) on our box"))
m0057.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0057.addFragment(Verbatim.new("hello"))
aClass.addMethod(m0057)
m0058 = MethodDesc.new("system", "class", "system( <i>aCmd</i> <i>[</i>, <i>args</i><i>]*</i> ) -> <code>true</code> or <code>false</code>")
m0058.addFragment(Paragraph.new("Executes <i>aCmd</i> in a subshell, returning <code>true</code> if the command was found and ran successfully, <code>false</code> otherwise. A detailed error code is available in <code>$?</code>. The arguments are processed in the same way as for <code>Kernel::exec</code> on page 419.\n"))
m0058.addFragment(Verbatim.new("system(\"echo *\")\nsystem(\"echo\", \"*\")"))
m0058.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0058.addFragment(Verbatim.new("config.h main.rb\n*"))
aClass.addMethod(m0058)
m0059 = MethodDesc.new("test", "class", "test(<i>aCmd</i>, <i>file1</i> <i>[</i>, <i>file2</i><i>]</i> ) -> <i>anObject</i>")
m0059.addFragment(Paragraph.new("Uses the integer <i>aCmd</i> to perform various tests on <i>file1</i> (Table 23.3 on page 430) or on <i>file1</i> and <i>file2</i> (Table 23.4).\n"))
aClass.addMethod(m0059)
m0060 = MethodDesc.new("throw", "class", "throw( <i>aSymbol</i> <i>[</i>, <i>anObject</i><i>]</i> )")
m0060.addFragment(Paragraph.new("Transfers control to the end of the active <code>catch</code> block waiting for <i>aSymbol</i>. Raises <code>NameError</code> if there is no <code>catch</code> block for the symbol. The optional second parameter supplies a return value for the <code>catch</code> block, which otherwise defaults to <code>nil</code>. For examples, see <code>Kernel::catch</code> on page 417.\n"))
aClass.addMethod(m0060)
m0061 = MethodDesc.new("trace_var", "class", "trace_var( <i>aSymbol</i>, <i>aCmd</i> ) -> <code>nil</code><br></br>trace_var( <i>aSymbol</i> ) {| val | block } <p></p> -> <code>nil</code>")
m0061.addFragment(Paragraph.new("Controls tracing of assignments to global variables. The parameter <i>aSymbol</i> identifies the variable (as either a string name or a symbol identifier). <i>cmd</i> (which may be a string or a <code>Proc</code> object) or block is executed whenever the variable is assigned. The block or <code>Proc</code> object receives the variable's new value as a parameter. Also see <code>Kernel::untrace_var</code>.\n"))
m0061.addFragment(Verbatim.new("trace_var :$_, proc {|v| puts \"$_ is now '\#{v}'\" }\n$_ = \"hello\"\n$_ = ' there'"))
m0061.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0061.addFragment(Verbatim.new("$_ is now 'hello'\n$_ is now ' there'"))
aClass.addMethod(m0061)
m0062 = MethodDesc.new("trap", "class", "trap( <i>signal</i>, <i>cmd</i> ) -> <i>anObject</i><br></br>trap( <i>signal</i> ) {| | block } -> <i>anObject</i>")
m0062.addFragment(Paragraph.new("Specifies the handling of signals. The first parameter is a signal name (a string such as ``SIGALRM'', ``SIGUSR1'', and so on) or a signal number. The characters ``SIG'' may be omitted from the signal name. The command or block specifies code to be run when the signal is raised. If the command is the string ``IGNORE'' or ``SIG_IGN'', the signal will be ignored. If the command is ``DEFAULT'' or ``SIG_DFL'', the operating system's default handler will be invoked. If the command is ``EXIT'', the script will be terminated by the signal. Otherwise, the given command or block will be run.\n"))
m0062.addFragment(Paragraph.new("The special signal name ``EXIT'' or signal number zero will be invoked just prior to program termination.\n"))
m0062.addFragment(Paragraph.new("<code>trap</code> returns the previous handler for the given signal.\n"))
m0062.addFragment(Verbatim.new("trap 0, proc { puts \"Terminating: \#{$$}\" }\ntrap(\"CLD\") { puts \"Child died\" }\nfork && Process.wait"))
m0062.addFragment(Paragraph.new("<em>produces:</em>\n"))
m0062.addFragment(Verbatim.new("Terminating: 16422\nChild died\nTerminating: 16421"))
aClass.addMethod(m0062)
m0063 = MethodDesc.new("untrace_var", "class", "untrace_var( <i>aSymbol</i> <i>[</i>, <i>aCmd</i><i>]</i> ) -> <i>anArray</i> or <code>nil</code>")
m0063.addFragment(Paragraph.new("Removes tracing for the specified command on the given global variable and returns <code>nil</code>. If no command is specified, removes all tracing for that variable and returns an array containing the commands actually removed.\n"))
aClass.addMethod(m0063)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
