# Automatically generated....
raise 'Must be invoked by installation process' unless $opfile

# -----------------------------------------
aClass = ClassModule.new("Continuation", "Object", "class")
aClass.addFragment(Paragraph.new("<code>Continuation</code> objects are generated by <code>Kernel\#callcc</code>. They hold a return address and execution context, allowing a nonlocal return to the end of the <code>callcc</code> block from anywhere within a program. Continuations are somewhat analogous to a structured version of C's <code>setjmp/longjmp</code> (although they contain more state, so you might consider them closer to threads).\n"))
aClass.addFragment(Paragraph.new("For instance:\n"))
aClass.addFragment(Verbatim.new("arr = [ \"Freddie\", \"Herbie\", \"Ron\", \"Max\", \"Ringo\" ]\ncallcc{|$cc|}\nputs(message = arr.shift)\n$cc.call unless message =~ /Max/"))
aClass.addFragment(Paragraph.new("<em>produces:</em>\n"))
aClass.addFragment(Verbatim.new("Freddie\nHerbie\nRon\nMax"))
aClass.addFragment(Paragraph.new("This (somewhat contrived) example allows the inner loop to abandon processing early:\n"))
aClass.addFragment(Verbatim.new("callcc {|cont|\n  for i in 0..4\n    print \"\\n\#{i}: \"\n    for j in i*5...(i+1)*5\n      cont.call() if j == 17\n      printf \"%3d\", j\n    end\n  end\n}\nprint \"\\n\""))
aClass.addFragment(Paragraph.new("<em>produces:</em>\n"))
aClass.addFragment(Verbatim.new("0:   0  1  2  3  4\n1:   5  6  7  8  9\n2:  10 11 12 13 14\n3:  15 16"))
m0002 = MethodDesc.new("call", "instance", "<i>cont</i>.call( <i>[</i><i>args</i><i>]*</i> )")
m0002.addFragment(Paragraph.new("Invokes the continuation. The program continues from the end of the <code>callcc</code> block. If no arguments are given, the original <code>callcc</code> returns <code>nil</code>. If one argument is given, <code>callcc</code> returns it. Otherwise, an array containing <i>args</i> is returned.\n"))
m0002.addFragment(Verbatim.new("callcc {|cont|  cont.call }           \#=> nil\ncallcc {|cont|  cont.call 1 }         \#=> 1\ncallcc {|cont|  cont.call 1, 2, 3 }   \#=> [1, 2, 3]\n"))
aClass.addMethod(m0002)

File.open($opfile, "w") {|f| Marshal.dump(aClass, f) }
