/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#ifndef _hexonet_XFramebuffer_h_
#define _hexonet_XFramebuffer_h_


#include "Framebuffer.h"

#include <X11/X.h>
#include <X11/Xlib.h>

namespace rfb {

class XFramebuffer: public Framebuffer
{
  public:
    XFramebuffer( Display *_display,
                  Window _window,
		  unsigned int _width,
		  unsigned int _height );

  virtual void update( unsigned int _x,
                       unsigned int _y,
                       unsigned int _w,
		       unsigned int _h );

  virtual void copyRect( unsigned int _destX,
                         unsigned int _destY,
                         unsigned int _width,
                         unsigned int _height,
                         unsigned int _srcX,
                         unsigned int _srcY );

  Display *display;
  Window window;
  XImage *image;
  int sharedMemory;
  GC gc;
  int *colormap;
  Colormap cmap;
};


}

#endif // _hexonet_XFramebuffer_h_
