/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "rfb.h"


namespace rfb {


/**************************************************/
/* CARD16                                         */
/**************************************************/

CARD16::CARD16( unsigned int _value = 0 )
{
  value[1] = _value;
  _value >>= 8;
  value[0] = _value;
}

/*
CARD16::operator unsigned int()
{
  return (value[0] << 8) | value[1];
}
*/

CARD16& CARD16::operator=( unsigned int other )
{
  value[1] = other;
  other >>= 8;
  value[0] = other;
  return (*this);
}


/**************************************************/
/* CARD32                                         */
/**************************************************/

CARD32::CARD32( unsigned int _value = 0 )
{
  value[3] = _value;
  _value >>= 8;
  value[2] = _value;
  _value >>= 8;
  value[1] = _value;
  _value >>= 8;
  value[0] = _value;
}

/*
CARD32::operator unsigned int()
{
  return (value[0] << 24) | (value[1] << 16) | (value[2] << 8) | value[3];
}
*/


CARD32& CARD32::operator=( unsigned int other )
{
  value[3] = other;
  other >>= 8;
  value[2] = other;
  other >>= 8;
  value[1] = other;
  other >>= 8;
  value[0] = other;
  return (*this);
}


/**************************************************/
/* State                                          */
/**************************************************/

State::State() {}
State::~State() {}
void State::update() {}


} // namespace rfb

