/*
 *  Copyright (C) 2000 heXoNet Support GmbH, D-66424 Homburg.
 *  All Rights Reserved.
 *
 *  This is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This software is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this software; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307,
 *  USA.
 */

#include "ScaleFramebuffer.h"
#include <stdlib.h>
#include <string.h>

namespace rfb {

ScaleFramebuffer::ScaleFramebuffer( Framebuffer & _fb, int _width, int _height )
    {
      fb = &_fb;
      width = _width;
      height = _height;
      pixelFormat = fb->pixelFormat;
      bytesPerLine = (pixelFormat.bits_per_pixel >> 3) * width;
      data = (unsigned char*) malloc( bytesPerLine * height );
    }


void ScaleFramebuffer::update( unsigned int _x,
                         unsigned int _y,
               		 unsigned int _w,
		         unsigned int _h
	               )
    {
      _w = (fb->width * (_w + _x ) + width - 1) / width;
      _h = (fb->height * (_h + _y ) + height - 1) / height;
      _x = fb->width * _x / width;
      _y = fb->height * _y / height;
      _w -= _x;
      _h -= _y;
      unsigned int x, y, lasty = height;
      for ( y = _y; y < _y + _h; y++ ) {
        unsigned int ny = height * y / fb->height;
        if ( ny == lasty )
          memcpy( fb->data + y * fb->bytesPerLine + _x * (pixelFormat.bits_per_pixel >> 3),
                  fb->data + (y-1) * fb->bytesPerLine + _x * (pixelFormat.bits_per_pixel >> 3),
                  _w * (pixelFormat.bits_per_pixel >> 3) );
        else {
          lasty = ny;
          for ( x = _x; x < _x + _w; x++ ) {
            unsigned int nx = width * x / fb->width;
            fb->data[ y * fb->bytesPerLine + x * (pixelFormat.bits_per_pixel >> 3) ]
              = data[ ny * bytesPerLine + nx * (pixelFormat.bits_per_pixel >> 3) ];
            if ( pixelFormat.bits_per_pixel > 8 ) {
              fb->data[ y * fb->bytesPerLine + x * (pixelFormat.bits_per_pixel >> 3) +1]
                = data[ ny * bytesPerLine + nx * (pixelFormat.bits_per_pixel >> 3) +1];
              if ( pixelFormat.bits_per_pixel > 16 ) {
                fb->data[ y * fb->bytesPerLine + x * (pixelFormat.bits_per_pixel >> 3) +2]
                  = data[ ny * bytesPerLine + nx * (pixelFormat.bits_per_pixel >> 3) +2];
                if ( pixelFormat.bits_per_pixel > 24 )
                  fb->data[ y * fb->bytesPerLine + x * (pixelFormat.bits_per_pixel >> 3) +3]
                    = data[ ny * bytesPerLine + nx * (pixelFormat.bits_per_pixel >> 3) +3];
              }
            }
          }
        }
      }
      fb->update( _x, _y, _w, _h );
    }

void ScaleFramebuffer::copyRect( unsigned int _destX,
                           unsigned int _destY,
                           unsigned int _width,
                           unsigned int _height,
                           unsigned int _srcX,
                           unsigned int _srcY
                         )
    {
      if ( ((_destX * fb->width % width) == (_srcX * fb->width % width)) &&
           ((_destY * fb->height % height) == (_srcY * fb->height % height)) ) {
        if ( ( fb->width % width ) || ( fb->height % height ) )
          Framebuffer::copyRect( _destX, _destY, _width, _height, _srcX, _srcY );
        _width = (fb->width * (_width + _srcX ) + width - 1) / width;
        _height = (fb->height * (_height + _srcY ) + height - 1) / height;
        _srcX = fb->width * _srcX / width;
        _srcY = fb->height * _srcY / height;
        _destX = fb->width * _destX / width;
        _destY = fb->height * _destY / height;
        _width -= _srcX;
        _height -= _srcY;
        fb->copyRect( _destX, _destY, _width, _height, _srcX, _srcY );
      } else {
        Framebuffer::copyRect( _destX, _destY, _width, _height, _srcX, _srcY );
        update( _destX, _destY, _width, _height );
      }
    }


}
