\name{replisting-class}
\docType{class}
\alias{replisting-class}
\alias{replisting}
\alias{repReleaseLevel,replisting-method}
\alias{numSubReps,replisting-method}
\alias{replisting,replisting-method}
\alias{repURL,replisting-method}
\alias{show,replisting-method}
\alias{summary,replisting-method}
\title{A class to represent repository information}
\description{Provides structure to basic repository information, such as
  type, URL, subrepositories, etc}
\section{Objects from the Class}{
Objects can be created by calls of the form \code{new("replisting", ...)}.
}
\section{Slots}{
  \describe{
    \item{\code{replisting}:}{Object of class \code{"matrix"} The
      information itself}
  }
}

\section{Methods}{
  \describe{
    \item{summary}{\code{signature(object = "replisting")}: An output of
      the information}
    \item{show}{\code{signature(object = "replisting")}: A verbose
      output of the information}
    \item{replisting}{\code{signature(object = "replisting")}: Returns
      the information matrix}
    \item{numSubReps}{\code{signature(object = "replisting")}: Returns
      the number of available subrepositories}
    \item{repReleaseLevel}{\code{signature(object = "replisting")}:
      Returns the release level for this replisting}
  }
}
\author{Jeff Gentry}
\seealso{\code{\link{ReposEntry-class}},\code{\link{repdatadesc-class}}}
\examples{
## Note that generally the replisting matrix would come from a
## repository 'replisting' file.  Generating it manually here.
a <- matrix(ncol=4,nrow=1)
a[1,] <- c("Test Repository",
  "package","http://www.bioconductor.org/repository","/sample/package")

colnames(a) <- c("repname","reptype","repaddrBase","repaddrPath")

z <- new("replisting",replisting=a)
z
}
\keyword{classes}
