\name{getPkgVers}
\alias{getPkgVers}
\alias{is.installed}
\title{Information for an installed package}
\description{
  These functions retrieve information on installed packages, including
  whether or not a package is installed.
}
\usage{
is.installed(pkg, vers=NULL, verbose=TRUE, oper="==", libs)
getPkgVers(pkg, libs = reposToolsLibPaths(), verbose=TRUE)
}
\arguments{
  \item{pkg}{ The package to check}
  \item{vers}{The version of the package.  NULL implies any version}
  \item{libs}{A R library directory (or vector of directories).}
  \item{verbose}{Extra diagnostics}
  \item{oper}{Allows for a version test instead of a direct '=='}
}
\value{
  is.installed: This function will return a logical representing if the
    specified package is installed or not.  The version parameter
    defaults to NULL, which implies any version of the package.  If a
    version is specified, it can be either as a string or as a
    \code{VersionNumber} object.  If the former, it will be coerced to
    the latter.  Argument \code{oper} can be any comparitive function
    (>, <, !=, etc), but defaults to \code{==}.  This is the comparator
    applied to see if a package of a given version is installed.
  
  getPkgVers:  This function returns a list containing all version
    numbers of any instance of the package being isntalled.  If the
    package is installed only in one occassion, it will be a single
    element list.  If the package is installed multiple times, each
    instance will have a corresponding version number.  Likewise, an
    empty list is returned if the package is not installed.  The
    \code{VersionNumber} class is used for the return value.
}
\author{Jeff Gentry}
\seealso{\code{\link{VersionNumber}}, \code{\link{reposToolsLibPaths}}}
\examples{
  lib <- paste(.find.package("reposTools"),"data/",sep="/")
  getPkgVers("reposTools",lib)
}
\keyword{utilities}
