/* hmap.h - A hash table (map datatype) implementation.
 *
 * Copyright (C) 2001  Oskar Liljeblad
 *
 * This file is part of the file renaming utilities (renameutils)
 * and regex-markup.
 *
 * This software is copyrighted work licensed under the terms of the
 * GNU General Public License. Please consult the file `COPYING' for
 * details.
 */

#ifndef __HMAP_H__
#define __HMAP_H__

/* POSIX */
#if HAVE_STDINT_H
#include <stdint.h>
#endif
/* common */
#include "collections.h"
#include "iterator.h"

typedef struct _HMap HMap;

typedef uint32_t (*HashFunc)(const void *);

HMap *hmap_new(void);
HMap *hmap_new_specific(uint32_t initial_capacity, float load_factor);
void hmap_set_hash_function(HMap *map, HashFunc hash_key);
void hmap_set_compare_function(HMap *map, CompareFunc compare_keys);
void hmap_free(HMap *map);

void hmap_clear(HMap *map);
uint32_t hmap_size(HMap *map);

bool hmap_is_empty(HMap *map);
bool hmap_contains_value(HMap *map, const void *value);
bool hmap_contains_key(HMap *map, const void *key);

void *hmap_get(HMap *map, const void *key);
void *hmap_put(HMap *map, void *key, void *value);
void *hmap_remove(HMap *map, const void *key);

uint32_t string_hash(const char *key);

void hmap_iterate_values(HMap *map, IteratorFunc iterator_func);
Iterator *hmap_value_iterator(HMap *map);

#endif
