(*pp camlp4o -I . *)
(************************************************************
 *
 * A part of Regexp/OCaml module.
 * 
 * (c) 2002-2003 Yutaka Oiwa. All Rights Reserved.
 *
 * This file is distributed under the terms of the Q Public
 * License version 1.0.
 *
 ************************************************************)

#load "../pa_pragma/pa_pragma.cmo";;

#load "./pa_regexp_match.cma";;

(* #pragma "no-precompile-regexp";; *)

open Printf

let f s =
  printf "input: \"%s\"  --> " s;
  Regexp.match s with
    "^\(.\)(\066)(.)$" as _, c ->
      (* binding to variable, backslash escape: "(A)BC" -> "C" *)
      printf "case A: %s\n" c

  | "(?i)^\(.\)(B)(.)$" as _, c ->
      (* caseless match, non-binding group: "(a)bc" -> "c" *)
      printf "case B: %s\n" c

  | "^(\d+)[ \x2c]+(\d+)$" as a : int, c > int_of_string when a < 50 ->
      (* simple type coercion, when clause: "12,70" -> "in 82" *)
      printf "int in:%d\n" (a + c)

  | "(?x) ^ (\d+) [\ \o054]{1,}  (\d+)  $" 
      as a : int, c > Pervasives.int_of_string ->
	(* long type coercion: "70,12" -> "out 82" *)
	printf "int out:%d\n" (a + c)
	
  | "(?:^..)(.)?$" as t > (fun s -> s.[0]) ->
      (* optional match: "ABC" -> "3chars C", "AB" -> "2chars" *)
      begin
	match t with
	  Some c -> printf "3chars, third character is %c\n" c
	| None   -> printf "2chars\n"
      end
  | "^(\d+)(?:-(\d+)){0,1}$" as a : int, b : int = a ->
      (* optional match with coercion and default value *)
      (* "5" -> "5 .. 5", "5-70" -> "5 .. 7" *)
      printf "%d .. %d\n" a b

  | _ -> (* default case *)
      printf "no match\n"

let _ = 
  if Array.length Sys.argv < 2 then begin
    f "(A)BC";
    f "(a)bc";
    f "12,70";
    f "70,12";
    f "ABC";
    f "DE";
    f "5";
    f "5-70";
    f "D"
  end
  else
    for i = 1 to Array.length Sys.argv - 1 do
      f Sys.argv.(i)
    done
