//////////////////////////////////////////////////////////////////////////
//
//  Filename    : QLightSourceEditorImpl.h
//  Class       : QLightSourceEditorImpl
//
//  Author(s)   : Michael Meissner
// 
//  Description : GUI for editing light sources
//  Purpose     : 
//
//  Date        : September 2001
//
//  Updates     :    who    | date   | what
//                ----------+--------+-------------------------------------
//                          |        |
//
////////////////////////////////////////////////////////////////////////////



#ifndef __LIGHTSOURCEEDITORIMPL_H
#define __LIGHTSOURCEEDITORIMPL_H

// QT
/////////

// QGLViewer
//////////////
#include <QGLViewer.h>
#include <CList.h>
#include <CLightSource.h>
#include "QLightSourceEditor.h"

// Own
////////


// Forward declarations
////////////////////////////


class QLightSourceEditorImpl : public QLightSourceEditor
{
   Q_OBJECT
         
   public:
      QLightSourceEditorImpl( QGLViewer *viewer, QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
      ~QLightSourceEditorImpl();
   
      void setLightList(CList<CLightSource> &);

   signals:
      //////////////
      // SIGNAL
      //////////////
      
      /** This signal is emitted when the scene should be redrawed. */
      void sigRedrawGL();
           
      /** Is emitted to submit the camerapath. */
      void sigLightSourceList(const CList<CLightSource> &);

   protected slots:
      ////////////////////
      // PROTECTED SLOTS 
      ////////////////////
      virtual void sltTypeChanged(int);
      virtual void sltStatusChanged(int);
      virtual void sltIntensityChanged();
      virtual void sltRedChanged();
      virtual void sltGreenChanged();
      virtual void sltBlueChanged();
      virtual void sltPosXchanged();
      virtual void sltPosYchanged();
      virtual void sltPosZchanged();
      virtual void sltDirXchanged();
      virtual void sltDirYchanged();
      virtual void sltDirZchanged();
      virtual void sltAngleChanged();
      virtual void sltExponentChanged();
      virtual void sltConstantAttenuationChanged();
      virtual void sltLinearAttenuationChanged();
      virtual void sltQuadraticAttenuationChanged();
      virtual void sltDeleteLight();
      virtual void sltButtonCancel();
      virtual void sltButtonApply();
      virtual void sltButtonOk();

      /** Whenever somethings changes by mouse input in the
       * list box, then this slot is called. */
      virtual void sltSelectionChanged();

   private:
      /** Filters events. */
      bool eventFilter(QObject *o, QEvent *e);
          
      /** set a new light by inserting it into the list. */
      void setLight(CCamera &);

      /** update the GUI components. */
      void updateGUI();

      QGLViewer *m_pViewer;

      CList<CLightSource>* m_pOriginalList;
      CList<CLightSource>* m_pWorkingList;
};

#endif
