#include "playlistwrapper.h"

playlistWrapper * playlistWrapper::m_self;

playlistWrapper & playlistWrapper::self()
{
	if (m_self == 0)
		m_self = new playlistWrapper;
	return *m_self;
}


playlistWrapper::playlistWrapper()
{
	cout << "Singleton playlistWrapper constructed" << endl;
	
}

void playlistWrapper::updatePlaylist()
{
	m_list.clear();
	assert(m_list.size() == 0);

	gint playlist_length = xmms_remote_get_playlist_length(0);
	for (int i=0; i<playlist_length; ++i)
	{
		gchar *title = xmms_remote_get_playlist_title(0, i);
		gchar *filename = xmms_remote_get_playlist_file(0, i);
		int time = xmms_remote_get_playlist_time(0, i);
		// void xmms_remote_get_info(gint session, gint * rate, gint * freq, gint * nch);
		int rate, freq, nch;
		rate = freq = nch = 0;

		t_songInfo info(title, filename, i, time, freq, rate, nch);
		m_list[i] = info;

		g_free(title);
		g_free(filename);
	}
}

void playlistWrapper::playFileByPos(int pos) const
{
	xmms_remote_set_playlist_pos(0, pos);
	if (!xmms_remote_is_playing(0))
		xmms_remote_play(0);
}

unsigned int playlistWrapper::length() const
{
	return m_list.size();
}

const t_songInfo & playlistWrapper::operator [](unsigned int i) const
{
	return m_list.find(i)->second;
}

unsigned int playlistWrapper::getCurrentTime() const
{
    return xmms_remote_get_output_time(0);
}

const t_songInfo & playlistWrapper::getCurrentSong() const
{
	// get running pos
	
	if (!xmms_remote_is_playing(0))
	{
		// FIXME
		throw 0;
	}
	else
	{
		gint pos = xmms_remote_get_playlist_pos(0);
		return (*this)[pos];
	}
}

int playlistWrapper::getPlayerStatus() const
{
	if (xmms_remote_is_paused(0))
	{
		return PAUSED;
	}
	else if (xmms_remote_is_playing(0))
	{
		return PLAYING;
	}
	return STOPPED;
}

bool playlistWrapper::getRandomStatus() const
{
	return xmms_remote_is_shuffle(0);
}

void playlistWrapper::setRandomStatus() const
{
	xmms_remote_toggle_shuffle(0);
}

void playlistWrapper::pressNext() const
{
	xmms_remote_playlist_next(0);
}

void playlistWrapper::pressPrev() const
{
	xmms_remote_playlist_prev(0);
}

void playlistWrapper::pressPlay() const
{
	xmms_remote_play(0);
}

void playlistWrapper::pressStop() const
{
	xmms_remote_stop(0);
}

void playlistWrapper::pressPause() const
{
	xmms_remote_pause(0);
}
