#ifndef VISUAL_PLATFORM_H
#define VISUAL_PLATFORM_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

// The following are platform-specific fixes for various
//   name conflicts and spurious warnings, that need to
//   be fixed at the very top of every file
#ifdef _MSC_VER
#pragma warning( disable : 4786 )   // identifier truncated
#endif


#ifdef HAVE_CONFIG_H 
#include "config.h"
#else // Assume we are compiling with MSVC
#define HAVE_WIN32_API 1
#endif // !HAVE_CONFIG_H

#ifdef __MWERKS__
#include "mac.h"
#endif

#ifdef HAVE_GTK_GL_AREA
#if __GNUC__ < 3
  // Workaround namespace collision in g++ 2.95
  #include <iostream.h>
#endif
#endif  // !HAVE_GTK_GL_AREA

#include <string>
#include "vthread.h"

// This attribute is used to silence unneeded warnings from GCC when -Wall
// is enabled.
#ifdef __GNUC__
# define UNUSED __attribute__((__unused__))
#else
# define UNUSED
#endif

namespace visual
{

void init_platform();
  // Called when the module initializes.  It should only
  //   perform initialization that cannot safely be 
  //   deferred to another function such as threaded_timer,
  //   or which is very inexpensive.
  // Any required finalization should be performed by an
  //   atexit() handler.

void threaded_sleep(double seconds);   
  // Releases the Python interpreter lock and sleeps for
  //   seconds, then reacquires the lock.  Do not call this if
  //   you do not have the interpreter lock!
  // In a single-thread environment, this should permit
  //   other programs to run and handle callbacks.

void nothread_sleep(double seconds);  
  // Sleeps without doing anything with the interpreter
  //   lock.  This should generally only be called when
  //   you do not have the lock.
  // In a single-thread environment, this should at least
  //   allow other programs to run.

double sclock();
  // Returns a time value in seconds.  The origin is
  //   undefined.

template <class T>
void threaded_timer(double seconds, bool (*callback)(T*), T* data);
  // Calls callback(data) after seconds.  All callbacks are
  //   called from the same thread, but this need not be
  //   the calling thread.  threaded_timer() may be safely
  //   called from the main thread, and it may be safely
  //   called from a callback.

void threaded_exit(int status);
  // A callback may call this function to terminate the
  //   program.  It may terminate immediately, or it
  //   may return and terminate the program only after
  //   the callback has returned.

bool handle_event(struct _object* os_event);
  // Handle an event structure passed back from Python.  On
  //   platforms which do not use Python code to handle events,
  //   this function should do nothing.
  // If the event was handled, and should not be passed to further
  //   event handlers, return true.

// Per-platform 

} // !namespace visual

#ifdef HAVE_WIN32_API    // Microsoft Visual C++ || MinGW
  #include "platwin.h"

  #define GL_INCLUDE "wgl.h"
  #define platform_glContext wglContext
  #define cvisual_DLL __declspec(dllexport)
#endif // !HAVE_WIN32_API

#if defined(HAVE_GTK_GL_AREA) || defined(HAVE_GTK_GL_EXT_MM)
  #include "platlinux.h"
 
#ifdef HAVE_GTK_GL_EXT_MM
  #define GL_INCLUDE "xgl2.h"
  #define platform_glContext xgl2Context
 
#else  // Should have GtkGLarea.
  #define GL_INCLUDE "xgl.h"
  #define platform_glContext xglContext
 
#endif // !HAVE_GTK_GL_EXT
 
  #define cvisual_DLL
  #define LINUX
#endif // !HAVE_GTK_GL_AREA && !HAVE_GTK_GL_EXT_MM


#ifdef MAC          // Macintosh (CodeWarrior)
  /*** Fix name collision with 'mutex' ***/
  #include <msl_mutex>
  #define mutex MUTEX
  /***************************************/

  #include "platnothread.h"
  typedef noCritSec mutex;

  #define GL_INCLUDE "aglcx.h"
  #define platform_glContext aglContext
  #define cvisual_DLL __declspec(dllexport)
#endif // !MAC

#endif // !PLATFORM_H
