#ifndef DOMLETTE_EXPAT_H
#define DOMLETTE_EXPAT_H

#ifdef __cplusplus
extern "C" {
#endif

#include "Python.h"

  #include "expat_interface.h"

  ExpatParser Expat_ParserCreate(void *userState);

  void Expat_ParserFree(ExpatParser parser);

  int Expat_ParseDocument(ExpatParser parser, PyObject *source, int readDtd);

  int Expat_ParseEntity(ExpatParser parser, PyObject *source);

  void Expat_ParserStop(ExpatParser parser);

  int Expat_GetParsingStatus(ExpatParser parser);

  int Expat_GetXIncludeProcessing(ExpatParser parser);

  void Expat_SetXIncludeProcessing(ExpatParser parser, int do_xip);

  int Expat_SetWhitespaceRules(ExpatParser parser, PyObject *rules);

  PyObject *Expat_GetBase(ExpatParser parser);

  int Expat_GetLineNumber(ExpatParser parser);
  
  int Expat_GetColumnNumber(ExpatParser parser);

  int Expat_SplitName(ExpatParser parser, PyObject *triplet, 
                      PyObject **namespaceURI,
                      PyObject **localName,
                      PyObject **qualifiedName,
                      PyObject **prefix);

  void Expat_SetStartDocumentHandler(ExpatParser parser,
                                     ExpatStartDocumentHandler handler);

  void Expat_SetEndDocumentHandler(ExpatParser parser,
                                   ExpatEndDocumentHandler handler);

  void Expat_SetStartElementHandler(ExpatParser parser,
                                    ExpatStartElementHandler handler);

  void Expat_SetEndElementHandler(ExpatParser parser,
                                  ExpatEndElementHandler handler);

  void Expat_SetCharacterDataHandler(
                                ExpatParser parser,
                                ExpatCharacterDataHandler handler);

  void Expat_SetProcessingInstructionHandler(
                                ExpatParser parser,
                                ExpatProcessingInstructionHandler handler);

  void Expat_SetCommentHandler(ExpatParser parser,
                               ExpatCommentHandler handler);

  void Expat_SetStartNamespaceDeclHandler(
                                ExpatParser parser,
                                ExpatStartNamespaceDeclHandler handler);

  void Expat_SetEndNamespaceDeclHandler(
                                ExpatParser parser,
                                ExpatEndNamespaceDeclHandler handler);

  void Expat_SetDoctypeDeclHandler(ExpatParser parser,
                                   ExpatDoctypeDeclHandler handler);

  void Expat_SetUnparsedEntityDeclHandler(
                                ExpatParser parser,
                                ExpatUnparsedEntityDeclHandler handler);

  int DomletteExpat_Init(PyObject *module);
  void DomletteExpat_Fini(void);

#ifdef __cplusplus
}
#endif

#endif /* DOMLETTE_EXPAT_H */
