########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Server/__init__.py,v 1.6 2005/04/07 20:05:54 jkloth Exp $
"""
Repository server (direct access) base module

Copyright 2005 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Server import FtServerBaseException, FTSERVER_NAMESPACE

#FTSERVER_SERVER_NS = FTSERVER_NAMESPACE + '/server'
FTSERVER_SERVER_NS = FTSERVER_NAMESPACE

import MessageSource

class FtServerServerException(FtServerBaseException):
    """
    Exception class for errors incurred while using the
    server core APIs
    """
    MessageSource = MessageSource

Error = MessageSource.Error

# Base class for modules used in servers
class Module:

    commands = {}

    handlers = {}

    def initialize(self, parser, config):
        """
        Hook to allow all modules to perform whatever is needed before
        beginning to process configuration entries.
        """
        pass

    def loadObject(self, path):
        print 'FIXME - load in restricted execution,', path
        try:
            parts = path.split('.')
            module = __import__('.'.join(parts[:-1]), {}, {}, parts[-1:])
            return getattr(module, parts[-1])
        except:
            exception, value = sys.exc_info()[:2]
            if type(exception) is types.ClassType:
                exception = exception.__name__
            msg = 'problem with %s - %s: %s' % (path, exception, value)
            raise Exception(msg)
