/* *************************************************************************
  Module:        lexgaugepop.c
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Routines for 'Reset Gauges' popup window.
                 Also contains generic popup_window() function,
                 used by all the selection popups ('Reset Gauges',
                 'Install Cartridges', and the 'Align Cartridges' windows).
  Changes:

****************************************************************************
                 COPYRIGHT (C) 1999, 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
**************************************************************************** */
#include <stdio.h>
#include <gtk/gtk.h>
#include "lexgui.h"

/* -------------------------------------------------------------------------
        close_twbutton() Makes close button for the scrolled text window. 
                         Close callback also clears message box in
                         top master window and sensitizes the top.
   ------------------------------------------------------------------------- */
void close_twbutton(tx_struct *tw)
{
  GtkWidget *tquitbox, *tbutton;
  tquitbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_end(GTK_BOX(tw->topvbox), tquitbox, FALSE, FALSE, 6);
  gtk_widget_show(tquitbox);

  tbutton = gtk_button_new_with_label("Close");
  gtk_box_pack_start(GTK_BOX(tquitbox), tbutton, TRUE, FALSE, 0);
  /* The following connects a "clicked" signal to clear
     the top message field and sensitize entry & toptable. */
  gtk_signal_connect(GTK_OBJECT (tbutton), "clicked",
                     GTK_SIGNAL_FUNC (deleteSTW), (gpointer)tw);
  gtk_widget_show(tbutton);
} 
/* -------------------------------------------------------------------------
        close_dcbutton()  Makes close button for the scrolled dynamic
                          choices window.  Close callback also clears
                          message box in top master window and sensitizes 
                          the top.
   ------------------------------------------------------------------------- */
void close_dcbutton(io_struct *io)
{
  GtkWidget *quitbox, *button;
  quitbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_end(GTK_BOX((io->dc_ptr)->sw.topvbox), quitbox, FALSE, FALSE, 5);
  gtk_widget_show(quitbox);

  button = gtk_button_new_with_label("Close");
  gtk_box_pack_start(GTK_BOX(quitbox), button, TRUE, FALSE, 0);
  /* The following connects a "clicked" signal to clear
     the top message field and sensitize entry & toptable. */
  gtk_signal_connect(GTK_OBJECT (button), "clicked",
                     GTK_SIGNAL_FUNC (deleteDC), (gpointer)io);
  gtk_widget_show(button);
}
/* -------------------------------------------------------------------------
        close_tbutton() Makes close button for task windows (gauge window,
                        align window, install window, etc.)
                        Close callback also clears message box in
                        top master window, sensitizes the top, and 
                        destroys the dialog if it exists.
   ------------------------------------------------------------------------- */
void close_tbutton(task_struct *task)
{
  GtkWidget *tquitbox, *tbutton;

  tquitbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_end(GTK_BOX(task->vbox_top), tquitbox, FALSE, FALSE, 6);
  gtk_widget_show(tquitbox);

  tbutton = gtk_button_new_with_label("Close");
  gtk_box_pack_start(GTK_BOX(tquitbox), tbutton, TRUE, FALSE, 0);
  /* The following connects a "clicked" signal to clear
     the top message field and sensitize entry & toptable. */
  gtk_signal_connect(GTK_OBJECT (tbutton), "clicked",
                     GTK_SIGNAL_FUNC (deleteTW), (gpointer)task);
  gtk_widget_show(tbutton);
}
/* -------------------------------------------------------------------------
        popup_window() Generic popup window with frame & close button.
                       Be sure and do a show on the top window at the end of
                       the calling function.
   ------------------------------------------------------------------------- */
void popup_window(task_struct *task, char *title)
{
  GtkWidget *frame;

  task->tasktop = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(task->tasktop), title);
  gtk_container_border_width(GTK_CONTAINER(task->tasktop), 5);

  set_color(&(task->tasktop), BLACK, FG, NORMAL);
  set_color(&(task->tasktop), BLACK, TEXT, NORMAL);
  set_color(&(task->tasktop), WHITE, BG, NORMAL);

  frame = gtk_frame_new(NULL);
  gtk_container_add(GTK_CONTAINER(task->tasktop), frame);
  gtk_frame_set_label_align( GTK_FRAME(frame), 0.5, 0.0);
  gtk_frame_set_shadow_type( GTK_FRAME(frame), GTK_SHADOW_OUT);
  gtk_widget_show(frame);

  task->vbox_top = gtk_vbox_new(FALSE, 0);
  gtk_container_border_width(GTK_CONTAINER(task->vbox_top), 5);
  gtk_container_add(GTK_CONTAINER(frame), task->vbox_top);
  gtk_widget_show(task->vbox_top);

  close_tbutton(task);
  /* need to gtk_widget_show(name) at the end of the calling function,
     where name is whatever task->tasktop is set to. */
}
/* -------------------------------------------------------------------------
        clear_msgbox() Clears error message and destroys explain button
                       if it exists.
   ------------------------------------------------------------------------- */
void clear_msgbox(msgbox_struct *m)
{
  if(GTK_IS_WIDGET(m->expbutton))
  {
    gtk_widget_destroy(m->expbutton);
    m->expbutton = NULL;
  }
  gtk_label_set_text(GTK_LABEL(m->msglabel), "");
} 
/* -------------------------------------------------------------------------
        gauge_CB()
   ------------------------------------------------------------------------- */
void gauge_CB(GtkWidget *widget, mbb_struct *mb)
{
  static gchar *inkType[] = {"Black", "Color", "Photo"};
  char message[50];

  clear_msgbox(mb->msgboxptr); /* clear immediately */
  if(!opendev(mb->msgboxptr, 2))
  {
    sprintf(message, "%s gauge reset.", inkType[mb->butnum]);
    put_msg(mb->msgboxptr, message, GREEN, 0);
    reset_ink_gauge(mb->butnum, mb->msgboxptr);
    clear_message(mb->msgboxptr); /* clear with timer */
  }
  closedev();
}
/* -------------------------------------------------------------------------
        rgauges_window()
   ------------------------------------------------------------------------- */
void rgauges_window(int alreadyopen, topwin_struct *top)
{
  int i;
  static task_struct gauges_window;
  static mbb_struct mbb[3];
  GtkWidget *label, *table;
  GtkWidget *button[3];
  char tstring[30];
  GtkWidget *therbox, *pixmapwidget;
  extern int devtype;

  init_task(top, &gauges_window);
  popup_window(&gauges_window, "Reset Gauges");
  gtk_widget_set_usize(gauges_window.tasktop, 270, 240); 

  /* For the thermometer pixmap at the top, added at the end of this function */
  therbox = gtk_hbox_new(FALSE, 0);
  gtk_box_pack_start(GTK_BOX(gauges_window.vbox_top), therbox, FALSE, FALSE, 0);
  gtk_widget_show(therbox);
  make_separator(gauges_window.vbox_top);

  label = gtk_label_new("Select the gauge you want to reset.\n");
  gtk_box_pack_start(GTK_BOX(gauges_window.vbox_top), label, FALSE, FALSE, 0);
  gtk_widget_show(label);

  table = gtk_table_new(3, 2, FALSE); 
  gtk_box_pack_start(GTK_BOX(gauges_window.vbox_top), table, FALSE, FALSE, 0);
  for(i = 0; i < 3; i++)
  {
    mbb[i].msgboxptr = &(gauges_window.msgbox);
    mbb[i].butnum = i;
    button[i] = gtk_button_new();
    gtk_widget_set_usize(button[i], 12, 12);
    gtk_signal_connect (GTK_OBJECT (button[i]), "clicked",
                        GTK_SIGNAL_FUNC (gauge_CB), (gpointer)&mbb[i]);
    gtk_table_attach(GTK_TABLE(table), button[i], 0, 1, i, i + 1,
                     GTK_EXPAND, GTK_EXPAND, 5, 5);
    gtk_widget_show(button[i]);
  }
  sprintf(tstring, "%s", "Black Ink Level Gauge.");
  put_mstring(&table, tstring, 0, 1);
  sprintf(tstring, "%s", "Color Ink Level Gauge.");
  put_mstring(&table, tstring, 1, 2);
  sprintf(tstring, "%s", "Photo Ink Level Gauge.");
  put_mstring(&table, tstring, 2, 3);

  gtk_widget_show(table);
  make_messageBox(&(gauges_window.vbox_top), &(gauges_window.msgbox));

  /* The call below is for the X delete */
  gtk_signal_connect(GTK_OBJECT(gauges_window.tasktop), "delete_event",
                     GTK_SIGNAL_FUNC(deleteTWX), (gpointer)&gauges_window);

  gtk_widget_show(gauges_window.tasktop);
  /* Add the thermometer pixmap to this window */
  pixmapwidget = create_nbpix(&(gauges_window.tasktop), 3);
  gtk_box_pack_start(GTK_BOX(therbox), pixmapwidget, TRUE, FALSE, 0);
  if(!devtype && alreadyopen)
    pop_set_note(&gauges_window, NULL);
}
