/* *************************************************************************
  Module:        fixed.h
  Author:        Matt Simpson
                 Arlington, TX
                 matthewsimpson@home.com
  Date:          August, 2000
  Description:
                 Fixed settings for specific printers and families
                 that Pup supports.
****************************************************************************
                 COPYRIGHT (C) 2000 Matt Simpson
                 GNU General Public License
                 See lexgui.c for full notice.
****************************************************************************
                 Portions of this file include PJL variable names
                 queried from the following printers, of which the
                 manufacturer's copyright (if any) takes precedence:

                 Lexmark Optra 40
                 Lexmark Optra E310
                 HP 2100M, 4000N, LJ4 Plus
**************************************************************************** */

#ifndef FIXED_INCLUDED
#define FIXED_INCLUDED

/* 
   Quick Summary:  1. prefs->printer is set from the preferences file .puprc,
                      the user selection menu, or defaulted.
                   2. prefs->index is set based on the array index
                      of *printer_name[] matching prefs->printer.
                      This happens in set_printer_index().
                   3. The variable set to use in *pv[] (below) is
                      chosen in set_query_fixed() based on prefs->index.
                   4. The family index to use (see Family Specific Commands
                      below) is found in set_printer_family(). This is set
                      based on mappings from all the prefs->index's.
                   5. The family command to use is found in get_family_command()
                      and is based on an integer and family parameter sent to 
                      it.The integer parameter tells which command to use,
                      and the family parameter tells which array index in that
                      command to use.
*/

/* -------------------------------------------------------------------------
   Printer definitions. Default is 1st one. The order has to be the same
   as the corresponding variable definitions in *pv[]. The last string,
   "end", is used as an array termination flag. Note: printer definitions
   are not needed or used for the dynamic settings and query stuff.
   ------------------------------------------------------------------------- */
static gchar *printer_name[] = {
  "Lexmark Optra 40/45",
  "Lexmark Optra E310",
  "HP 2100M",
  "HP 4000",
  "HP LJ4 Plus",
  /* Add future printers here, with corresponding variable definitions in *pv[].
     Note: The number of printers here MUST agree with the number of variable
     set definitions in *pv[]. */
  "end" /* required termination string */
};

/* -------------------------------------------------------------------------
        Printer Specific Variable Definitions
   ------------------------------------------------------------------------- */
/* The string after each "=" is the current setting of the printer's
   variable at the time I queried it, but is not relevant here because
   we don't know your printer's current setting. However, it is required
   for the parsing routines which look for a string there. The reason
   is because the dynamic query uses the same parsing routines and
   looks for this; the query coming back is in the same format as listed
   here and in that case the current setting is relevant and used. 

   Note each array index in *pv[] corresponds to the same array index in 
   *printer_name[] and these two MUST agree. */

static gchar *pv[] = {

/* Lexmark Optra 40/45 */

"COPIES=1 [2 RANGE]\n"
"  1\n"
"  999\n"
"LPAPERSOURCE=TRAY1 [3 ENUMERATED]\n"
"  TRAY1\n"
"  MANUALENVELOPE\n"
"  MANUALPAPER\n"
"PAPER=LETTER [14 ENUMERATED]\n"
"  LETTER\n"
"  LEGAL\n"
"  A4\n"
"  A5\n"
"  JISB5\n"
"  CUSTOM\n"
"  EXECUTIVE\n"
"  COM10\n"
"  COM9\n"
"  MONARCH\n"
"  DL\n"
"  C5\n"
"  B5\n"
"  OTHERENVELOPE\n"
"ORIENTATION=PORTRAIT [2 ENUMERATED]\n"
"  PORTRAIT\n"
"  LANDSCAPE\n"
"LANG=ENGLISH [12 ENUMERATED]\n"
"  ENGLISH\n"
"  FRENCH\n"
"  GERMAN\n"
"  ITALIAN\n"
"  SPANISH\n"
"  DANISH\n"
"  NORWEGIAN\n"
"  DUTCH\n"
"  SWEDISH\n"
"  FINNISH\n"
"  PORTUGUESE\n"
"  JAPANESE\n"
"FORMLINES=60 [2 RANGE]\n"
"  1\n"
"  255\n"
"PERSONALITY=AUTO [3 ENUMERATED]\n"
"  AUTO\n"
"  PCL\n"
"  POSTSCRIPT\n"
"TIMEOUT=90 [2 RANGE]\n"
"  0\n"
"  255\n"
"AUTOCONT=0 [2 RANGE]\n"
"  0\n"
"  255\n"
"LMANUALPAPERSIZE=LETTER [7 ENUMERATED]\n"
"  LETTER\n"
"  LEGAL\n"
"  A4\n"
"  A5\n"
"  JISB5\n"
"  CUSTOM\n"
"  EXECUTIVE\n"
"LMANUALENVELOPESIZE=COM10 [7 ENUMERATED]\n"
"  COM10\n"
"  COM9\n"
"  MONARCH\n"
"  DL\n"
"  C5\n"
"  B5\n"
"  OTHERENVELOPE\n"
"LPARM:PCL FONTNUMBER=0 [2 RANGE]\n"
"  0\n"
"  76\n"
"LPARM:PCL PITCH=10.00 [2 RANGE]\n"
"  0.08\n"
"  100.00\n"
"LPARM:PCL PTSIZE=12.00 [2 RANGE]\n"
"  1.00\n"
"  1008.00\n"
"LPARM:PCL SYMSET=PC8 [33 ENUMERATED]\n"
"  ROMAN8\n"
"  ISOL1\n"
"  ISOL2\n"
"  ISOL5\n"
"  PC8\n"
"  PC8DN\n"
"  PC850\n"
"  PC852\n"
"  PC8TK\n"
"  WINL1\n"
"  WINL2\n"
"  WINL5\n"
"  DESKTOP\n"
"  PSTEXT\n"
"  VNINTL\n"
"  VNUS\n"
"  MSPUBL\n"
"  MATH8\n"
"  PSMATH\n"
"  VNMATH\n"
"  PIFONT\n"
"  LEGAL\n"
"  ISO4\n"
"  ISO6\n"
"  ISO11\n"
"  ISO15\n"
"  ISO17\n"
"  ISO21\n"
"  ISO60\n"
"  ISO69\n"
"  WIN30\n"
"  VNDING\n"
"  PSDING\n"
"LPARM:POSTSCRIPT PRTPSERRS=ON [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"LJAMRECOVERY=AUTO [3 ENUMERATED]\n"
"  ON\n"
"  OFF\n"
"  AUTO\n"
"LPAGEMODE=NORMAL [2 ENUMERATED]\n"
"  NORMAL\n"
"  WHOLEPAGE\n"
"LPARM:PCL LA4WIDTH=198 [2 ENUMERATED]\n"
"  198\n"
"  203\n"
"LTRAY1PAPERTYPE=PLAIN [17 ENUMERATED]\n"
"  PLAIN\n"
"  BOND\n"
"  TRANSPARENCY\n"
"  CARDSTOCK\n"
"  LABELS\n"
"  LETTERHEAD\n"
"  PREPRINTED\n"
"  COLORED\n"
"  PHOTO\n"
"  GREETINGCARD\n"
"  COATED\n"
"  GLOSSY\n"
"  IRONON\n"
"  ENVELOPE\n"
"  CUSTOMTYPE1\n"
"  CUSTOMTYPE2\n"
"  CUSTOMTYPE3\n"
"LMANUALPAPERTYPE=PLAIN [16 ENUMERATED]\n"
"  PLAIN\n"
"  BOND\n"
"  TRANSPARENCY\n"
"  CARDSTOCK\n"
"  LABELS\n"
"  LETTERHEAD\n"
"  PREPRINTED\n"
"  COLORED\n"
"  PHOTO\n"
"  GREETINGCARD\n"
"  COATED\n"
"  GLOSSY\n"
"  IRONON\n"
"  CUSTOMTYPE1\n"
"  CUSTOMTYPE2\n"
"  CUSTOMTYPE3\n"
"LMANUALENVELOPETYPE=ENVELOPE [4 ENUMERATED]\n"
"  ENVELOPE\n"
"  CUSTOMTYPE1\n"
"  CUSTOMTYPE2\n"
"  CUSTOMTYPE3\n"
"LBLANKPAGES=DONOTPRINT [2 ENUMERATED]\n"
"  PRINT\n"
"  DONOTPRINT\n"
"LMULTIPAGEBORDER=NONE [2 ENUMERATED]\n"
"  NONE\n"
"  SOLID\n"
"LMULTIPAGEORDER=HORIZONTAL [4 ENUMERATED]\n"
"  HORIZONTAL\n"
"  VERTICAL\n"
"  REVHORIZONTAL\n"
"  REVVERTICAL\n"
"LMULTIPAGEPRINT=OFF [8 ENUMERATED]\n"
"  OFF\n"
"  2UP\n"
"  3UP\n"
"  4UP\n"
"  6UP\n"
"  9UP\n"
"  12UP\n"
"  16UP\n"
"LMULTIPAGEVIEW=AUTO [3 ENUMERATED]\n"
"  AUTO\n"
"  SHORTEDGE\n"
"  LONGEDGE\n"
"LAUTOCRLF=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"LAUTOLFCR=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"LTYPE1FONTS=ON [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"LCOLLATION=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"LSEPARATORSHEETS=NONE [4 ENUMERATED]\n"
"  NONE\n"
"  BETWEENCOPIES\n"
"  BETWEENJOBS\n"
"  BETWEENPAGES\n"
"LCOLORCORRECTION=AUTO [4 ENUMERATED]\n"
"  NONE\n"
"  DISPLAY\n"
"  VIVID\n"
"  AUTO\n"
"LIMAGESMOOTHING=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"LPRINTQUALITY=NORMAL [4 ENUMERATED]\n"
"  QUICKPRINT\n"
"  NORMAL\n"
"  PRESENTATION\n"
"  1200IMAGEQ\n"
"LHONORINIT=DONOTHONORSIGNAL [2 ENUMERATED]\n"
"  DONOTHONORSIGNAL\n"
"  HONORSIGNAL\n"
"LUSDEFAULTS=US [2 ENUMERATED]\n"
"  US\n"
"  NONUS\n"
"PARALLEL=FAST [2 ENUMERATED]\n"
"  SLOW\n"
"  FAST\n"
"LCUSTOMTYPE1MEDIA=PAPER [4 ENUMERATED]\n"
"  PAPER\n"
"  TRANSPARENCY\n"
"  COATED\n"
"  GLOSSY\n"
"LCUSTOMTYPE2MEDIA=PAPER [4 ENUMERATED]\n"
"  PAPER\n"
"  TRANSPARENCY\n"
"  COATED\n"
"  GLOSSY\n"
"LCUSTOMTYPE3MEDIA=PAPER [4 ENUMERATED]\n"
"  PAPER\n"
"  TRANSPARENCY\n"
"  COATED\n"
"  GLOSSY\n"
"LJAPANESESUPPORT=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n",

/* Lexmark Optra E310 */

"LPAGECOUNT=0 [2 RANGE]\n"
"  0\n"
"  900000\n"
"LTOPMARGINOFFSET=0 [2 RANGE]\n"
"  -128\n"
"  127\n"
"LLEFTMARGINOFFSET=0 [2 RANGE]\n"
"  -128\n"
"  127\n"
"LPAPERSOURCE=TRAY1 [3 ENUMERATED]\n"
"  TRAY1\n"
"  MANUALENVELOPE\n"
"  MANUALPAPER\n"
"PAPER=LETTER [14 ENUMERATED]\n"
"  LETTER\n"
"  LEGAL\n"
"  A4\n"
"  A5\n"
"  JISB5\n"
"  CUSTOM\n"
"  EXECUTIVE\n"
"  COM10\n"
"  COM9\n"
"  MONARCH\n"
"  DL\n"
"  C5\n"
"  B5\n"
"  OTHERENVELOPE\n",

/* HP 2100M */

"LANG=ENGLISH [15 ENUMERATED]\n"
"  ENGLISH\n"
"  FRENCH\n"
"  GERMAN\n"
"  ITALIAN\n"
"  SPANISH\n"
"  SWEDISH\n"
"  DANISH\n"
"  NORWEGIAN\n"
"  DUTCH\n"
"  FINNISH\n"
"  PORTUGUESE\n"
"  TURKISH\n"
"  POLISH\n"
"  CZECH\n"
"  HUNGARIAN\n"
"COPIES=1 [2 RANGE]\n"
"  1\n"
"  999\n"
"PAPER=LETTER [16 ENUMERATED]\n"
"  LETTER\n"
"  LEGAL\n"
"  A4\n"
"  EXECUTIVE\n"
"  COM10\n"
"  MONARCH\n"
"  C5\n"
"  DL\n"
"  ISOB5\n"
"  B5\n"
"  CUSTOM\n"
"  JISB5\n"
"  JPOST\n"
"  JPOSTD\n"
"  A5\n"
"  FOOLSCAP\n"
"ORIENTATION=PORTRAIT [2 ENUMERATED]\n"
"  PORTRAIT\n"
"  LANDSCAPE\n"
"FORMLINES=60 [2 RANGE]\n"
"  5\n"
"  128\n"
"MANUALFEED=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"RET=ON [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"RESOLUTION=1200 [3 ENUMERATED]\n"
"  300\n"
"  600\n"
"  1200\n"
"PERSONALITY=AUTO [3 ENUMERATED]\n"
"  AUTO\n"
"  PCL\n"
"  POSTSCRIPT\n"
"TIMEOUT=15 [2 RANGE]\n"
"  5\n"
"  300\n"
"MPTRAY=FIRST [2 ENUMERATED]\n"
"  CASSETTE\n"
"  FIRST\n"
"INTRAY1=UNLOCKED [2 ENUMERATED]\n"
"  UNLOCKED\n"
"  LOCKED\n"
"INTRAY2=UNLOCKED [2 ENUMERATED]\n"
"  UNLOCKED\n"
"  LOCKED\n"
"AUTOCONT=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"DENSITY=3 [2 RANGE]\n"
"  1\n"
"  5\n"
"IOBUFFER=AUTO [3 ENUMERATED]\n"
"  AUTO\n"
"  ON\n"
"  OFF\n"
"COURIER=REGULAR [2 ENUMERATED]\n"
"  REGULAR\n"
"  DARK\n"
"WIDEA4=NO [2 ENUMERATED]\n"
"  NO\n"
"  YES\n"
"REPRINT=AUTO [3 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"  AUTO\n"
"LPARM:PCL FONTSOURCE=I [2 ENUMERATED]\n"
"  I\n"
"  M1\n"
"LPARM:PCL FONTNUMBER=0 [2 RANGE]\n"
"  0\n"
"  54\n"
"LPARM:PCL PITCH=10.00 [2 RANGE]\n"
"  0.44\n"
"  99.99\n"
"LPARM:PCL PTSIZE=12.00 [2 RANGE]\n"
"  4.00\n"
"  999.75\n"
"LPARM:PCL SYMSET=PC8 [29 ENUMERATED]\n"
"  PC8\n"
"  ROMAN8\n"
"  ISOL1\n"
"  ISOL2\n"
"  ISOL5\n"
"  ISOL6\n"
"  PC775\n"
"  PC8DN\n"
"  PC850\n"
"  PC852\n"
"  PC8TK\n"
"  PC1004\n"
"  WINL1\n"
"  WINL2\n"
"  WINL5\n"
"  WINBALT\n"
"  DESKTOP\n"
"  PSTEXT\n"
"  LEGAL\n"
"  ISO4\n"
"  ISO6\n"
"  ISO11\n"
"  ISO15\n"
"  ISO17\n"
"  ISO21\n"
"  ISO60\n"
"  ISO69\n"
"  WIN30\n"
"  MCTEXT\n"
"LPARM:PCL LINETERMINATION=0 [4 ENUMERATED]\n"
"  0\n"
"  1\n"
"  2\n"
"  3\n"
"LPARM:POSTSCRIPT PRTPSERRS=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n",

/* HP 4000 */

"LANG=ENGLISH [17 ENUMERATED]\n"
"  ENGLISH\n"
"  FRENCH\n"
"  GERMAN\n"
"  ITALIAN\n"
"  SPANISH\n"
"  SWEDISH\n"
"  DANISH\n"
"  NORWEGIAN\n"
"  DUTCH\n"
"  FINNISH\n"
"  PORTUGUESE\n"
"  TURKISH\n"
"  POLISH\n"
"  JAPANESE\n"
"  RUSSIAN\n"
"  CZECH\n"
"  HUNGARIAN\n"
"COPIES=1 [2 RANGE]\n"
"  1\n"
"  999\n"
"PAPER=LETTER [12 ENUMERATED]\n"
"  LETTER\n"
"  A4\n"
"  LEGAL\n"
"  EXECUTIVE\n"
"  JISB5\n"
"  A5\n"
"  CUSTOM\n"
"  COM10\n"
"  MONARCH\n"
"  C5\n"
"  DL\n"
"  B5\n"
"ORIENTATION=PORTRAIT [2 ENUMERATED]\n"
"  PORTRAIT\n"
"  LANDSCAPE\n"
"MANUALFEED=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"RET=MEDIUM [4 ENUMERATED]\n"
"  OFF\n"
"  LIGHT\n"
"  MEDIUM\n"
"  DARK\n"
"RESOLUTION=600 [3 ENUMERATED]\n"
"  300\n"
"  600\n"
"  1200\n"
"PERSONALITY=AUTO [3 ENUMERATED]\n"
"  AUTO\n"
"  PCL\n"
"  POSTSCRIPT\n"
"TIMEOUT=15 [2 RANGE]\n"
"  5\n"
"  300\n"
"MPTRAY=FIRST [2 ENUMERATED]\n"
"  FIRST\n"
"  CASSETTE\n"
"CLEARABLEWARNINGS=JOB [2 ENUMERATED]\n"
"  JOB\n"
"  ON\n"
"AUTOCONT=ON [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"DENSITY=3 [2 RANGE]\n"
"  1\n"
"  5\n"
"LOWTONER=CONTINUE [2 ENUMERATED]\n"
"  STOP\n"
"  CONTINUE\n"
"ECONOMODE=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"POWERSAVETIME=30 [5 ENUMERATED]\n"
"  15\n"
"  30\n"
"  60\n"
"  120\n"
"  180\n"
"IOBUFFER=AUTO [3 ENUMERATED]\n"
"  AUTO\n"
"  ON\n"
"  OFF\n"
"RESOURCESAVE=OFF [3 ENUMERATED]\n"
"  AUTO\n"
"  ON\n"
"  OFF\n"
"COURIER=REGULAR [2 ENUMERATED]\n"
"  REGULAR\n"
"  DARK\n"
"WIDEA4=NO [2 ENUMERATED]\n"
"  NO\n"
"  YES\n"
"FORMLINES=60 [2 RANGE]\n"
"  5\n"
"  128\n"
"LPARM:PCL FONTNUMBER=0 [2 RANGE]\n"
"  0\n"
"  88\n"
"LPARM:PCL PITCH=10.00 [2 RANGE]\n"
"  0.44\n"
"  99.99\n"
"LPARM:PCL SYMSET=PC8 [29 ENUMERATED]\n"
"  PC8\n"
"  ROMAN8\n"
"  ISOL1\n"
"  ISOL2\n"
"  ISOL5\n"
"  ISOL6\n"
"  PC775\n"
"  PC8DN\n"
"  PC850\n"
"  PC852\n"
"  PC8TK\n"
"  PC1004\n"
"  WINL1\n"
"  WINL2\n"
"  WINL5\n"
"  WINBALT\n"
"  DESKTOP\n"
"  PSTEXT\n"
"  LEGAL\n"
"  ISO4\n"
"  ISO6\n"
"  ISO11\n"
"  ISO15\n"
"  ISO17\n"
"  ISO21\n"
"  ISO60\n"
"  ISO69\n"
"  WIN30\n"
"  MCTEXT\n"
"LPARM:POSTSCRIPT PRTPSERRS=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n",

/* HP LJ4 Plus */

"COPIES=1 [2 RANGE]\n"
"  1\n"
"  999\n"
"PAPER=LETTER [9 ENUMERATED]\n"
"  LETTER\n"
"  LEGAL\n"
"  A4\n"
"  EXECUTIVE\n"
"  COM10\n"
"  MONARCH\n"
"  C5\n"
"  DL\n"
"  B5\n"
"ORIENTATION=PORTRAIT [2 ENUMERATED]\n"
"  PORTRAIT\n"
"  LANDSCAPE\n"
"FORMLINES=60 [2 RANGE]\n"
"  5\n"
"  128\n"
"MANUALFEED=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"RET=MEDIUM [4 ENUMERATED]\n"
"  OFF\n"
"  LIGHT\n"
"  MEDIUM\n"
"  DARK\n"
"RESOLUTION=600 [2 ENUMERATED]\n"
"  300\n"
"  600\n"
"PERSONALITY=AUTO [2 ENUMERATED]\n"
"  AUTO\n"
"  PCL\n"
"TIMEOUT=15 [2 RANGE]\n"
"  5\n"
"  300\n"
"ECONOMODE=OFF [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"POWERSAVE=ON [2 ENUMERATED]\n"
"  OFF\n"
"  ON\n"
"POWERSAVETIME=180 [5 ENUMERATED]\n"
"  15\n"
"  30\n"
"  60\n"
"  120\n"
"  180\n"
"IOBUFFER=AUTO [3 ENUMERATED]\n"
"  AUTO\n"
"  ON\n"
"  OFF\n"
"LPARM:PCL FONTNUMBER=0 [2 RANGE]\n"
"  0\n"
"  52\n"
"LPARM:PCL PITCH=10.00 [2 RANGE]\n"
"  0.44\n"
"  99.99\n"
"LPARM:PCL SYMSET=ROMAN8 [31 ENUMERATED]\n"
"  ROMAN8\n"
"  ISOL1\n"
"  ISOL2\n"
"  ISOL5\n"
"  PC8\n"
"  PC8DN\n"
"  PC850\n"
"  PC852\n"
"  PC8TK\n"
"  WINL1\n"
"  WINL2\n"
"  WINL5\n"
"  DESKTOP\n"
"  PSTEXT\n"
"  VNINTL\n"
"  VNUS\n"
"  MSPUBL\n"
"  MATH8\n"
"  PSMATH\n"
"  VNMATH\n"
"  PIFONT\n"
"  LEGAL\n"
"  ISO4\n"
"  ISO6\n"
"  ISO11\n"
"  ISO15\n"
"  ISO17\n"
"  ISO21\n"
"  ISO60\n"
"  ISO69\n"
"  WIN30\n"
};
/* -------------------------------------------------------------------------
        Family Specific Commands
   ------------------------------------------------------------------------- */
/* 
   These are commands for printing configuration, font, and demo pages.
   Currently the Lexmark family is based on the Optra 40/45 and the HP
   family is based on the 2100M. In other words, these are the printers
   I tested the commands on. These are organized by family, because
   the commands may work accross a family of printers. However, I can't
   be sure it will work on a printer not listed but in the same family
   until someone tests it. The HP 4000 family is not the same as the
   2100M family, as several commands are not available. However, most
   of these missing commands can be accessed from the front panel on
   the 4000 printer. 

   If you add a new family of commands, see the Quick Summary at the top of 
   this file. Commented-out examples are given below. If you are wondering
   which commands your printer supports for doing these tasks, look in
   the PJL documentation specific to your printer. Sometimes these
   commands are given in a query, which you can see in Pup's Query Printer
   page; don't put them in *pv[] and instead add them below.

   In the arrays below, the 0 index is already designated for the Lexmark
   (Optra 40/45) family and the 1 index is designated for the HP (2100M) family.
   Likewise, in get_family_command() case 0 is designated for *pm[] (below),
   case 1 for *pps[], case 2 for *ppcl[], etc. 

   NOTAVAIL means to ignore this command and issue an error message saying
   this command is not available for this family.

   NOTE: For setting variables (both fixed and dynamic mode), the command
   used is @PJL DEFAULT. This is not included below; instead it is built
   into the function adtimer(). I built this in because it is a standard
   PJL command and I am assuming it will work for all flavors of PJL. Likewise
   there are other hard-coded commands in send_commands(), instead of putting
   them here.
*/
/* ------------------------------------------------------------------------- */
/* Description & Command -------------------- Family ----------------------- */

/* Menu/Settings/Configuration Page */
static gchar *pm[] = {
"@PJL LPRINTMENUS",                           /* Lexmark */
"@PJL SET TESTPAGE=SELFTEST",                 /* HP */
"NOTAVAIL"                                    /* HP 4000 */
/*,"@PJL another_command_to_print_settings"*/ /* Your family */
};

/* PS Font Page */
static gchar *pps[] = {
"@PJL LPRINTPSFONTS",                         /* Lexmark */
"@PJL SET TESTPAGE=PSTYPEFACELIST",           /* HP */
"NOTAVAIL"                                    /* HP 4000 */
/*,"@PJL another_command_to_print_ps"*/       /* Your family */
};

/* PCL Font Page */
static gchar *ppcl[] = {
"@PJL LPRINTPCLFONTS",                        /* Lexmark */
"@PJL SET TESTPAGE=PCLTYPELIST",              /* HP */
"NOTAVAIL"                                    /* HP 4000 */ 
/*,"@PJL another_command_to_print_pcl"*/      /* Your family */
};

/* Demo Page */
static gchar *pdemo[] = {
"NOTAVAIL",                                   /* Lexmark */
"@PJL SET TESTPAGE=DEMOPAGE",                 /* HP */
"NOTAVAIL"                                    /* HP 4000 */
/*,"@PJL another_command_to_print_demo"*/     /* Your family */ 
};

#ifdef EXAMPLE_TO_ADD_ANOTHER_COMMAND
/* Another Page */
static gchar *pnew_command[] = {
"NOTAVAIL",                                   /* Lexmark */
"NOTAVAIL",                                   /* HP */
"NOTAVAIL",                                   /* HP 4000 */
"@PJL YOURCOMMAND"                            /* Your family */
};
#endif

#endif
