#ifndef OPT_APPEARANCE_H
#define OPT_APPEARANCE_H

#include "optionstab.h"

#include <qlineedit.h>

class FontLabel : public QLineEdit
{
	Q_OBJECT
public:
	FontLabel(QWidget *parent = 0, const char *name = 0);

	void setFont(QString);
	QString fontName() const;

	QSize sizeHint() const;

private:
	QString m_font;
	int m_defaultHeight;
};

class QWidget;
struct Options;
class QButtonGroup;
class QLineEdit;

class OptionsTabAppearance : public OptionsTab
{
	Q_OBJECT
public:
	OptionsTabAppearance(QObject *parent);
	~OptionsTabAppearance();

	QWidget *widget();
	void applyOptions(Options *opt);
	void restoreOptions(const Options *opt);

private slots:
	void setData(PsiCon *, QWidget *);
	void chooseColor(int);
	void chooseFont(int);

private:
	QWidget *w, *parentWidget;
	QButtonGroup *bg_color;
	FontLabel *le_font[4];
	QButtonGroup *bg_font;
	Options *o;
};

#endif
