/*
 * groupchatdlg.h - dialogs for handling groupchat
 * Copyright (C) 2001, 2002  Justin Karneges
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include<qlistview.h>
#include<qlineedit.h>
#include<qtooltip.h>
#include"im.h"
#include"ui_gcjoin.h"

using namespace XMPP;

class PsiCon;
class PsiAccount;

class GCJoinDlg : public GCJoinUI
{
	Q_OBJECT
public:
	GCJoinDlg(PsiCon *, PsiAccount *);
	~GCJoinDlg();

	void joined();
	void error(int, const QString &);

protected:
	//void closeEvent(QCloseEvent *);

public slots:
	void done(int);

private slots:
	void doJoin();
	void updateIdentity(PsiAccount *);
	void pa_disconnected();
	void recent_activated(int);

private:
	class Private;
	Private *d;

	void disableWidgets();
	void enableWidgets();
};

class GCUserViewItem : public QListViewItem
{
public:
	GCUserViewItem(QListView *);

	Status s;
};

class GCUserView : public QListView, public QToolTip
{
	Q_OBJECT
public:
	GCUserView(QWidget *parent=0, const char *name=0);
	~GCUserView();

	void updateAll();
	QListViewItem *findEntry(const QString &);
	void updateEntry(const QString &, const Status &);
	void removeEntry(const QString &);
	QStringList nickList() const;

protected:
	// reimplemented
	void maybeTip(const QPoint &);

signals:
	void action(const QString &, const Status &, int);

private slots:
	void qlv_doubleClicked(QListViewItem *);
	void qlv_contextMenuRequested(QListViewItem *, const QPoint &, int);
};

/*class GCLineEdit : public QLineEdit
{
	Q_OBJECT
public:
	GCLineEdit(QWidget *parent=0, const char *name=0);

signals:
	void upPressed();
	void downPressed();

protected:
	void keyPressEvent(QKeyEvent *);
};*/

class GCMainDlg : public QWidget
{
	Q_OBJECT
public:
	GCMainDlg(PsiAccount *, const Jid &);
	~GCMainDlg();

	Jid jid() const;

	void error(int, const QString &);
	void presence(const QString &, const Status &);
	void message(const Message &);
	void joined();

protected:
	void keyPressEvent(QKeyEvent *);
	void closeEvent(QCloseEvent *);
	void windowActivationChange(bool);

signals:
	void aSend(const Message &);

public slots:
	void optionsUpdate();

private slots:
	void mle_returnPressed();
	void doTopic();
	void openFind();
	void doFind(int, int, const QString &);
	void flashAnimate();
	void pa_updatedActivity();
	void goDisc();
	void goConn();
	void lv_action(const QString &, const Status &, int);
	void doClear();
	void doClearButton();

public:
	class Private;
private:
	Private *d;

	void doFlash(bool);
	void doAlert();
	void updateCaption();
	void appendSysMsg(const QString &, bool, const QDateTime &ts=QDateTime());
	void appendMessage(const Message &, bool);
	void setLooks();

	QString getNickColor(QString);
	QMap<QString,int> nicks;
	int nicknumber;
};

class GCFindDlg : public QDialog
{
	Q_OBJECT
public:
	GCFindDlg(int, int, const QString &, QWidget *parent=0, const char *name=0);
	~GCFindDlg();

	void found(int, int);
	void error(const QString &);

signals:
	void find(int, int, const QString &);

private slots:
	void doFind();

private:
	int para, index;
	QLineEdit *le_input;
};
