#ifndef PGPTEST_H
#define PGPTEST_H

#include<qdialog.h>
#include<qlabel.h>
#include<qlistview.h>
#include<qtextedit.h>
#include<qpushbutton.h>
#include"openpgp.h"

class View : public QDialog
{
	Q_OBJECT
public:
	View(OpenPGP::Engine *, QWidget *parent=0);
	~View();

private slots:
	void pgp_initFinished(bool ok, const QString &str);

	void encrypt();
	void decrypt();
	void sign();
	void verify();
	void pgp_finished(bool);
	void pgp_needPassphrase();
	void pgp_keysUpdated();

private:
	QTextEdit *te, *te2;
	QListView *lv;
	OpenPGP::Engine *pgp;
	QPixmap *pix_key;
	QPushButton *pb_encrypt, *pb_decrypt, *pb_sign, *pb_verify;

	void enableButtons();
	void disableButtons();

	void loadKeys();
};

#endif
