#ifndef GPGPROC_H
#define GPGPROC_H

#include<qobject.h>

class GPGProc : public QObject
{
	Q_OBJECT
public:
	GPGProc();
	~GPGProc();

	bool start(const QString &bin, const QStringList &args, bool useExtra=true);

	void writeToStdin(const QByteArray &);
	void writeToAux(const QByteArray &);
	void writeToCommand(const QByteArray &);

	void closeStdin();
	void closeAux();
	void closeCommand();

	QByteArray readStdout();
	QByteArray readStderr();

	bool isRunning() const;
	bool normalExit() const;
	int exitStatus() const;

signals:
	void readyReadStdout();
	void readyReadStderr();
	void processExited();
	void wroteToStdin();
	void wroteToAux();
	void wroteToCommand();
	void statusLine(const QString &);

private slots:
	void proc_readyReadStdout();
	void proc_readyReadStderr();
	void proc_wroteToStdin();
	void proc_processExited();
	void timeout();
	void sn_activated(int);

private:
	class Private;
	Private *d;

	void closePipes();
	void processStatusData(const QByteArray &);
};

#endif
