#ifndef INCACHE_H_INCLUDED
#define INCACHE_H_INCLUDED /* allow multiple inclusions */

/* 
 * Prospect: a developer's system profiler.
 *
 * COPYRIGHT (C) 2001-2004 Hewlett-Packard Company
 *
 * Author: Alex Tsariounov, HP
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* $Id: incache.h,v 1.5 2004/01/09 20:29:28 type2 Exp $ */

/*
********************************************************************************
**
**                         PROSPECT PROJECT
**                    INCACHE MODULE DEFINITIONS
**
********************************************************************************
*/

/*
 * Required include files
 */
#include "f_sym_name.h"


#ifdef __ia64__
/*
 * IA-64 instructions come in 128 bit bundles of
 * two 64 bit parts.  These are in the elf file 
 * sequentially.  Thus we increment by 16 if we 
 * pull them out.  The PC is supposed to encode the
 * slot number in the lower two bits, perhaps.
 */
#define cINSTRUCTIONSZ  16

#endif 

/*
 * INCACHE Prototypes:
 */
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

void init_incache(unsigned long, unsigned long, unsigned int, 
                 unsigned int, syms_key_t*);
int  stuff_incache(unsigned long, unsigned int);
void close_incache(void);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif  /* INCACHE_H_INCLUDED */
