#ifndef	_PPXP_IP_IPCP_H
#define	_PPXP_IP_IPCP_H

#define	MAX_DNSERVER	3
#define	MAX_WINSERVER	2

typedef enum {
    DNSRES_NO=0,
    DNSRES_FIX,
    DNSRES_YES,
    DNSRES_MAX
} dnsres_t;

struct ipcpopt_s {
    struct in_addr r_addr;
    struct in_addr r_mask;
    struct in_addr l_addr;
    struct in_addr l_mask;
    struct in_addr netmask;
    struct in_addr network;
    struct in_addr dns[MAX_DNSERVER];
    struct in_addr wins[MAX_WINSERVER];
    char *up, *down, *start, *stop;
    char *domain;
    bool_t restoreroute;
    bool_t vjcmp;
    /*    bool_t dnserve;		/* serve DNS address(es) */
    bool_t dnsrelay;		/* DNS relay */
    bool_t s_local;		/* use Static/Specified local address */
    dnsres_t res_conf;		/* make resolv.conf */
    bool_t proxyarp;		/* set proxy arp */
    u_int8_t vj_max_slot;
    u_int8_t vj_cmp_slot;
};

struct ipcpreg_s {
    struct in_addr addr;
    struct in_addr dns1, dns2;
    struct in_addr wins1, wins2;
    struct cproto_s {
	u_int16_t nbo_cproto;
	union {
	    struct vjcmp_s {
		u_int8_t max_slot_id;
		u_int8_t cmp_slot_id;
	    } vj;
	} opt;
    } cproto;
};

typedef enum {IPAT_NONE=0, IPAT_QUEUE, IPAT_ALL} ipatflag_t;

/*
 * IP Address Translation Flag
 *
 * IPAT_NONE:	not translate
 * IPAT_QUEUE:	translate only queued packet
 * IPAT_ALL:	translate all packet
 */

extern struct ipcpreg_s ipcprReg, ipcplReg;
extern struct ipcpopt_s ipcpOpt;
extern ipatflag_t ipAtFlag;

#endif	/* _PPXP_IP_IPCP_H */
