#!/usr/bin/perl
#  correct_packages.pl
#    $Last modified: Wed Apr 19 03:22:58 2000$
#                   Copyright (c) 1999 kamop
#  $Id: correct_packages.pl,v 1.4 1999/06/07 08:28:13 kamop Exp $
# 

## ή
## (1) եɤ߹
## (2) ѥåեɤ߹
##     $pacf˳ƥѥåեξ
## (3) ɤ߹ѥåե뤫鲾ۥѥå̾ξ򽸤
##     (2)Ǥϳƥѥåե˥ǡpacˤۤ뤿ᡤ
##     ޤȤɬפ롥
## (4) ϥեɤ߹
## (5) Ϥ줿ѥåե˰¸ѥå
## (6) ̽
## (7) ۥѥå
## (8) ѥå

## ե
##   kdeb_debug             KDEB.pm ΥǥХå٥
##   correct_packages_debug correct_packages.pl ΥǥХå٥
##   base_dir               ǥ쥯ȥ 1BASE_DIR1
##   select_file            ̥եϥե
##   script_file            ǤӤޤĥ꡼ۥץȥե
##   output_file            ̽ϥե
##   provides_file          ۥѥå̾ϥե
##   CONF: ARRAY files      ޤʤ
##                          files Ȥ̾ˤȤ̣
##                          ʹߡfiles  push 
##   files = <id>           ͭ<id>
##   files::<id>::file      <id>Υѥåե̾
##   files::<id>::base_dir  ǥ쥯ȥ 2BASE_DIR2
##
##   ºݤɤ߹ѥåեϰʲΤ褦ˤʤޤ
##   BASE_DIR1 / BASE_DIR2 / ѥåե̾
##    = base_dir / files::<id>::base_dir / files::<id>::file
##

use strict;
use KDEB;

my($kdeb) = new KDEB;

## եɤ߹
my($conf_file) = $ARGV[0];
if(! -f $conf_file){
  die "No such input file $conf_file.";
}
my($fileconf_debug) = 0;
my($conf) = $kdeb->conf_read(file=>$conf_file,
                             debug=>$fileconf_debug);

## ǥХå٥
##   1: åɽ
##   2: Ĺåɽ
##   3: ɲäΤɽ
##   4: åΤɽ
##   5: 塼ɽ
my($debug) = $conf->{'correct_packages_debug'};

## ϥե
my($input_file) = $ARGV[1];
if(! -f $input_file){
  $input_file = $conf->{'select_file'};
  if(! -f $input_file){
    die "No such input file $input_file.";
  }
}

## ѥåեɤ߹
my($pacf) = $kdeb->PACF_new(conf=>$conf);
$kdeb->PACF_read_packages(PACF=>$pacf);

## ۥѥå̾å
my($rpac) = $kdeb->PAC_new();
## Provide򥳥ԡ
&assemble_provides(PAC=>$rpac, PACF=>$pacf);


## ̤ PAC
##   ˤϰʲξΤߤ롥
##   - ѥå̾
##   - ۥѥå
##   - Priority
my($newpac) = $kdeb->PAC_new();
## ե
&read_inputfile(file=>$input_file, PAC=>$newpac, PACF=>$pacf);

## ղþɽ
&output_additional(PAC=>$newpac, PACF=>$pacf,
                   output_file=>$conf->{'select_additional'});

## ѥå
&correct_packages(PAC=>$newpac, RPAC=>$rpac, PACF=>$pacf);


#######################################################################

## ̽
my($output_file) = $conf->{"expand_file"};
&output_packages(file=>$output_file, PAC=>$newpac);

## ۥѥå
$output_file = $conf->{"provides_file"};
print "provide: $output_file\n";
&output_provides(file=>$output_file, PAC=>$newpac);

## ղþɽ
&output_additional(PAC=>$newpac, PACF=>$pacf,
                   output_file=>$conf->{'expand_additional'});

## ѥå
my($deb_size) = &calc_filesize(PAC=>$newpac, PACF=>$pacf);
print "Size of Debian Packages is ".
  $deb_size."(".int($deb_size / 1000000)."MB).\n";

exit;

#######################################################################
#######################################################################

#######################################################################
## MODULE: output_packages
## DESC:
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub output_packages{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($file) = $ref{'file'};
  my($PAC) = $ref{'PAC'};
##
  my($tag_names) = $kdeb->PACN_names();
  my($packages) = $PAC->{$tag_names};
  my($fh, $res) = $kdeb->open_file(file=>"> ".$file);
  print $fh join("\n", @{$packages});
  print $fh "\n";
  $fh->close();
} ## output_packages

#######################################################################
## MODULE: output_provides
## DESC: Provides 
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub output_provides{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($file) = $ref{'file'};
  my($PAC) = $ref{'PAC'};
##
  my($fh, $res) = $kdeb->open_file(file=>"> ".$file);
  my($tag_provides) = $kdeb->PACN_provides();
  my($provide);
  foreach $provide (@{$PAC->{$tag_provides}}){
    ## ۥѥå̾
    $kdeb->debug_print_provide(PAC=>$PAC, provide=>$provide, fhout=>$fh);
  } ## foreach $provide
  $fh->close();
} ## output_provides

#######################################################################
## MODULE: calc_filesize
## DESC: DEBեΥ׻
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub calc_filesize{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($PACF) = $ref{'PACF'};
##
  my($tag_names) = $kdeb->PACN_names();
  my($name);
  my($size) = 0;
  my($tag_check, $tag_info, $id);
  foreach $name (@{$PAC->{$tag_names}}){
    ## åʸ PACF ΥեIDֹˤʤäƤ롥
    $tag_check = $kdeb->PACN_check(name=>$name);
    $id = $PAC->{$tag_check};
    ## ե륵­
    $tag_info = $kdeb->PACN_info(name=>$name, info=>'Size');
    $size += $PACF->[$id]->{'PAC'}->{$tag_info};
  } ## foreach $name
  return($size);
} ## calc_filesize

#######################################################################
## MODULE: assemble_provides
## DESC: ѥåե뽸 PACF  Provides 򽸤
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub assemble_provides{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($PAC) = $ref{'PAC'};
  my($PACF) = $ref{'PACF'};
##
  my($i);
  for($i = 0; $i <= $#{$PACF}; $i++){
    print STDERR "Assembling Provides in ".$PACF->[$i]->{'id'}."\n"
      if($debug & 1);
    &copy_provides(from_pac=>$PACF->[$i]->{"PAC"}, to_pac=>$PAC);
  } ## for($i)
} ## assemble_provides

#######################################################################
## MODULE: copy_provides
## DESC: from_pac ˤ Provides  to_pac ˥ԡ
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub copy_provides{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($fpac) = $ref{'from_pac'};
  my($tpac) = $ref{'to_pac'};
##
  my($tag_provides) = $kdeb->PACN_provides();
  my($provide, $name);
  my($tag_info);
  my($tag_provide);
  ## Ʋۥѥå˽
  foreach $provide (@{$fpac->{$tag_provides}}){
    $tag_provide = $kdeb->PACN_provide(name=>$provide);
    ## fpac βۥѥåϿƤƼ¥ѥåˤĤ
    foreach $name (@{$fpac->{$tag_provide}}){
      ## ͥ٥٥򥳥ԡ
      $tag_info = $kdeb->PACN_info(name=>$name, info=>'LEVEL');
      $tpac->{$tag_info} = $fpac->{$tag_info};
      ## ۥѥå̾ꥹȤϿ
      $kdeb->PAC_add_provide(PAC=>$tpac, name=>$name, provides=>$provide);
    } ## foreach $name
  } ## foreach $provide
} ## copy_provides

#######################################################################
## MODULE: read_inputfile
## DESC:
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub read_inputfile{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($file) = $ref{'file'};
  my($pac) = $ref{'PAC'};
  my($pacf) = $ref{'PACF'};
##
  my($fh, $res) = $kdeb->open_file(file=>$file);
  die "No such file($file)." if($res == 0);
  while(<$fh>){
    chomp;
    next if((/^$/) || (/^\#/));
    $kdeb->PAC_add_package(PAC=>$pac, PACF=>$pacf, name=>$_);
  }
  $fh->close();
} ## read_inputfile

#######################################################################
## MODULE: correct_packages
## DESC:
## - $newpac_names ϥ塼
## - $newpac_names ˤѥåĤĥåơ
##   ɬפʥѥå $newpac_names κǸ롥
## - $newpac_names κǸޤõнλ
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub correct_packages{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($pac) = $ref{'PAC'};
  my($pacf) = $ref{'PACF'};
  my($rpac) = $ref{'RPAC'};
##
  my($tag_names) = $kdeb->PACN_names();
  my($names) = $pac->{$tag_names};
##
  my($required_packages, $add_packages);
  my($i) = 0;
  my($res, $n, $name);
  while($i <= $#{$names}){
    ## 塼ɽ
    print STDERR "QUEUE(".$i.":".$#{$names}.") is ".join(",", @{$names})."\n"
      if($debug & 0x10);
    ##
    print STDERR "Checking ".$names->[$i]."\n"
      if($debug & 8);
    ## ǽ˥ѥåѥåꥹȤˤ뤫å
    ($res, $n) = $kdeb->PACF_check_name
      (PACF=>$pacf, name=>$names->[$i]);
    die "$i(".$names->[$i].") is not in packages.\n" if($res == 0);
    print STDERR $names->[$i]." is in $n\n";
    ## ѥåɬפʥѥå
    ##   $required_packages  , ǶڤäΤäƤ
    $required_packages = $kdeb->get_required_packages
      (PAC=>$pacf->[$n]->{'PAC'}, name=>$names->[$i]);
      ## , packages=>$pac
    ## $required_packages ǤϤɬפʥѥå
    ## - ֥å
    $add_packages = &get_add_packages(PAC=>$pac, RPAC=>$rpac, PACF=>$pacf,
                                      packages=>$required_packages);
    ## $add_packages ˤѥå򥭥塼κǸ
    ## ΤȤǤ˥塼ˤΤʤ
    foreach $name (@{$add_packages}){
      print "Adding $name\n"
        if($debug & 4);
      $kdeb->PAC_add_package(PAC=>$pac, PACF=>$pacf, name=>$name);
    } ## foreach $name
    $i++;
  } ## for($i)
} ## correct_packages

#######################################################################
## MODULE: get_add_packages
## DESC:
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub get_add_packages{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($pac) = $ref{'PAC'};
  my($rpac) = $ref{'RPAC'};
  my($pacf) = $ref{'PACF'};
  my($packages) = $ref{'packages'};
##
  my($res);
  my($or_packages, $n);
  my($name, $ver, $i);
  my($check);
  my(@new_or_packages) = ();
  my(@add_packages) = ();
  my(%check_package);
  my($tag_provides, $tag_provide, $provide);
##
  foreach $or_packages (@{$packages}){
    ## OR ʤΤǡor_packagesΤɤ줫ΥѥåФ
    ## OR ѥå˸Ĥ $check = 1 ˤ
    $check = 0;
    @new_or_packages = ();
    ## ƥѥå
    foreach $n (@{$or_packages}){
      ## ѥå̾ȥСʬΥ
      ($name, $ver) = $kdeb->get_real_package_name(name=>$n);
      print "  Check '$n'->'$name'\n"
        if($debug & 2);
      ## 塼ˤǤˤ뤫å
      $res = $kdeb->PAC_check_name(PAC=>$newpac, name=>$name);
      if($res > 0){
        ## 塼ˤǤˤȤ
        $check = 1;
        if($res == 2){
          ## ۥѥå̾Ȥ¸
          $tag_provide = $kdeb->PACN_provide(name=>$name);
          print "    $name is OK(".join(",",@{$newpac->{$tag_provide}}).").\n"
            if($debug & 1);
        }else{
          print "    $name is OK.\n"
            if($debug & 1);
        } ## if($res)
      }else{
        print "    $name is NG.\n"
          if($debug & 1);
        ## 塼˥ѥåʤСѥåꥹȤõ
        ## ۥѥåassembleθġΥѥåꥹȤ¸ߤ򸡺
        ($res, $i) = $kdeb->PACF_check_name(PACF=>$pacf, name=>$name);
        if($res > 0){
          if($res == 2){ ## ۥѥå̾
            $tag_provides = $kdeb->PACN_provide(name=>$name);
            ## ºݤβۥѥå󶡤¥ѥå $rpac 
            $provide = $rpac->{$tag_provides}->[0];
            print "    $provide($name) is found in list.\n"
              if($debug & 1);
            push(@new_or_packages, $provide);
          }else{
            print "    $name is found in list.\n"
              if($debug & 1);
            push(@new_or_packages, $name);
          }
        }
      } ## if($res)
    } ## foreach $n
    ## 塼˥ѥå $check = 1
    if($check == 0){
      if($#new_or_packages > 0){
        ## ʣĸ䤬󤬤ä顤ȤǽƤ餦
        die "Need select ".join(" or ", @new_or_packages)."\n";
      }elsif($#new_or_packages == -1){
        ## 䤬ʤȤ => ѥåꥹȤˤʤ
        print STDERR "There is not $name.\n";
      }else{
        ## ѥå֤äƤʤå
        $n = $new_or_packages[0];
        if($check_package{$n} eq ""){
          ## ֤äƤʤäɲ
          push(@add_packages, $n);
          $check_package{$n} = "x";
        } ## foreach $n
      }
    } ## if($check)
  } ## foreach $or_packages
  return(\@add_packages);
} ## get_add_packages

sub check_package{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($pac) = $ref{'PAC'};
  my($name) = $ref{'name'};
##
} ## check_package

#######################################################################
## MODULE: output_additional
## DESC: DependsRecommendsSuggestsƤѥå̾
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub output_additional{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($pac) = $ref{'PAC'};
  my($pacf) = $ref{'PACF'};
  my($output_file) = $ref{'output_file'};
##
  my($fhout, $res) = $kdeb->open_file(file=>"> ".$output_file);
  print $fhout "## Output Depends.\n";
  &output_field(PACF=>$pacf, PAC=>$pac, field=>'Depends', fhout=>$fhout);
  print $fhout "\n## Output Recommends.\n";
  &output_field(PACF=>$pacf, PAC=>$pac, field=>'Recommends', fhout=>$fhout);
  print $fhout "\n## Output Suggests.\n";
  &output_field(PACF=>$pacf, PAC=>$pac, field=>'Suggests', fhout=>$fhout);
  $fhout->close();
} ## print_additional

#######################################################################
## MODULE: output_field
## DESC: PACѥåλꤵ줿եΥѥå̾
## IN:
## OUT:
## OP:
## STATUS:
## END:
sub output_field{
  my($self) = shift if(defined($_[0]) && (ref($_[0]) ne ''));
  my(%ref) = @_;
##
  my($pac) = $ref{'PAC'};
  my($pacf) = $ref{'PACF'};
  my($field) = $ref{'field'};
  my($fhout) = $ref{'fhout'};
##
  my($tag_names) = $kdeb->PACN_names();
  my($names) = $pac->{$tag_names};
  my($name);
  my($res);
  my($packages, $or_packages);
  my($id);
##
  foreach $name (@{$names}){
    print STDERR "$name\n" if($name eq "cron");
    ($res, $id) = $kdeb->PACF_check_name(PACF=>$pacf, name=>$name);
    $packages = $kdeb->get_field_packages(PAC=>$pacf->[$id]->{'PAC'},
                                          name=>$name, field=>$field);
    foreach $or_packages (@{$packages}){
      print $fhout join(" | ", @{$or_packages});
      print $fhout "\n";
      if($name eq "cron"){
        print join(" | ", @{$or_packages});
        print "\n";
      }
    }
  } ## foreach $name
} ## print_field

#######################################################################
#######################################################################
#######################################################################


# Local Variables:
# End:
