/*
 * FIXME: Small memory leaks
 *
 */

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include "proto.h"
#include "../src/pimppa.h"

#define MODE_ADD		0
#define MODE_EDIT		1

struct kludge
{
	bowser_table *table;
	GtkWidget **widgets;
};

typedef struct kludge kludge;

struct flagkludge
{
	bowser_flags *flags;
	unsigned int which_flag;
};

typedef struct flagkludge flagkludge;

static void modify(bowser_table *table, int mode);
static void add_stub(GtkWidget *widget, gpointer data);
static void delete_stub(GtkWidget *widget, gpointer data);
static void edit_stub(GtkWidget *widget, gpointer data);
static void refresh(GtkWidget *widget, gpointer data);

GnomeUIInfo bulkMenu[] = {

	GNOMEUIINFO_ITEM_NONE("Add", "Edit item", add_stub),
    GNOMEUIINFO_ITEM_NONE("Edit selected", "Edit selected item", edit_stub),
    GNOMEUIINFO_ITEM_NONE("Delete selected", "Delete selected item", delete_stub),
	GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_NONE("Refresh", "Refresh current table", refresh),
	GNOMEUIINFO_END
};

static gint
doubleclick_handler(GtkWidget *widget, GdkEventButton *event,
                        gpointer data)
{
	static int kludge=0;

	if(event->type==GDK_2BUTTON_PRESS && event->button==1)
	{
		edit_stub(widget, data);
		kludge^=1;
	}

	if(!kludge && event->type==GDK_BUTTON_RELEASE)
	{
		gtk_clist_unselect_all((GtkCList *)widget);
		kludge^=1;
	}

	return(TRUE);
}

static void
flag_pressed(GtkWidget *widget, gpointer data)
{
	flagkludge *tmp=(flagkludge *)data;

	tmp->flags->flag_flag^=(1L<<tmp->which_flag);

//	fprintf(stderr, "DEBUG: flag_pressed(), %d %ld\n", 
//			tmp->which_flag,
//			tmp->flags->flag_flag);
}

static void
flag_destroy(GtkWidget *widget, gpointer data)
{
	flagkludge *tmp=(flagkludge *)data;

	free(tmp);

//	fprintf(stderr, "DEBUG: flag_destroy()\n");
}

static void
row_selected(GtkWidget *widget, gpointer data)
{

}

static void 
add_stub(GtkWidget *widget, gpointer data)
{
	modify((bowser_table *)data, MODE_ADD);
}

static void
edit_stub(GtkWidget *widget, gpointer data)
{
	modify((bowser_table *)data, MODE_EDIT);
}

static void
modify_clicked(GnomeDialog *dlg, int button, gpointer data)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	GList *tmplist;
	kludge *tmpkludge=(kludge *)data;
	GtkWidget **widgets=tmpkludge->widgets;
	bowser_table *table=tmpkludge->table;
	int i;
	char fields[QUERY_MAX];
	char values[QUERY_MAX];

	switch(button)
	{
		case 0:
			break;
		case 1:
		default:
			gtk_clist_thaw(table->table_list);
			gnome_dialog_close(dlg);
			return;
			break;
	}

	table=tmpkludge->table;

	values[0]=0; fields[0]=0;
	for(i=0;i<table->table_column_amount;i++)
	{
		char escapebuf[QUERY_MAX];
		char *tmpstr;

		strcat(values, "'");

		switch(table->table_column[i].column_type)
		{
			case COLUMN_TEXT:
			{
				tmpstr=gtk_entry_get_text(GTK_ENTRY(widgets[i]));
				mysql_escape_string(escapebuf, tmpstr, strlen(tmpstr));

				strcat(values, escapebuf);
			
				break;
			}
			case COLUMN_NUMBER:
			{
				int number;

				tmpstr=gtk_entry_get_text(GTK_ENTRY(widgets[i]));
		
				if(sscanf(tmpstr, "%d", &number)==0)
				{
					my_error_dialog("Unh, number columns wanna numbers, man!");
					return;
				}
				
				mysql_escape_string(escapebuf, tmpstr, strlen(tmpstr));

				strcat(values, escapebuf);

				break;
			}
			case COLUMN_COMBO:
			{
				bowser_foreign *foreign=table->table_column[i].column_extra;

				if(foreign->foreign_key[0])
				{
					int retval;
		//			fprintf(stderr, "HIER!\n");	

		//			fprintf(stderr, "SELECT %s 
					retval=p_query(db, "SELECT %s " 
							   "FROM %s "
							   "WHERE %s='%s'",
							foreign->foreign_key,
							foreign->foreign_table,
							foreign->foreign_name,
							gtk_entry_get_text(GTK_ENTRY(widgets[i])));
					sql_result=mysql_store_result(db);
					if(sql_result)
					{
						if((sql_row=mysql_fetch_row(sql_result)))
						{
		//					fprintf(stderr, "DEBUG: got %s\n", sql_row[0]);
				
							mysql_escape_string(escapebuf, 
												sql_row[0], 
												strlen(sql_row[0]));
		
							strcat(values, escapebuf);
						}
						else
						{
							my_error_dialog("Invalid value in combox!\n");
							return;
						}
						
						mysql_free_result(sql_result);
					}
				}
				break;
			}
			case COLUMN_FLAGS:
			{
				char buffer[512];
				struct bowser_flags *tmp;

				tmp=table->table_column[i].column_extra;

				sprintf(buffer, "%lu", 
						tmp->flag_flag);

//				fprintf(stderr, "DEBUG: Flags %s\n", buffer);

				mysql_escape_string(escapebuf, buffer, strlen(buffer));
				strcat(values, escapebuf);
			}
			default:
				break;
		}

		strcat(values, "'");

		strcat(fields, table->table_column[i].column_name);
		
		if(i<table->table_column_amount-1)
		{
			strcat(values, ",");
			strcat(fields, ",");
		}	
	}
	
// Check that key field isn't NULL

	if(strcmp(gtk_entry_get_text(GTK_ENTRY(widgets[0])), "")==0)
	{
		my_error_dialog("First field can't be empty!\n");
		return;
	}

// Check for the change of the key field

	if((tmplist=table->table_list->selection) != NULL)
	{
		gchar *text;
	
		gtk_clist_get_text(GTK_CLIST(table->table_list), (int)tmplist->data,
						0, &text);
	
		if(strcmp(text, gtk_entry_get_text(GTK_ENTRY(widgets[0]))) != 0)
		{
			// key field changed, delete old
			delete_stub(NULL, table); 
		}
	}
		
//	fprintf(stderr, "REPLACE INTO %s (%s)
	p_query(db, "REPLACE INTO %s (%s) "
		    "VALUES (%s)",
		table->table_name, fields,
		values);

	free(tmpkludge);

	gtk_clist_thaw(table->table_list);

	refresh(NULL, table);

	gnome_dialog_close(dlg);
}


// static void 
// add_group(GtkWidget *widget, gpointer data, int flags)
static void
modify(bowser_table *table, int mode)
{
	GtkWidget *dlg;
	GList *tmplist=NULL;
	gchar **texts=NULL;
	GtkCList *list=table->table_list;
	kludge *tmpkludge;
	int i=0;
		
	texts=malloc(sizeof(gchar *)*table->table_column_amount);

	if(mode==MODE_EDIT)
	{
		if((tmplist=list->selection) == NULL)
		{
			free(texts);
			return;
		}
		
		for(i=0;i<table->table_column_amount;i++)
		{
			gtk_clist_get_text(GTK_CLIST(list), (int)tmplist->data,
							i, &texts[i]);
		}
	}
	else
	{
		for(i=0;i<table->table_column_amount;i++)
		{
			texts[i]=table->table_column[i].column_default;
		}
	}

	gtk_clist_freeze(list);

	dlg=gnome_dialog_new((mode==MODE_ADD ? "Add" : "Edit"),
						GNOME_STOCK_BUTTON_OK,
						GNOME_STOCK_BUTTON_CANCEL,
						NULL);

	gtk_widget_set_usize(GTK_WIDGET(dlg), 400,0);
	gtk_window_set_position(GTK_WINDOW(dlg), GTK_WIN_POS_CENTER);

//	gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(Bowser));
	
	tmpkludge=malloc(sizeof(tmpkludge));
	tmpkludge->widgets=malloc(sizeof(GtkWidget *)*table->table_column_amount);
	tmpkludge->table=table;

	gtk_signal_connect(GTK_OBJECT(dlg), "clicked",
						GTK_SIGNAL_FUNC(modify_clicked),
						tmpkludge);

	for(i=0;i<table->table_column_amount;i++)
	{
		bowser_column column=table->table_column[i];

//		fprintf(stderr, "DEBUG: ColType: %d\n", column.column_type);

		switch(column.column_type)
		{
			case COLUMN_TEXT:
			{
//				fprintf(stderr, "DEBUG: JEh!\n");

				newbox(column.column_name, GNOME_DIALOG(dlg)->vbox, 
						(texts ? texts[i] : ""), &tmpkludge->widgets[i],  300);
				break;
			}
			case COLUMN_NUMBER:
			{
				newbox(column.column_name, GNOME_DIALOG(dlg)->vbox, 
						(texts ? texts[i] : ""), &tmpkludge->widgets[i],  300);
				break;
			}
			case COLUMN_FLAGS:
			{
				bowser_flags *flagtmp=column.column_extra;
				int j;
				GtkWidget *button, *label;

				if(texts)
					flagtmp->flag_flag=atoi(texts[i]);
				else
					flagtmp->flag_flag=0;
			
//				fprintf(stderr, "DEBUG: %s %ld\n", flagtmp->flag_name[0],
//												flagtmp->flag_flag);

				label=gtk_label_new("Flags");
				gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),
									label, TRUE, TRUE, 0);
				gtk_widget_show(label);
				

				for(j=0;j<flagtmp->flag_amount;j++)
				{
					flagkludge *tmp;

					tmp=malloc(sizeof(flagkludge));

					tmp->flags=flagtmp;
					tmp->which_flag=j;

					button=gtk_toggle_button_new_with_label(flagtmp->flag_name[j]);
					if((flagtmp->flag_flag & (1L<<j)))
					{
						gtk_toggle_button_set_active((GtkToggleButton *)button, TRUE);
					}
					
					gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),
										button, TRUE, TRUE, 0);
                	gtk_signal_connect(GTK_OBJECT(button), "pressed",
										(GtkSignalFunc) flag_pressed, tmp);
                	gtk_signal_connect(GTK_OBJECT(button), "destroy",
									(GtkSignalFunc) flag_destroy, tmp);
					
					gtk_widget_show(button);
				}
				
				break;
			}
			case COLUMN_COMBO:
			{
				GtkWidget *combox, *label;
				GList *glist;
				bowser_foreign *foreign=column.column_extra;
	
				label=gtk_label_new(column.column_name);
				gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),
									label, TRUE, TRUE, 0);
				gtk_widget_show(label);
				
				glist=get_sql(db, "SELECT %s FROM %s "
						  "ORDER BY %s",
						foreign->foreign_name,
						foreign->foreign_table,
						foreign->foreign_name);

				if(mode==MODE_EDIT)	// Set current as default, ugly hack	
				{
					gchar *tmptext=malloc(strlen(texts[i])+1);
					strcpy(tmptext, texts[i]);
					glist=g_list_prepend(glist, tmptext);
				}

    			combox=gtk_combo_new();
  			    gtk_combo_set_popdown_strings( GTK_COMBO(combox), glist) ;

				gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox), combox, TRUE, TRUE, 0);
    			gtk_signal_connect (GTK_OBJECT(GTK_COMBO(combox)), "destroy",
			                        (GtkSignalFunc) clear_glist, glist);
			    gtk_widget_show(combox);
				
				gtk_combo_set_value_in_list(GTK_COMBO(combox), TRUE, FALSE);
    			
				tmpkludge->widgets[i]=GTK_WIDGET(GTK_COMBO(combox)->entry);
				break;
			}
			default:
				break;
		}
	}

	gtk_widget_show_all(dlg);

	return;
}

static void
refresh(GtkWidget *widget, gpointer data)
{
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	int i, foreigns=0;
	char buffer[QUERY_MAX];
	char foreign[QUERY_MAX];
	char where[QUERY_MAX];
	bowser_table *table=(bowser_table *)data;
	GtkWidget *wherebox;
	gchar *wheretmp;
	GtkCList *list;

//	fprintf(stderr, "DEBUG: refresh()\n");

	if(!table)
	{
		fprintf(stderr, "Error: Urg, no 'gpointer data' for refresh()\n");
		return;
	}
	buffer[0]=0;foreign[0]=0;where[0]=0;
	
	list=table->table_list;
	if(!list)
		return;

	gtk_clist_clear(list);

	wherebox=gtk_object_get_data(GTK_OBJECT(list), "wherebox");
	if(!wherebox)
		return;

	wheretmp=gtk_entry_get_text(GTK_ENTRY(wherebox));
	if(!wheretmp)
		return;

	strcpy(where, wheretmp);

// Count foreigns

	for(i=0;i<table->table_column_amount;i++)
	{
		if(table->table_column[i].column_type==COLUMN_COMBO)
			foreigns++;
	}

	for(i=0;i<table->table_column_amount;i++)
	{
		bowser_column *column=&table->table_column[i];
		bowser_foreign *ftmp=column->column_extra;
			
		if(column->column_type==COLUMN_COMBO && ftmp && ftmp->foreign_table[0])
		{
			char string[QUERY_MAX];

			strcat(foreign, ftmp->foreign_table);
			strcat(foreign, ",");
			
			sprintf(string, "%s=%s",
					ftmp->foreign_key,
					column->column_name);

//			strcat(where, string);

			if(foreigns>0)
			{
				strcat(where, " AND ");
				strcat(where, string);
				foreigns--;
			}

			strcat(buffer, ftmp->foreign_name);
		}
		else
			strcat(buffer, column->column_name);
		
		if(i<table->table_column_amount-1)
			strcat(buffer, ", ");
	}

/*
	fprintf(stderr, "SELECT %s FROM %s %s %s %s\n\n", 
				buffer, 
				(foreign[0] ? foreign : ""),
				table->table_name,
				(where[0] ? "WHERE " : ""),
				(where[0] ? where : ""));
*/

//	fprintf(stderr, "SELECT %s FROM %s %s %s %s", 
	p_query(db, "SELECT %s FROM %s %s %s %s", 
		buffer, 
		(foreign[0] ? foreign : ""),
		table->table_name,
		(where[0] ? "WHERE " : ""),
		(where[0] ? where : ""));
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		gtk_clist_freeze(GTK_CLIST(list));
		
		while((sql_row=mysql_fetch_row(sql_result)))
		{
			gtk_clist_prepend(GTK_CLIST(list), sql_row);
		}

		mysql_free_result(sql_result);
		
		gtk_clist_sort(GTK_CLIST(list));
		gtk_clist_thaw(GTK_CLIST(list));

	}

	return;
}

static void 
delete_stub(GtkWidget *widget, gpointer data)
{
	GList *tmplist=NULL;
	bowser_table *table=(bowser_table *)data;
	gchar *id;

	if((tmplist=table->table_list->selection)==NULL)
		return;

	gtk_clist_get_text(table->table_list, (int)tmplist->data, 0, &id);


/*
	fprintf(stderr, "DELETE FROM %s WHERE %s='%s'\n",
					table->table_name,
					table->table_column[0].column_name, id);			
*/

	p_query(db, "DELETE FROM %s "
	            "WHERE %s='%s'",
		table->table_name,
		table->table_column[0].column_name, id);			
	
	refresh(NULL, table);

}

GtkWidget *get_table(bowser_table *table)
{
	GtkWidget *popupmenu, *tempwid, *list, *wherebox;
	GtkWidget *vbox, *hbox, *scrolled_window, *label;
	gchar **titles;
	char buffer[PATH_MAX];
	int i;

	vbox=gtk_vbox_new(FALSE, 0);

	titles=malloc(sizeof(gchar *)*(table->table_column_amount));

	for(i=0;i<table->table_column_amount;i++)
		titles[i]=table->table_column[i].column_name;

	table->table_list=(GtkCList *)gtk_clist_new_with_titles(
								 table->table_column_amount, titles);

	list=(GtkWidget *)table->table_list;

	gtk_signal_connect(GTK_OBJECT(list), "select_row",
						GTK_SIGNAL_FUNC(row_selected),
						table);
    gtk_signal_connect(GTK_OBJECT(list), "button_press_event",
                        GTK_SIGNAL_FUNC(doubleclick_handler),
                        table);
    gtk_signal_connect(GTK_OBJECT(list), "button_release_event",
                        GTK_SIGNAL_FUNC(doubleclick_handler),
                        table);

	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
									GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_box_pack_start(GTK_BOX(vbox), scrolled_window, TRUE, TRUE, 0);
	gtk_widget_show (scrolled_window);
	
	for(i=0;i<table->table_column_amount;i++)
	{
		gtk_clist_set_column_width (GTK_CLIST(list), i, table->table_column[i].column_width);
	}

/*
	gtk_clist_set_shadow_type(GTK_CLIST(group_list), GTK_SHADOW_OUT);

	gtk_clist_set_column_width (GTK_CLIST(group_list), 0, 300);
	gtk_clist_set_column_width (GTK_CLIST(group_list), 1, 120);
*/

	gtk_container_add(GTK_CONTAINER(scrolled_window), list);
    gtk_widget_show(list);

/******* Add popup menu **********/

	popupmenu=gnome_popup_menu_new(bulkMenu);
	gnome_popup_menu_attach(popupmenu, list, table);
	gnome_app_install_menu_hints(GNOME_APP(Bowser), bulkMenu);
	
/******* wherebox ****************/
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show (hbox);
	
	label = gtk_label_new("SQL where:");
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);

    wherebox=gtk_entry_new_with_max_length(PATH_MAX);
    gtk_signal_connect(GTK_OBJECT(wherebox),"activate",
                        GTK_SIGNAL_FUNC(refresh),
                        table);

	sprintf(buffer, "%s LIKE '%%'", table->table_column[0].column_name);
	gtk_entry_set_text(GTK_ENTRY(wherebox), buffer);

    gtk_object_set_data(GTK_OBJECT(list), "wherebox", wherebox);

    gtk_box_pack_start(GTK_BOX(hbox),wherebox,TRUE,TRUE,0);

/****** Add, Edit, Cancel gadgets **********/
	
	hbox = gtk_hbox_new (TRUE, 15);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
	gtk_widget_show (hbox);

	tempwid = gtk_button_new_with_label (_("Add"));
	GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (hbox), tempwid, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT (tempwid), "clicked",
						GTK_SIGNAL_FUNC (add_stub), table);
	gtk_widget_show (tempwid);

	tempwid = gtk_button_new_with_label (_("Edit"));
	GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (hbox), tempwid, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT (tempwid), "clicked",
				      GTK_SIGNAL_FUNC (edit_stub), table);
	gtk_widget_show (tempwid);

	tempwid = gtk_button_new_with_label (_("Delete"));
	GTK_WIDGET_SET_FLAGS (tempwid, GTK_CAN_DEFAULT);
	gtk_box_pack_start (GTK_BOX (hbox), tempwid, TRUE, TRUE, 0);
	gtk_signal_connect (GTK_OBJECT (tempwid), "clicked",
						GTK_SIGNAL_FUNC (delete_stub), table);
	gtk_widget_show (tempwid);
	
	refresh(NULL, table);

	return(vbox);
}

