/*
 * Decompiled with CFR 0.152.
 */
package de.mud.ssh;

import de.mud.ssh.Cipher;
import de.mud.ssh.SshMisc;
import java.math.BigInteger;

public class SshCrypto {
    private Cipher sndCipher;
    private Cipher rcvCipher;

    public SshCrypto(String type, byte[] key) {
        this.sndCipher = Cipher.getInstance(type);
        this.rcvCipher = Cipher.getInstance(type);
        this.sndCipher.setKey(key);
        this.rcvCipher.setKey(key);
    }

    public byte[] encrypt(byte[] block) {
        return this.sndCipher.encrypt(block);
    }

    public byte[] decrypt(byte[] block) {
        return this.rcvCipher.decrypt(block);
    }

    public static byte[] encrypteRSAPkcs1Twice(byte[] clearData, byte[] server_key_public_exponent, byte[] server_key_public_modulus, byte[] host_key_public_exponent, byte[] host_key_public_modulus) {
        byte[] key2mod;
        byte[] key2exp;
        byte[] key1mod;
        byte[] key1exp;
        if (server_key_public_modulus.length < host_key_public_modulus.length) {
            key1exp = server_key_public_exponent;
            key1mod = server_key_public_modulus;
            key2exp = host_key_public_exponent;
            key2mod = host_key_public_modulus;
        } else {
            key1exp = host_key_public_exponent;
            key1mod = host_key_public_modulus;
            key2exp = server_key_public_exponent;
            key2mod = server_key_public_modulus;
        }
        int offset = 0;
        byte[] EncryptionBlock = new byte[key1mod.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        int i = 2;
        while (i < EncryptionBlock.length - clearData.length - 1) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
            ++i;
        }
        EncryptionBlock[offset++] = 0;
        int i2 = 0;
        while (i2 < clearData.length) {
            EncryptionBlock[offset++] = clearData[i2];
            ++i2;
        }
        BigInteger m = new BigInteger(1, key1mod);
        BigInteger e = new BigInteger(1, key1exp);
        BigInteger message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        byte[] messageByteTemp = message.toByteArray();
        byte[] messageByte = new byte[key1mod.length];
        int tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        int i3 = messageByte.length - messageByteTemp.length + tempOffset;
        while (i3 < messageByte.length) {
            messageByte[i3] = messageByteTemp[tempOffset++];
            ++i3;
        }
        clearData = messageByte;
        offset = 0;
        EncryptionBlock = new byte[key2mod.length];
        EncryptionBlock[0] = 0;
        EncryptionBlock[1] = 2;
        offset = 2;
        int i4 = 2;
        while (i4 < EncryptionBlock.length - clearData.length - 1) {
            EncryptionBlock[offset++] = SshMisc.getNotZeroRandomByte();
            ++i4;
        }
        EncryptionBlock[offset++] = 0;
        int i5 = 0;
        while (i5 < clearData.length) {
            EncryptionBlock[offset++] = clearData[i5];
            ++i5;
        }
        m = new BigInteger(1, key2mod);
        e = new BigInteger(1, key2exp);
        message = new BigInteger(1, EncryptionBlock);
        message = message.modPow(e, m);
        messageByteTemp = message.toByteArray();
        messageByte = new byte[key2mod.length];
        tempOffset = 0;
        while (messageByteTemp[tempOffset] == 0) {
            ++tempOffset;
        }
        int i6 = messageByte.length - messageByteTemp.length + tempOffset;
        while (i6 < messageByte.length) {
            messageByte[i6] = messageByteTemp[tempOffset++];
            ++i6;
        }
        byte[] encrypted_session_key = new byte[key2mod.length + 2];
        encrypted_session_key[1] = (byte)(8 * key2mod.length & 0xFF);
        encrypted_session_key[0] = (byte)(8 * key2mod.length >> 8 & 0xFF);
        int i7 = 0;
        while (i7 < key2mod.length) {
            encrypted_session_key[i7 + 2] = messageByte[i7];
            ++i7;
        }
        return encrypted_session_key;
    }
}

