/*
**  MimeMultipart.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <Pantomime/MimeMultipart.h>

#include <Pantomime/Constants.h>

#include <Foundation/NSDebug.h>

@implementation MimeMultipart

//
//
//
- (id) init
{
  array = [NSMutableArray array];
  RETAIN(array);
  
  return self;
}


//
//
//
- (void) dealloc
{
  RELEASE(array);
  
  [super dealloc];
}


//
//
//
- (void) addBodyPart: (Part *) thePart 
{
  if ( thePart )
    {
      [array addObject: thePart];
    }
  else
    {
      NSDebugLog(@"MimeMultipart: -addBodyPart tried to insert a null mime body part");
    }
}


//
//
//
- (void) removeBodyPart: (Part *) thePart
{
  if ( thePart )
    {
      [array removeObject: thePart];
    }
}

//
// Returns the number of mime body parts in this mime multipart object.
//
- (int) count
{
  return [array count];
}


//
//
//
- (Part *) bodyPartAtIndex: (int) theIndex
{
  return [array objectAtIndex: theIndex];

}

@end
