/*
**  SMTP.h
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**  
**  This library is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  Lesser General Public License for more details.
**  
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _Pantomime_H_SMTP
#define _Pantomime_H_SMTP

#include <Pantomime/Service.h>
#include <Pantomime/Transport.h>

#import <Foundation/NSArray.h>
#import <Foundation/NSData.h>
#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>

@class Connection;
@class Message;
@class TCPConnection;

//
//
//
@interface SMTPResponse : NSObject
{
  NSString *text;
  int code;
}

- (id) initResponseWithCode: (int) theCode
                       text: (NSString *) theText;

- (int) code;
- (NSString *) text;

@end


//
//
//
@interface SMTP : NSObject <Service, Transport>
{
  id<Connection> tcpConnection;
  
  NSMutableArray *supportedMechanisms;
  NSMutableArray *responsesFromServer;
  
  NSString *name;
  int port;

  NSString *username;

  // RFC1870: Message Size Declaration
  unsigned int maxSizeAllowedByServer;
}

- (void) close;

- (void) reset;

- (NSString *) lastResponse;
- (int) lastResponseCode;

@end


//
// Private methods
//
@interface SMTP (Private)

- (void) _decodeSupportedAuthenticationMechanismFromResponse: (SMTPResponse *) theResponse;

- (void) _decodeMaxSizeAllowedFromResponse: (SMTPResponse *) theResponse;

- (void) _parseServerOutput;

- (BOOL) _sendMessage: (Message *) theMessage
        withRawSource: (NSData *) theRawSource;

- (BOOL) _writeRecipients: (NSArray *) recipients
        usingBouncingMode: (BOOL) aBOOL;

- (BOOL) _writeMessageFromRawSource: (NSData *) theRawSource;

- (BOOL) _plainAuthentication: (NSString *) theUsername
                     password: (NSString *) thePassword;

- (BOOL) _loginAuthentication: (NSString *) theUsername
                     password: (NSString *) thePassword;

- (BOOL) _cramMD5Authentication: (NSString *) theUsername
                       password: (NSString *) thePassword;

- (void) _preInit;
- (BOOL) _postInit;

@end

#endif // _Pantomime_H_SMTP
