# --
# Kernel/Language/pt.pm - provides pt language translation
# Copyright (C) 2004 CAT <filipehenriques at ip.pt>
# --
# $Id: pt.pm,v 1.12 2004/08/24 08:20:42 martin Exp $
# --
# This software comes with ABSOLUTELY NO WARRANTY. For details, see
# the enclosed file COPYING for license information (GPL). If you
# did not receive this file, see http://www.gnu.org/licenses/gpl.txt.
# --
package Kernel::Language::pt;

use strict;

use vars qw($VERSION);
$VERSION = '$Revision: 1.12 $';
$VERSION =~ s/^\$.*:\W(.*)\W.+?$/$1/;

# --
sub Data {
    my $Self = shift;
    my %Param = @_;
    my %Hash = ();

    # $$START$$
    # Last translation Tue Aug 24 10:11:39 2004 by 

    # possible charsets
    $Self->{Charset} = ['iso-8859-1', 'iso-8859-15', ];
    # date formats (%A=WeekDay;%B=LongMonth;%T=Time;%D=Day;%M=Month;%Y=Jear;)
    $Self->{DateFormat} = '%D.%M.%Y %T';
    $Self->{DateFormatLong} = '%A %D %B %T %Y';
    $Self->{DateInputFormat} = '%D.%M.%Y';
    $Self->{DateInputFormatLong} = '%D.%M.%Y - %T';

    %Hash = (
    # Template: AAABase
      ' 2 minutes' => ' 2 minutos',
      ' 5 minutes' => ' 5 minutos',
      ' 7 minutes' => ' 7 minutos',
      '(Click here to add)' => '(Clique aqui para adicionar)',
      '...Back' => '',
      '10 minutes' => '10 minutos',
      '15 minutes' => '15 minutos',
      'Added User "%s"' => '',
      'AddLink' => 'Adicionar link',
      'Admin-Area' => 'rea de Administrao',
      'agent' => 'Agente',
      'Agent-Area' => 'rea de Agente',
      'all' => 'todos',
      'All' => 'Todos',
      'Attention' => 'Ateno',
      'Back' => 'Retornar',
      'before' => 'antes',
      'Bug Report' => 'Relatrio de Erros',
      'Calendar' => '',
      'Cancel' => 'Cancelar',
      'change' => 'alterar',
      'Change' => 'Alterar',
      'change!' => 'alterar!',
      'click here' => 'clique aqui',
      'Comment' => 'Comentrio',
      'Contract' => '',
      'Crypt' => '',
      'Crypted' => '',
      'Customer' => 'Cliente',
      'customer' => 'cliente',
      'Customer Info' => 'Informao do Cliente',
      'day' => 'dia',
      'day(s)' => 'dia(s)',
      'days' => 'dias',
      'description' => 'descrio',
      'Description' => 'Descrio',
      'Directory' => '',
      'Dispatching by email To: field.' => 'Despachado pelo campo de email Para:',
      'Dispatching by selected Queue.' => 'Despachado pela Queue seleccionada',
      'Don\'t show closed Tickets' => 'No mostrar Tickets fechados',
      'Don\'t work with UserID 1 (System account)! Create new users!' => 'No trabalhe com o UserID 1(Conta de Sistema)! Criar novos utilizadores!',
      'Done' => 'Feito',
      'end' => 'fim',
      'Error' => 'Erro',
      'Example' => 'Exemplo',
      'Examples' => 'Exemplos',
      'Facility' => 'Facilidade',
      'FAQ-Area' => 'rea FAQ',
      'Feature not active!' => 'Caracterstica no activa!',
      'go' => 'ir',
      'go!' => 'ir!',
      'Group' => 'Grupo',
      'History::AddNote' => 'Added note (%s)',
      'History::Bounce' => 'Bounced to "%s".',
      'History::CustomerUpdate' => 'Updated: %s',
      'History::EmailAgent' => 'Email sent to customer.',
      'History::EmailCustomer' => 'Added email. %s',
      'History::FollowUp' => 'FollowUp for [%s]. %s',
      'History::Forward' => 'Forwarded to "%s".',
      'History::Lock' => 'Locked ticket.',
      'History::LoopProtection' => 'Loop-Protection! No auto-response sent to "%s".',
      'History::Misc' => '%s',
      'History::Move' => 'Ticket moved into Queue "%s" (%s) from Queue "%s" (%s).',
      'History::NewTicket' => 'New Ticket [%s] created (Q=%s;P=%s;S=%s).',
      'History::OwnerUpdate' => 'New owner is "%s" (ID=%s).',
      'History::PhoneCallAgent' => 'Agent called customer.',
      'History::PhoneCallCustomer' => 'Customer called us.',
      'History::PriorityUpdate' => 'Changed priority from "%s" (%s) to "%s" (%s).',
      'History::Remove' => '%s',
      'History::SendAgentNotification' => '"%s"-notification sent to "%s".',
      'History::SendAnswer' => 'Email sent to "%s".',
      'History::SendAutoFollowUp' => 'AutoFollowUp sent to "%s".',
      'History::SendAutoReject' => 'AutoReject sent to "%s".',
      'History::SendAutoReply' => 'AutoReply sent to "%s".',
      'History::SendCustomerNotification' => 'Notification sent to "%s".',
      'History::SetPendingTime' => 'Updated: %s',
      'History::StateUpdate' => 'Old: "%s" New: "%s"',
      'History::TicketFreeTextUpdate' => 'Updated: %s=%s;%s=%s;',
      'History::TicketLinkAdd' => 'Added link to ticket "%s".',
      'History::TicketLinkDelete' => 'Deleted link to ticket "%s".',
      'History::TimeAccounting' => '%s time unit(s) accounted. Now total %s time unit(s).',
      'History::Unlock' => 'Unlocked ticket.',
      'History::WebRequestCustomer' => 'Customer request via web.',
      'Hit' => 'Hit',
      'Hits' => 'Hits',
      'hour' => 'hora',
      'hours' => 'horas',
      'Ignore' => 'Ignorar',
      'invalid' => 'invlido',
      'Invalid SessionID!' => 'Identificador de Sesso Invlido',
      'Language' => 'Idioma',
      'Languages' => 'Idiomas',
      'last' => 'ultimo',
      'Line' => 'Linha',
      'Lite' => 'Lite',
      'Login failed! Your username or password was entered incorrectly.' => 'Login invlido! O utilizador ou password foram introduzidos incorrectamente.',
      'Logout successful. Thank you for using OTRS!' => 'Saiu com sucesso. Obrigado por utilizar o OTRS!',
      'Message' => 'Mensagem',
      'minute' => 'minuto',
      'minutes' => 'minutos',
      'Module' => 'Mdulo',
      'Modulefile' => 'Ficheiro de Mdulo',
      'month(s)' => 'mes(ses)',
      'Name' => 'Nome',
      'New Article' => 'Novo Artigo',
      'New message' => 'Nova mensagem',
      'New message!' => 'Nova mensagem!',
      'Next' => '',
      'Next...' => '',
      'No' => 'No',
      'no' => 'no',
      'No entry found!' => 'Sem resultados',
      'No Permission!' => '',
      'No such Ticket Number "%s"! Can\'t link it!' => '',
      'No suggestions' => 'Sem sugestes',
      'none' => 'Nada',
      'none - answered' => 'nada  - respondido',
      'none!' => 'Nada!',
      'Normal' => 'Normal',
      'off' => 'desligado',
      'Off' => 'Desligado',
      'On' => 'Ligado',
      'on' => 'ligado',
      'Online Agent: %s' => '',
      'Online Customer: %s' => '',
      'Password' => 'Senha de Acesso',
      'Passwords dosn\'t match! Please try it again!' => '',
      'Pending till' => 'Pendente at',
      'Please answer this ticket(s) to get back to the normal queue view!' => 'Por favor, responda a este(s) ticket(s) para retornar  vista normal da Queue!',
      'Please contact your admin' => 'Por Favor contactar o administrador',
      'please do not edit!' => 'por favor no editar!',
      'possible' => 'possvel',
      'Preview' => 'Ver antes',
      'QueueView' => 'QueueView',
      'reject' => 'rejeitar',
      'replace with' => 'substituir por',
      'Reset' => 'Reset',
      'Salutation' => 'Saudao',
      'Session has timed out. Please log in again.' => 'A sesso expirou. Por favor autentique-se novamente',
      'Show closed Tickets' => 'Mostrar Tickets fechados',
      'Sign' => '',
      'Signature' => 'Assinatura',
      'Signed' => '',
      'Size' => '',
      'Sorry' => 'Desculpe',
      'Stats' => 'Estatsticas',
      'Subfunction' => 'Sub-funo',
      'submit' => 'Submeter',
      'submit!' => 'Submeter!',
      'system' => 'Sistema',
      'Take this Customer' => '',
      'Take this User' => 'Utilize este utilizador',
      'Text' => 'Texto',
      'The recommended charset for your language is %s!' => 'O conjunto de caracteres recomendado para o seu idioma  %s!',
      'Theme' => 'Tema',
      'There is no account with that login name.' => 'No existe conta com esse utilizador',
      'Ticket Number' => '',
      'Timeover' => 'Tempo esgotado',
      'To: (%s) replaced with database email!' => 'Para: (%s) substituido pelo email da base de dados',
      'top' => 'incio',
      'Type' => 'Tipo',
      'update' => 'actualizar',
      'Update' => 'Actualizar',
      'update!' => 'actualizar!',
      'Upload' => '',
      'User' => 'Utilizador',
      'Username' => 'Nome de Utilizador',
      'Valid' => 'Vlido',
      'Warning' => 'Aviso',
      'week(s)' => 'semana(s)',
      'Welcome to OTRS' => 'Bem-vindo ao OTRS',
      'Word' => 'Palavra',
      'wrote' => 'escreveu',
      'year(s)' => 'ano(s)',
      'Yes' => 'Sim',
      'yes' => 'sim',
      'You got new message!' => 'Recebeu uma mensagem nova',
      'You have %s new message(s)!' => 'Tem %s mensagem(s) nova(s)!',
      'You have %s reminder ticket(s)!' => 'Tem %s lembrete(s)',

    # Template: AAAMonth
      'Apr' => 'Abr',
      'Aug' => 'Ago',
      'Dec' => 'Dec',
      'Feb' => 'Fev',
      'Jan' => 'Jan',
      'Jul' => 'Jul',
      'Jun' => 'Jun',
      'Mar' => 'Mar',
      'May' => 'Mai',
      'Nov' => 'Nov',
      'Oct' => 'Out',
      'Sep' => 'Set',

    # Template: AAAPreferences
      'Closed Tickets' => 'Tickets Fechados',
      'CreateTicket' => '',
      'Custom Queue' => 'Queue Personalizada',
      'Follow up notification' => 'Notificao de Follow up',
      'Frontend' => 'Interface',
      'Mail Management' => 'Gesto de Mails',
      'Max. shown Tickets a page in Overview.' => 'N mximo de tickets por pgina em OverView ',
      'Max. shown Tickets a page in QueueView.' => 'N mximo de tickets por pgina em QueueView',
      'Move notification' => 'Notificao de movimentos',
      'New ticket notification' => 'Notificao de novo ticket',
      'Other Options' => 'Outras Opes',
      'PhoneView' => 'Chamada',
      'Preferences updated successfully!' => 'Preferncias actualizadas com sucesso!',
      'QueueView refresh time' => 'Tempo de refresh da QueueView',
      'Screen after new ticket' => 'Ecr aps novo ticket',
      'Select your default spelling dictionary.' => 'Seleccionar o seu corrector ortogrfico',
      'Select your frontend Charset.' => 'Selecionar o Conjunto de Caracteres da sua Interface .',
      'Select your frontend language.' => 'Selecionar o Idioma da sua Interface.',
      'Select your frontend QueueView.' => 'Selecionar o seu Interface da QueueView.',
      'Select your frontend Theme.' => 'Selecionar o Tema do seu Interface.',
      'Select your QueueView refresh time.' => 'Selecionar o tempo de refresh da QueueView',
      'Select your screen after creating a new ticket.' => 'Seleccionar ecr aps criao de novo ticket.',
      'Send me a notification if a customer sends a follow up and I\'m the owner of this ticket.' => 'Notificar se um cliente enviar um follow up e sou o owner desse ticket.',
      'Send me a notification if a ticket is moved into one of "My Queues".' => '',
      'Send me a notification if a ticket is unlocked by the system.' => 'Notificar se um ticket for desbloqueado pelo sistema.',
      'Send me a notification if there is a new ticket in "My Queues".' => '',
      'Show closed tickets.' => 'Mostrar tickets fechados',
      'Spelling Dictionary' => 'Corrector Ortogrfico',
      'Ticket lock timeout notification' => 'Notificao de bloqueio por tempo expirado',
      'TicketZoom' => 'Detalhes do ticket',

    # Template: AAATicket
      '1 very low' => '1 muito baixo',
      '2 low' => '2 baixo',
      '3 normal' => '3 normal',
      '4 high' => '4 alto',
      '5 very high' => '5 muito alto',
      'Action' => 'Aco',
      'Age' => 'Idade',
      'Article' => 'Artigo',
      'Attachment' => 'Anexo',
      'Attachments' => 'Anexos',
      'Bcc' => 'Copia Invisvel',
      'Bounce' => 'Devolver',
      'Cc' => 'Cpia ',
      'Close' => 'Fechar',
      'closed' => '',
      'closed successful' => 'fechado com xito',
      'closed unsuccessful' => 'fechado sem xito',
      'Compose' => 'Compr',
      'Created' => 'Criado',
      'Createtime' => 'Hora de criao',
      'email' => 'email',
      'eMail' => 'eMail',
      'email-external' => 'email-externo',
      'email-internal' => 'email-interno',
      'Forward' => 'Encaminhar',
      'From' => 'De',
      'high' => 'alto',
      'History' => 'Histrico',
      'If it is not displayed correctly,' => 'Se ele no for exibido correctamente,',
      'lock' => 'bloquear',
      'Lock' => 'Bloquear',
      'low' => 'baixo',
      'Move' => 'Mover',
      'new' => 'novo',
      'normal' => 'normal',
      'note-external' => 'nota-externa',
      'note-internal' => 'nota-interna',
      'note-report' => 'nota-relatrio',
      'open' => 'aberto',
      'Owner' => 'Proprietrio',
      'Pending' => 'Pendentes',
      'pending auto close+' => 'pendente fecho automtico+',
      'pending auto close-' => 'pendente fecho automtico-',
      'pending reminder' => 'post-it de pendente',
      'phone' => 'telefone',
      'plain' => 'texto',
      'Priority' => 'Prioridade',
      'Queue' => 'Queue',
      'removed' => 'removido',
      'Sender' => 'Remetente',
      'sms' => 'sms',
      'State' => 'Estado',
      'Subject' => 'Assunto',
      'This is a' => 'Este  um',
      'This is a HTML email. Click here to show it.' => 'Este  um email HTML. Clicar aqui para mostrar.',
      'This message was written in a character set other than your own.' => 'Esta mensagem foi escrita utilizando um conjunto de caracteres diferente do seu.',
      'Ticket' => 'Ticket',
      'Ticket "%s" created!' => 'Ticket "%s" criados!',
      'To' => 'Para',
      'to open it in a new window.' => 'para abrir em nova janela.',
      'Unlock' => 'Desbloquear',
      'unlock' => 'desbloquear',
      'very high' => 'muito alto',
      'very low' => 'muito baixo',
      'View' => 'Ver',
      'webrequest' => 'Solicitar via web',
      'Zoom' => 'Detalhes',

    # Template: AAAWeekDay
      'Fri' => 'Sex',
      'Mon' => 'Seg',
      'Sat' => 'Sab',
      'Sun' => 'Dom',
      'Thu' => 'Qui',
      'Tue' => 'Ter',
      'Wed' => 'Qua',

    # Template: AdminAttachmentForm
      'Add' => 'Adicionar',
      'Attachment Management' => 'Gernciamento de Anexos',

    # Template: AdminAutoResponseForm
      'Auto Response From' => 'Auto-Resposta De',
      'Auto Response Management' => 'Gernciamento de Auto-Respostas',
      'Note' => 'Nota',
      'Response' => 'Resposta',
      'to get the first 20 character of the subject' => 'para obter os 20 primeiros caracteres do assunto',
      'to get the first 5 lines of the email' => 'para obter as 5 primeiras linhas do email',
      'to get the from line of the email' => 'para obter a linha "De" do email',
      'to get the realname of the sender (if given)' => 'para obter o nome do remetente (se possuir no email)',
      'to get the ticket id of the ticket' => 'para obter o ID do ticket',
      'to get the ticket number of the ticket' => 'para obter o nmero do ticket',
      'Useable options' => 'Opes acessveis',

    # Template: AdminCustomerUserForm
      'Customer User Management' => 'Gesto de Users de Clientes',
      'Customer user will be needed to have an customer histor and to to login via customer panels.' => '',
      'Result' => '',
      'Search' => 'Procura',
      'Search for' => '',
      'Select Source (for add)' => '',
      'Source' => '',
      'The message being composed has been closed.  Exiting.' => 'A mensagem sendo composta foi fechada. Saindo.',
      'This values are read only.' => '',
      'This values are required.' => '',
      'This window must be called from compose window' => 'Esta janela deve ser chamada da janela de composio',

    # Template: AdminCustomerUserGroupChangeForm
      'Change %s settings' => 'Modificar %s configuraes',
      'Customer User <-> Group Management' => 'Personalizar Utilizador <-> Grupo de Gesto',
      'Full read and write access to the tickets in this group/queue.' => 'Acesso total de leitura e escrita para os tickets neste grupo/Queue.',
      'If nothing is selected, then there are no permissions in this group (tickets will not be available for the user).' => 'Se nada for seleccionado, ento no h permisses neste grupo (tickets no estaram disponveis para o utilizador).',
      'Permission' => 'Permisso',
      'Read only access to the ticket in this group/queue.' => 'Acesso apenas de leitura para o ticket neste grupo/Queue.',
      'ro' => 'ro',
      'rw' => 'rw',
      'Select the user:group permissions.' => 'Seleccionar o utilizador:permisses de grupo.',

    # Template: AdminCustomerUserGroupForm
      'Change user <-> group settings' => 'Modificar users <-> configuraes de grupos',

    # Template: AdminEmail
      'Admin-Email' => 'Email do Admin.',
      'Body' => 'Corpo',
      'OTRS-Admin Info!' => 'Informao do Administrador do OTRS!',
      'Recipents' => 'Destinatrios',
      'send' => 'enviar',

    # Template: AdminEmailSent
      'Message sent to' => 'Mensagem enviada para',

    # Template: AdminGenericAgent
      '(e. g. 10*5155 or 105658*)' => '(ex: 10*5155 ou 105658*)',
      '(e. g. 234321)' => '(ex: 234321)',
      '(e. g. U5150)' => '(ex: U5150)',
      '-' => '',
      'Add Note' => 'Adicionar Nota',
      'Agent' => 'Agente',
      'and' => 'e',
      'CMD' => '',
      'Customer User Login' => 'Login de Cliente',
      'CustomerID' => 'Id.do Cliente',
      'CustomerUser' => 'Utilizador do Cliente',
      'Days' => '',
      'Delete' => 'Eliminar',
      'Delete tickets' => '',
      'Edit' => 'Editar',
      'Fulltext-Search in Article (e. g. "Mar*in" or "Baue*")' => 'Procura de texto-completo no artigo (ex: "Mar*in" ou "Baue*")',
      'GenericAgent' => '',
      'Hours' => '',
      'Job-List' => '',
      'Jobs' => '',
      'Last run' => '',
      'Minutes' => '',
      'Modules' => '',
      'New Agent' => '',
      'New Customer' => '',
      'New Owner' => 'Novo Proprietrio',
      'New Priority' => '',
      'New Queue' => 'Nova Queue',
      'New State' => '',
      'New Ticket Lock' => '',
      'No time settings.' => 'Sem definies de tempo',
      'Param 1' => '',
      'Param 2' => '',
      'Param 3' => '',
      'Param 4' => '',
      'Param 5' => '',
      'Param 6' => '',
      'Save' => '',
      'Save Job as?' => '',
      'Schedule' => '',
      'This command will be executed. ARG[0] will be the ticket number. ARG[1] the ticket id.' => '',
      'Ticket created' => 'Ticket criado',
      'Ticket created between' => 'Ticket criado entre',
      'Ticket Lock' => '',
      'TicketFreeText' => 'Texto livre do Ticket',
      'Times' => 'Vezes',
      'Warning! This tickets will be removed from the database! This tickets are lost!' => '',

    # Template: AdminGroupForm
      'Create new groups to handle access permissions for different groups of agent (e. g. purchasing department, support department, sales department, ...).' => 'Crie novos grupos para manipular as permisses de acesso para diferentes grupos de agentes (exemplos: departamento de compras, departamento de suporte, departamento de vendas, etc...).',
      'Group Management' => 'Gesto de Grupos',
      'It\'s useful for ASP solutions.' => 'Isto  til para solues ASP.',
      'The admin group is to get in the admin area and the stats group to get stats area.' => 'O grupo admin  para uso na rea de administrao e o grupo estatsticas  para uso na rea de estatsticas.',

    # Template: AdminLog
      'System Log' => 'Registro do Sistema',
      'Time' => '',

    # Template: AdminNavigationBar
      'AdminEmail' => 'Email do Administrador',
      'Attachment <-> Response' => 'Anexo <-> Resposta',
      'Auto Response <-> Queue' => 'Auto-Respostas <-> Queue',
      'Auto Responses' => 'Auto-Respostas',
      'Customer User' => 'Utilizador de Cliente',
      'Customer User <-> Groups' => 'Utilizador de Cliente <-> Grupos',
      'Email Addresses' => 'Endereos de Emails',
      'Groups' => 'Grupos',
      'Logout' => 'Sair',
      'Misc' => 'Variedades',
      'Notifications' => 'Notificaes',
      'PGP Keys' => '',
      'PostMaster Filter' => 'Filtro do PostMaster',
      'PostMaster POP3 Account' => 'Conta de POP3 do PostMaster',
      'Responses' => 'Respostas',
      'Responses <-> Queue' => 'Respostas <-> Queues',
      'Role' => '',
      'Role <-> Group' => '',
      'Role <-> User' => '',
      'Roles' => '',
      'Select Box' => 'Caixa de Seleo',
      'Session Management' => 'Gesto de Sesses',
      'SMIME Certificates' => '',
      'Status' => 'Status',
      'System' => 'Sistema',
      'User <-> Groups' => 'Utilizador <-> Grupos',

    # Template: AdminNotificationForm
      'Config options (e. g. &lt;OTRS_CONFIG_HttpType&gt;)' => 'Opes de Configurao (Ex. &lt;OTRS_CONFIG_HttpType&gt;)',
      'Notification Management' => 'Gesto de Notificao',
      'Notifications are sent to an agent or a customer.' => 'Notificaes so enviadas para o agente ou o cliente',
      'Options of the current customer user data (e. g. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)' => 'Opoes do Cliente corrente (Ex. &lt;OTRS_CUSTOMER_DATA_USERFIRSTNAME&gt;)',
      'Options of the current user who requested this action (e. g. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)' => 'Opes do utilizador que requereu a aco (Ex. &lt;OTRS_CURRENT_USERFIRSTNAME&gt;)',
      'Ticket owner options (e. g. &lt;OTRS_OWNER_USERFIRSTNAME&gt;)' => 'Opes do dono do Ticket',

    # Template: AdminPGPForm
      'Bit' => '',
      'Expires' => '',
      'File' => '',
      'Fingerprint' => '',
      'FIXME: WHAT IS PGP?' => '',
      'Identifier' => '',
      'In this way you can directly edit the keyring configured in Kernel/Config.pm.' => '',
      'Key' => 'Chave',
      'PGP Key Management' => '',

    # Template: AdminPOP3Form
      'All incoming emails with one account will be dispatched in the selected queue!' => 'Todos os emails de entrada com uma conta ser despachado na Queue selecionada!',
      'Dispatching' => 'Despachando',
      'Host' => 'Anfitrio',
      'If your account is trusted, the already existing x-otrs header at arrival time (for priority, ...) will be used! PostMaster filter will be used anyway.' => '',
      'POP3 Account Management' => 'Gesto de Contas POP3',
      'Trusted' => 'Confivel',

    # Template: AdminPostMasterFilter
      'Do dispatch or filter incoming emails based on email X-Headers! RegExp is also possible.' => '',
      'Filtername' => '',
      'Header' => '',
      'If you use RegExp, you also can use the matched value in () as [***] in \'Set\'.' => '',
      'Match' => 'Igual',
      'PostMaster Filter Management' => '',
      'Set' => 'Selecciona',
      'Value' => 'Valor',

    # Template: AdminQueueAutoResponseForm
      'Queue <-> Auto Response Management' => 'Gesto de Queues <-> Auto-Resposta',

    # Template: AdminQueueAutoResponseTable

    # Template: AdminQueueForm
      '0 = no escalation' => '0 = sem escalamento',
      '0 = no unlock' => '0 = sem desbloqueio',
      'Customer Move Notify' => 'Movimento de Cliente Notificado',
      'Customer Owner Notify' => 'Owner de Cliente Notificado',
      'Customer State Notify' => 'Estado de Cliente Notificado',
      'Escalation time' => 'Tempo de escalamento',
      'Follow up Option' => 'Opo de follow up',
      'If a ticket is closed and the customer sends a follow up the ticket will be locked for the old owner.' => 'Se um ticket est fechado e um cliente envia um follow up, este mesmo ticket ser bloqueado para o antigo proprietrio.',
      'If a ticket will not be answered in thos time, just only this ticket will be shown.' => 'Se um ticket no foi respondido dentro deste tempo, apenas os tickets com este tempo vencido sero exibidos.',
      'If an agent locks a ticket and he/she will not send an answer within this time, the ticket will be unlock automatically. So the ticket is viewable for all other agents.' => 'Se um agente bloqueia um ticket e ele no envia uma resposta dentro deste tempo, o ticket ser desbloqueado automaticamente. Ento o ticket ser visvel para todos os outros agentes.',
      'OTRS sends an notification email to the customer if the ticket is moved.' => 'OTRS envia um email de  notificao para o cliente se ticket for movido.',
      'OTRS sends an notification email to the customer if the ticket owner has changed.' => 'OTRS envia um email de notificao se o owner do ticket for alterado.',
      'OTRS sends an notification email to the customer if the ticket state has changed.' => 'OTRS envia um email de notificao se o estado do ticket for alterado.',
      'Queue Management' => 'Gesto de Queues',
      'Sub-Queue of' => 'Sub-Queue de',
      'Systemaddress' => 'Endereo do Sistema',
      'The salutation for email answers.' => 'A saudao para as respostas de emails.',
      'The signature for email answers.' => 'A assinatura para as respostas de emails.',
      'Ticket lock after a follow up' => 'Bloqueio do bilhete aps os follow ups',
      'Unlock timeout' => 'Tempo de desbloqueio',
      'Will be the sender address of this queue for email answers.' => 'Ser o endereo de email de respostas desta Queue.',

    # Template: AdminQueueResponsesChangeForm
      'Std. Responses <-> Queue Management' => 'Respostas Padro <-> Gesto de Queues',

    # Template: AdminQueueResponsesForm
      'Answer' => 'Resposta',

    # Template: AdminResponseAttachmentChangeForm
      'Std. Responses <-> Std. Attachment Management' => 'Respostas Padro <-> Gesto Anexos Padro',

    # Template: AdminResponseAttachmentForm

    # Template: AdminResponseForm
      'A response is default text to write faster answer (with default text) to customers.' => 'Uma resposta  um texto padro para compr respostas rpidas (com texto padro) para clientes.',
      'All Customer variables like defined in config option CustomerUser.' => '',
      'Don\'t forget to add a new response a queue!' => 'No se esquea de adicionar a nova resposta a uma Queue!',
      'Next state' => 'Prximo estado',
      'Response Management' => 'Gesto de Respostas',
      'The current ticket state is' => 'O estado corrento do ticket ',
      'Your email address is new' => '',

    # Template: AdminRoleForm
      'Create a role and put groups in it. Then add the role to the users.' => '',
      'It\'s useful for a lot of users and groups.' => '',
      'Role Management' => '',

    # Template: AdminRoleGroupChangeForm
      'create' => 'criar',
      'move_into' => 'mover para',
      'owner' => 'dono',
      'Permissions to change the ticket owner in this group/queue.' => 'Permisses para modificar o dono do Ticket neste grupo/queue',
      'Permissions to change the ticket priority in this group/queue.' => 'Permisses para modificar a prioridade do Ticket neste grupo/queue',
      'Permissions to create tickets in this group/queue.' => 'Permisses para criar Tickets neste grupo/queue',
      'Permissions to move tickets into this group/queue.' => 'Permisses para mover Tickets neste grupo/queue',
      'priority' => 'prioridade',
      'Role <-> Group Management' => '',

    # Template: AdminRoleGroupForm
      'Change role <-> group settings' => '',

    # Template: AdminRoleUserChangeForm
      'Active' => '',
      'Role <-> User Management' => '',
      'Select the role:user relations.' => '',

    # Template: AdminRoleUserForm
      'Change user <-> role settings' => '',

    # Template: AdminSMIMEForm
      'Add Certificate' => '',
      'Add Private Key' => '',
      'FIXME: WHAT IS SMIME?' => '',
      'Hash' => '',
      'In this way you can directly edit the certification and private keys in file system.' => '',
      'Secret' => '',
      'SMIME Certificate Management' => '',

    # Template: AdminSalutationForm
      'customer realname' => 'Nome do cliente',
      'for agent firstname' => 'Nome do Agente',
      'for agent lastname' => 'Sobrenome do Agente',
      'for agent login' => 'para login de agente',
      'for agent user id' => 'para ID de utilizador de agente',
      'Salutation Management' => 'Gesto de Saudaes',

    # Template: AdminSelectBoxForm
      'Limit' => 'Limite',
      'SQL' => 'SQL',

    # Template: AdminSelectBoxResult
      'Select Box Result' => 'Selecione a Caixa de Resultado',

    # Template: AdminSession
      'kill all sessions' => 'Finalizar todas as sesses',
      'kill session' => 'Finalizar sesso',
      'Overview' => 'Overview',
      'Session' => '',
      'Sessions' => 'Sesses',
      'Uniq' => 'nico',

    # Template: AdminSignatureForm
      'Signature Management' => 'Gesto de Assinaturas',

    # Template: AdminStateForm
      'See also' => 'Ver tambm',
      'State Type' => 'Estado Tipo',
      'System State Management' => 'Gesto de Estados do Sistema',
      'Take care that you also updated the default states in you Kernel/Config.pm!' => 'Ter em conta que tambm actualizaste',

    # Template: AdminSystemAddressForm
      'All incoming emails with this "Email" (To:) will be dispatched in the selected queue!' => 'Todos os emails de entrada com este Email(Para:) sero despachados na Queue selecionada!',
      'Email' => '',
      'Realname' => 'Nome',
      'System Email Addresses Management' => 'Gesto dos Endereos de Emails do Sistema',

    # Template: AdminUserForm
      'Don\'t forget to add a new user to groups!' => 'No esquea de adicionar um novo user nos grupos!',
      'Firstname' => 'Nome',
      'Lastname' => 'Sobrenome',
      'User Management' => 'Gesto de Users',
      'User will be needed to handle tickets.' => 'Ser necessrio um user para manipular os tickets.',

    # Template: AdminUserGroupChangeForm
      'User <-> Group Management' => 'Users <-> Gesto de Grupos',

    # Template: AdminUserGroupForm

    # Template: AgentBook
      'Address Book' => 'Lista de Endereos',
      'Discard all changes and return to the compose screen' => 'Descartar todas as modificaes e retornar para o ecr de composio',
      'Return to the compose screen' => 'Retornar para o ecr de composio',

    # Template: AgentBounce
      'A message should have a To: recipient!' => 'Uma mensagem deve possuir um Para: destinatrio!',
      'Bounce ticket' => 'Devolver bilhete',
      'Bounce to' => 'Devolver para',
      'Inform sender' => 'Informe o remetente',
      'Next ticket state' => 'Prximo estado do ticket',
      'Send mail!' => 'Enviar email!',
      'You need a email address (e. g. customer@example.com) in To:!' => 'Precisa de um endereo de email (exemplo: cliente@exemplo.pt) no Para:!',
      'Your email with ticket number "<OTRS_TICKET>" is bounced to "<OTRS_BOUNCE_TO>". Contact this address for further informations.' => 'Seu email com o nmero de ticket "<OTRS_TICKET>" foi devolvido para "<OTRS_BOUNCE_TO>". Contate este endereo para mais informaes.',

    # Template: AgentBulk
      '$Text{"Note!' => '',
      'A message should have a subject!' => 'A mensagem deve conter um assunto!',
      'Note type' => 'Tipo de nota',
      'Note!' => 'Nota!',
      'Options' => 'Opes',
      'Spell Check' => 'Checar Ortografia',
      'Ticket Bulk Action' => '',

    # Template: AgentClose
      ' (work units)' => ' (unidades de trabalho)',
      'A message should have a body!' => 'A mensagem deve conter um texto!',
      'Close ticket' => 'Fechar ticket',
      'Close type' => 'Tipo de fecho',
      'Close!' => 'Fechar!',
      'Note Text' => 'Nota',
      'Time units' => 'Unidades de tempo',
      'You need to account time!' => ' necessrio o tempo dispendido',

    # Template: AgentCompose
      'A message must be spell checked!' => 'Tem de verificar a ortografia da mensagem',
      'Attach' => 'Anexo',
      'Compose answer for ticket' => 'Compr uma resposta para o ticket',
      'for pending* states' => 'em estado pendente*',
      'Is the ticket answered' => 'O ticket foi respondido',
      'Pending Date' => 'Data de Pendncia',

    # Template: AgentCrypt

    # Template: AgentCustomer
      'Change customer of ticket' => 'Modificar o cliente do ticket',
      'Search Customer' => 'Procurar cliente',
      'Set customer user and customer id of a ticket' => ' necessrio o utilizador e o ID do cliente do Ticket',

    # Template: AgentCustomerHistory
      'All customer tickets.' => 'Todos os Tickets do utilizador',
      'Customer history' => 'Histrico do cliente',

    # Template: AgentCustomerMessage
      'Follow up' => 'Follow up',

    # Template: AgentCustomerView
      'Customer Data' => 'Dados do Cliente',

    # Template: AgentEmailNew
      'All Agents' => 'Todos os Agentes',
      'Clear To' => '',
      'Compose Email' => '',
      'new ticket' => 'novo ticket',

    # Template: AgentForward
      'Article type' => 'Tipo de artigo',
      'Date' => 'Data',
      'End forwarded message' => 'Terminar mensagem encaminhada',
      'Forward article of ticket' => 'Encaminhar o artigo do Ticket',
      'Forwarded message from' => 'Mensagem encaminhada de',
      'Reply-To' => 'Responder-Para',

    # Template: AgentFreeText
      'Change free text of ticket' => 'Alterar Texto livre do Ticket',

    # Template: AgentHistoryForm
      'History of' => 'Histrico de',

    # Template: AgentHistoryRow

    # Template: AgentInfo
      'Info' => 'Informao',

    # Template: AgentLookup
      'Lookup' => '',

    # Template: AgentMailboxNavBar
      'All messages' => 'Todas as mensagens',
      'down' => 'inversa',
      'Mailbox' => 'Caixa de Entrada',
      'New' => 'Novos',
      'New messages' => 'Mensagens novas',
      'Open' => 'Abertos',
      'Open messages' => 'Mensagens abertas',
      'Order' => 'Ordem',
      'Pending messages' => 'Mensagens pendentes',
      'Reminder' => 'Lembretes',
      'Reminder messages' => 'Mensagens com lembretes',
      'Sort by' => 'Ordenado pela',
      'Tickets' => 'Tickets',
      'up' => 'normal',

    # Template: AgentMailboxTicket
      '"}' => '',
      '"}","14' => '',
      'Add a note to this ticket!' => '',
      'Change the ticket customer!' => '',
      'Change the ticket owner!' => '',
      'Change the ticket priority!' => '',
      'Close this ticket!' => '',
      'Shows the detail view of this ticket!' => '',
      'Unlock this ticket!' => '',

    # Template: AgentMove
      'Move Ticket' => 'Mover Ticket',
      'Previous Owner' => 'Proprietrio Anterior',
      'Queue ID' => 'ID da Queue',

    # Template: AgentNavigationBar
      'Agent Preferences' => '',
      'Bulk Action' => '',
      'Bulk Actions on Tickets' => '',
      'Create new Email Ticket' => '',
      'Create new Phone Ticket' => '',
      'Email-Ticket' => '',
      'Locked tickets' => 'Tickets bloqueados',
      'new message' => 'Nova mensagem',
      'Overview of all open Tickets' => '',
      'Phone-Ticket' => '',
      'Preferences' => 'Preferncias',
      'Search Tickets' => '',
      'Ticket selected for bulk action!' => '',
      'You need min. one selected Ticket!' => '',

    # Template: AgentNote
      'Add note to ticket' => 'Adicionar nota ao Ticket',

    # Template: AgentOwner
      'Change owner of ticket' => 'Modificar o proprietrio do Ticket',
      'Message for new Owner' => 'Mensagem para um novo Proprietrio',

    # Template: AgentPending
      'Pending date' => 'Data da pendncia',
      'Pending type' => 'Tipo de pendncia',
      'Set Pending' => 'Definir como Pendente',

    # Template: AgentPhone
      'Phone call' => 'Chamada telefnica',

    # Template: AgentPhoneNew
      'Clear From' => 'Limpar "De:"',

    # Template: AgentPlain
      'ArticleID' => 'Id.do artigo',
      'Download' => '',
      'Plain' => 'Texto',
      'TicketID' => 'TicketID',

    # Template: AgentPreferencesCustomQueue
      'My Queues' => '',
      'You also get notified about this queues via email if enabled.' => '',
      'Your queue selection of your favorite queues.' => '',

    # Template: AgentPreferencesForm

    # Template: AgentPreferencesGeneric

    # Template: AgentPreferencesPassword
      'Change Password' => 'Modificar Password',
      'New password' => 'Nova password',
      'New password again' => 'Re-introduza a nova password',

    # Template: AgentPriority
      'Change priority of ticket' => 'Modificar a prioridade do ticket',

    # Template: AgentSpelling
      'Apply these changes' => 'Aplicar estas modificaes',
      'Spell Checker' => 'Verificar a Ortografica',
      'spelling error(s)' => 'erro(s) ortogrficos',

    # Template: AgentStatusView
      'D' => 'D',
      'of' => 'de',
      'Site' => 'Site',
      'sort downward' => 'ordem decrescente',
      'sort upward' => 'ordem crescente',
      'Ticket Status' => 'Estado do ticket',
      'U' => 'C',

    # Template: AgentTicketLink
      'Delete Link' => '',
      'Link' => '',
      'Link to' => 'Link para',

    # Template: AgentTicketLocked
      'Ticket locked!' => 'Ticket bloqueado!',
      'Ticket unlock!' => 'Ticket desbloqueado!',

    # Template: AgentTicketPrint

    # Template: AgentTicketPrintHeader
      'Accounted time' => 'Tempo contabilizado',
      'Escalation in' => 'Escalado em',

    # Template: AgentUtilSearch
      'Profile' => 'Perfil',
      'Result Form' => 'Formulrio de resultado',
      'Save Search-Profile as Template?' => 'Guardar Perfil de Procura como Template',
      'Search-Template' => 'Template de procura',
      'Select' => 'Seleccionar',
      'Ticket Search' => 'Procura de Tickets',
      'Yes, save it with name' => 'Sim, guardar com o nome',

    # Template: AgentUtilSearchByCustomerID
      'Customer history search' => 'Procura no Histrico do cliente',
      'Customer history search (e. g. "ID342425").' => 'Procura no Histrico do cliente (exemplo: "ID342425")',
      'No * possible!' => 'No so possveis *!',

    # Template: AgentUtilSearchResult
      'Change search options' => 'Alterar opes de procura',
      'Results' => 'Resultados',
      'Search Result' => 'Resultado de Procura',
      'Total hits' => 'Total de acertos',

    # Template: AgentUtilSearchResultPrint

    # Template: AgentUtilSearchResultShort

    # Template: AgentUtilTicketStatus
      'All closed tickets' => 'Todos os Tickets fechados',
      'All open tickets' => 'Todos os tickets abertos',
      'closed tickets' => 'Tickets fechados',
      'open tickets' => 'Tickets abertos',
      'or' => 'ou',
      'Provides an overview of all' => 'D uma viso geral de todos os',
      'So you see what is going on in your system.' => 'Ento, voc v o que est a acontecer no seu sistema.',

    # Template: AgentZoomAgentIsCustomer
      'Compose Follow up' => 'Compor Follow up',
      'Your own Ticket' => 'O seu Ticket',

    # Template: AgentZoomAnswer
      'Compose Answer' => 'Compr resposta',
      'Contact customer' => 'Contactar cliente',
      'phone call' => 'chamada telefnica',

    # Template: AgentZoomArticle
      'Split' => 'Dividir',

    # Template: AgentZoomBody
      'Change queue' => 'Modificar Queue',

    # Template: AgentZoomHead
      'Change the ticket free fields!' => '',
      'Free Fields' => 'Campos Livres',
      'Link this ticket to an other one!' => '',
      'Lock it to work on it!' => '',
      'Print' => 'Imprimir',
      'Print this ticket!' => '',
      'Set this ticket to pending!' => '',
      'Shows the ticket history!' => '',

    # Template: AgentZoomStatus
      '"}","18' => '',
      'Locked' => '',
      'SLA Age' => '',

    # Template: Copyright
      'printed by' => 'impresso por',

    # Template: CustomerAccept

    # Template: CustomerCreateAccount
      'Create Account' => 'Criar Conta',
      'Login' => 'Login',

    # Template: CustomerError
      'Traceback' => 'Retroceder',

    # Template: CustomerFAQArticleHistory
      'FAQ History' => 'Histrico da FAQ',

    # Template: CustomerFAQArticlePrint
      'Category' => 'Categorias',
      'Keywords' => 'Palavras Chave',
      'Last update' => 'ltima Actualizao',
      'Problem' => 'Problema',
      'Solution' => 'Soluo',
      'Symptom' => 'Sintoma',

    # Template: CustomerFAQArticleSystemHistory
      'FAQ System History' => 'Sistema de Histrico da FAQ',

    # Template: CustomerFAQArticleView
      'FAQ Article' => 'Artigo da FAQ',
      'Modified' => 'Modificado',

    # Template: CustomerFAQOverview
      'FAQ Overview' => 'Resumo da FAQ',

    # Template: CustomerFAQSearch
      'FAQ Search' => 'Procura na FAQ',
      'Fulltext' => 'Texto completo',
      'Keyword' => 'Palavra chave',

    # Template: CustomerFAQSearchResult
      'FAQ Search Result' => 'Resultado da Procura na FAQ',

    # Template: CustomerFooter
      'Powered by' => 'Produzido por',

    # Template: CustomerLostPassword
      'Lost your password?' => 'Esqueceu-se da password?',
      'Request new password' => 'Solicitar nova password',

    # Template: CustomerMessage

    # Template: CustomerMessageNew

    # Template: CustomerNavigationBar
      'CompanyTickets' => '',
      'Create new Ticket' => 'Criar um novo Ticket',
      'FAQ' => 'FAQ',
      'MyTickets' => '',
      'New Ticket' => 'Novo Tickets',
      'Welcome %s' => 'Bem-vindo %s',

    # Template: CustomerPreferencesForm

    # Template: CustomerPreferencesGeneric

    # Template: CustomerPreferencesPassword

    # Template: CustomerStatusView

    # Template: CustomerTicketSearch

    # Template: CustomerTicketSearchResultPrint

    # Template: CustomerTicketSearchResultShort

    # Template: CustomerTicketZoom

    # Template: CustomerWarning

    # Template: Error
      'Click here to report a bug!' => 'Clicar para reportar um erro!',

    # Template: FAQArticleDelete
      'FAQ Delete' => 'Eliminar FAQ',
      'You really want to delete this article?' => 'Deseja mesmo eliminar este artigo?',

    # Template: FAQArticleForm
      'A article should have a title!' => '',
      'Comment (internal)' => 'Comentrio (interno)',
      'Filename' => 'Nome do Ficheiro',
      'Title' => '',

    # Template: FAQArticleHistory

    # Template: FAQArticlePrint

    # Template: FAQArticleSystemHistory

    # Template: FAQArticleView

    # Template: FAQArticleViewSmall

    # Template: FAQCategoryForm
      'FAQ Category' => 'Categoria da FAQ',
      'Name is required!' => '',

    # Template: FAQLanguageForm
      'FAQ Language' => 'Idioma da FAQ',

    # Template: FAQNavigationBar

    # Template: FAQOverview

    # Template: FAQSearch

    # Template: FAQSearchResult

    # Template: Footer
      'Top of Page' => 'Topo da Pgina',

    # Template: FooterSmall

    # Template: InstallerBody
      'Create Database' => 'Criar Base de Dados',
      'Drop Database' => 'Apagar Base de Dados',
      'Finished' => 'Terminado',
      'System Settings' => 'Propriedades de Sistema',
      'Web-Installer' => 'Instalador Web',

    # Template: InstallerFinish
      'Admin-User' => 'Utilizador de Admin',
      'After doing so your OTRS is up and running.' => 'Depois disto o seu OTRS estar completamente funcional',
      'Have a lot of fun!' => 'Divirta-se!',
      'Restart your webserver' => 'Reinicie o seu servidor Web',
      'Start page' => 'Pgina Inicial',
      'To be able to use OTRS you have to enter the following line in your command line (Terminal/Shell) as root.' => 'Para usar o OTRS tem de introduzir o seguinte comando na linha de comandos (Terminal/Shell) como root',
      'Your OTRS Team' => 'A sua Equipa OTRS',

    # Template: InstallerLicense
      'accept license' => 'Aceitar licena',
      'don\'t accept license' => 'No Aceitar licena',
      'License' => 'Licena',

    # Template: InstallerStart
      'Create new database' => 'Criar nova Base de Dados',
      'DB Admin Password' => 'Password Admin da Base de Dados',
      'DB Admin User' => 'Utilizador Admin da Base de Dados',
      'DB Host' => 'Servidor Base de Dados',
      'DB Type' => 'Tipo da Base de Dados',
      'default \'hot\'' => 'por defeito \'hot\'',
      'Delete old database' => 'Eliminar Base de Dados Antiga',
      'next step' => 'prximo passo',
      'OTRS DB connect host' => 'Servidor de ligao da Base de Dados OTRS',
      'OTRS DB Name' => 'Nome da Base de Dados OTRS',
      'OTRS DB Password' => 'Password da Base de Dados OTRS',
      'OTRS DB User' => 'Utilizador Base de Dados OTRS',
      'your MySQL DB should have a root password! Default is empty!' => 'A sua Base de Dados MySQL deve ter uma password de root! Por defeito no tem password!',

    # Template: InstallerSystem
      '(Checks MX recordes of used email addresses by composing an answer. Don\'t use CheckMXRecord if your OTRS machine is behinde a dial-up line $!)' => '
(Verifica os apontadores de MX quando compoe uma resposta. No usar caso esteja a usar uma ligao dial-up!)',
      '(Email of the system admin)' => '(Email do administrador do sistema)',
      '(Full qualified domain name of your system)' => '(Nome completo do domnio do seu sistema)',
      '(Logfile just needed for File-LogModule!)' => '(Ficheiro de registo para File-LogModule)',
      '(The identify of the system. Each ticket number and each http session id starts with this number)' => '(A identidade do sistema. Cada nmero de Ticket e cada id. da sesso http, inicia com este nmero)',
      '(Ticket identifier. Some people want toset this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificao do Ticket. Algumas pessoas usam \'Ticket#\', \'Chamada#\' or \'MeuTicket#\')',
      '(Used default language)' => '(Idioma padro utilizado)',
      '(Used log backend)' => '()',
      '(Used ticket number format)' => '(Formato de Ticket utilizado)',
      'CheckMXRecord' => 'Verificar apontador de MX',
      'Default Charset' => 'Conjunto de Caracteres Padro',
      'Default Language' => 'Idioma Padro',
      'Logfile' => 'Ficheiro de Log',
      'LogModule' => 'Mdulo de Logs',
      'Organization' => 'Organizao',
      'System FQDN' => 'FQDN do sistema',
      'SystemID' => 'ID do sistema',
      'Ticket Hook' => 'Identificador do Ticket',
      'Ticket Number Generator' => 'Gerador de Nmeros de Tickets',
      'Use utf-8 it your database supports it!' => 'Usar utf-8 se a base de dados suportar',
      'Webfrontend' => 'Interface Web',

    # Template: LostPassword

    # Template: NoPermission
      'No Permission' => 'Sem Permisso',

    # Template: Notify

    # Template: PrintFooter
      'URL' => 'URL',

    # Template: QueueView
      'All tickets' => 'Todos Tickets',
      'Page' => 'Pgina',
      'Queues' => 'Queues',
      'Tickets available' => 'Tickets disponveis',
      'Tickets shown' => 'Tickets mostrados',

    # Template: SystemStats

    # Template: Test
      'OTRS Test Page' => 'Pgina de Teste do OTRS',

    # Template: TicketEscalation
      'Ticket escalation!' => 'Escalamento de Tickets!',

    # Template: TicketView

    # Template: TicketViewLite

    # Template: Warning

    # Template: css
      'Home' => 'Incio',

    # Template: customer-css
      'Contact' => 'Contacto',
      'Online-Support' => 'Suporte-Online',
      'Products' => 'Produtos',
      'Support' => 'Suporte',

    # Misc
      '"}","15' => '',
      '"}","30' => '',
      '(Ticket identifier. Some people want to set this to e. g. \'Ticket#\', \'Call#\' or \'MyTicket#\')' => '(Identificador do Ticket. Algumas pessoas gostam de usar por exemplo \'Ticket#\, \'Chamada#\' ou \'MeuTicket#\')',
      'A message should have a From: recipient!' => 'Uma mensagem deve conter um De: remetente!',
      'Add auto response' => 'Adicionar uma auto-resposta',
      'AdminArea' => 'rea de Administrao',
      'AgentFrontend' => 'Interface do Agente',
      'Article free text' => 'Texto livre do artigo',
      'Change Response <-> Attachment settings' => 'Modificar Resposta <-> Configuraes de Anexos',
      'Change answer <-> queue settings' => 'Modificar respostas <-> configuraes de Queues',
      'Change auto response settings' => 'Modificar as configuraes da auto-resposta',
      'Charset' => 'Conjunto de Caracteres',
      'Charsets' => 'Conjunto de Caracteres',
      'Create' => 'Criar',
      'Customer called' => 'Cliente contactado',
      'Customer user will be needed to to login via customer panels.' => 'Um user de cliente  necessrio para se logar pelo painel de clientes',
      'FAQ State' => 'Estado da FAQ',
      'Fulltext search' => 'Procura completa de texto',
      'Fulltext search (e. g. "Mar*in" or "Baue*" or "martin+hallo")' => 'Procura completa em todo texto (exemplo: "Fil*e" ou "Henr*" ou "filipe+henriques")',
      'Graphs' => 'Grficos',
      'Handle' => 'Manipular',
      'If your account is trusted, the x-otrs header (for priority, ...) will be used!' => 'Se sua conta  confivel, os cabealhos x-otrs (para prioridade, ...) sero utilizados!',
      'Lock Ticket' => 'Bloquear Ticket',
      'Max Rows' => 'Nmero mximo de linhas',
      'My Tickets' => 'Meus Tickets',
      'New state' => 'Novo estado',
      'New ticket via call.' => 'Novo Ticket via chamada telefnica.',
      'New user' => 'Novo Utilizador',
      'POP3 Account' => 'Conta POP3',
      'Pending!' => 'Pendente!',
      'Phone call at %s' => 'Chamada telefnica s %s',
      'Please go away!' => 'Sair, por favor',
      'PostMasterFilter Management' => 'Gesto do filtro do PostMaster',
      'Search in' => 'Procurar em',
      'Select source:' => '',
      'Select your custom queues' => 'Seleccione a sua Queue personalizada',
      'Send me a notification if a ticket is moved into a custom queue.' => 'Notificar se um ticket for movido para uma Queue personalizada',
      'Send me a notification if there is a new ticket in my custom queues.' => 'Notificar se h um novo ticket nas minhas Queues personalizadas.',
      'SessionID' => 'Identificao da sesso',
      'Set customer id of a ticket' => 'Definir a identificao do cliente de um ticket',
      'Short Description' => 'Pequena Descrio',
      'Show all' => 'Mostrar todos os',
      'Status defs' => 'Estados',
      'Sympthom' => 'Sintoma',
      'System Charset Management' => 'Gernciamento de Conjunto de Caracteres do Sistema',
      'System Language Management' => 'Gesto de Idiomas do Sistema',
      'Ticket free text' => 'Texto livre do ticket',
      'Ticket limit:' => 'Limite do Ticket:',
      'Ticket-Overview' => 'Resumo do Ticket',
      'Time till escalation' => 'Tempo para escalao',
      'Utilities' => 'Utilitrios',
      'With State' => 'Com Estado',
      'You have to be in the admin group!' => 'Tem que estar no grupo admin!',
      'You have to be in the stats group!' => 'Tem que estar no grupo stats!',
      'You need a email address (e. g. customer@example.com) in From:!' => 'Precisa de um endereo de email (ex:cliente@exemplo.pt) no campo De:!',
      'auto responses set' => 'respostas automticas activas',
      'by' => 'por',
      'search' => 'procurar',
      'search (e. g. 10*5155 or 105658*)' => 'procurar (exemplo: 1055155 ou 105658*)',
      'store' => 'armazenar',
      'tickets' => 'tickets',
      'valid' => 'vlido',
      'view' => 'Vista',
    );

    # $$STOP$$

    $Self->{Translation} = \%Hash;
}
# --
1;

