/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

#ifndef INCL_DEF
#define iNCL_DEF

#define DEF_HEAP_SIZE  64
#define INFINITY       0x7FFF0000
#define ROUND_ERROR    2
#define MAX_NUM_LEVELS 10

#define CLASS 0
#define LEAF  1

#define EOL              '\n'

#ifndef TRUE
#define TRUE   1
#define FALSE  0
#endif

/* yc-m: relative comparison */
/*
#define cmp_eq(x, y) ((int)x > (int)(y - ROUND_ERROR) && \
  (int)x < (int)(y + ROUND_ERROR))
#define cmp_neq(x, y) ((int)x < (int)(y - ROUND_ERROR) || \
  (int)x > (int)(y + ROUND_ERROR))
#define cmp_l(x, y) ((int)x <= (int)(y - ROUND_ERROR))
#define cmp_leq(x, y) ((int)x <= (int)(y + ROUND_ERROR))
#define cmp_g(x, y) ((int)x >= (int)(y + ROUND_ERROR))
#define cmp_geq(x, y) ((int)x >= (int)(y - ROUND_ERROR))

#ifndef max
#define max(x, y) ((int)x > (int)y ? x: y)
#define min(x, y) ((int)x < (int)y ? x: y)
#endif
*/

#define cmp_eq(x, y) ((((int)x - (int)(y - ROUND_ERROR)) > 0 ) && \
  (((int)x - (int)(y + ROUND_ERROR)) < 0))
#define cmp_neq(x, y) ((((int)x - (int)(y - ROUND_ERROR)) < 0) || \
  (((int)x - (int)(y + ROUND_ERROR)) > 0))
#define cmp_l(x, y) (((int)x - (int)(y - ROUND_ERROR)) <= 0)
#define cmp_leq(x, y) (((int)x - (int)(y + ROUND_ERROR)) <= 0)
#define cmp_g(x, y) (((int)x - (int)(y + ROUND_ERROR)) >= 0)
#define cmp_geq(x, y) (((int)x - (int)(y - ROUND_ERROR)) >= 0)

#define cmp2_eq(x, y) (x - y == 0)
#define cmp2_neq(x, y) (x - y != 0)
#define cmp2_l(x, y) (x - y < 0)
#define cmp2_leq(x, y) (x - y <= 0)
#define cmp2_g(x, y) (x - y > 0)
#define cmp2_geq(x, y) (x - y >= 0)



#ifndef max
#define max(x, y) ((((int)x - (int)y) > 0) ? x: y)
#define min(x, y) ((((int)x - (int)y) < 0) ? x: y)
#endif

#endif

