/*
 * pipe_rend.cc --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2001-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "pipe_rend.h"
#define ALPHA 90	// convergence for average diff size (out of 100)

// Note: pntypes.h must be included before windows.h for MSVC6.0
#include <stdio.h>
#include <assert.h>

// This class is a psuedo renderer that grabs the YUV frames and instead of
// passing it to the screen, it gives it to a RealNetworks encoding engine. For use
// in tgw.

static class PipeRendererClass : public TclClass {
public:
  PipeRendererClass() : TclClass ("Module/Renderer/PipeRenderer") {};
  TclObject* create(int /* argc */, const char*const* /* argv */) {
    return (new PipeRenderer);
  };
} rm_Pipe;

PipeRenderer::PipeRenderer() : ConditionalReplenisher(), encoder_(0),frame_data_(0), avg_diff_size_(0), bidder_house_(0), diff_threshold(24), diffs_want_to_send(0) {
  //  fd = fopen ("blah", "w");
  frame_ = new YuvFrame(0,0,0,0,0);
}

PipeRenderer::~PipeRenderer() {
  //  fclose (fd);
}

// This is to report the bandwidht usage for this source back to the UI (which is bandwidthObj)
void PipeRenderer::bandwidthUsage(int x) {
  Tcl& tcl = Tcl::instance();
  tcl.evalf("%s %d", bandwidthObj, x);
}

// receive a YUV frame, setup structures if this is the first frame, else do the conditional
// replenishment checks and report to the auction house how much data you want to send...
void PipeRenderer::recv(Buffer* b) {
  YuvFrame* in_frame_ = (YuvFrame*)b;
  int y;

  if ((in_frame_->width_ != frame_->width_) || 
      (in_frame_->height_ != frame_->height_)) {

    /* First time called or frame size changed. Reallocate frame data space and reinit crvec */

    if (frame_data_ != 0) {
      delete [] frame_data_;
    }
    y = in_frame_->width_*in_frame_->height_*3/2;
    frame_data_ = new u_int8_t[y];
    
    memcpy(frame_data_, in_frame_->bp_, y);

    crinit(in_frame_->width_, in_frame_->height_);
    y = ((in_frame_->width_ >> 4) * (in_frame_->height_ >>4));
    crvec_to_send_ = new u_char[y];
    crvec_not_sent_ = new u_char[y];
    bzero(crvec_not_sent_, y);
          
    frame_->crvec_ = crvec_to_send_;
    frame_->bp_ = frame_data_;
    frame_->width_ = in_frame_->width_;
    frame_->height_ = in_frame_->height_;
    frame_->layer_ = 0;    
  } else {
    // Frame size is the same, so do conditional replenishment.
    int mark = age_blocks() | CR_MOTION_BIT | CR_LQ;
    
    register int _stride = in_frame_->width_;
    
    const u_char* rb = &(frame_data_[scan_ * _stride]);
    const u_char* lb = &(in_frame_->bp_[scan_ * _stride]);
    
    u_char* crv = crvec_;

    int bw = frame_->width_/16;
    int bh = frame_->height_/16;
    
    for (y = 0; y < bh; y++) {
      const u_char* nrb = rb;
      const u_char* nlb = lb;
      u_char* ncrv = crv;
      
      for (int x = 0; x < bw; x++) {
	int tl = 0;
	int tc1 = 0;
 	int tc2 = 0;
 	int tr = 0;
 	int bl = 0;
 	int bc1 = 0;
 	int bc2 = 0;
 	int br = 0;

	tl = lb[0] - rb[0] + lb[1] - rb[1] + lb[2] - rb[2] + lb[3] - rb[3];
 	if (tl < 0) tl = -tl;

 	tc1 = lb[4] - rb[4] + lb[5] - rb[5] + lb[6] - rb[6] + lb[7] - rb[7];
 	if (tc1 < 0) tc1 = -tc1;

 	tc2 = lb[8] - rb[8] + lb[9] - rb[9] + lb[10] - rb[10] + lb[11] -rb[11];
 	if (tc2 < 0) tc2 = -tc2;

	tr = lb[12] - rb[12] + lb[13] - rb[13] + lb[14] - rb[14] + 
	  lb[15] - rb[15];
	if (tr < 0) tr = -tr;
	
 	lb += _stride << 3;
 	rb += _stride << 3;

	bl = lb[0] - rb[0] + lb[1] - rb[1] + lb[2] - rb[2] + lb[3] - rb[3];
	if (bl < 0) bl = -bl;
	
	bc1 = lb[4] - rb[4] + lb[5] - rb[5] + lb[6] - rb[6] + lb[7] - rb[7];
	if (bc1 < 0) bc1 = -bc1;

	bc2 = lb[8] - rb[8] + lb[9] - rb[9] + lb[10] - rb[10] + lb[11] -rb[11];
	if (bc2 < 0) bc2 = -bc2;

	br = lb[12] - rb[12] + lb[13] - rb[13] + lb[14] - rb[14] + 
	  lb[15] - rb[15];
	if (br < 0) br = -br;
	
	lb -= _stride << 3;
	rb -= _stride << 3;
	
 	if (scan_ < 4) {
	  /*	  // north-west 
	  if ((tl >= diff_threshold) && (x > 0) && (y > 0)) {
	    crv[-bw-1] = mark;
	  }
	  // north
 	  if (((tl >= diff_threshold) || (tc1 >= diff_threshold) || (tc2 >= diff_threshold) || (tr >= diff_threshold)) &&
	      (y > 0)) {
	    crv[-bw] = mark;
	  }
	  // north-east 
 	  if ((tr >= diff_threshold) && (x < bw - 1) && (y > 0)) {
	    crv[-bw+1] = mark;
	  }
	  // west
	  if (((tl >= diff_threshold) || (bl >= diff_threshold)) && (x > 0)) {
	    crv[-1] = mark;
	  } */
	  // middle 
	  if ((tl >= diff_threshold) || (tc1 >= diff_threshold) || (tc2 >= diff_threshold) || (tr >= diff_threshold) ||
	      (bl >= diff_threshold) || (bc1 >= diff_threshold) || (bc2 >= diff_threshold) || (br >= diff_threshold)) {
	    crv[0] = mark;
	  }/*
	  // east 
	  if (((tr >= diff_threshold) || (br >=diff_threshold)) && (x < bw - 1)) {
	    crv[1] = 0;
	  }*/
 	} else {
	  /*	  // south-west 
	  if ((bl >= diff_threshold) && (x > 0) && (y < bh-1)) {
	    crv[bw-1] = mark;
	  }
	  // south 
	  if (((bl >= diff_threshold) || (bc1 >= diff_threshold) || (bc2 >= diff_threshold) || (br >= diff_threshold)) &&
	      (y < bh-1)) {
	    crv[bw] = mark;
	  }
	  // south-east
	  if ((br >= diff_threshold) && (x < bw - 1) && (y < bh - 1)) {
	    crv[bw+1] = mark;
	  }
	  // west 
	  if (((bl >= diff_threshold) || (tl >= diff_threshold)) && (x > 0)) {
	    crv[-1] = mark;
	  } */
	  // middle 
	  if ((bl >= diff_threshold) || (bc1 >= diff_threshold) || (bc2 >= diff_threshold) || (br >= diff_threshold) ||
	      (tl >= diff_threshold) || (tc1 >= diff_threshold) || (tc2 >= diff_threshold) || (tr >= diff_threshold)) {
	    crv[0] = mark;
	  }
	  /*	  // east 
	  if (((br >= diff_threshold) || (tr >=diff_threshold)) && (x < bw - 1)) {
	    crv[1] = 0;
	    } */
	}
 	lb += 16;
	rb += 16;
	crv++;
      }
      lb = nlb + (_stride << 4);
      rb = nrb + (_stride << 4);
      crv = ncrv + bw;
    }

    // Copy blocks into frame based on conditional replenishment

    crv = crvec_;
    int off = frame_->width_ * frame_->height_;
    u_char* dest_lum = frame_data_;
    u_char* dest_cr = frame_data_+off;
    u_char* dest_cb = frame_data_+off+(off/4);
    u_char* src_lum = in_frame_->bp_;
    u_char* src_cr = in_frame_->bp_+off;
    u_char* src_cb = in_frame_->bp_+off+(off/4);

    for (y = 0; y < bh; y++) {
      int i;
      for (int x = 0; x < bw; x++) {
	int s = *crv++;
	if ((s & CR_SEND) != 0) {
	  int idx = y*_stride*16+x*16;
	  u_int32_t* sl = (u_int32_t*) &(src_lum[idx]);
	  u_int32_t* dl = (u_int32_t*) &(dest_lum[idx]);
	  for(i=0; i<16; i++) {
	    dl[0] = sl[0];
	    dl[1] = sl[1];
	    dl[2] = sl[2];
	    dl[3] = sl[3];
	    dl += (_stride / 4);
	    sl += (_stride / 4);
	  }

	  idx = y*(_stride/2)*8+x*8;
	  u_int32_t* scr = (u_int32_t*) &(src_cr[idx]);
	  u_int32_t* scb = (u_int32_t*) &(src_cb[idx]);
	  u_int32_t* dcr = (u_int32_t*) &(dest_cr[idx]);
	  u_int32_t* dcb = (u_int32_t*) &(dest_cb[idx]);
	  for(i=0; i<8; i++) {
	    dcr[0] = scr[0];
	    dcr[1] = scr[1];
	    dcb[0] = scb[0];
	    dcb[1] = scb[1];
	    dcr += _stride / 8;
	    dcb += _stride / 8;
	    scr += _stride / 8;
	    scb += _stride / 8;
	  }
	}
      }
    }
  }
  frame_->ts_ = in_frame_->ts_;

  // calculate how many diffs you want to send.
  diffs_want_to_send = 0;
  for (y=((in_frame_->width_ >> 4) * (in_frame_->height_ >>4))-1;y>=0;y--) {
    if ((crvec_[y] & CR_SEND) != 0) {
      crvec_not_sent_[y] = crvec_[y];
      diffs_want_to_send++;
    } else if ((crvec_not_sent_[y] & CR_SEND) != 0) {
      diffs_want_to_send++;
    }
  }
  
  // should only occur at startup...
  if (avg_diff_size_ == 0)
    avg_diff_size_ = 50;

  //  printf("diffs_want_to_send: %x, %d, avg_diff_size:%d\n", this, diffs_want_to_send, avg_diff_size_);
  // tell the auction house how much data you want to send.
  bidder_house_->setDiffCount(this, diffs_want_to_send, avg_diff_size_);
}

// The auction house now tells the source that it can go ahead and send its data.
void PipeRenderer::giveToEncoder(int diffs_to_send) {
  //  fprintf(fd, "diffs_going_to_send: %x, %d\n", this, diffs_to_send);
  int x, marker, rand_num;
  int bytes_sent = 0;
  int size_of_crvec = ((frame_->width_ >> 4) * (frame_->height_ >>4));

  bzero(crvec_to_send_, size_of_crvec);

  if (diffs_to_send <= 0) {
    return;
  } else if (diffs_to_send >= diffs_want_to_send) {
    // we can send all our updates.
    memcpy(crvec_to_send_, crvec_not_sent_, size_of_crvec);
    bzero(crvec_not_sent_, size_of_crvec);
  } else {
    // we can only send a subset (randomly chosen) of our data.
    for (x = 0; x < diffs_to_send; x++) {
      rand_num = random()%size_of_crvec;
      marker = rand_num;
      while (((crvec_not_sent_[rand_num]) & CR_SEND) == 0) {
	rand_num = (rand_num+1)%size_of_crvec;
	if (rand_num == marker) {
	  //	fprintf(fd, "we were told to send too much\n");
	  Tcl::instance().eval("puts \"we were told to send more diffs then we have to send\"");
	  break;
	}
      }
      crvec_to_send_[rand_num] = crvec_not_sent_[rand_num];
      crvec_not_sent_[rand_num] = 0;
    }
  }
  
  if (encoder_ != 0) {
    // record how much data was actually sent.
    bytes_sent = encoder_->nb();
    encoder_->recv(frame_);
    bytes_sent = encoder_->nb() - bytes_sent;
    avg_diff_size_ = ((ALPHA*avg_diff_size_) + ((100-ALPHA)*(bytes_sent/diffs_to_send)))/100;
  }
}

int PipeRenderer::command(int argc, const char*const* argv) {
  Tcl& tcl = Tcl::instance();
  if (argc == 3) {
    if (strcmp(argv[1], "attach_encoder") == 0) {
      encoder_ = (EncoderModule*)TclObject::lookup(argv[2]);
      if (encoder_ == 0) {
	tcl.resultf("%s attach_encoder: no such encoder: %s", argv[0], argv[2]);
	return (TCL_ERROR);
      }
      return (TCL_OK);
    } else if (strcmp(argv[1], "use_auction_house") == 0) {
      bidder_house_ = (BidderHouse*)TclObject::lookup(argv[2]);
      if (bidder_house_ == 0) {
	tcl.resultf("%s use_auction_house: no such bidder house: %s", argv[0], argv[2]);
	return (TCL_ERROR);
      }
      bidder_house_->addSource(this);
      return (TCL_OK);
    } else if (strcmp(argv[1], "bandwidth_display") == 0) {
      sprintf(bandwidthObj, "%s change_bwUsage", argv[2]);
      return (TCL_OK);
    }
  }
  return (Renderer::command(argc, argv));
}



